/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.network.raman;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.Attribute;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IEntityTableModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IRamanDayZeroOperation;
import cerent.cms.model.IRamanModel;
import cerent.cms.model.ISideModel;
import cerent.cms.model.WrongNodeSide;
import cerent.cms.topo.INetLink;
import cerent.cms.ui.Wavelength;
import cerent.cms.ui.WzDiagDebug;
import cerent.cms.ui.network.MapLinkRenderer;
import cerent.cms.ui.network.raman.RamanAttribute;
import cerent.cms.ui.network.raman.RamanDayZeroDialog;
import cerent.cms.ui.network.raman.RamanDayZeroTableModel;
import cerent.cms.ui.network.raman.TxpPane;
import cerent.util.KDebug;
import cerent.util.SDebug;
import cerent.util.gui.UTable;
import java.util.ArrayList;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class RamanDayZeroInfo {
    public static final Attribute[][] lambdas = new Attribute[][]{{Wavelength.getWlAttribute(1), Wavelength.getWlAttribute(32)}, {Wavelength.getWlAttribute(84), Wavelength.getWlAttribute(129)}};
    public static final int END_MEASURE = 1;
    public static final int START_MEASURE = 0;
    static final String OPEN = "(";
    static final String CLOSE = ")";
    static final String COMMA = ",";
    static final String SPACE = " ";
    private String errorPane;
    private int errorCode;
    private boolean needRoute;
    private int testIndex;
    private RamanAttribute startNode = null;
    private RamanAttribute endNode = null;
    private boolean autoSkip = false;
    private boolean returnPageAlreadyDone = false;
    private ArrayList<RamanAttribute> allMiddleNodes;
    private ArrayList<RamanAttribute> currentMiddleNodes;
    private int middleNodes;
    private boolean dmuxPresent;
    private int[] txpLambda = new int[2];
    private IEntityModel[] trunk = new IEntityModel[2];
    private IEntityModel[] muxPort = new IEntityModel[2];
    private IRamanModel.RamanPowerMeasures[] ramanPowerMeasure = new IRamanModel.RamanPowerMeasures[2];
    private ArrayList<ArrayList> newRamanValues;
    private WzDiagDebug db;
    private boolean measureAccepted;
    private boolean needReturn;
    private boolean areInReturn;
    private boolean autoRun;
    private int deltaPwr;
    private boolean deltaPwrSet;
    private UTable ramanUTable;
    private ArrayList<TableColumn> removedColumns;
    private boolean allNodesOneLineCalibrated;
    private boolean evenSystem = false;
    private TxpPane txpPane;

    public boolean isAutoSkip() {
        return this.autoSkip;
    }

    public void setAutoSkip(boolean bl) {
        this.autoSkip = bl;
    }

    public void setStartNode(RamanAttribute ramanAttribute) {
        this.startNode = ramanAttribute;
        this.allMiddleNodes = new ArrayList();
        this.currentMiddleNodes = new ArrayList();
    }

    public RamanAttribute getStartNode() {
        return this.startNode;
    }

    public void setTxpLambdaCurrentTest(int n) {
        this.txpLambda[this.testIndex] = n;
    }

    public int getTxpLambdaCurrentTest() {
        return this.txpLambda[this.testIndex];
    }

    public RamanAttribute getEndNode() {
        return this.endNode;
    }

    public void setEndNode(RamanAttribute ramanAttribute) {
        this.endNode = ramanAttribute;
        if (this.db.on()) {
            this.db.println("StartNode: " + this.endNode.getNode().getName() + "\n" + "InPortIdx: " + this.endNode.getSingleRamanLinePort());
        }
    }

    public void setTrunkCurrentTest(IEntityModel iEntityModel) {
        this.trunk[this.testIndex] = iEntityModel;
    }

    public void setMuxCurrentTest(IEntityModel iEntityModel) {
        this.muxPort[this.testIndex] = iEntityModel;
    }

    public IEntityModel getTrunkCurrentTest() {
        return this.trunk[this.testIndex];
    }

    public IEntityModel getMuxCurrentTest() {
        return this.muxPort[this.testIndex];
    }

    public IEntityModel[] getTrunks() {
        return this.trunk;
    }

    public void setErrorPane(String string, int n) {
        this.errorPane = string;
        this.errorCode = n;
    }

    public RamanDayZeroInfo(WzDiagDebug wzDiagDebug) {
        this.initBasicParam();
        this.setAreInReturn(false);
        this.setNeedReturn(false);
        this.db = wzDiagDebug;
        this.newRamanValues = new ArrayList();
    }

    private void initBasicParam() {
        this.errorPane = null;
        this.errorCode = 0;
        this.middleNodes = 0;
        this.testIndex = 0;
        this.deltaPwr = 0;
        this.allNodesOneLineCalibrated = true;
        this.deltaPwrSet = false;
    }

    public void incTest() {
        ++this.testIndex;
    }

    public void decTest() {
        if (this.testIndex > 0) {
            --this.testIndex;
        }
    }

    public int getTestIndex() {
        return this.testIndex;
    }

    public void setRamanParamsCurrentTest(IRamanModel.RamanPowerMeasures ramanPowerMeasures, int n) {
        this.ramanPowerMeasure[n] = ramanPowerMeasures;
    }

    public IRamanModel.RamanPowerMeasures getRamanParamsCurrentTest(int n) {
        return this.ramanPowerMeasure[n];
    }

    public boolean isNeedRoute() {
        return this.needRoute;
    }

    public void setNeedRoute(boolean bl) {
        this.needRoute = bl;
    }

    public String getErrorPane() {
        return this.errorPane;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    /*
     * Enabled aggressive block sorting
     */
    public String setMiddleNodes(INetLink[] iNetLinkArray) {
        RamanAttribute ramanAttribute;
        IEntityModel iEntityModel;
        INodeModel iNodeModel;
        int n;
        boolean bl = false;
        this.middleNodes = 0;
        String string = "Setting Parameters Forward Path";
        for (n = 0; n < iNetLinkArray.length - 1; ++n) {
            iNodeModel = iNetLinkArray[n].getDst().getNodeModel();
            iEntityModel = MapLinkRenderer.getEntity(iNodeModel, iNetLinkArray[n].getDstEntityIndex());
            ramanAttribute = MapLinkRenderer.getEntity(iNodeModel, iNetLinkArray[n + 1].getSrcEntityIndex());
            RamanAttribute ramanAttribute2 = new RamanAttribute(iNodeModel, iEntityModel.getParent(), ramanAttribute.getParent());
            this.allMiddleNodes.add(ramanAttribute2);
            if (ramanAttribute2.lineNeedToBeTuned(this)) {
                if (bl) continue;
                this.setEndNode(new RamanAttribute(iNodeModel, iEntityModel.getParent()));
                bl = true;
                continue;
            }
            if (bl) continue;
            bl = this.setNextCurrentNode(1);
        }
        iNodeModel = iNetLinkArray[n].getDst().getNodeModel();
        iEntityModel = MapLinkRenderer.getEntity(iNodeModel, iNetLinkArray[n].getDstEntityIndex());
        ramanAttribute = new RamanAttribute(iNodeModel, iEntityModel.getParent());
        if (bl) {
            this.allMiddleNodes.add(ramanAttribute);
            return string;
        }
        if (ramanAttribute.lineNeedToBeTuned(this)) {
            this.setEndNode(new RamanAttribute(iNodeModel, iEntityModel.getParent()));
            this.allMiddleNodes.add(ramanAttribute);
            return string;
        }
        this.setEndNode(new RamanAttribute(iNodeModel, iEntityModel.getParent()));
        return "Accept Result";
    }

    private String setReturnMiddleNode(RamanAttribute ramanAttribute) {
        int n;
        String string = "Setting Parameters Forward Path";
        int n2 = this.allMiddleNodes.size();
        if (n2 == 0) {
            this.endNode = ramanAttribute;
            return string;
        }
        for (int i = 0; i < n2 - 1; ++i) {
            RamanAttribute ramanAttribute2 = this.allMiddleNodes.get(i);
            n = ramanAttribute2.getOutRamanLinePort().getIndex();
            int n3 = ramanAttribute2.getSingleRamanLinePort().getIndex();
            IEntityTableModel iEntityTableModel = ramanAttribute2.getNode().getEntityTable();
            IEntityModel iEntityModel = ramanAttribute2.getOutRamanLinePort().getParent();
            int n4 = iEntityModel.getEqType();
            IEntityModel iEntityModel2 = ramanAttribute2.getSingleRamanLinePort().getParent();
            int n5 = iEntityModel2.getEqType();
            try {
                int n6;
                ISideModel iSideModel;
                if (n4 == 287 || n4 == 321) {
                    ramanAttribute2.setSingleRamanLinePort(iEntityTableModel.getEntityModelByIndex(n), n4);
                } else {
                    try {
                        iSideModel = ramanAttribute2.getNode().getSideModels().getSideById(iEntityModel.getSide());
                        n6 = iSideModel.getLineIn() & 0xFF;
                        ramanAttribute2.setSingleRamanLinePort(RamanAttribute.takePort(n6, iEntityModel), n4);
                    }
                    catch (WrongNodeSide wrongNodeSide) {
                        KDebug.printStackTrace((Throwable)wrongNodeSide);
                    }
                }
                if (n5 == 287 || n5 == 321) {
                    ramanAttribute2.setOutRamanLinePort(iEntityTableModel.getEntityModelByIndex(n3));
                    continue;
                }
                try {
                    iSideModel = ramanAttribute2.getNode().getSideModels().getSideById(iEntityModel2.getSide());
                    n6 = iSideModel.getLineOut() & 0xFF;
                    ramanAttribute2.setOutRamanLinePort(RamanAttribute.takePort(n6, iEntityModel2));
                }
                catch (WrongNodeSide wrongNodeSide) {
                    KDebug.printStackTrace((Throwable)wrongNodeSide);
                }
                continue;
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
        }
        this.currentMiddleNodes.removeAll(this.allMiddleNodes);
        ArrayList<RamanAttribute> arrayList = new ArrayList<RamanAttribute>();
        for (n = n2 - 2; n >= 0; --n) {
            arrayList.add(this.allMiddleNodes.get(n));
        }
        arrayList.add(ramanAttribute);
        this.allMiddleNodes = arrayList;
        this.endNode = this.allMiddleNodes.get(0);
        if (!this.endNode.lineNeedToBeTuned(this)) {
            do {
                if (!this.setNextCurrentNode(0)) continue;
                return string;
            } while ((n = this.getCurrentMiddleNodes().size() == this.getAllMiddleNodes().size() - 1 ? 1 : 0) == 0);
            string = "Accept Result";
        }
        return string;
    }

    public ArrayList<RamanAttribute> getAllMiddleNodes() {
        return this.allMiddleNodes;
    }

    public ArrayList<RamanAttribute> getCurrentMiddleNodes() {
        return this.currentMiddleNodes;
    }

    public boolean setNextCurrentNode(int n) throws IndexOutOfBoundsException {
        int n2;
        do {
            n2 = this.currentMiddleNodes.size();
            ++this.middleNodes;
            RamanAttribute ramanAttribute = this.allMiddleNodes.get(this.middleNodes - n);
            this.currentMiddleNodes.add(this.allMiddleNodes.get(n2));
            if (this.middleNodes >= this.allMiddleNodes.size() || !ramanAttribute.lineNeedToBeTuned(this)) continue;
            this.setEndNode(ramanAttribute);
            this.testIndex = 0;
            return true;
        } while (n2 > this.middleNodes);
        return false;
    }

    public void setMeasureAccepted(boolean bl) {
        this.measureAccepted = bl;
    }

    public boolean isMeasureAccepted() {
        return this.measureAccepted;
    }

    public String prepareBackPath(IRamanDayZeroOperation iRamanDayZeroOperation, boolean bl) {
        RamanDayZeroDialog.restoreRaman(bl, this, iRamanDayZeroOperation);
        this.initBasicParam();
        this.setAreInReturn(true);
        RamanAttribute ramanAttribute = this.startNode;
        int n = this.allMiddleNodes.size();
        this.startNode = n > 0 ? this.allMiddleNodes.get(n - 1) : this.endNode;
        String string = this.setReturnMiddleNode(ramanAttribute);
        if (bl && string.equals("Setting Parameters Forward Path")) {
            string = "Calibrate Raman";
        }
        return string;
    }

    private void setAreInReturn(boolean bl) {
        this.areInReturn = bl;
    }

    public void setNeedReturn(boolean bl) {
        this.needReturn = bl;
    }

    public boolean isNeedReturn() {
        return this.needReturn;
    }

    public void setAutoRun(boolean bl) {
        this.autoRun = bl;
    }

    public boolean isAutoRun() {
        return this.autoRun;
    }

    public int getMiddleNodes() {
        return this.middleNodes;
    }

    public boolean isMultiSpan() {
        return this.allMiddleNodes.size() > 0;
    }

    public void addResultValues(ArrayList<String> arrayList) {
        arrayList.add(this.endNode.getName());
        arrayList.add(this.getPosition(this.endNode.getSingleRamanLinePort()));
        IRamanModel.RamanPowerMeasures ramanPowerMeasures = this.getRamanParamsCurrentTest(0);
        if (ramanPowerMeasures != null) {
            arrayList.add(Double.toString((double)ramanPowerMeasures.powerMinRamanLevel / 10.0));
            arrayList.add(Double.toString((double)ramanPowerMeasures.powerMaxRamanLevel / 10.0));
            arrayList.add(Double.toString(ramanPowerMeasures.loPowerForRamanMeasure));
            arrayList.add(Double.toString(ramanPowerMeasures.hiPowerForRamanMeasure));
            ramanPowerMeasures = this.getRamanParamsCurrentTest(1);
            arrayList.add(Double.toString((double)ramanPowerMeasures.powerMinRamanLevel / 10.0));
            arrayList.add(Double.toString((double)ramanPowerMeasures.powerMaxRamanLevel / 10.0));
            arrayList.add(Double.toString(ramanPowerMeasures.loPowerForRamanMeasure));
            arrayList.add(Double.toString(ramanPowerMeasures.hiPowerForRamanMeasure));
            this.newRamanValues.add(arrayList);
        }
    }

    private String getPosition(IEntityModel iEntityModel) {
        StringBuffer stringBuffer = new StringBuffer(50);
        if (iEntityModel.getNodeModel().isMultishelf()) {
            stringBuffer.append("Shelf ");
            stringBuffer.append(iEntityModel.getShelfId());
            stringBuffer.append(COMMA);
        }
        stringBuffer.append("Slot ");
        stringBuffer.append(iEntityModel.getSlot());
        stringBuffer.append(SPACE);
        stringBuffer.append(COMMA);
        stringBuffer.append("Port ");
        stringBuffer.append(iEntityModel.getPort());
        return stringBuffer.toString();
    }

    public ArrayList<ArrayList> getNewRamanValues() {
        return this.newRamanValues;
    }

    public void setDmuxPresent(boolean bl) {
        this.dmuxPresent = bl;
    }

    public boolean isDmuxPresent() {
        return this.dmuxPresent;
    }

    public boolean hasDeltaPwr() {
        return this.deltaPwrSet;
    }

    public void setDeltaPwr(int n) {
        this.deltaPwr = n;
        this.deltaPwrSet = true;
    }

    public int getDeltaPwr() {
        return this.deltaPwr;
    }

    public boolean isInReturn() {
        return this.areInReturn;
    }

    public void setResultTable(RamanDayZeroTableModel ramanDayZeroTableModel) {
        this.ramanUTable = new UTable((TableModel)ramanDayZeroTableModel);
    }

    public UTable getResultTable() {
        return this.ramanUTable;
    }

    public boolean needTxpSelection() {
        return this.allNodesOneLineCalibrated;
    }

    public boolean allNodesCalibrated() {
        if (this.isMultiSpan()) {
            if (this.getCurrentMiddleNodes().size() == this.getAllMiddleNodes().size() - 1) {
                this.allNodesOneLineCalibrated = true;
            } else {
                boolean bl = false;
                boolean bl2 = this.getCurrentMiddleNodes().size() == this.getAllMiddleNodes().size() - 1;
                do {
                    bl = this.setNextCurrentNode(0);
                    boolean bl3 = bl2 = this.getCurrentMiddleNodes().size() == this.getAllMiddleNodes().size() - 1;
                } while (!bl && !bl2);
                this.allNodesOneLineCalibrated = !bl;
            }
        } else {
            this.allNodesOneLineCalibrated = true;
        }
        return this.allNodesOneLineCalibrated;
    }

    public void removeColumns() {
        this.removedColumns = new ArrayList();
        TableColumn tableColumn = this.ramanUTable.getColumn((Object)RamanDayZeroTableModel.columnNames[9]);
        this.removedColumns.add(tableColumn);
        this.ramanUTable.removeColumn(tableColumn);
        tableColumn = this.ramanUTable.getColumn((Object)RamanDayZeroTableModel.columnNames[10]);
        this.removedColumns.add(tableColumn);
        this.ramanUTable.removeColumn(tableColumn);
        tableColumn = this.ramanUTable.getColumn((Object)RamanDayZeroTableModel.columnNames[13]);
        this.removedColumns.add(tableColumn);
        this.ramanUTable.removeColumn(tableColumn);
        tableColumn = this.ramanUTable.getColumn((Object)RamanDayZeroTableModel.columnNames[14]);
        this.removedColumns.add(tableColumn);
        this.ramanUTable.removeColumn(tableColumn);
        tableColumn = this.ramanUTable.getColumn((Object)RamanDayZeroTableModel.columnNames[15]);
        this.removedColumns.add(tableColumn);
        this.ramanUTable.removeColumn(tableColumn);
        tableColumn = this.ramanUTable.getColumn((Object)RamanDayZeroTableModel.columnNames[16]);
        this.removedColumns.add(tableColumn);
        this.ramanUTable.removeColumn(tableColumn);
        tableColumn = this.ramanUTable.getColumn((Object)RamanDayZeroTableModel.columnNames[17]);
        this.removedColumns.add(tableColumn);
        this.ramanUTable.removeColumn(tableColumn);
        tableColumn = this.ramanUTable.getColumn((Object)RamanDayZeroTableModel.columnNames[18]);
        this.removedColumns.add(tableColumn);
        this.ramanUTable.removeColumn(tableColumn);
        tableColumn = this.ramanUTable.getColumn((Object)RamanDayZeroTableModel.columnNames[19]);
        this.removedColumns.add(tableColumn);
        this.ramanUTable.removeColumn(tableColumn);
    }

    public void restoreColumns() {
        if (this.removedColumns == null) {
            return;
        }
        for (int i = 0; i < this.removedColumns.size(); ++i) {
            this.ramanUTable.addColumn(this.removedColumns.get(i));
        }
        this.removedColumns = null;
    }

    public void setEvenSelection(boolean bl) {
        this.evenSystem = bl;
    }

    public boolean isEven() {
        return this.evenSystem;
    }

    public void setTxpPane(TxpPane txpPane) {
        this.txpPane = txpPane;
    }

    public TxpPane getTxpPane() {
        return this.txpPane;
    }

    public boolean needReturnPage() {
        boolean bl = this.isNeedReturn();
        if (bl && !this.returnPageAlreadyDone) {
            this.returnPageAlreadyDone = true;
            return true;
        }
        return false;
    }

    public static enum sm {
        StartTest,
        DoMeasure,
        GetRamanParam,
        GetRamanParamEvent,
        Calculation,
        ReadNewValue,
        ReadNewValueEvent,
        AcceptParam;

    }
}

