/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.network.raman;

import cerent.cms.model.IRamanModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class RamanDoMeasurePane
extends JPanel {
    public static final String TIME_LABEL = "Time Stamp: ";
    public static final String MINPWR_LABEL = "Low Power (dBm): ";
    public static final String MAXPWR_LABEL = "High Power (dBm): ";
    private JTextField timeText;
    private JTextField minPwrText;
    private JTextField maxPwrText;

    public RamanDoMeasurePane(GridBagLayout gridBagLayout) {
        super(gridBagLayout);
        this.setLayout(new BoxLayout(this, 1));
        this.initThiscomponent();
    }

    private void initThiscomponent() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)new JLabel(TIME_LABEL), gridBagConstraints);
        this.timeText = new JTextField();
        Dimension dimension = this.timeText.getSize();
        dimension.width += 100;
        dimension.height += 20;
        this.timeText.setEditable(false);
        this.timeText.setPreferredSize(dimension);
        ++gridBagConstraints.gridx;
        jPanel.add((Component)this.timeText, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        jPanel.add((Component)new JLabel(MINPWR_LABEL), gridBagConstraints);
        this.minPwrText = new JTextField();
        this.minPwrText.setEditable(false);
        this.minPwrText.setPreferredSize(dimension);
        ++gridBagConstraints.gridx;
        jPanel.add((Component)this.minPwrText, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        jPanel.add((Component)new JLabel(MAXPWR_LABEL), gridBagConstraints);
        this.maxPwrText = new JTextField();
        this.maxPwrText.setEditable(false);
        this.maxPwrText.setPreferredSize(dimension);
        ++gridBagConstraints.gridx;
        jPanel.add((Component)this.maxPwrText, gridBagConstraints);
        this.add((Component)jPanel, "South");
    }

    public void updateValues(IRamanModel.RamanPowerMeasures ramanPowerMeasures) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("H:mm:ss");
        Date date = new Date((long)ramanPowerMeasures.measureTimeStamp * 1000L);
        this.timeText.setText(simpleDateFormat.format(date));
        this.maxPwrText.setText(Double.toString((double)ramanPowerMeasures.powerMaxRamanLevel / 10.0));
        this.minPwrText.setText(Double.toString((double)ramanPowerMeasures.powerMinRamanLevel / 10.0));
    }

    public void cleanMesure() {
        this.timeText.setText(" ");
        this.maxPwrText.setText(" ");
        this.minPwrText.setText(" ");
    }
}

