/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.network.rpr;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.Feature;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IEtherMacAddr;
import cerent.cms.model.IModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.IRprConstants;
import cerent.cms.model.IRprTopoPeers;
import cerent.cms.model.IRprTopoStation;
import cerent.cms.model.ModelIndirectObservable;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NetworkModel;
import cerent.cms.model.NoSuchProperty;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.event.IAlarmStatus;
import cerent.cms.model.event.ICardAlarmStore;
import cerent.cms.ncp.RprTopoAdapter;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.NetworkViewController;
import cerent.cms.ui.network.AbstractMapNode;
import cerent.cms.ui.network.MapPersist;
import cerent.cms.ui.network.rpr.RprMap;
import cerent.cms.ui.network.rpr.RprMapCardLink;
import cerent.cms.ui.network.rpr.RprMapPort;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.IObservable;
import cerent.util.MacAddrFormat;
import cerent.util.NEMC;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.UPopupMenu;
import com.cisco.ctc.util.map.DetailedMapNode;
import com.cisco.ctc.util.map.MapLink;
import com.cisco.ctc.util.map.MapLinkConnector;
import com.cisco.ctc.util.map.MapNode;
import com.cisco.ctc.util.map.MapPort;
import com.cisco.ctc.util.map.MapToolkit;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class RprMapCard
extends AbstractMapNode
implements Observer,
IRprConstants {
    protected ICardAlarmStore alarmStore = null;
    private static final SDebug db = new SDebug("RprMapCard");
    private HashMap cktMapPorts = new HashMap();
    private HashMap rprMapPorts = new HashMap();
    private INodeModel nodeModel = null;
    private int cardIndex = -1;
    private int nodeId;
    private String macAddr = "";
    private RprMap rprMap = null;
    private static final String CMD_NODE_OPEN = "Open Card";
    private UpdateNodeAttributes updateNodeAttributes = new UpdateNodeAttributes();

    public RprMapCard(MapToolkit mapToolkit) {
        super(mapToolkit);
        this.rprMap = (RprMap)mapToolkit;
    }

    @Override
    public void init(Object object, double d, double d2, Object object2) {
        if (db.on()) {
            db.println("init() called");
        }
        super.init(object, d, d2, object2);
        IModuleModel iModuleModel = (IModuleModel)this.getUserObject();
        this.cardIndex = iModuleModel.getEntityIndex();
        this.nodeModel = iModuleModel.getNodeModel();
        if (this.nodeModel != null) {
            this.nodeId = this.nodeModel.getNodeId();
            this.addObservers();
            this.updateNodeAttributes();
        }
    }

    protected IModuleModel getRprCard() throws AbstractCmsNoSuchEntityException {
        IEntityModel iEntityModel = this.nodeModel.getEntityTable().getEntityModelByIndex(this.cardIndex);
        return (IModuleModel)iEntityModel;
    }

    protected int getCardRoleInLink(RprMapCardLink rprMapCardLink) {
        block4: {
            IModuleModel iModuleModel = (IModuleModel)rprMapCardLink.getSrcEntity().getParent();
            IModuleModel iModuleModel2 = (IModuleModel)rprMapCardLink.getDstEntity().getParent();
            try {
                IModuleModel iModuleModel3 = this.getRprCard();
                if (iModuleModel3 == iModuleModel) {
                    return 1;
                }
                if (iModuleModel3 == iModuleModel2) {
                    return 2;
                }
            }
            catch (Exception exception) {
                if (!db.on()) break block4;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return 0;
    }

    @Override
    protected MapPort createMapPort(DetailedMapNode detailedMapNode, MapLink mapLink, MapLinkConnector mapLinkConnector) {
        RprMapPort rprMapPort = new RprMapPort(detailedMapNode, mapLinkConnector);
        RprMapCardLink rprMapCardLink = (RprMapCardLink)mapLink;
        int n = this.getCardRoleInLink(rprMapCardLink);
        IPortModel iPortModel = null;
        if (n == 1) {
            iPortModel = rprMapCardLink.getSrcEntity();
        } else if (n == 2) {
            iPortModel = rprMapCardLink.getDstEntity();
        }
        if (iPortModel == null) {
            db.println("Unable to locate node in link");
            return null;
        }
        IRprTopoStation iRprTopoStation = null;
        try {
            iRprTopoStation = RprTopoAdapter.getRprTopoStation(iPortModel.getEntityIndex(), this.nodeModel, (IEntityModel)iPortModel);
        }
        catch (Exception exception) {
            db.severe("Error while retrieving rpr station: " + exception);
        }
        if (iRprTopoStation == null) {
            rprMapPort.init(iPortModel, null);
        } else {
            rprMapPort.init(iPortModel, iRprTopoStation.getMacAddr());
            String string = MacAddrFormat.format(iRprTopoStation.getMacAddr().getAddr());
            if (this.macAddr.length() == 0 || !string.equals(this.macAddr)) {
                this.macAddr = string;
                this.updateNodeName();
            }
        }
        int n2 = iPortModel.getPortNum()[0];
        if (this.cktMapPorts.get(n2) == null) {
            this.cktMapPorts.put(n2, rprMapPort);
        } else {
            this.rprMapPorts.put(n2, rprMapPort);
        }
        return rprMapPort;
    }

    protected boolean inPassThroughMode() {
        try {
            IModuleModel iModuleModel = this.getRprCard();
            IPortModel iPortModel = null;
            iPortModel = this.supportsPosOnMlmr(iModuleModel) ? iModuleModel.getRPREastPortModel() : (IPortModel)iModuleModel.getChildren().get(0);
            IRprTopoPeers iRprTopoPeers = RprTopoAdapter.getRprTopoPeers(iPortModel.getEntityIndex(), this.nodeModel, (IEntityModel)iPortModel);
            return iRprTopoPeers.getRinglet0Peers() == null && iRprTopoPeers.getRinglet1Peers() == null;
        }
        catch (Exception exception) {
            db.severe("Error while retrieving rpr topology peers: " + exception);
            return false;
        }
    }

    private boolean inRPRMode(IModuleModel iModuleModel) throws Exception {
        boolean bl = false;
        bl = this.supportsPosOnMlmr(iModuleModel) ? true : iModuleModel.isRPRMode();
        return bl;
    }

    private boolean isSelectedStation() {
        if (this.rprMap.selectedStation != null) {
            IEtherMacAddr iEtherMacAddr = this.rprMap.selectedStation.getMacAddr();
            for (int i = 0; i < 2; ++i) {
                IEtherMacAddr iEtherMacAddr2;
                RprMapPort rprMapPort = (RprMapPort)this.cktMapPorts.get(i);
                if (rprMapPort == null || !MacAddrFormat.format((iEtherMacAddr2 = (IEtherMacAddr)rprMapPort.getUserCookie()).getAddr()).equals(MacAddrFormat.format(iEtherMacAddr.getAddr()))) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean supportsPosOnMlmr(IModuleModel iModuleModel) {
        if (iModuleModel == null) {
            return false;
        }
        return Feature.provides((INodeModel)iModuleModel.getNodeModel(), (Feature)Feature.POS_ON_MLMR) && iModuleModel.getEqType() == 285;
    }

    protected RprMapPort getMapPort(int n) {
        if (this.rprMapPorts.get(n) != null) {
            return (RprMapPort)this.rprMapPorts.get(n);
        }
        return (RprMapPort)this.cktMapPorts.get(n);
    }

    protected RprMapPort getEastMapPort() {
        int n;
        block3: {
            n = 0;
            try {
                IModuleModel iModuleModel = this.getRprCard();
                if (this.supportsPosOnMlmr(iModuleModel)) {
                    n = iModuleModel.getRPREastPort();
                }
            }
            catch (Exception exception) {
                if (!db.on()) break block3;
                db.println("Error attempting to get the rpr module in getEastMapPort.");
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return this.getMapPort(n);
    }

    protected RprMapPort getWestMapPort() {
        int n;
        block3: {
            n = 1;
            try {
                IModuleModel iModuleModel = this.getRprCard();
                if (this.supportsPosOnMlmr(iModuleModel)) {
                    n = iModuleModel.getRPRWestPort();
                }
            }
            catch (Exception exception) {
                if (!db.on()) break block3;
                db.println("Error attempting to get the rpr module in getWestMapPort.");
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return this.getMapPort(n);
    }

    private String getNewNodeName() {
        String string;
        block2: {
            string = null;
            try {
                IModuleModel iModuleModel = this.getRprCard();
                string = this.nodeModel.getName() + ", Slot" + iModuleModel.getSlot() + ",\n" + this.macAddr;
            }
            catch (Exception exception) {
                if (!db.on()) break block2;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return string;
    }

    public synchronized void resetPosition() {
        block4: {
            try {
                IModuleModel iModuleModel = this.getRprCard();
                Point2D.Double double_ = RprMapCard.getPositionXY(this.mtk, iModuleModel);
                RprMapCard rprMapCard = this;
                if (double_.getX() == (double)rprMapCard.mtk.getCanvasCenterX()) {
                    RprMapCard rprMapCard2 = this;
                    if (double_.getY() == (double)rprMapCard2.mtk.getCanvasCenterY()) break block4;
                }
                this.setCoordinates(MapPersist.toNewX((int)double_.getX()), MapPersist.toNewY((int)double_.getY()));
            }
            catch (Exception exception) {
                if (!db.on()) break block4;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        this.mtk.updateView();
    }

    public static Point2D.Double getPositionXY(MapToolkit mapToolkit, IModuleModel iModuleModel) {
        double d;
        double d2;
        block5: {
            d2 = mapToolkit.getCanvasCenterX();
            d = mapToolkit.getCanvasCenterY();
            if (iModuleModel == null) {
                return new Point2D.Double(d2, d);
            }
            INodeModel iNodeModel = iModuleModel.getNodeModel();
            try {
                String string = "PositionXY" + iModuleModel.getEntityIndex();
                String string2 = iNodeModel.getProperty(string);
                String string3 = string2.substring(0, string2.indexOf(44));
                String string4 = string2.substring(string2.indexOf(44) + 1);
                d2 = Double.parseDouble(string3);
                d = Double.parseDouble(string4);
                if (RprMapCard.db.on) {
                    db.println("getPositionXY: node=" + iNodeModel.getName() + "slot=" + iModuleModel.getSlot() + ", x=" + d2 + " y=" + d);
                }
                return new Point2D.Double(d2, d);
            }
            catch (NoSuchProperty noSuchProperty) {
            }
            catch (Exception exception) {
                if (!db.on()) break block5;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return new Point2D.Double(d2, d);
    }

    private int getModelState() {
        ICardAlarmStore iCardAlarmStore;
        if (this.nodeModel.isInited() && this.nodeModel.getConnectionState() && (iCardAlarmStore = this.getCardAlarmStore()) != null) {
            return RprMapCard.getMapNodeState(iCardAlarmStore.getAlarmStatus());
        }
        return 4;
    }

    private void setState(int n) {
        this.state = n;
        this.updateGraphic();
    }

    protected void updateGraphic() {
        block3: {
            this.setColor(this.stateToColor(this.getState()));
            try {
                IModuleModel iModuleModel = this.getRprCard();
                if (!this.inRPRMode(iModuleModel) || this.inPassThroughMode()) {
                    this.setColor(DISCONNECTED_COLOR);
                }
            }
            catch (Exception exception) {
                if (!db.on()) break block3;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    @Override
    public void update(Observable observable, Object object) {
        if (db.on()) {
            db.println("update: received an update from:" + observable + " arg=" + object);
        }
        if (object == ModelUpdateType.CHANGED && (observable instanceof INodeModel || observable instanceof INodeModel.AbstractConnectionNotifier) || object instanceof IAlarmStatus) {
            SwingUtilities.invokeLater(this.updateNodeAttributes);
        }
    }

    private void updateNodeAttributes() {
        this.checkConnection();
        this.checkNodeNameChanged();
        this.checkNodeAttributes();
        this.updateNodePosition();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkConnection() {
        int n;
        int n2 = this.getState();
        if (n2 != (n = this.getModelState())) {
            try {
                NetworkViewController networkViewController;
                if (n2 == 5 || n2 == 4) {
                    if (db.on()) {
                        db.println("Update: " + this.getName() + " no longer " + "disconnected; observing its alarm store.");
                    }
                    this.startObservingAlarmStore();
                } else if (n == 4) {
                    if (db.on()) {
                        db.println("Update: " + this.getName() + " no longer " + "connected; stop observing its alarm store.");
                    }
                    this.stopObservingAlarmStore();
                }
                if (db.on()) {
                    db.println("received connection update: node=" + this.getName() + " ST=" + n2 + "->" + n);
                }
                if ((networkViewController = NetworkViewController.instance()) != null) {
                    boolean bl;
                    boolean bl2 = this.state != 4;
                    boolean bl3 = bl = n != 4;
                    if (bl2 != bl) {
                        if (db.on()) {
                            db.println("Notifying NVC of conn state change to " + bl);
                        }
                        networkViewController.nodeConnectionStateChanged(this.nodeModel, bl);
                    }
                }
            }
            catch (Exception exception) {
                db.println("checkConnection: caught exception");
                SDebug.printStackTrace((Throwable)exception);
            }
            finally {
                this.setState(n);
            }
        }
    }

    private void updateNodePosition() {
        if (!this.mtk.getMapProperty(this, 101)) {
            this.resetPosition();
        }
        this.mtk.updateView();
    }

    void updateNodeName() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String string = RprMapCard.this.getNewNodeName();
                if (!RprMapCard.this.isVirtual()) {
                    RprMapCard.this.setName(string);
                } else {
                    MapNode[] mapNodeArray = RprMapCard.this.getVNodes();
                    for (int i = 0; i < mapNodeArray.length; ++i) {
                        ((RprMapCard)mapNodeArray[i]).setName(string);
                    }
                }
            }
        });
    }

    private void checkNodeIdChanged() {
        if (this.nodeModel != null) {
            int n = this.nodeModel.getNodeId();
            if (RprMapCard.db.on) {
                db.println("oldNodeId=" + this.nodeId + " newNodeId=" + n);
            }
            if (this.nodeId != n && this.nodeId != 0) {
                NetworkViewController.instance().repairHistory(this.nodeId, n);
                NetworkModel.instance().nodeIdChanged(this.nodeId, n);
                String string = ErrorMsg.getString((EID)NEMC.WID_NEED_TO_REPAIR_CKTS_PARAM_1, (Object)this.nodeModel.getName());
                CerentDialog.warningDialog((Component)JOptionPane.getFrameForComponent(this.mtk.getGraphWindow()), (String)string, (String)"Node MAC Address Change", (boolean)false);
                this.nodeId = n;
            }
        }
    }

    private void checkNodeNameChanged() {
        block4: {
            try {
                String string = this.getName();
                String string2 = this.getNewNodeName();
                if (!string2.equals(string)) {
                    this.setName(string2);
                    if (db.on()) {
                        db.println("Update: Node name changed, " + string + " -> " + string2);
                    }
                }
            }
            catch (Exception exception) {
                if (!db.on()) break block4;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    private void checkNodeAttributes() {
        block2: {
            try {
                this.checkNodeIdChanged();
            }
            catch (Exception exception) {
                if (!db.on()) break block2;
                db.println("Caught exception in checkNodeAttributes->checkNodeIdChanged()");
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    private void addObservers() {
        if (this.nodeModel != null) {
            ModelIndirectObservable.instance().addObserver((IObservable)this.nodeModel, this);
            if (this.nodeModel.getConnectionNotifier() != null) {
                this.nodeModel.getConnectionNotifier().addObserver((Observer)this);
            }
        }
    }

    private void startObservingAlarmStore() {
        ICardAlarmStore iCardAlarmStore;
        if (RprMapCard.db.on) {
            db.println("startObservingAlarmStore: node " + this.getName());
        }
        if ((iCardAlarmStore = this.getCardAlarmStore()) != null) {
            iCardAlarmStore.addAlarmStatusObserver((Observer)this);
        }
    }

    private void stopObservingAlarmStore() {
        ICardAlarmStore iCardAlarmStore;
        if (RprMapCard.db.on) {
            db.println("stopObservingAlarmStore: node " + this.getName());
        }
        if ((iCardAlarmStore = this.getCardAlarmStore()) != null) {
            iCardAlarmStore.deleteAlarmStatusObserver((Observer)this);
            this.resetElementAlarmStore();
        }
    }

    protected void deleteObservers() {
        if (this.nodeModel != null) {
            ModelIndirectObservable.instance().deleteObserver((IObservable)this.nodeModel, this);
            if (this.nodeModel.getConnectionNotifier() != null) {
                this.nodeModel.getConnectionNotifier().deleteObserver((Observer)this);
            }
            this.stopObservingAlarmStore();
        }
    }

    @Override
    public void destroy() {
        block3: {
            if (RprMapCard.db.on) {
                db.println("destroy() called");
            }
            try {
                this.deleteObservers();
            }
            catch (Exception exception) {
                if (!db.on()) break block3;
                db.println("Caught exception in destroy()");
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        super.destroy();
    }

    @Override
    public String getToolTipText() {
        IModuleModel iModuleModel;
        block10: {
            try {
                iModuleModel = this.getRprCard();
                if (!this.inRPRMode(iModuleModel)) {
                    return "Not in RPR Mode";
                }
                if (this.inPassThroughMode()) {
                    return "In PassThrough Mode";
                }
            }
            catch (Exception exception) {
                if (!db.on()) break block10;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        if (this.isSelectedStation()) {
            return this.rprMap.selectedStation.getChkSm();
        }
        if (this.getState() != 4 && (iModuleModel = this.getCardAlarmStore()) != null) {
            IAlarmStatus iAlarmStatus = iModuleModel.getAlarmStatus();
            if (iAlarmStatus != null) {
                StringBuffer stringBuffer = new StringBuffer();
                if (this.isVirtual()) {
                    stringBuffer.append(this.getRealNode().getDomainName() + "(");
                }
                stringBuffer.append(this.getName() + ":");
                stringBuffer.append(" CR:" + iAlarmStatus.critical());
                stringBuffer.append(" MJ:" + iAlarmStatus.major());
                stringBuffer.append(" MI:" + iAlarmStatus.minor());
                if (this.isVirtual()) {
                    stringBuffer.append(")");
                }
                return stringBuffer.toString();
            }
            if (this.isVirtual()) {
                return "(" + this.getName() + ":" + " CR:0 MJ:0 MI:0 )";
            }
            return this.getName() + ":" + " CR:0 MJ:0 MI:0";
        }
        return this.getName() + ": Card not responding";
    }

    protected boolean isSuperuser() {
        return AbstractPane.isUserAuthorized((IModel)this.nodeModel, SecurityLevel.SUPERUSER);
    }

    @Override
    protected void initPopupMenu(UPopupMenu uPopupMenu) {
        int n = this.getState();
        this.actOrg.addMenuItem((JComponent)uPopupMenu, null, CMD_NODE_OPEN, 79);
        this.actOrg.getAbstractButton(CMD_NODE_OPEN).setEnabled(n != 4);
        this.actOrg.addMenuItem((JComponent)uPopupMenu, null, this.rprMap.CMD_NODE_RESET_POS, 82);
        this.actOrg.getAbstractButton(this.rprMap.CMD_NODE_RESET_POS).setEnabled(n != 4);
        super.initPopupMenu(uPopupMenu);
        this.actOrg.setEnabled("Move Node Back To Parent View", false);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == CMD_NODE_OPEN) {
            this.doOpenNode();
        } else if (string == this.rprMap.CMD_NODE_RESET_POS) {
            this.doResetPos();
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    public synchronized void doResetPos() {
        if (!CerentDialog.yesNoDialog((Component)JOptionPane.getFrameForComponent(this.mtk.getGraphWindow()), (String)this.rprMap.getResetNodePrompt(true), (String)this.rprMap.CMD_NODE_RESET_POS)) {
            return;
        }
        this.resetPosition();
    }

    @Override
    protected boolean canInsertToDomain() {
        return false;
    }

    private ICardAlarmStore getCardAlarmStore() {
        block3: {
            if (this.alarmStore == null && this.nodeModel != null) {
                try {
                    IModuleModel iModuleModel = this.getRprCard();
                    int n = iModuleModel.getSlot();
                    this.alarmStore = this.nodeModel.getElementAlarmStore().getCardAlarmStore(n);
                }
                catch (Exception exception) {
                    if (!db.on()) break block3;
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
        }
        return this.alarmStore;
    }

    private void resetElementAlarmStore() {
        this.alarmStore = null;
    }

    private class UpdateNodeAttributes
    implements Runnable {
        private UpdateNodeAttributes() {
        }

        @Override
        public void run() {
            RprMapCard.this.updateNodeAttributes();
        }
    }
}

