/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.network.rpr;

import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.Feature;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IInterfaceModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.IRprConstants;
import cerent.cms.model.ModelIndirectObservable;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.event.IAlarmStatus;
import cerent.cms.model.event.ICardAlarmStore;
import cerent.cms.ui.NetworkDefaults;
import cerent.cms.ui.network.NetMapNode;
import cerent.cms.ui.network.rpr.RprMap;
import cerent.cms.ui.network.rpr.RprMapCard;
import cerent.util.IObservable;
import cerent.util.SDebug;
import cerent.util.gui.UPopupMenu;
import com.cisco.ctc.util.map.DetailedMapNode;
import com.cisco.ctc.util.map.MapLinkConnector;
import com.cisco.ctc.util.map.MapPort;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class RprMapPort
extends MapPort
implements Observer,
IRprConstants {
    protected IPortModel mlPortModel;
    public static final String CMD_SHOW_RPR = "Show RPR Topo";
    private static final SDebug db = new SDebug("RprMapPort");

    public RprMapPort(DetailedMapNode detailedMapNode, MapLinkConnector mapLinkConnector) {
        super(detailedMapNode, mapLinkConnector);
    }

    @Override
    public void init(Object object, Object object2) {
        super.init(object, object2);
        this.mlPortModel = (IPortModel)object;
        if (this.mlPortModel != null) {
            ICardAlarmStore iCardAlarmStore;
            IModuleModel iModuleModel = this.mlPortModel.getModuleModel();
            if (null != iModuleModel) {
                iCardAlarmStore = this.getCardAlarmStore((IEntityModel)iModuleModel);
                iCardAlarmStore.enablePortAlarmsStatus(iModuleModel);
                iCardAlarmStore.addAlarmStatusObserver((Observer)this);
            }
            if (null != (iCardAlarmStore = this.mlPortModel.getInterfaceModel())) {
                ModelIndirectObservable.instance().addObserver((IObservable)iCardAlarmStore, this);
            }
            this.setInfoString();
            this.updateColor();
        } else if (RprMapPort.db.on) {
            db.println("mlPortModel is null");
        }
    }

    private Color getEntityModelColor(IEntityModel iEntityModel) {
        Color color = NetMapNode.DISCONNECTED_COLOR;
        if (iEntityModel instanceof IPortModel) {
            try {
                switch (((IPortModel)iEntityModel).getAdminState()) {
                    case 1: {
                        color = NetMapNode.DISCONNECTED_COLOR;
                        break;
                    }
                    case 2: {
                        color = NetMapNode.OOS_MT_COLOR;
                        break;
                    }
                    case 3: {
                        color = NetMapNode.IS_AINS_COLOR;
                        break;
                    }
                    case 0: {
                        color = NetMapNode.OK_COLOR;
                    }
                }
            }
            catch (NoSuchInterface noSuchInterface) {
                db.severe(noSuchInterface.toString());
            }
            if (color.equals(NetMapNode.OK_COLOR)) {
                ICardAlarmStore iCardAlarmStore = this.getCardAlarmStore(iEntityModel);
                IPortModel iPortModel = (IPortModel)iEntityModel;
                color = RprMapPort.getMapNodeColor(iCardAlarmStore.getEntityAlarmStatus((IEntityModel)iPortModel));
            }
        }
        return color;
    }

    private ICardAlarmStore getCardAlarmStore(IEntityModel iEntityModel) {
        INodeModel iNodeModel = iEntityModel.getNodeModel();
        return iNodeModel.getElementAlarmStore().getCardAlarmStore(iEntityModel.getSlot());
    }

    public void dispose() {
        if (this.mlPortModel != null) {
            ICardAlarmStore iCardAlarmStore;
            IModuleModel iModuleModel = this.mlPortModel.getModuleModel();
            if (null != iModuleModel) {
                iCardAlarmStore = this.getCardAlarmStore((IEntityModel)iModuleModel);
                iCardAlarmStore.disablePortAlarmsStatus();
                iCardAlarmStore.deleteAlarmStatusObserver((Observer)this);
            }
            if (null != (iCardAlarmStore = this.mlPortModel.getInterfaceModel())) {
                ModelIndirectObservable.instance().deleteObserver((IObservable)iCardAlarmStore, this);
            }
            this.mlPortModel = null;
        }
    }

    protected static Color getMapNodeColor(IAlarmStatus iAlarmStatus) {
        Color color = NetMapNode.getMapNodeColor(iAlarmStatus);
        if (NetMapNode.DISCONNECTED_COLOR.equals(color)) {
            color = NetMapNode.CRITICAL_COLOR;
        }
        return color;
    }

    public String asSlashSeparatedString() {
        String string = null;
        if (this.mlPortModel != null) {
            int[] nArray = this.mlPortModel.getPortNum();
            IModuleModel iModuleModel = this.mlPortModel.getModuleModel();
            string = Feature.provides((INodeModel)this.mlPortModel.getNodeModel(), (Feature)Feature.POS_ON_MLMR) && iModuleModel.getEqType() == 285 ? (nArray[0] == iModuleModel.getRPREastPort() ? "E" : "W") : (nArray[0] == 0 ? "E" : "W");
        }
        return string;
    }

    public String getServiceStateString() {
        if (this.mlPortModel != null) {
            try {
                return NetworkDefaults.getCmsHostTDMTerms().getTermForServiceState(this.mlPortModel.getServiceStateType());
            }
            catch (NoSuchInterface noSuchInterface) {
                db.severe(noSuchInterface.toString());
            }
            catch (Exception exception) {
                db.severe(exception.toString());
            }
        }
        return "";
    }

    private void setInfoString() {
        this.setInfoString(this.asSlashSeparatedString());
    }

    @Override
    public void setInfoString(String string) {
        super.setInfoString(string);
        this.updateLinkText(this.getInfoString());
    }

    public void invalidateRelatedRegion() {
        RprMapCard rprMapCard = (RprMapCard)this.parentNode;
        if (rprMapCard != null) {
            rprMapCard.invalidate();
        }
    }

    public void updateColor() {
        if (this.mlPortModel != null) {
            try {
                Color color = this.getColor();
                INodeModel iNodeModel = this.mlPortModel.getNodeModel();
                IEntityModel iEntityModel = iNodeModel.getEntityTable().getEntityModelByIndex(this.mlPortModel.getEntityIndex());
                Color color2 = this.getEntityModelColor(iEntityModel);
                if (RprMapPort.db.on) {
                    db.println("new color for EntityModel (em=" + iEntityModel + ")is: " + color2);
                }
                if (!color.equals(color2)) {
                    this.setColor(color2);
                    this.setInfoString();
                    this.invalidateRelatedRegion();
                    db.info("Update on port " + this.getInfoString());
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (RprMapPort.db.on) {
                    db.info("IllegalArgumentException in RprMapPort - not updating state - probably ok.");
                }
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                SDebug.printStackTrace((Throwable)abstractCmsIOException);
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
            }
        } else if (RprMapPort.db.on) {
            db.println("mlPortModel is null!" + this);
        }
    }

    @Override
    public void update(Observable observable, Object object) {
        if (RprMapPort.db.on) {
            db.println("update(observable=" + observable + ", Object=" + object + ")");
        }
        if (observable instanceof IInterfaceModel || object instanceof IAlarmStatus) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    RprMapPort.this.updateColor();
                }
            });
        }
    }

    @Override
    protected void initPopupMenu(UPopupMenu uPopupMenu) {
        RprMapCard rprMapCard;
        if (this.mlPortModel.inRPRMode() && !(rprMapCard = (RprMapCard)this.parentNode).inPassThroughMode()) {
            this.actOrg.addMenuItem((JComponent)uPopupMenu, null, CMD_SHOW_RPR, 83);
        }
    }

    @Override
    public String getToolTipText() {
        StringBuffer stringBuffer = new StringBuffer(this.getInfoString());
        String string = this.getServiceStateString();
        if (string.length() > 0) {
            stringBuffer.append('(' + string + ')');
        }
        switch (this.getLetter()) {
            case 'I': {
                stringBuffer.append(", Idle");
                break;
            }
            case 'W': {
                stringBuffer.append(", Wait To Restore");
                break;
            }
            case 'M': {
                stringBuffer.append(", Manual Switch");
                break;
            }
            case 'D': {
                stringBuffer.append(", Signal Degrade");
                break;
            }
            case 'S': {
                stringBuffer.append(", Signal Fail");
                break;
            }
            case 'F': {
                stringBuffer.append(", Forced Switch");
            }
        }
        return stringBuffer.toString();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(CMD_SHOW_RPR)) {
            IPortModel iPortModel = (IPortModel)this.getUserObject();
            ((RprMap)this.mtk).drawRprTopo(iPortModel);
        } else {
            super.actionPerformed(actionEvent);
        }
    }
}

