/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ohcircuits;

import cerent.cms.model.Attribute;
import cerent.cms.model.IOhCircuitEnd;
import cerent.cms.model.IOhConnectionModel;
import cerent.cms.model.IOhXconModel;
import cerent.cms.model.ohcircuits.OhNetCircuitModel;
import cerent.cms.ocm.OhCircuit;
import cerent.cms.ocm.OhNetCircuitEnd;
import cerent.cms.ocm.OwCircuit;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.AbstractTabbedView;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NetCSHelpConst;
import cerent.cms.ui.NetworkDefaults;
import cerent.cms.ui.Pane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.ohcircuits.OhCedGeneralPane;
import cerent.cms.ui.ohcircuits.OhCedIpTunnelPane;
import cerent.cms.ui.ohcircuits.OhCedOwPane;
import cerent.cms.ui.ohcircuits.OhCircuitEditDialog;
import cerent.util.EID;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;

public class OhCircuitEditTabbedView
extends AbstractTabbedView {
    public static final String GENERAL_TAB = "General";
    public static final String OW_TAB = "OW Circuits";
    public static final String IP_TUNNEL_TAB = "Tunnel";
    protected TDMTerminology tdmTerm;
    private OhCircuit currentCircuit;
    private OhCircuitEditDialog ced;
    private boolean upgradeInProgress = false;
    private static final SDebug db = new SDebug("CircuitEditTabbedView");

    public OhCircuitEditTabbedView(OhCircuit ohCircuit, OhCircuitEditDialog ohCircuitEditDialog) throws NullPointerException, UnsupportedOperationException {
        super(new OhNetCircuitModel(ohCircuit));
        this.ced = ohCircuitEditDialog;
        this.currentCircuit = ohCircuit;
        if (this.currentCircuit == null) {
            throw new NullPointerException("The circuit is null.");
        }
        if (db.on()) {
            db.println("Editing circuit " + this.currentCircuit.getCircuitName());
        }
        if (db.on()) {
            db.println("\tAdding general tab.");
        }
        this.addGeneralEditTab();
        if (db.on()) {
            db.println("\tAdded general tab.");
        }
        boolean bl = false;
        bl = this.currentCircuit instanceof OwCircuit;
        if (bl && this.currentCircuit.isComplete() && this.currentCircuit.isTerm2TermCircuit() && !this.currentCircuit.getSource().equals(this.currentCircuit.getFirstDestination())) {
            this.addOwTab();
        }
        boolean bl2 = false;
        boolean bl3 = bl2 = this.currentCircuit.getCircuitType() == 6;
        if (bl2 || this.isValidForUpgrade()) {
            this.addIpTunnelTab();
        }
    }

    private boolean isSdccChannel(int n) {
        return n == 0;
    }

    private void addOwTab() {
        this.addTab(OW_TAB, (Component)((Object)new OhCedOwPane(OW_TAB, this)));
    }

    private void addIpTunnelTab() {
        this.addTab(IP_TUNNEL_TAB, (Component)((Object)new OhCedIpTunnelPane(IP_TUNNEL_TAB, this)));
    }

    private void addGeneralEditTab() {
        this.addTab(GENERAL_TAB, (Component)((Object)new OhCedGeneralPane(GENERAL_TAB, this)));
    }

    private boolean isValidForUpgrade() {
        boolean bl = false;
        boolean bl2 = false;
        if (this.currentCircuit.getCircuitTypeObj().isDccTunnelType()) {
            List list = this.currentCircuit.getConnections();
            OhNetCircuitEnd ohNetCircuitEnd = this.currentCircuit.getSource();
            IOhCircuitEnd iOhCircuitEnd = (IOhCircuitEnd)this.currentCircuit.getDestinations().get(0);
            Integer n = new Integer(ohNetCircuitEnd.getNodeId());
            Integer n2 = new Integer(iOhCircuitEnd.getNodeId());
            for (IOhConnectionModel iOhConnectionModel : list) {
                int n3;
                Integer n4 = new Integer(iOhConnectionModel.getNodeModel().getNodeId());
                IOhXconModel iOhXconModel = (IOhXconModel)iOhConnectionModel;
                if (n4.equals(n)) {
                    n3 = iOhXconModel.getInputChannelType();
                    if (!this.isSdccChannel(n3)) continue;
                    bl = true;
                    continue;
                }
                if (!n4.equals(n2) || !this.isSdccChannel(n3 = iOhXconModel.getOutputChannelType())) continue;
                bl2 = true;
            }
        }
        return bl && bl2;
    }

    protected Attribute[] getAttributes(String string) {
        return NetworkDefaults.getAttributeMap().getAttributeArray(string);
    }

    public void setUpgradeInProgress(boolean bl) {
        this.upgradeInProgress = bl;
        if (!this.upgradeInProgress) {
            this.ced.dispose();
        }
    }

    public boolean getUpgradeInProgress() {
        return this.upgradeInProgress;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        return new Dimension(500, 210);
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        super.stateChanged(changeEvent);
        Pane pane = this.getCurrentPane();
        if (pane != null && pane instanceof AbstractPane && this.ced != null) {
            AbstractPane abstractPane = (AbstractPane)pane;
            JTable jTable = abstractPane.getTable();
            CSHelpID cSHelpID = this.getPaneHelpID(pane);
            if (cSHelpID == null) {
                this.ced.enableHelp(false);
            } else {
                this.ced.enableHelp(true);
            }
        }
    }

    public CSHelpID getHelpID() {
        return this.getPaneHelpID(this.getCurrentPane());
    }

    private CSHelpID getPaneHelpID(Pane pane) {
        if (pane instanceof OhCedGeneralPane) {
            return NetCSHelpConst.OhCedGeneralPane;
        }
        if (pane instanceof OhCedOwPane) {
            return NetCSHelpConst.OhCedOwPane;
        }
        if (pane instanceof OhCedIpTunnelPane) {
            return NetCSHelpConst.OhCedIpTunnelPane;
        }
        return null;
    }

    public void displayErrorDialog(TabbedView tabbedView, Exception exception, EID eID) {
    }
}

