/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ohcircuits;

import cerent.cms.model.INodeModel;
import cerent.cms.model.IOhCircuitEnd;
import cerent.cms.ocm.OhCircuit;
import cerent.cms.ocm.OhNetCircuitEnd;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.NetElemComparator;
import cerent.cms.topo.NetLinkComparator;
import cerent.cms.topo.Network;
import cerent.cms.ui.network.AbstractNetworkMap;
import cerent.cms.ui.network.NetMapFactory;
import cerent.cms.ui.network.NetMapLink;
import cerent.cms.ui.ohcircuits.OhCircuitColumnRenderer;
import cerent.util.ColorUtil;
import cerent.util.Preferences;
import cerent.util.SDebug;
import com.cisco.ctc.util.map.MapLink;
import com.cisco.ctc.util.map.MapNode;
import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;

public class OhCircuitMap
extends AbstractNetworkMap
implements PropertyChangeListener {
    protected INetElement srcNE;
    private TreeSet circuitNodes;
    private TreeSet circuitLinks;
    private Network network;
    private OhCircuit circuit;
    public static String PREFS_CIRCUIT_KEY = "ctc.circuits";
    public static String PREFS_ACTIVE_SPAN = "activespan";
    public static String PREFS_STANDBY_SPAN = "standbyspan";
    public static final Color COLOR_DEFAULT_ACTIVE = Color.green;
    public static final Color COLOR_DEFAULT_STANDBY = new Color(128, 0, 192);
    private static final SDebug db = new SDebug("OhCircuitMap");

    public OhCircuitMap(OhCircuit ohCircuit) {
        super(db, 0, NetMapFactory.instance());
        this.circuit = ohCircuit;
        Preferences.instance().addPropertyChangeListener((PropertyChangeListener)this);
        NetMapLink.LINK_ACTIVE_COLOR = OhCircuitMap.getPrefColor(PREFS_ACTIVE_SPAN);
        NetMapLink.LINK_STANDBY_COLOR = OhCircuitMap.getPrefColor(PREFS_STANDBY_SPAN);
        this.updateView();
        this.circuitNodes = new TreeSet(new NetElemComparator());
        this.circuitLinks = new TreeSet(new NetLinkComparator());
        this.network = Network.instance();
    }

    protected void clearNodeMarkers() {
        MapNode[] mapNodeArray = this.getMapNodes();
        for (int i = 0; i < mapNodeArray.length; ++i) {
            MapNode mapNode = mapNodeArray[i];
            if (!this.nodeIsForwardable(mapNode)) continue;
            mapNode.setDesc(null);
        }
    }

    public INetLink findReverseLink(INetLink iNetLink) {
        return this.netModel.findReverseLink(iNetLink);
    }

    private String getPoint(OhNetCircuitEnd ohNetCircuitEnd, boolean bl) {
        if (ohNetCircuitEnd == null) {
            if (this.dbg.on()) {
                this.dbg.println("ckt end is null");
            }
            return null;
        }
        return OhCircuitColumnRenderer.getEndpoint(ohNetCircuitEnd.getNetElement(), ohNetCircuitEnd, this.circuit, bl, true);
    }

    protected void addNodeMarkers() {
        this.addSourceNodeMarker();
        this.addDestinationNodeMarkers();
    }

    protected void addSourceNodeMarker() {
        this.addNodeMarker(this.circuit.getSource(), true);
    }

    protected void addDestinationNodeMarkers() {
        this.addNodeMarker(this.circuit.getFirstDestination(), false);
        OhNetCircuitEnd ohNetCircuitEnd = this.circuit.getSource();
        List list = this.circuit.getDestinations();
        for (int i = 1; i < list.size(); ++i) {
            if (ohNetCircuitEnd == null) continue;
            this.addNodeMarker(new OhNetCircuitEnd((IOhCircuitEnd)list.get(i), ohNetCircuitEnd.getNodeId()), false);
        }
    }

    protected void addNodeMarker(OhNetCircuitEnd ohNetCircuitEnd, boolean bl) {
        MapNode mapNode;
        if (ohNetCircuitEnd.getNodeModel() != null && (mapNode = this.getMapNode(ohNetCircuitEnd.getNodeModel())) != null) {
            mapNode.addDesc(bl ? "Source" : "Destination");
            OhCircuit ohCircuit = this.getOhCircuit();
            String string = this.getPoint(ohNetCircuitEnd, bl);
            if (string != null) {
                mapNode.addDesc(string);
            }
        }
    }

    protected OhCircuit getOhCircuit() {
        return this.circuit;
    }

    public void setOhCircuit(OhCircuit ohCircuit) {
        this.circuit = ohCircuit;
        this.reInitMap();
    }

    protected INodeModel getCktSrcNodeModel() {
        OhNetCircuitEnd ohNetCircuitEnd = this.circuit.getSource();
        if (ohNetCircuitEnd != null) {
            INetElement iNetElement = this.network.getNetElem(this.circuit.getSource().getNodeId());
            return iNetElement == null ? null : iNetElement.getNodeModel();
        }
        if (db.on()) {
            db.println("ckt source node is null");
        }
        return null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals(PREFS_ACTIVE_SPAN)) {
            NetMapLink.LINK_ACTIVE_COLOR = OhCircuitMap.getPrefColor(PREFS_ACTIVE_SPAN);
        }
        if (string.equals(PREFS_STANDBY_SPAN)) {
            NetMapLink.LINK_STANDBY_COLOR = OhCircuitMap.getPrefColor(PREFS_STANDBY_SPAN);
        }
        this.updateView();
    }

    @Override
    public void dispose() {
        Preferences.instance().removePropertyChangeListener((PropertyChangeListener)this);
        this.network = null;
        super.dispose();
    }

    protected void showCircuitObjects() {
        INodeModel iNodeModel = this.getCktSrcNodeModel();
        if (iNodeModel != null) {
            this.srcNE = this.network.getNetElem(this.getCktSrcNodeModel().getNodeId());
            this.circuitNodes.add(this.srcNE);
            this.findConnectedNEs(this.srcNE);
            Iterator iterator = this.circuitNodes.iterator();
            while (iterator.hasNext()) {
                INodeModel iNodeModel2 = ((INetElement)iterator.next()).getNodeModel();
                this.addNode(iNodeModel2, true, null);
            }
            this.initializeMapLinks(this.circuitLinks);
            this.circuitNodes.clear();
            this.circuitLinks.clear();
            this.clearNodeMarkers();
            this.addNodeMarkers();
            this.traceCircuit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void traceCircuit() {
        MapLink mapLink;
        Object object = this;
        synchronized (object) {
            for (INetLink iNetLink : this.getLinkUserObjects()) {
                mapLink = this.getMapLink(iNetLink);
                this.setNetMapLinkState("traceCircuit()", mapLink, 1);
            }
        }
        object = this.circuit.getCircuitSpans();
        if (object == null) {
            return;
        }
        if (db.on()) {
            db.finer("Circuit spans: ");
        }
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            INetLink iNetLink;
            iNetLink = (INetLink)iterator.next();
            if (db.on()) {
                db.finer(iNetLink.prettyString());
            }
            if ((mapLink = this.getMapLink(iNetLink)) == null) {
                INetLink iNetLink2 = this.findReverseLink(iNetLink);
                mapLink = this.getMapLink(iNetLink2);
            }
            if (mapLink == null) {
                this.addLink(iNetLink, null);
                mapLink = this.getMapLink(iNetLink);
            }
            if (mapLink == null) continue;
            this.setNetMapLinkState("traceCircuit()", mapLink, 4);
        }
        this.updateView();
    }

    private void findConnectedNEs(INetElement iNetElement) {
        List list = this.network.findAllNetLinksWithNetElem(iNetElement);
        if (db.on()) {
            db.fine("Found " + list.size() + " connected links");
        }
        if (list.size() == 0) {
            return;
        }
        for (INetLink iNetLink : list) {
            INetElement iNetElement2 = iNetLink.getSrc();
            INetElement iNetElement3 = iNetLink.getDst();
            if (this.circuitLinks.contains(iNetLink)) continue;
            this.circuitLinks.add(iNetLink);
            if (!this.circuitNodes.contains(iNetElement2)) {
                this.circuitNodes.add(iNetElement2);
                this.findConnectedNEs(iNetElement2);
            }
            if (this.circuitNodes.contains(iNetElement3)) continue;
            this.circuitNodes.add(iNetElement3);
            this.findConnectedNEs(iNetElement3);
        }
    }

    public static Color getPrefColor(String string) {
        String string2 = Preferences.instance().getProperty(PREFS_CIRCUIT_KEY, string, null);
        if (string.equals(PREFS_ACTIVE_SPAN)) {
            return ColorUtil.getColor(string2, COLOR_DEFAULT_ACTIVE);
        }
        return ColorUtil.getColor(string2, COLOR_DEFAULT_STANDBY);
    }
}

