/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ohcircuits;

import cerent.cms.model.Feature;
import cerent.cms.model.IModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.NodeModel;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.ohcircuits.OhCircuitDataSource;
import cerent.cms.ocm.OhCircuit;
import cerent.cms.ocm.OhCircuitManager;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.CSHelpButton;
import cerent.cms.ui.IPreselectCircuits;
import cerent.cms.ui.NetCSHelpConst;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.circuits.ByNameTable;
import cerent.cms.ui.ohcircuits.OhCircuitColumnRenderer;
import cerent.cms.ui.ohcircuits.OhCircuitCreationDialog;
import cerent.cms.ui.ohcircuits.OhCircuitEditDialog;
import cerent.cms.ui.ohcircuits.OhCircuitSearchDialog;
import cerent.util.AnnotatedException;
import cerent.util.CEMC;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.IAsyncObserver;
import cerent.util.NEMC;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.row.RowDataSource;
import cerent.util.gui.row.RowDataSourceListener;
import cerent.util.gui.row.SortableRowTableModel;
import cerent.util.job.JobStatus;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class OhCircuitsPane
extends AbstractPane
implements ActionListener,
IAsyncObserver,
IPreselectCircuits,
TableModelListener,
RowDataSourceListener,
ListSelectionListener,
MouseListener {
    public static final String CREATE = "Create...";
    public static final String DELETE = "Delete...";
    public static final String EDIT = "Edit...";
    public static final String SEARCH = "Search...";
    public static final String MERGE = "Merge...";
    public static final String UPGRADE = "Upgrade";
    private static final String SCOPE_NET = "Network";
    private static final String SCOPE_NODE = "Node";
    private static final String SCOPE_CARD = "Card";
    UScrollPane scrollPane;
    private JPanel buttons;
    private JButton createPB;
    private JButton deletePB;
    private JButton editPB;
    private JButton mergePB;
    private JButton searchPB;
    private JButton upgradePB;
    private JComboBox scopeCB;
    private Vector circuitsVector;
    private SortableRowTableModel model;
    private OhCircuitDataSource source;
    private boolean inited = false;
    private OhCircuitSearchDialog csd = null;
    private List preselectedCircuitIds = null;
    private boolean preselectionsActive = false;
    private static final SDebug db = new SDebug("OhCircuitsPane");

    public OhCircuitsPane(String string, IModel iModel, TabbedView tabbedView) {
        super(string, iModel, tabbedView);
        this.setDefaultPrivilegeLevel(SecurityLevel.PROVISIONING);
    }

    @Override
    public void enteringPage() {
        if (!this.inited) {
            this.buttons = this.getButtonBar();
            this.setDefaultCircuitScope();
            this.source = new OhCircuitDataSource(this.getCurrentCircuitScope());
            this.source.addRowDataSourceListener(this);
            this.model = new SortableRowTableModel((RowDataSource)this.source, OhCircuitColumnRenderer.createTableRenderers(0), OhCircuit.class);
            this.table = new ByNameTable(this.model);
            this.updateCircuitSearchInfo();
            this.upgradePB.setVisible(false);
            this.setLayout(new BorderLayout());
            this.scrollPane = new UScrollPane((Component)this.table);
            this.scrollPane.getViewport().setScrollMode(0);
            this.add((Component)this.scrollPane, "Center");
            this.add(this.buttons, "South");
            this.table.addMouseListener(this);
            this.table.getSelectionModel().addListSelectionListener(this);
            this.model.addTableModelListener(this);
            this.inited = true;
        } else {
            this.source.setEnabled(true);
        }
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
    }

    @Override
    public void leavingPage() throws Exception {
        this.source.setEnabled(false);
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
    }

    @Override
    public void refresh() {
    }

    @Override
    public void destroy() {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        if (this.inited) {
            this.model.release();
            this.source.removeRowDataSourceListener(this);
            this.source.dispose();
        }
        this.preselectedCircuitIds = null;
        super.destroy();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.createPB) {
            this.createCircuit();
        } else if (object == this.deletePB) {
            this.deleteSelectedCircuits(this.getSelectedCircuits("Delete", true, "Deleting overhead circuits with ports enabled will affect traffic being transported on the overhead circuits.\n"));
        } else if (object == this.editPB) {
            this.editSelectedCircuits(this.getSelectedCircuits("Edit", false));
        } else if (object == this.mergePB) {
            this.mergeCircuits();
        } else if (object == this.searchPB) {
            this.csd = OhCircuitSearchDialog.getInstance((JComponent)((Object)this), this.table, this.scrollPane, this.circuitsVector);
            if (this.table.getSelectedRowCount() > 0) {
                OhCircuit ohCircuit = (OhCircuit)this.table.getValueAt(this.table.getSelectedRow(), 0);
                this.csd.setSelectedCircuit(ohCircuit);
            }
            this.csd.show();
        } else if (object == this.scopeCB && this.source != null) {
            this.source.setCircuitScope(this.getCurrentCircuitScope());
        }
        this.syncButtons(true);
    }

    private void createCircuit() {
        OhCircuitCreationDialog ohCircuitCreationDialog = OhCircuitCreationDialog.instance((JComponent)((Object)this));
        IModel iModel = this.getUiModel();
        if (iModel instanceof NodeModel) {
            ohCircuitCreationDialog.setSourceNode((NodeModel)iModel);
            ohCircuitCreationDialog.setDestNode((NodeModel)iModel);
        } else if (iModel instanceof IModuleModel) {
            INodeModel iNodeModel = iModel.getNodeModel();
            if (iNodeModel instanceof NodeModel) {
                ohCircuitCreationDialog.setSourceNode((NodeModel)iNodeModel);
                ohCircuitCreationDialog.setDestNode((NodeModel)iNodeModel);
            } else {
                ohCircuitCreationDialog.setSourceNode(null);
                ohCircuitCreationDialog.setDestNode(null);
            }
        }
        ohCircuitCreationDialog.show();
    }

    private void mergeCircuits() {
        String string = "The merged UDC and Orderwire circuits can form termination-to-termination\npaths.\nSuch paths are formed by one termination-to-cross-connection \ncircuit, zero or more cross-connection-to-cross-connection circuits \nand one cross-connection-to-termination circuit, \nconnected by existing links.\nAre you sure you want to continue?";
        if (CerentDialog.yesNoDialog((Component)((Object)this), (String)string, (String)"Merge Circuit")) {
            try {
                int n = OhCircuitManager.instance().mergeAllCircuits();
                CerentDialog.infoDialog((Component)((Object)this), (String)("In total " + n + " circuits were " + "successfully merged."), (String)"Circuit Merge Succeeded");
            }
            catch (AnnotatedException annotatedException) {
                SDebug.printStackTrace((Throwable)annotatedException);
                ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_ERROR_MERGE_CIRCUITS_PARAM_1, (Object)annotatedException.getMessage());
            }
        }
    }

    public OhCircuit[] getSelectedCircuits(String string, boolean bl) {
        return this.getSelectedCircuits(string, bl, "");
    }

    private OhCircuit[] getSelectedCircuits(String string, boolean bl, String string2) {
        int[] nArray = this.table.getSelectedRows();
        OhCircuit[] ohCircuitArray = new OhCircuit[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            ohCircuitArray[i] = (OhCircuit)this.model.getValueAt(nArray[i], 0);
        }
        if (ohCircuitArray.length == 0) {
            ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_NO_CIRCUITS_SELECTED_PARAM_1, (Object)(string + " circuit."));
        } else if (bl && !CerentDialog.yesNoDialog((Component)((Object)this), (String)(string2 = string2 + "Are you sure you want to " + string.toLowerCase() + " the " + (ohCircuitArray.length == 1 ? " selected circuit?" : " " + ohCircuitArray.length + " selected circuits?")), (String)(string + " Circuit"))) {
            ohCircuitArray = new OhCircuit[]{};
        }
        return ohCircuitArray;
    }

    private void deleteSelectedCircuits(OhCircuit[] ohCircuitArray) {
        Object object;
        int[] nArray = OhCircuitManager.instance().deleteCheck(ohCircuitArray);
        OhCircuit[] ohCircuitArray2 = ohCircuitArray;
        int n = ohCircuitArray.length;
        if (nArray != null) {
            int n2;
            object = "Deleting partial circuit";
            Object[] objectArray = new String[]{"Yes", "Yes to All", "No", "Cancel"};
            boolean bl = false;
            int n3 = 2;
            n = ohCircuitArray.length - nArray.length;
            for (n2 = 0; n2 < nArray.length && !bl; ++n2) {
                String string = "The circuit \"" + ohCircuitArray[nArray[n2]].getCircuitName() + "\"" + "is in the PARTIAL state; deletion might strand bandwidth." + "\nIs it OK to force the deletion of the circuit?";
                n3 = JOptionPane.showOptionDialog((Component)((Object)this), string, (String)object, -1, 2, null, objectArray, objectArray[2]);
                if (n3 == 1) {
                    n = ohCircuitArray.length;
                    bl = true;
                    break;
                }
                if (n3 == 2) continue;
                if (n3 == 3) {
                    n = 0;
                    break;
                }
                if (n3 != 0) continue;
                nArray[n2] = -1;
                ++n;
            }
            if (n > 0) {
                if (bl) {
                    ohCircuitArray2 = ohCircuitArray;
                } else {
                    ohCircuitArray2 = new OhCircuit[n];
                    n2 = 0;
                    int n4 = 0;
                    for (int i = 0; i < ohCircuitArray.length; ++i) {
                        if (n2 < nArray.length && i == nArray[n2]) {
                            ++n2;
                            continue;
                        }
                        if (n4 >= n) continue;
                        ohCircuitArray2[n4++] = ohCircuitArray[i];
                        if (n2 >= nArray.length || nArray[n2] != -1) continue;
                        ++n2;
                    }
                }
            }
        }
        try {
            if (n > 0) {
                for (int i = 0; i < ohCircuitArray2.length; ++i) {
                    object = ohCircuitArray2[i];
                    if (!((OhCircuit)object).isCircuitNodesInVersionUp()) continue;
                    ErrorMsg.displayDetailed((Component)((Object)this), NEMC.EID_CIRCUIT_DELETION_ERROR, CEMC.EID_NODE_UPGRADING_EXCEPTION.getMessage());
                    return;
                }
                OhCircuitManager.instance().deleteSelectedCircuits(ohCircuitArray2, this);
            }
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_CIRCUIT_DELETION_ERROR);
        }
    }

    private void editSelectedCircuits(OhCircuit[] ohCircuitArray) {
        for (int i = 0; i < ohCircuitArray.length; ++i) {
            if (ohCircuitArray[i].isComplete()) {
                OhCircuitEditDialog.getInstance(ohCircuitArray[i]).show();
                continue;
            }
            CerentDialog.infoDialog((Component)((Object)this), (String)"Circuits in the PARTIAL state cannot be edited.", (String)"Circuit Edit");
        }
    }

    private JPanel getButtonBar() {
        this.createPB = this.makeActionButton(CREATE);
        this.deletePB = this.makeActionButton(DELETE);
        this.editPB = this.makeActionButton(EDIT);
        this.editPB.setEnabled(this.isUserAuthorized(SecurityLevel.PROVISIONING));
        this.mergePB = this.makeActionButton(MERGE);
        this.searchPB = this.makeActionButton(SEARCH);
        this.searchPB.setEnabled(true);
        this.upgradePB = this.makeActionButton(UPGRADE);
        this.scopeCB = new JComboBox<Object>(new Object[]{SCOPE_NET, SCOPE_NODE});
        this.scopeCB.addActionListener(this);
        JPanel jPanel = OhCircuitsPane.createHorizontalPanel(null);
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 5, 5));
        JPanel jPanel3 = new JPanel(new FlowLayout(0, 5, 5));
        jPanel2.add(this.createPB);
        jPanel2.add(this.editPB);
        jPanel2.add(this.deletePB);
        jPanel2.add(this.mergePB);
        jPanel2.add(this.searchPB);
        jPanel2.add(this.upgradePB);
        jPanel3.add(new CSHelpButton(NetCSHelpConst.OhCircuitsPane));
        jPanel.add((Component)jPanel2, "Center");
        jPanel.add((Component)jPanel3, "East");
        return jPanel;
    }

    private JButton makeActionButton(String string) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(this);
        jButton.setFocusPainted(false);
        this.enableComponent(jButton);
        return jButton;
    }

    private void setDefaultCircuitScope() {
        IModel iModel = this.getUiModel();
        if (iModel instanceof IModuleModel) {
            this.scopeCB.setEnabled(true);
            this.scopeCB.addItem(SCOPE_CARD);
            this.scopeCB.setSelectedItem(SCOPE_CARD);
        } else if (iModel instanceof INodeModel) {
            this.scopeCB.setEnabled(true);
            this.scopeCB.setSelectedItem(SCOPE_NODE);
        } else {
            this.scopeCB.setEnabled(false);
            this.scopeCB.setSelectedItem(SCOPE_NET);
        }
    }

    private IModel getCurrentCircuitScope() {
        Object object = this.scopeCB.getSelectedItem();
        INodeModel iNodeModel = null;
        if (SCOPE_NET.equals(object)) {
            iNodeModel = null;
        } else if (SCOPE_NODE.equals(object)) {
            iNodeModel = this.getUiModel().getNodeModel();
        } else if (SCOPE_CARD.equals(object)) {
            iNodeModel = this.getUiModel();
        }
        return iNodeModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCircuitSearchInfo() {
        int n = this.model.getRowCount();
        this.circuitsVector = new Vector(n);
        for (int i = 0; i < n; ++i) {
            try {
                OhCircuit ohCircuit = (OhCircuit)this.table.getValueAt(i, 0);
                this.circuitsVector.add(ohCircuit);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (OhCircuitsPane.db.on) {
            db.fine("CircuitsPane:updateCircuitSearchInfo: " + this.circuitsVector.toString());
        }
        if (this.csd == null) {
            return;
        }
        OhCircuitSearchDialog ohCircuitSearchDialog = this.csd;
        synchronized (ohCircuitSearchDialog) {
            this.csd.setCircuitsVector(this.circuitsVector);
            this.csd.setTable(this.table);
        }
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        this.updateCircuitSearchInfo();
        this.syncButtons(false);
        if (this.preselectionsActive) {
            this.selectPreselectedCircuits();
        }
    }

    private void selectPreselectedCircuits() {
        if (null != this.table) {
            this.table.clearSelection();
            OhCircuit ohCircuit = null;
            for (int i = 0; i < this.table.getRowCount(); ++i) {
                ohCircuit = (OhCircuit)this.table.getValueAt(i, 0);
                if (null != ohCircuit) {
                    if (!this.preselectedCircuitIds.contains(ohCircuit.getCircuitId())) continue;
                    this.table.getSelectionModel().addSelectionInterval(i, i);
                    continue;
                }
                if (!OhCircuitsPane.db.on) continue;
                db.fine("netCircuit was null");
            }
        } else if (OhCircuitsPane.db.on) {
            db.fine("table was null");
        }
    }

    public void asyncUpdate(Object object, JobStatus jobStatus) {
        final String string = (String)jobStatus.getResult();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                CerentDialog.infoDialog((Component)((Object)OhCircuitsPane.this), (String)string, (String)"Circuit Deletion Result");
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void setPreselectedCircuitIds(List list) {
        this.preselectedCircuitIds = list;
        if (this.preselectedCircuitIds == null || this.preselectedCircuitIds.size() < 2) {
            CerentDialog.infoDialog((Component)((Object)this), (String)"There are no circuits affected by this alarm.", (String)"No Circuits Affected");
        } else {
            this.preselectionsActive = true;
            this.selectPreselectedCircuits();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!listSelectionEvent.getValueIsAdjusting()) {
            this.syncButtons(true);
        }
    }

    private void syncButtons(boolean bl) {
        int n;
        int n2 = this.table != null ? this.table.getSelectedRowCount() : -1;
        int n3 = n = this.table != null ? this.table.getRowCount() : -1;
        if (db.on()) {
            db.fine("syncButtons " + (n2 != -1 && n != -1 ? n2 + "/" + n + " (Sel/Tot)" + (n2 > n ? " !!!" : "") : "table is null"));
        }
        if (this.table != null) {
            boolean bl2;
            boolean bl3 = bl2 = this.table.getSelectedRowCount() > 0 && this.table.getRowCount() > 0;
            if (bl2) {
                this.enableComponent(this.deletePB);
                this.editPB.setEnabled(this.isUserAuthorized(SecurityLevel.PROVISIONING));
                if (bl) {
                    this.updateCircuitSearchInfo();
                }
            } else {
                this.editPB.setEnabled(false);
                this.deletePB.setEnabled(false);
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        int n;
        this.preselectionsActive = false;
        this.preselectedCircuitIds = null;
        if (mouseEvent.getClickCount() == 2 && (n = this.table.rowAtPoint(mouseEvent.getPoint())) != -1) {
            this.table.setRowSelectionInterval(n, n);
            if (this.isUserAuthorized(SecurityLevel.PROVISIONING)) {
                this.editSelectedCircuits(this.getSelectedCircuits("Edit", false));
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void rowsAdded(int n, int n2) {
    }

    public void rowsUpdated(int n, int n2) {
    }

    public void rowsDeleted(int n, int n2) {
    }

    public void dataSourceChanged() {
        if (this.preselectionsActive) {
            this.delayedSelectPreselectedCircuits();
        }
    }

    public void dataStructureChanged() {
    }

    public void bulkRowAdded(int n, Object object) {
    }

    public void bulkRowUpdated(int n, Object object, Object object2) {
    }

    public void bulkRowDeleted(int n, Object object) {
    }

    public void bulkDataSourceChanged() {
        if (this.preselectionsActive) {
            this.delayedSelectPreselectedCircuits();
        }
    }

    public void bulkUpdateView() {
    }

    private void delayedSelectPreselectedCircuits() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                OhCircuitsPane.this.selectPreselectedCircuits();
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    private boolean isMSNode(INodeModel iNodeModel) {
        boolean bl = false;
        if (Feature.provides((INodeModel)iNodeModel, (Feature)Feature.MULTISHELF)) {
            bl = iNodeModel.isMultishelf();
        }
        return bl;
    }
}

