/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ppc;

import cerent.cms.loader.ElementFactoryFinder;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IOpticsPortModel;
import cerent.cms.model.OchPortsHelper;
import cerent.cms.ui.IEntityCellRenderer;
import cerent.cms.ui.circuits.CircuitEndCellRenderer;
import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;

public class CombosCellRenderer
extends DefaultListCellRenderer {
    private final boolean fullRenderer;
    private final boolean showPortTypes;
    private final boolean showTooltip;

    public CombosCellRenderer(boolean bl, boolean bl2, boolean bl3) {
        this.showPortTypes = bl;
        this.fullRenderer = bl2;
        this.showTooltip = bl3;
    }

    public CombosCellRenderer(boolean bl, boolean bl2) {
        this(bl, bl2, false);
    }

    public CombosCellRenderer(boolean bl) {
        this(false, bl, false);
    }

    @Override
    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
        String string = "";
        if (object instanceof INodeModel) {
            string = ((INodeModel)object).getName();
        } else if (object instanceof Integer) {
            string = object.toString();
        } else if (object instanceof IModuleModel) {
            string = CombosCellRenderer.toString((IModuleModel)object);
        } else if (object instanceof IEntityModel) {
            string = this.showPortTypes ? CombosCellRenderer.toString((IEntityModel)object, this.showPortTypes, this.fullRenderer) : CombosCellRenderer.toString((IEntityModel)object, this.fullRenderer);
            if (bl && this.showTooltip) {
                this.setToolTipText(CombosCellRenderer.getTooltipStr((IEntityModel)object));
            }
        } else if (object != null) {
            string = object.toString();
        }
        this.setText(string);
        return this;
    }

    public static String toString(IModuleModel iModuleModel) {
        INodeModel iNodeModel = iModuleModel.getNodeModel();
        IEntityCellRenderer iEntityCellRenderer = ElementFactoryFinder.getElementFactory(iNodeModel).createEntityCellRenderer(iModuleModel);
        return iEntityCellRenderer.getString((Object)iModuleModel, null).trim();
    }

    public static String toString(IEntityModel iEntityModel, boolean bl) {
        String string = CircuitEndCellRenderer.getPortString(iEntityModel, true);
        string = string + OchPortsHelper.getSideString(iEntityModel, OchPortsHelper.SideStringType.SlashSeparated);
        if (bl) {
            string = CombosCellRenderer.toString(iEntityModel.getModuleModel()) + "/" + string;
        }
        return string;
    }

    public static String toString(IEntityModel iEntityModel, boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer(10);
        if (bl2) {
            stringBuffer.append(CombosCellRenderer.toString(iEntityModel.getModuleModel()) + "/");
        }
        if (bl) {
            try {
                stringBuffer.append(CircuitEndCellRenderer.getPortString(iEntityModel, true));
                if (iEntityModel instanceof IOpticsPortModel) {
                    stringBuffer.append(" (");
                    stringBuffer.append(((IOpticsPortModel)iEntityModel).getOptPortTypeString());
                    stringBuffer.append(")");
                }
            }
            catch (Exception exception) {
                stringBuffer.append("N/A");
            }
        }
        return stringBuffer.toString();
    }

    public static final String getTooltipStr(IEntityModel iEntityModel) {
        StringBuffer stringBuffer = new StringBuffer(20);
        INodeModel iNodeModel = iEntityModel.getNodeModel();
        IEntityCellRenderer iEntityCellRenderer = ElementFactoryFinder.getElementFactory(iNodeModel).createEntityCellRenderer(iEntityModel.getModuleModel());
        stringBuffer.append(iEntityCellRenderer.getString((Object)iEntityModel.getModuleModel(), "shelf "));
        stringBuffer.append("/");
        stringBuffer.append(CircuitEndCellRenderer.getPortString(iEntityModel, true));
        stringBuffer.append(OchPortsHelper.getSideString(iEntityModel, OchPortsHelper.SideStringType.SlashSeparated));
        return stringBuffer.toString();
    }
}

