/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ppc;

import cerent.cms.ncp.PPCRepairOperator;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NetCSHelpConst;
import cerent.cms.ui.PPCRepairDialog;
import cerent.cms.ui.WzDiagDebug;
import cerent.cms.ui.WzDialog;
import cerent.cms.ui.WzPane;
import cerent.cms.ui.ppc.PPCRepairInfo;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.UScrollPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;

public class PPCRepGuessTerms
extends WzPane {
    private JList list;
    private DefaultListModel model;

    public PPCRepGuessTerms(WzDialog wzDialog, WzDiagDebug wzDiagDebug, String string) {
        super(wzDialog, wzDiagDebug, string);
    }

    @Override
    public void enteringPane() {
        block4: {
            super.enteringPane();
            PPCRepairOperator pPCRepairOperator = PPCRepairOperator.newInstance();
            try {
                this.model.clear();
                List<PPCRepairOperator.IpChange> list = pPCRepairOperator.discoverIpChanges();
                for (PPCRepairOperator.IpChange ipChange : list) {
                    this.model.addElement(ipChange);
                }
                if (list.size() > 0) {
                    this.list.setSelectedIndex(0);
                }
            }
            catch (Exception exception) {
                CerentDialog.errorDialog((Component)this, (String)"Discovery failed.");
                if (!this.db.on()) break block4;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    @Override
    public void validatePage() throws Exception {
        PPCRepairInfo pPCRepairInfo = ((PPCRepairDialog)this.parent).getInfo();
        PPCRepairOperator.IpChange ipChange = this.getSelected();
        if (ipChange == null) {
            throw new Exception("You must select one IP change to proceed.");
        }
        pPCRepairInfo.setIpChange(ipChange);
    }

    @Override
    protected String getNextPaneName() {
        return "PPC Terminations to Repair";
    }

    @Override
    protected void initPane() {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new BorderLayout(5, 5));
        jPanel.add((Component)new JLabel("Select the IP change to apply:"), "North");
        this.model = new DefaultListModel();
        this.list = new JList(this.model);
        this.list.setCellRenderer(new IpChangeRenderer());
        UScrollPane uScrollPane = new UScrollPane((Component)this.list);
        jPanel.add((Component)uScrollPane, "Center");
        this.add((Component)jPanel, "Center");
    }

    @Override
    public CSHelpID getHelpID() {
        return NetCSHelpConst.PPCRepDiscoveryPane;
    }

    @Override
    public JComponent getStatusComponent() {
        PPCRepairOperator.IpChange ipChange = this.getSelected();
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        arrayList.add(new String[]{"IP change: ", "from " + ipChange.getOldIp() + " to " + ipChange.getCurrIp()});
        return PPCRepGuessTerms.getGridPanel(arrayList);
    }

    @Override
    protected String getStatusText() {
        StringBuffer stringBuffer = new StringBuffer();
        PPCRepairOperator.IpChange ipChange = this.getSelected();
        stringBuffer.append("Discovered IP change: from " + ipChange.getOldIp() + " to " + ipChange.getCurrIp());
        return stringBuffer.toString();
    }

    PPCRepairOperator.IpChange getSelected() {
        return (PPCRepairOperator.IpChange)this.list.getSelectedValue();
    }

    static class IpChangeRenderer
    extends DefaultListCellRenderer {
        IpChangeRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            if (object instanceof PPCRepairOperator.IpChange) {
                PPCRepairOperator.IpChange ipChange = (PPCRepairOperator.IpChange)object;
                this.setText("Old IP: " + ipChange.getOldIp() + ", Current IP: " + ipChange.getCurrIp());
            }
            return this;
        }
    }
}

