/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ppc;

import cerent.cms.model.INodeModel;
import cerent.cms.ncp.PPCRepairOperator;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NetCSHelpConst;
import cerent.cms.ui.PPCRepairDialog;
import cerent.cms.ui.WzDiagDebug;
import cerent.cms.ui.WzDialog;
import cerent.cms.ui.WzPane;
import cerent.cms.ui.ppc.CombosCellRenderer;
import cerent.cms.ui.ppc.PPCHelper;
import cerent.cms.ui.ppc.PPCRepairInfo;
import cerent.util.InetUtil;
import cerent.util.gui.UComboBox;
import cerent.util.gui.UScrollPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;

public class PPCRepPreamble
extends WzPane {
    private RepairTypeAttr typeAttr;

    public PPCRepPreamble(WzDialog wzDialog, WzDiagDebug wzDiagDebug, String string) {
        super(wzDialog, wzDiagDebug, string);
    }

    @Override
    public void validatePage() throws Exception {
        PPCRepairInfo pPCRepairInfo = ((PPCRepairDialog)this.parent).getInfo();
        if (this.typeAttr.isToDiscover()) {
            pPCRepairInfo.setToDiscover(true);
        } else {
            InetUtil.makeIpAddr(this.typeAttr.getPrevIp());
            pPCRepairInfo.setToDiscover(false);
            pPCRepairInfo.setIpChange(new PPCRepairOperator.IpChange(this.typeAttr.getCurrIp(), this.typeAttr.getPrevIp()));
        }
    }

    @Override
    protected String getNextPaneName() {
        PPCRepairInfo pPCRepairInfo = ((PPCRepairDialog)this.parent).getInfo();
        if (pPCRepairInfo.isToDiscover()) {
            return "Discover IP Changes";
        }
        return "PPC Terminations to Repair";
    }

    @Override
    protected void initPane() {
        this.setLayout(new BorderLayout());
        this.typeAttr = new RepairTypeAttr();
        this.add((Component)this.typeAttr.getUI(), "Center");
    }

    @Override
    public CSHelpID getHelpID() {
        return NetCSHelpConst.PPCRepIntroPane;
    }

    @Override
    public JComponent getStatusComponent() {
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        arrayList.add(new String[]{"Type: ", this.typeAttr.toString()});
        return PPCRepPreamble.getGridPanel(arrayList);
    }

    @Override
    protected String getStatusText() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Type: ").append(this.typeAttr.toString());
        return stringBuffer.toString();
    }

    class RepairTypeAttr
    implements ActionListener {
        private final String PREAMBLE = "<html><body><p>The PPC Repair wizard fixes PPC terminations in cases where the IP address changes for one node connected by one link.</p><p>This wizard is also able to discover the IP address change based on information stored by the PPC terminations.<br>As an alternative, you can directly provision the necessary information about the old and current IP addresses.</p><p>Refer to your user documentation for PPC link repair procedures and information.</p></body></html>";
        private ButtonGroup typeBG;
        private JRadioButton discoverIpsRB;
        private JRadioButton givenIpsRB;
        private UComboBox nodesCB;
        private JTextField currIpTF;
        private JTextField prevIpTF;
        private JPanel p = new JPanel(new BorderLayout());

        RepairTypeAttr() {
            JEditorPane jEditorPane = new JEditorPane("text/html", "<html><body><p>The PPC Repair wizard fixes PPC terminations in cases where the IP address changes for one node connected by one link.</p><p>This wizard is also able to discover the IP address change based on information stored by the PPC terminations.<br>As an alternative, you can directly provision the necessary information about the old and current IP addresses.</p><p>Refer to your user documentation for PPC link repair procedures and information.</p></body></html>");
            jEditorPane.setEditable(false);
            this.p.add((Component)new UScrollPane((Component)jEditorPane), "Center");
            JPanel jPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(5, 5, 0, 0);
            gridBagConstraints.anchor = 18;
            ++gridBagConstraints.gridy;
            gridBagConstraints.gridwidth = 3;
            gridBagConstraints.gridheight = 1;
            ++gridBagConstraints.gridy;
            this.discoverIpsRB = new JRadioButton("Try to discover IP address changes");
            jPanel.add((Component)this.discoverIpsRB, gridBagConstraints);
            ++gridBagConstraints.gridy;
            this.givenIpsRB = new JRadioButton("Apply the following IP change:");
            jPanel.add((Component)this.givenIpsRB, gridBagConstraints);
            ++gridBagConstraints.gridy;
            this.typeBG = new ButtonGroup();
            this.typeBG.add(this.discoverIpsRB);
            this.typeBG.add(this.givenIpsRB);
            this.typeBG.setSelected(this.discoverIpsRB.getModel(), true);
            this.discoverIpsRB.addActionListener(this);
            this.givenIpsRB.addActionListener(this);
            gridBagConstraints.gridwidth = 1;
            ++gridBagConstraints.gridy;
            jPanel.add((Component)new JLabel("Current IP: "), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            INodeModel[] iNodeModelArray = PPCHelper.getNodes();
            this.nodesCB = new UComboBox();
            jPanel.add((Component)this.nodesCB, gridBagConstraints);
            this.nodesCB.setRenderer((ListCellRenderer)new CombosCellRenderer(false));
            this.nodesCB.setModel(new DefaultComboBoxModel<INodeModel>(iNodeModelArray));
            this.nodesCB.setEnabled(false);
            this.nodesCB.addActionListener((ActionListener)this);
            gridBagConstraints.gridx = 2;
            this.currIpTF = new JTextField(15);
            jPanel.add((Component)this.currIpTF, gridBagConstraints);
            this.currIpTF.setEditable(false);
            ++gridBagConstraints.gridy;
            gridBagConstraints.gridx = 0;
            jPanel.add((Component)new JLabel("Original IP: "), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            this.prevIpTF = new JTextField();
            jPanel.add((Component)this.prevIpTF, gridBagConstraints);
            this.prevIpTF.setEnabled(false);
            gridBagConstraints.gridx = 0;
            ++gridBagConstraints.gridy;
            jPanel.add((Component)new JPanel(), gridBagConstraints);
            this.p.add((Component)jPanel, "South");
        }

        JPanel getUI() {
            return this.p;
        }

        boolean isToDiscover() {
            return this.discoverIpsRB.isSelected();
        }

        String getCurrIp() {
            return this.currIpTF.getText();
        }

        String getPrevIp() {
            return this.prevIpTF.getText();
        }

        public String toString() {
            return this.isToDiscover() ? "Discover IP changes" : "IP change from " + this.getPrevIp() + " to " + this.getCurrIp();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.nodesCB.setEnabled(!this.isToDiscover());
            INodeModel iNodeModel = (INodeModel)this.nodesCB.getSelectedItem();
            if (iNodeModel != null) {
                this.currIpTF.setText(InetUtil.makeDottedString(iNodeModel.getIpConfig().getIpAddress()));
            } else {
                this.currIpTF.setText("");
            }
            this.prevIpTF.setEnabled(!this.isToDiscover());
        }
    }
}

