/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ppc;

import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NetCSHelpConst;
import cerent.cms.ui.OpticalChannelAttr;
import cerent.cms.ui.PPCLinkCreationDialog;
import cerent.cms.ui.Wavelength;
import cerent.cms.ui.WzDiagDebug;
import cerent.cms.ui.WzDialog;
import cerent.cms.ui.WzPane;
import cerent.cms.ui.ppc.PPCCreationInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class PPCcdAttrsPane
extends WzPane {
    private PPCTypeAttr typeAttr;
    private PPCProtectionAttr protectionAttr;

    public PPCcdAttrsPane(WzDialog wzDialog, WzDiagDebug wzDiagDebug, String string) {
        super(wzDialog, wzDiagDebug, string);
    }

    @Override
    public void validatePage() throws Exception {
        PPCCreationInfo pPCCreationInfo = ((PPCLinkCreationDialog)this.parent).getInfo();
        pPCCreationInfo.setWavelength(-1);
        if (this.typeAttr.isBidi2Bidi()) {
            pPCCreationInfo.setBidi2Bidi();
        } else if (this.typeAttr.isSide2SideOTS()) {
            pPCCreationInfo.setSide2SideOTS();
        } else if (this.typeAttr.isOts2Ots()) {
            pPCCreationInfo.setOts2Ots();
        } else if (this.typeAttr.isBidi2OCH()) {
            pPCCreationInfo.setBidi2OCH();
            if (!this.typeAttr.isColorless()) {
                pPCCreationInfo.setWavelength(this.typeAttr.getChannel());
            }
        } else {
            pPCCreationInfo.setL2();
        }
        pPCCreationInfo.setProtected(this.protectionAttr.isProtected());
    }

    @Override
    protected String getNextPaneName() {
        return "PPC Origination";
    }

    @Override
    protected void initPane() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.anchor = 18;
        this.typeAttr = new PPCTypeAttr();
        jPanel.add((Component)this.typeAttr.getUI(), gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.protectionAttr = new PPCProtectionAttr();
        jPanel.add((Component)this.protectionAttr.getUI(), gridBagConstraints);
        ++gridBagConstraints.gridx;
        jPanel.add((Component)new JPanel(), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        jPanel.add((Component)new JPanel(), gridBagConstraints);
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel, "Center");
    }

    @Override
    public CSHelpID getHelpID() {
        return NetCSHelpConst.PPCCdAttrsPane;
    }

    @Override
    public JComponent getStatusComponent() {
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        arrayList.add(new String[]{"Type: ", this.typeAttr.toString()});
        arrayList.add(new String[]{"Protected: ", this.protectionAttr.toString()});
        return PPCcdAttrsPane.getGridPanel(arrayList);
    }

    @Override
    protected String getStatusText() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Type: ").append(this.typeAttr.toString());
        stringBuffer.append("\nProtected: ").append(this.protectionAttr.toString());
        return stringBuffer.toString();
    }

    class PPCProtectionAttr {
        private JCheckBox protectionCB;
        private JPanel p = WzPane.createHorizontalPanel(null);

        PPCProtectionAttr() {
            this.p.setAlignmentX(0.0f);
            this.protectionCB = new JCheckBox("Protected");
            this.p.add(this.protectionCB);
        }

        JPanel getUI() {
            return this.p;
        }

        boolean isProtected() {
            return this.protectionCB.isSelected();
        }

        void setEnabled(boolean bl) {
            this.protectionCB.setEnabled(bl);
        }

        void setSelected(boolean bl) {
            this.protectionCB.setSelected(bl);
        }

        public String toString() {
            return this.isProtected() ? "Yes" : "No";
        }
    }

    class PPCTypeAttr
    implements ActionListener {
        private ButtonGroup typeBG;
        private JRadioButton bidi2bidiL2RB;
        private JRadioButton bidi2bidiRB;
        private JRadioButton side2sideRB;
        private JRadioButton ots2otsRB;
        private JRadioButton bidi2OCHRB;
        private OpticalChannelAttr optChannelAttr;
        private JPanel p = new JPanel(new GridBagLayout());

        PPCTypeAttr() {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(5, 5, 0, 0);
            gridBagConstraints.anchor = 18;
            this.bidi2bidiL2RB = new JRadioButton("Client/Trunk to Client/Trunk (L2)");
            this.p.add((Component)this.bidi2bidiL2RB, gridBagConstraints);
            ++gridBagConstraints.gridy;
            this.bidi2bidiRB = new JRadioButton("Client/Trunk to Client/Trunk");
            this.p.add((Component)this.bidi2bidiRB, gridBagConstraints);
            ++gridBagConstraints.gridy;
            this.side2sideRB = new JRadioButton("Side to Side (OTS)");
            this.p.add((Component)this.side2sideRB, gridBagConstraints);
            ++gridBagConstraints.gridy;
            this.ots2otsRB = new JRadioButton("OTS to OTS");
            this.p.add((Component)this.ots2otsRB, gridBagConstraints);
            ++gridBagConstraints.gridy;
            this.bidi2OCHRB = new JRadioButton("OCH Trunk to OCH Filter");
            this.p.add((Component)this.bidi2OCHRB, gridBagConstraints);
            this.typeBG = new ButtonGroup();
            this.typeBG.add(this.bidi2bidiL2RB);
            this.typeBG.add(this.bidi2bidiRB);
            this.typeBG.add(this.side2sideRB);
            this.typeBG.add(this.ots2otsRB);
            this.typeBG.add(this.bidi2OCHRB);
            this.typeBG.setSelected(this.bidi2OCHRB.getModel(), true);
            this.bidi2bidiL2RB.addActionListener(this);
            this.bidi2bidiRB.addActionListener(this);
            this.side2sideRB.addActionListener(this);
            this.ots2otsRB.addActionListener(this);
            this.bidi2OCHRB.addActionListener(this);
            this.optChannelAttr = new OpticalChannelAttr(3);
            ++gridBagConstraints.gridy;
            this.p.add((Component)this.optChannelAttr.getUI(), gridBagConstraints);
            this.optChannelAttr.setEnabled(true);
            ++gridBagConstraints.gridx;
            this.p.add((Component)new JPanel(), gridBagConstraints);
            this.p.setBorder(BorderFactory.createTitledBorder("Link Type"));
        }

        JPanel getUI() {
            return this.p;
        }

        boolean isBidi2BidiL2() {
            return this.bidi2bidiL2RB.isSelected();
        }

        boolean isBidi2Bidi() {
            return this.bidi2bidiRB.isSelected();
        }

        boolean isSide2SideOTS() {
            return this.side2sideRB.isSelected();
        }

        boolean isOts2Ots() {
            return this.ots2otsRB.isSelected();
        }

        boolean isBidi2OCH() {
            return this.bidi2OCHRB.isSelected();
        }

        int getChannel() {
            return this.optChannelAttr.getChannel();
        }

        boolean isColorless() {
            return this.optChannelAttr.isColorless();
        }

        public String toString() {
            return this.isBidi2Bidi() ? "OCH-Trunk to OCH-Trunk" : (this.isSide2SideOTS() ? "Side to Side (OTS)" : (this.isOts2Ots() ? "OTS to OTS" : (this.isBidi2BidiL2() ? "Trunk to Trunk L2" : "OCH-Trunk to OCH-Filter [" + (this.isColorless() ? "COLORLESS" : Wavelength.getWavelengthStringFromWavelength(this.getChannel())) + "]")));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.optChannelAttr.setEnabled(this.isBidi2OCH());
            PPCcdAttrsPane.this.protectionAttr.setEnabled(this.isBidi2Bidi() || this.isBidi2OCH());
            if (this.isSide2SideOTS() || this.isOts2Ots() || this.isBidi2BidiL2()) {
                PPCcdAttrsPane.this.protectionAttr.setSelected(false);
            }
        }
    }
}

