/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.provalarms;

import cerent.cms.model.INodeModel;
import cerent.cms.model.NodeModel;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Observable;
import java.util.Observer;

public class ProvNodeProfile
implements Comparable,
Observer {
    private static final SDebug db = new SDebug("ProvNodeProfile");
    protected String nodeName;
    protected ArrayList profileList;
    protected INodeModel nodeModel;
    protected String version;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String dump() {
        StringBuffer stringBuffer = new StringBuffer(this.nodeName + "::");
        ArrayList arrayList = this.profileList;
        synchronized (arrayList) {
            for (int i = 0; i < this.profileList.size(); ++i) {
                stringBuffer.append(this.profileList.get(i) + " ");
            }
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.nodeName;
    }

    public boolean equals(Object object) {
        return this.compareTo(object) == 0;
    }

    public int compareTo(Object object) {
        return this.toString().compareTo(object.toString());
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public INodeModel getNodeModel() {
        return this.nodeModel;
    }

    public ProvNodeProfile(INodeModel iNodeModel) {
        this.nodeModel = iNodeModel;
        if (iNodeModel != null) {
            this.nodeName = iNodeModel.getName();
            ((NodeModel)iNodeModel).addObserver(this);
        }
        this.profileList = new ArrayList();
    }

    public void setVersionString(String string) {
        this.version = string;
    }

    public String getVersionString() {
        return this.version;
    }

    public ArrayList getProfileList() {
        return this.profileList;
    }

    public int numberOfProfiles() {
        return this.profileList.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteAllProfiles() {
        ArrayList arrayList = this.profileList;
        synchronized (arrayList) {
            this.profileList.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAllProfiles(Collection collection) {
        ArrayList arrayList = this.profileList;
        synchronized (arrayList) {
            return this.profileList.containsAll(collection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsProfile(String string) {
        ArrayList arrayList = this.profileList;
        synchronized (arrayList) {
            return this.profileList.contains(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addProfile(String string) {
        ArrayList arrayList = this.profileList;
        synchronized (arrayList) {
            if (!this.containsProfile(string)) {
                this.profileList.add(string);
                Collections.sort(this.profileList);
                return this.profileList.indexOf(string);
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteProfile(String string) {
        ArrayList arrayList = this.profileList;
        synchronized (arrayList) {
            if (!this.containsProfile(string)) {
                db.println("profile " + string + " on node " + this.nodeName + " not found for delete.");
                return false;
            }
            this.profileList.remove(string);
            return true;
        }
    }

    @Override
    public void update(Observable observable, Object object) {
        INodeModel iNodeModel;
        String string;
        if (observable instanceof INodeModel && (string = (iNodeModel = (INodeModel)observable).getName()) != this.nodeName) {
            this.nodeName = string;
        }
    }

    public void dispose() {
        this.deleteAllProfiles();
        if (this.nodeModel != null) {
            ((NodeModel)this.nodeModel).deleteObserver(this);
        }
    }
}

