/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.provalarms;

import cerent.cms.ui.provalarms.ProvAlarmsPane;
import cerent.cms.ui.provalarms.ProvAlarmsTableModel;
import cerent.cms.ui.provalarms.ProvNodeProfile;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.NEMC;
import cerent.util.gui.UScrollPane;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.BorderFactory;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class ProvNodeProfileSelector
implements ListSelectionListener {
    protected ProvAlarmsPane parent;
    protected ProvAlarmsTableModel model;
    protected JList nodeList;
    protected JList availableProfiles;
    protected JPanel nodeProfSelPanel;
    protected UScrollPane profileScrollPane;
    protected UScrollPane nodeScrollPane;
    protected GridBagLayout gridbag = new GridBagLayout();
    protected GridBagConstraints gbc = new GridBagConstraints();
    protected boolean state;
    protected ArrayList nodeInfoList;

    void setEnabled(boolean bl) {
        this.state = bl;
        this.nodeProfSelPanel.setEnabled(this.state);
        this.nodeList.setEnabled(this.state);
        this.availableProfiles.setEnabled(this.state);
        this.nodeScrollPane.setEnabled(this.state);
        this.profileScrollPane.setEnabled(this.state);
    }

    ProvNodeProfileSelector(ArrayList arrayList, ProvAlarmsPane provAlarmsPane, ProvAlarmsTableModel provAlarmsTableModel, Component component) {
        this.parent = provAlarmsPane;
        this.model = provAlarmsTableModel;
        this.nodeInfoList = arrayList;
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (int i = 0; i < arrayList.size(); ++i) {
            ProvNodeProfile provNodeProfile = (ProvNodeProfile)arrayList.get(i);
            arrayList2.add(provNodeProfile.getNodeName());
        }
        this.nodeList = new JList<Object>(arrayList2.toArray());
        this.nodeList.setSelectionMode(0);
        this.nodeList.setBorder(BorderFactory.createLoweredBevelBorder());
        this.nodeProfSelPanel = new JPanel();
        this.nodeScrollPane = new UScrollPane();
        this.nodeScrollPane.getViewport().setView(this.nodeList);
        this.nodeList.addListSelectionListener(this);
        this.availableProfiles = new JList<String>(new String[0]);
        this.availableProfiles.setBorder(BorderFactory.createLoweredBevelBorder());
        this.profileScrollPane = new UScrollPane();
        this.profileScrollPane.getViewport().setView(this.availableProfiles);
        this.nodeScrollPane.setBorder((Border)BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Node Names"));
        this.profileScrollPane.setBorder((Border)BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Profile Names"));
        this.nodeScrollPane.setPreferredSize(ProvAlarmsPane.SELECTIONBOX_DIM);
        this.profileScrollPane.setPreferredSize(ProvAlarmsPane.SELECTIONBOX_DIM);
        this.nodeProfSelPanel.setLayout(this.gridbag);
        this.gbc.anchor = 18;
        if (component != null) {
            this.gbc.gridx = 0;
            this.gbc.gridy = 0;
            this.gridbag.setConstraints(component, this.gbc);
            this.nodeProfSelPanel.add(component);
        }
        this.gbc.gridx = 1;
        this.gridbag.setConstraints((Component)this.nodeScrollPane, this.gbc);
        this.nodeProfSelPanel.add((Component)this.nodeScrollPane);
        this.gbc.gridx = 2;
        this.gridbag.setConstraints((Component)this.profileScrollPane, this.gbc);
        this.nodeProfSelPanel.add((Component)this.profileScrollPane);
    }

    public JPanel getPanel() {
        return this.nodeProfSelPanel;
    }

    public JList getNodeList() {
        return this.nodeList;
    }

    public JList getAvailableProfiles() {
        return this.availableProfiles;
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!listSelectionEvent.getValueIsAdjusting() && listSelectionEvent.getSource() == this.nodeList) {
            String string = (String)this.nodeList.getSelectedValue();
            ArrayList arrayList = null;
            if (string != null) {
                String string2 = string;
                this.nodeInfoList = this.model.verifyProfilesMatchNode(string2);
                for (int i = 0; i < this.nodeInfoList.size(); ++i) {
                    ProvNodeProfile provNodeProfile = (ProvNodeProfile)this.nodeInfoList.get(i);
                    String string3 = provNodeProfile.getNodeName();
                    if (!string2.equals(string3)) continue;
                    ArrayList arrayList2 = provNodeProfile.getProfileList();
                    arrayList = (ArrayList)arrayList2.clone();
                    break;
                }
                if (arrayList == null || arrayList.size() == 0) {
                    ErrorMsg.displayError((Component)((Object)this.parent), (EID)NEMC.EID_NO_PROFILES_PARAM_1, (Object)string2);
                } else {
                    Collections.sort(arrayList);
                }
            }
            this.availableProfiles = arrayList != null && string != null ? new JList<Object>(arrayList.toArray()) : new JList<String>(new String[0]);
            this.availableProfiles.setBorder(BorderFactory.createLoweredBevelBorder());
            this.profileScrollPane.getViewport().setView(this.availableProfiles);
        }
    }
}

