/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.tl1;

import cerent.cms.ui.tl1.HistoryItem;
import cerent.cms.ui.tl1.TL1ClientPanel;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.NEMC;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.UFileChooser;
import cerent.util.gui.UScrollPane;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.RandomAccessFile;
import java.util.Date;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class HistoryBox {
    private static final int HISTORY_MAX_LENGTH = 1000;
    private JList lHistory;
    private UScrollPane spHistoryList;
    private DefaultListModel historyModel;
    private JLabel tHistoryLabel;
    private JPanel pHistoryPanel;
    private JPanel pHistoryButtonsPanel;
    private JButton bLoadHistory;
    private JButton bReLoadHistory;
    private JButton bSaveHistory;
    private JButton bDeleteHistory;
    private JButton bDeleteAllHistory;
    private JLabel tFindText;
    private JTextField tfFindHistory;
    private JButton bFindHistory;
    private JButton bFindNextHistory;
    private JScrollBar vScrollBar;
    private TL1ClientPanel tl1Client;
    private File loadedFile;
    private Font historyListFont = new Font("Courier", 0, 14);
    private static final SDebug db = new SDebug("HistoryBox");

    public HistoryBox(TL1ClientPanel tL1ClientPanel) {
        this.tl1Client = tL1ClientPanel;
        this.loadedFile = null;
    }

    public JPanel getClientPanel() {
        return this.pHistoryPanel;
    }

    public void display() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.pHistoryPanel = new JPanel();
        this.pHistoryPanel.setLayout(gridBagLayout);
        this.tHistoryLabel = new JLabel("Request History: (double-click to execute command)");
        this.historyModel = new DefaultListModel();
        this.lHistory = new JList(this.historyModel);
        this.lHistory.setVisibleRowCount(5);
        this.lHistory.setFixedCellHeight(18);
        this.lHistory.setSelectionMode(0);
        this.lHistory.setFont(this.historyListFont);
        this.lHistory.addMouseListener(new MouseListener());
        this.spHistoryList = new UScrollPane((Component)this.lHistory);
        this.vScrollBar = this.spHistoryList.getVerticalScrollBar();
        this.vScrollBar.setMaximum(100);
        this.vScrollBar.setMinimum(0);
        this.pHistoryButtonsPanel = new JPanel(new FlowLayout(0));
        this.bSaveHistory = new JButton("Save");
        this.bSaveHistory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HistoryBox.this.saveHistory();
            }
        });
        this.pHistoryButtonsPanel.add(this.bSaveHistory);
        this.bLoadHistory = new JButton("Load");
        this.bLoadHistory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HistoryBox.this.loadHistory(null);
            }
        });
        this.pHistoryButtonsPanel.add(this.bLoadHistory);
        this.bReLoadHistory = new JButton("Re-Load");
        this.bReLoadHistory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HistoryBox.this.loadHistory(HistoryBox.this.loadedFile);
            }
        });
        this.pHistoryButtonsPanel.add(this.bReLoadHistory);
        this.bDeleteHistory = new JButton("Delete");
        this.bDeleteHistory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HistoryBox.this.deleteHistory(false);
            }
        });
        this.pHistoryButtonsPanel.add(this.bDeleteHistory);
        this.bDeleteAllHistory = new JButton("Clear");
        this.bDeleteAllHistory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HistoryBox.this.deleteHistory(true);
            }
        });
        this.pHistoryButtonsPanel.add(this.bDeleteAllHistory);
        this.tFindText = new JLabel("Search:");
        this.pHistoryButtonsPanel.add(this.tFindText);
        this.tfFindHistory = new JTextField(10);
        this.tfFindHistory.getDocument().addDocumentListener(new TextListener());
        this.tfFindHistory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HistoryBox.this.findHistory();
            }
        });
        this.pHistoryButtonsPanel.add(this.tfFindHistory);
        this.bFindHistory = new JButton("Find");
        this.bFindHistory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HistoryBox.this.findHistory();
            }
        });
        this.pHistoryButtonsPanel.add(this.bFindHistory);
        this.bFindNextHistory = new JButton("Find Next");
        this.bFindNextHistory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HistoryBox.this.findNextHistory();
            }
        });
        this.pHistoryButtonsPanel.add(this.bFindNextHistory);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        this.pHistoryPanel.add((Component)this.tHistoryLabel, gridBagConstraints);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.25;
        this.pHistoryPanel.add((Component)this.spHistoryList, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 10;
        gridBagConstraints.weighty = 0.0;
        this.pHistoryPanel.add((Component)this.pHistoryButtonsPanel, gridBagConstraints);
    }

    public synchronized void addToHistory(String string, boolean bl) {
        Locator locator = new Locator(-1, false);
        HistoryItem historyItem = new HistoryItem(string);
        locator.locateIndex = this.search(this.historyModel, historyItem.value());
        if (locator.locateIndex != -1) {
            this.historyModel.removeElementAt(locator.locateIndex);
        }
        if (this.historyModel.getSize() >= 1000) {
            this.historyModel.removeElementAt(0);
        }
        this.historyModel.addElement(historyItem);
        locator.locateIndex = this.historyModel.getSize() - 1;
        if (bl && locator.locateIndex > -1) {
            final Locator locator2 = locator;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    HistoryBox.this.lHistory.setSelectedIndex(locator2.locateIndex);
                    HistoryBox.this.vScrollBar.setValue(locator2.locateIndex * HistoryBox.this.lHistory.getFixedCellHeight());
                }
            });
        }
    }

    public synchronized void deleteHistory(boolean bl) {
        if (bl) {
            this.historyModel.removeAllElements();
        } else {
            int n = this.lHistory.getSelectedIndex();
            if (n != -1) {
                this.historyModel.removeElementAt(n);
            }
        }
    }

    private void getAndSetItem(Object object) {
        if (object == this.lHistory) {
            HistoryItem historyItem = (HistoryItem)this.lHistory.getSelectedValue();
            this.tl1Client.setTl1RequestText(historyItem);
        }
    }

    void executeCommand(String string) {
        if (string != null) {
            this.tl1Client.execCommand(string);
        }
    }

    public void loadHistory(File file) {
        Object object;
        if (file == null) {
            object = new UFileChooser();
            if (object.showOpenDialog((Component)this.getClientPanel()) != 0) {
                object.dispose();
                return;
            }
            file = object.getSelectedFile();
            object.dispose();
        }
        try {
            String string;
            object = new RandomAccessFile(file, "r");
            while ((string = ((RandomAccessFile)object).readLine()) != null) {
                if (string.length() <= 0 || string.charAt(0) == ';') continue;
                this.addToHistory(string.trim(), false);
            }
            ((RandomAccessFile)object).close();
            this.loadedFile = file;
            this.tl1Client.appendToMessageLog("\nLoaded History File: " + this.loadedFile.getCanonicalPath() + "   => on" + new Date().toString() + "\n");
        }
        catch (Exception exception) {
            db.println("Exception occured: ");
            SDebug.printStackTrace((Throwable)exception);
        }
    }

    private void saveHistory() {
        UFileChooser uFileChooser = new UFileChooser();
        if (uFileChooser.showSaveDialog((Component)this.getClientPanel()) != 0) {
            uFileChooser.dispose();
            return;
        }
        File file = uFileChooser.getSelectedFile();
        uFileChooser.dispose();
        try {
            Object object;
            if (file.exists()) {
                object = "The file '" + file.getAbsolutePath() + "' already exists.\n\n" + "Do you want to override it?";
                boolean bl = CerentDialog.yesNoDialog((Component)this.tl1Client, (String)object, (String)"Warning");
                if (!bl) {
                    return;
                }
                file.delete();
            }
            object = new Character('\n');
            String string = ";" + object + "; CTC TL1 Client created at " + new Date() + object + ";" + object;
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
            randomAccessFile.writeBytes(string);
            for (int i = 0; i < this.historyModel.getSize(); ++i) {
                HistoryItem historyItem = (HistoryItem)this.historyModel.get(i);
                if (!historyItem.savable()) continue;
                randomAccessFile.writeBytes(historyItem.value());
                randomAccessFile.writeBytes(((Character)object).toString());
            }
            randomAccessFile.close();
        }
        catch (Exception exception) {
            db.println("Failed to save history file");
            ErrorMsg.displayError((Component)this.tl1Client, (EID)NEMC.EID_FILE_SAVE_EXCEPTION);
        }
    }

    private void findHistory() {
        String string = this.tfFindHistory.getText();
        if (string.length() > 0) {
            this.lHistory.clearSelection();
            this.tl1Client.setTl1RequestText(null);
            int n = this.searchStartWith(this.historyModel, string, -1);
            if (n != -1) {
                this.lHistory.setSelectedIndex(n);
                SwingUtilities.invokeLater(new SbSetter(this.vScrollBar, n * this.lHistory.getFixedCellHeight()));
            }
        }
    }

    private void findNextHistory() {
        int n = this.lHistory.getSelectedIndex();
        if (n == -1) {
            this.findHistory();
        } else {
            String string = this.tfFindHistory.getText();
            if (string.length() > 0) {
                this.tl1Client.setTl1RequestText(null);
                int n2 = this.searchStartWith(this.historyModel, string, n);
                if (n2 != -1) {
                    this.lHistory.setSelectedIndex(n2);
                    SwingUtilities.invokeLater(new SbSetter(this.vScrollBar, n2 * this.lHistory.getFixedCellHeight()));
                }
            }
        }
    }

    private synchronized int searchStartWith(DefaultListModel defaultListModel, String string, int n) {
        for (int i = 0; i < defaultListModel.getSize(); ++i) {
            HistoryItem historyItem;
            if (i <= n || !(historyItem = (HistoryItem)defaultListModel.getElementAt(i)).value().startsWith(string)) continue;
            return i;
        }
        return -1;
    }

    private synchronized int search(DefaultListModel defaultListModel, String string) {
        for (int i = 0; i < defaultListModel.getSize(); ++i) {
            HistoryItem historyItem = (HistoryItem)defaultListModel.getElementAt(i);
            if (string.compareToIgnoreCase(historyItem.value()) != 0) continue;
            return i;
        }
        return -1;
    }

    private class Locator {
        public int locateIndex;
        public boolean itemFound;

        public Locator(int n, boolean bl) {
            this.locateIndex = n;
            this.itemFound = bl;
        }
    }

    private class MouseListener
    extends MouseAdapter {
        private MouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if ((mouseEvent.getModifiers() & 0x10) > 0) {
                HistoryBox.this.getAndSetItem(mouseEvent.getSource());
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if ((mouseEvent.getModifiers() & 0x10) > 0) {
                HistoryBox.this.getAndSetItem(mouseEvent.getSource());
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if ((mouseEvent.getModifiers() & 0x10) > 0 && mouseEvent.getClickCount() == 2) {
                JList jList = (JList)mouseEvent.getSource();
                HistoryItem historyItem = (HistoryItem)jList.getSelectedValue();
                HistoryBox.this.executeCommand(historyItem.value());
            }
        }
    }

    private class SbSetter
    implements Runnable {
        private int value;
        private JScrollBar vsb;

        public SbSetter(JScrollBar jScrollBar, int n) {
            this.value = n;
            this.vsb = jScrollBar;
        }

        @Override
        public void run() {
            this.vsb.setValue(this.value);
        }
    }

    private class TextListener
    implements DocumentListener {
        private TextListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            HistoryBox.this.findHistory();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            HistoryBox.this.findHistory();
        }
    }
}

