/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.tl1;

import cerent.cms.ui.tl1.HistoryItem;
import cerent.cms.ui.tl1.TL1ClientPanel;
import cerent.cms.ui.tl1.TextAreaAppender;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.NEMC;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.UFileChooser;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.RandomAccessFile;
import java.util.Date;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

public class MessageBox {
    private GridBagLayout gbl = new GridBagLayout();
    private GridBagConstraints gbc = new GridBagConstraints();
    private JTabbedPane tabbedPane;
    private TL1ClientPanel parentPanel;
    private JPanel messagePanel;
    private JTextArea messageLogTextArea;
    private JPanel buttonPanel;
    private JButton saveMessageLogButton;
    private JButton clearMessageLogButton;
    private JButton separatorButton;
    private TextAreaAppender textAreaAppender;
    private JCheckBox cbAutoScroll;
    private JPanel summaryPanel;
    private JPanel summaryButtonPanel;
    private JTable summaryTable;
    private JButton summaryClearButton;
    private UScrollPane spSummaryTable;
    private SummaryTableModel summaryModel;
    private Font messageLogFont = new Font("Courier", 1, 14);
    static final int MAX_CHARS = 262144;
    static final int MAX_SUMMARY_LIST = 1000;
    private final String[] columns = new String[]{"Command", "Date/Time"};
    private static final SDebug db = new SDebug("MessageBox");

    public MessageBox(TL1ClientPanel tL1ClientPanel) {
        this.parentPanel = tL1ClientPanel;
    }

    public JComponent getClientPanel() {
        return this.tabbedPane;
    }

    public void display() {
        this.messagePanel = new JPanel();
        this.summaryPanel = new JPanel();
        this.tabbedPane = new JTabbedPane();
        this.messageLogTextArea = new JTextArea(20, 80);
        this.messageLogTextArea.setFont(this.messageLogFont);
        UScrollPane uScrollPane = new UScrollPane((Component)this.messageLogTextArea);
        this.cbAutoScroll = new JCheckBox("Auto Scroll", true);
        this.textAreaAppender = new TextAreaAppender(this.messageLogTextArea, this.cbAutoScroll, 262144);
        this.messageLogTextArea.setEditable(false);
        this.buttonPanel = new JPanel();
        this.saveMessageLogButton = new JButton("Save Log");
        this.saveMessageLogButton.addActionListener(new LogActListener());
        this.buttonPanel.add(this.saveMessageLogButton);
        this.clearMessageLogButton = new JButton("Clear Log");
        this.clearMessageLogButton.addActionListener(new LogActListener());
        this.buttonPanel.add(this.clearMessageLogButton);
        this.separatorButton = new JButton("Separator");
        this.separatorButton.addActionListener(new LogActListener());
        this.buttonPanel.add(this.separatorButton);
        this.messagePanel.setLayout(this.gbl);
        this.gbc.fill = 1;
        this.gbc.gridy = 0;
        this.gbc.gridx = 0;
        this.gbc.gridwidth = 10;
        this.gbc.weightx = 1.0;
        this.gbc.weighty = 1.0;
        this.messagePanel.add((Component)uScrollPane, this.gbc);
        this.gbc.anchor = 17;
        this.gbc.fill = 0;
        this.gbc.gridy = 1;
        this.gbc.gridx = 0;
        this.gbc.weightx = 0.0;
        this.gbc.weighty = 0.0;
        this.messagePanel.add((Component)this.buttonPanel, this.gbc);
        this.gbc.anchor = 13;
        this.gbc.fill = 0;
        this.gbc.gridy = 1;
        this.gbc.gridx = 7;
        this.gbc.gridwidth = 10;
        this.messagePanel.add((Component)this.cbAutoScroll, this.gbc);
        this.tabbedPane.add("Message Log", this.messagePanel);
        this.summaryPanel.setLayout(new BorderLayout());
        this.summaryModel = new SummaryTableModel();
        for (int i = 0; i < this.columns.length; ++i) {
            this.summaryModel.addColumn(this.columns[i]);
        }
        this.summaryTable = new UTable((TableModel)this.summaryModel);
        this.spSummaryTable = new UScrollPane((Component)this.summaryTable);
        this.summaryPanel.add((Component)this.spSummaryTable);
        this.summaryButtonPanel = new JPanel(new FlowLayout(0));
        this.summaryClearButton = new JButton("Clear Summary");
        this.summaryClearButton.addActionListener(new LogActListener());
        this.summaryButtonPanel.add(this.summaryClearButton);
        this.summaryPanel.add((Component)this.summaryButtonPanel, "South");
        this.tabbedPane.add("Summary Log", this.summaryPanel);
        this.tabbedPane.setVisible(true);
    }

    public synchronized void appendText(String string) {
        this.textAreaAppender.append(string);
    }

    public synchronized void appendSummary(String string) {
        if (this.summaryModel.getRowCount() > 1000) {
            this.summaryModel.removeRow(0);
        }
        Vector<String> vector = new Vector<String>(this.summaryModel.getColumnCount());
        vector.add(HistoryItem.hidePasswords(string));
        vector.add(new Date().toString());
        this.summaryModel.addRow(vector);
    }

    private void clearMessageLog() {
        this.textAreaAppender.clear();
    }

    private void addSeparator() {
        this.appendText("\n\n==================================== " + new Date().toString() + "\n");
    }

    private void clearSummaryLog() {
        Vector<Vector> vector = this.summaryModel.getDataVector();
        vector.clear();
        this.summaryModel.fireTableDataChanged();
    }

    private void saveMessageLog() {
        UFileChooser uFileChooser = new UFileChooser();
        if (uFileChooser.showSaveDialog((Component)this.getClientPanel()) != 0) {
            uFileChooser.dispose();
            return;
        }
        File file = uFileChooser.getSelectedFile();
        uFileChooser.dispose();
        try {
            if (file.exists()) {
                String string = "The file '" + file.getAbsolutePath() + "' already exists.\n\n" + "Do you want to override it?";
                boolean bl = CerentDialog.yesNoDialog((Component)this.parentPanel, (String)string, (String)"Warning");
                if (!bl) {
                    return;
                }
                file.delete();
            }
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
            randomAccessFile.writeBytes(this.messageLogTextArea.getText());
            randomAccessFile.close();
        }
        catch (Exception exception) {
            db.println("Exception thrown in loadFile=" + exception);
            ErrorMsg.displayError((Component)this.parentPanel, (EID)NEMC.EID_FILE_SAVE_EXCEPTION);
        }
    }

    private class LogActListener
    implements ActionListener {
        private LogActListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == MessageBox.this.saveMessageLogButton) {
                MessageBox.this.saveMessageLog();
            } else if (object == MessageBox.this.clearMessageLogButton) {
                MessageBox.this.clearMessageLog();
            } else if (object == MessageBox.this.separatorButton) {
                MessageBox.this.addSeparator();
            } else if (object == MessageBox.this.summaryClearButton) {
                MessageBox.this.clearSummaryLog();
            }
        }
    }

    private class SummaryTableModel
    extends DefaultTableModel {
        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }
}

