/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.vlan;

import cerent.cms.model.IModel;
import cerent.cms.model.INodeModel;
import cerent.cms.ui.vlan.IModelSelector;
import cerent.cms.ui.vlan.ProfileVlanDbPane;
import cerent.util.gui.UScrollPane;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.border.Border;

class ProfileSelector
implements IModelSelector {
    private Component aComponent;
    protected Map<String, INodeModel> name2Node;
    protected JList nodeList;
    protected JPanel nodeProfSelPanel;
    protected UScrollPane nodeScrollPane;
    protected GridBagLayout gridbag = new GridBagLayout();
    protected GridBagConstraints gbc = new GridBagConstraints();
    protected boolean state;
    protected List nodes;

    @Override
    public void setEnabled(boolean bl) {
        this.state = bl;
        this.nodeProfSelPanel.setEnabled(this.state);
        this.nodeList.setEnabled(this.state);
        this.nodeScrollPane.setEnabled(this.state);
    }

    ProfileSelector(Component component) {
        this.aComponent = component;
        this.name2Node = new HashMap<String, INodeModel>();
    }

    @Override
    public void setNetScope(Collection<INodeModel> collection) {
        this.init(collection);
    }

    private void init(Collection<INodeModel> collection) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (INodeModel iNodeModel : collection) {
            String string = iNodeModel.getName();
            arrayList.add(string);
            this.name2Node.put(string, iNodeModel);
        }
        this.nodeList = new JList<Object>(arrayList.toArray());
        this.nodeList.setSelectionMode(0);
        this.nodeList.setBorder(BorderFactory.createLoweredBevelBorder());
        this.nodeProfSelPanel = new JPanel();
        this.nodeScrollPane = new UScrollPane();
        this.nodeScrollPane.getViewport().setView(this.nodeList);
        this.nodeScrollPane.setBorder((Border)BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Node Names"));
        this.nodeScrollPane.setPreferredSize(ProfileVlanDbPane.SELECTIONBOX_DIM);
        this.nodeProfSelPanel.setLayout(this.gridbag);
        this.gbc.anchor = 18;
        if (this.aComponent != null) {
            this.gbc.gridx = 0;
            this.gbc.gridy = 0;
            this.gridbag.setConstraints(this.aComponent, this.gbc);
            this.nodeProfSelPanel.add(this.aComponent);
        }
        this.gbc.gridx = 1;
        this.gridbag.setConstraints((Component)this.nodeScrollPane, this.gbc);
        this.nodeProfSelPanel.add((Component)this.nodeScrollPane);
    }

    public JPanel getPanel() {
        return this.nodeProfSelPanel;
    }

    public JList getNodeList() {
        return this.nodeList;
    }

    @Override
    public Collection<IModel> getSelectedModels() {
        Object[] objectArray = this.getNodeList().getSelectedValues();
        ArrayList<IModel> arrayList = new ArrayList<IModel>(objectArray.length);
        for (Object object : objectArray) {
            INodeModel iNodeModel = this.name2Node.get(object.toString());
            arrayList.add((IModel)iNodeModel);
        }
        return arrayList;
    }

    @Override
    public int getNumSelectedModels() {
        return this.getNodeList().getSelectedValues().length;
    }
}

