/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.vlan;

import cerent.cms.model.CTCUserException;
import cerent.cms.model.IModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.INodeModelAndIndex;
import cerent.cms.model.ISVlanProfile;
import cerent.cms.model.ISVlanProfileModel;
import cerent.cms.model.ISVlanProfileModels;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.SVlanProfile;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.Network;
import cerent.cms.ui.vlan.DSPComparator;
import cerent.cms.ui.vlan.DisplayableSVlanProfile;
import cerent.cms.ui.vlan.SVlanProfileChangedEvent;
import cerent.util.ContextedSDebug;
import cerent.util.IDisposable;
import cerent.util.IObservable;
import cerent.util.IObserver;
import cerent.util.ObservableManager;
import cerent.util.gui.row.ListRowDataSource;
import cerent.util.gui.row.RowDataSource;
import cerent.util.gui.row.RowDataSourceListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;

public class SVlanProfileRowDataSource
implements RowDataSource,
IDisposable,
IObserver,
Observer {
    private static final String NEW_PROFILE_PREFIX = "New Profile ";
    private static final DisplayableSVlanProfile NEW_PROFILE = new DisplayableSVlanProfile((ISVlanProfile)new SVlanProfile("New Profile "), "None");
    private static IdentityHashMap<INodeModel, Object> observedNes = new IdentityHashMap();
    private static IdentityHashMap<INodeModel, Object> removedNes = new IdentityHashMap();
    private static final INodeModel[] INODE_MODEL_ARRAY_TEMPLATE = new INodeModel[0];
    private ListRowDataSource<DisplayableSVlanProfile> rds = new ListRowDataSource((Comparator)DSPComparator.instance(), DisplayableSVlanProfile.class);
    private ObservableManager om = new ObservableManager(this, true){

        @Override
        protected int indexOf(Observable observable) {
            int n = this.observables.size();
            for (int i = 0; i < n; ++i) {
                Object e = this.observables.get(i);
                if (e != observable) continue;
                return i;
            }
            return -1;
        }
    };
    private static Debug db = new Debug("SVlanProfileRowDataSource");

    public SVlanProfileRowDataSource() {
        this.om.setPassing(true);
        db.setContext(this);
    }

    void setUnderlyingLock(Object object) {
        this.rds.setLock(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DisplayableSVlanProfile getObjectAtRow(int n) {
        DisplayableSVlanProfile displayableSVlanProfile = null;
        Object object = this.rds.getLock();
        synchronized (object) {
            displayableSVlanProfile = (DisplayableSVlanProfile)this.rds.getObjectAtRow(n);
        }
        return displayableSVlanProfile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int findEqualObject(DisplayableSVlanProfile displayableSVlanProfile) {
        int n = -1;
        Object object = this.rds.getLock();
        synchronized (object) {
            n = this.rds.findEqualObject((Object)displayableSVlanProfile);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setObjectAtRow(int n, Object object) {
        DisplayableSVlanProfile displayableSVlanProfile = (DisplayableSVlanProfile)object;
        if (db.on()) {
            db.println("setObjectAtRow(" + n + ", " + this.dump(displayableSVlanProfile) + ")");
        }
        DisplayableSVlanProfile displayableSVlanProfile2 = null;
        int n2 = -1;
        Object object2 = this.rds.getLock();
        synchronized (object2) {
            displayableSVlanProfile2 = (DisplayableSVlanProfile)this.rds.getObjectAtRow(n);
            n2 = this.rds.replace(n, (Object)displayableSVlanProfile);
        }
        if (displayableSVlanProfile2 != displayableSVlanProfile) {
            if (displayableSVlanProfile2 != null) {
                this.deleteObserver(displayableSVlanProfile2);
                if (displayableSVlanProfile2 instanceof IDisposable) {
                    displayableSVlanProfile2.dispose();
                }
            }
            if (displayableSVlanProfile != null) {
                this.addObserver(displayableSVlanProfile);
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyRowChange(DisplayableSVlanProfile displayableSVlanProfile) {
        if (db.on()) {
            db.println("notifyRowChange(" + this.dump(displayableSVlanProfile) + ")");
        }
        Object object = this.rds.getLock();
        synchronized (object) {
            this.rds.notifyChange((Object)displayableSVlanProfile);
        }
    }

    public Object clone(Object object) {
        return ((DisplayableSVlanProfile)object).clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int findSame(Object object) {
        int n = -1;
        Object object2 = this.rds.getLock();
        synchronized (object2) {
            n = this.rds.findSame(object);
        }
        return n;
    }

    public void dispose() {
        this.om.reset();
        this.rds.dispose();
        db.clearContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addNeObserver(INodeModel iNodeModel) {
        boolean bl = false;
        if (iNodeModel == null) {
            return bl;
        }
        ISVlanProfileModels iSVlanProfileModels = observedNes;
        synchronized (iSVlanProfileModels) {
            if (removedNes.get(iNodeModel) != null) {
                return false;
            }
            if (observedNes.get(iNodeModel) != null) {
                return bl;
            }
            bl = true;
            observedNes.put(iNodeModel, iNodeModel);
            INetElement iNetElement = Network.instance().getNetElem(iNodeModel.getNodeId());
            if (iNetElement != null) {
                iNetElement.addObserver(this);
            }
        }
        iSVlanProfileModels = iNodeModel.getISVlanProfileModels();
        if (iSVlanProfileModels != null) {
            this.addSvlanProfileModelObserver(iSVlanProfileModels);
        }
        if (db.on()) {
            db.println("addNeObserver(" + iNodeModel + ")");
        }
        return bl;
    }

    public Collection<INodeModel> getNeObservers() {
        return new ArrayList<INodeModel>(observedNes.keySet());
    }

    private void addSvlanProfileModelObserver(ISVlanProfileModels iSVlanProfileModels) {
        this.om.addObservable((Observable)iSVlanProfileModels);
    }

    private void addObserver(DisplayableSVlanProfile displayableSVlanProfile) {
        this.addDisplayableSVlanProfileObserver(displayableSVlanProfile);
        if (db.on()) {
            db.println("addObserver on: " + this.dump(displayableSVlanProfile));
        }
    }

    private void addDisplayableSVlanProfileObserver(DisplayableSVlanProfile displayableSVlanProfile) {
        this.om.addObservable((Observable)((Object)displayableSVlanProfile));
    }

    public boolean deleteNeObserver(INodeModel iNodeModel) {
        return this.deleteNeObserver(iNodeModel, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteNeObserver(INodeModel iNodeModel, boolean bl) {
        boolean bl2 = false;
        if (iNodeModel == null) {
            return bl2;
        }
        ISVlanProfileModels iSVlanProfileModels = observedNes;
        synchronized (iSVlanProfileModels) {
            if (bl) {
                removedNes.put(iNodeModel, iNodeModel);
            }
            if (observedNes.get(iNodeModel) == null) {
                return bl2;
            }
            bl2 = true;
            observedNes.remove(iNodeModel);
            INetElement iNetElement = Network.instance().getNetElem(iNodeModel.getNodeId());
            if (iNetElement != null) {
                iNetElement.deleteObserver(this);
            }
        }
        iSVlanProfileModels = iNodeModel.getISVlanProfileModels();
        if (iSVlanProfileModels != null) {
            this.deleteSVlanProfileModelsObserver(iSVlanProfileModels);
        }
        if (db.on()) {
            db.println("deleteNeObserver(" + iNodeModel + ")");
        }
        return bl2;
    }

    private void deleteSVlanProfileModelsObserver(ISVlanProfileModels iSVlanProfileModels) {
        this.om.removeObservable((Observable)iSVlanProfileModels);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAllNeObservers() {
        if (db.on()) {
            db.println("deleteAllNeObservers()");
        }
        INodeModel[] iNodeModelArray = null;
        INodeModel[] iNodeModelArray2 = observedNes;
        synchronized (observedNes) {
            iNodeModelArray = observedNes.keySet().toArray(INODE_MODEL_ARRAY_TEMPLATE);
            observedNes.clear();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            for (INodeModel iNodeModel : iNodeModelArray) {
                ISVlanProfileModels iSVlanProfileModels = iNodeModel.getISVlanProfileModels();
                if (iSVlanProfileModels == null) continue;
                this.deleteSVlanProfileModelsObserver(iSVlanProfileModels);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteNeObservers(int[] nArray) {
        int n;
        int n2 = n = nArray == null ? 0 : nArray.length;
        if (n == 0) {
            return;
        }
        Object object = this.rds.getLock();
        synchronized (object) {
            if (this.rds.getRowCount() == n) {
                this.deleteAllNeObservers();
                IdentityHashMap<INodeModel, Object> identityHashMap = observedNes;
                synchronized (identityHashMap) {
                    removedNes.clear();
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    DisplayableSVlanProfile displayableSVlanProfile = (DisplayableSVlanProfile)this.rds.getObjectAtRow(nArray[i]);
                    if (displayableSVlanProfile == null) continue;
                    List<INodeModelAndIndex> list = displayableSVlanProfile.getNodeSources();
                    for (INodeModelAndIndex iNodeModelAndIndex : list) {
                        INodeModel iNodeModel = iNodeModelAndIndex.nm;
                        this.deleteNeObserver(iNodeModel, true);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteNeObservers(Collection<DisplayableSVlanProfile> collection) {
        int n;
        int n2 = n = collection == null ? 0 : collection.size();
        if (n == 0) {
            return;
        }
        Object object = this.rds.getLock();
        synchronized (object) {
            if (this.rds.getRowCount() == n) {
                this.deleteAllNeObservers();
                IdentityHashMap<INodeModel, Object> identityHashMap = observedNes;
                synchronized (identityHashMap) {
                    removedNes.clear();
                }
            } else {
                for (DisplayableSVlanProfile displayableSVlanProfile : collection) {
                    List<INodeModelAndIndex> list = displayableSVlanProfile.getNodeSources();
                    for (INodeModelAndIndex iNodeModelAndIndex : list) {
                        INodeModel iNodeModel = iNodeModelAndIndex.nm;
                        this.deleteNeObserver(iNodeModel, true);
                    }
                }
            }
        }
    }

    private void deleteObserver(DisplayableSVlanProfile displayableSVlanProfile) {
        this.deleteDisplayableSVlanProfileObserver(displayableSVlanProfile);
        if (db.on()) {
            db.println("deleteObserver on: " + this.dump(displayableSVlanProfile));
        }
    }

    private void deleteDisplayableSVlanProfileObserver(DisplayableSVlanProfile displayableSVlanProfile) {
        this.om.removeObservable((Observable)((Object)displayableSVlanProfile));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRowCount() {
        int n = 0;
        Object object = this.rds.getLock();
        synchronized (object) {
            n = this.rds.getRowCount();
        }
        return n;
    }

    public void addRowDataSourceListener(RowDataSourceListener rowDataSourceListener) {
        this.rds.addRowDataSourceListener(rowDataSourceListener);
    }

    public void removeRowDataSourceListener(RowDataSourceListener rowDataSourceListener) {
        this.rds.removeRowDataSourceListener(rowDataSourceListener);
    }

    public Collection getAllObjects() {
        return this.getAllDisplayableSVlanProfiles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<DisplayableSVlanProfile> getAllDisplayableSVlanProfiles() {
        Collection collection = null;
        Object object = this.rds.getLock();
        synchronized (object) {
            collection = this.rds.getObjects();
        }
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DisplayableSVlanProfile> getAllEditedDisplayableSVlanProfiles() {
        ArrayList<DisplayableSVlanProfile> arrayList = null;
        Object object = this.rds.getLock();
        synchronized (object) {
            arrayList = new ArrayList<DisplayableSVlanProfile>();
            int n = this.rds.getRowCount();
            for (int i = 0; i < n; ++i) {
                DisplayableSVlanProfile displayableSVlanProfile = (DisplayableSVlanProfile)this.rds.getObjectAtRow(i);
                if (!displayableSVlanProfile.wasEdited()) continue;
                arrayList.add(displayableSVlanProfile);
            }
        }
        return arrayList;
    }

    public Class<DisplayableSVlanProfile> getRowObjectClass() {
        return this.rds.getRowObjectClass();
    }

    public boolean add(ISVlanProfile iSVlanProfile, String string) {
        DisplayableSVlanProfile displayableSVlanProfile = new DisplayableSVlanProfile(iSVlanProfile, string);
        return this.add(displayableSVlanProfile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(DisplayableSVlanProfile displayableSVlanProfile) {
        boolean bl = false;
        Object object = this.rds.getLock();
        synchronized (object) {
            bl = this._add(displayableSVlanProfile);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(Collection<? extends DisplayableSVlanProfile> collection) {
        boolean bl = false;
        int n = collection.size();
        Object object = this.rds.getLock();
        synchronized (object) {
            this.rds.ensureCapacity(this.rds.getRowCount() + n);
            for (DisplayableSVlanProfile displayableSVlanProfile : collection) {
                bl = this._add(displayableSVlanProfile);
            }
        }
        this.dumpAll("resulting DSP");
        return bl;
    }

    private void dumpAll(String string) {
        if (db.on()) {
            Collection collection = this.getAllObjects();
            db.println(string + " size: " + collection.size());
            for (Object e : collection) {
                db.println("  " + this.dump(e));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensureCapacity(int n) {
        Object object = this.rds.getLock();
        synchronized (object) {
            this.rds.ensureCapacity(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DisplayableSVlanProfile addNewCopy(DisplayableSVlanProfile displayableSVlanProfile) {
        DisplayableSVlanProfile displayableSVlanProfile2 = null;
        Object object = this.rds.getLock();
        synchronized (object) {
            int n = this.getHighestNew() + 1;
            ISVlanProfile iSVlanProfile = displayableSVlanProfile.getCopyOfProfile(NEW_PROFILE_PREFIX + n);
            displayableSVlanProfile2 = new DisplayableSVlanProfile(iSVlanProfile, "None");
            this._add(displayableSVlanProfile2);
        }
        return displayableSVlanProfile2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DisplayableSVlanProfile addNew(int n) {
        DisplayableSVlanProfile displayableSVlanProfile = null;
        Object object = this.rds.getLock();
        synchronized (object) {
            ArrayList<DisplayableSVlanProfile> arrayList = new ArrayList<DisplayableSVlanProfile>(n);
            int n2 = this.getHighestNew() + 1;
            for (int i = 0; i < n; ++i) {
                displayableSVlanProfile = new DisplayableSVlanProfile((ISVlanProfile)new SVlanProfile(NEW_PROFILE_PREFIX + (n2 + i)), "None");
                arrayList.add(displayableSVlanProfile);
            }
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                DisplayableSVlanProfile displayableSVlanProfile2;
                displayableSVlanProfile = displayableSVlanProfile2 = (DisplayableSVlanProfile)iterator.next();
                this._add(displayableSVlanProfile2);
            }
        }
        return displayableSVlanProfile;
    }

    private int getHighestNew() {
        DisplayableSVlanProfile displayableSVlanProfile;
        String string;
        int n = this.rds.findMatchingRow((Object)NEW_PROFILE);
        if (n < 0) {
            n = -n - 1;
        }
        int n2 = 0;
        int n3 = this.rds.getRowCount();
        for (int i = n; i < n3 && (string = (displayableSVlanProfile = (DisplayableSVlanProfile)this.rds.getObjectAtRow(i)).getName()).startsWith(NEW_PROFILE_PREFIX); ++i) {
            String string2 = string.substring(NEW_PROFILE_PREFIX.length());
            try {
                int n4 = Integer.parseInt(string2);
                if (n4 <= n2) continue;
                n2 = n4;
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                if (!db.on()) continue;
                Debug.printStackTrace((Throwable)numberFormatException);
            }
        }
        return n2;
    }

    private boolean _add(DisplayableSVlanProfile displayableSVlanProfile) {
        return this._add(displayableSVlanProfile, null);
    }

    private boolean _add(DisplayableSVlanProfile displayableSVlanProfile, Object object) {
        boolean bl = db.on();
        if (bl) {
            db.println("_add(" + this.dump(displayableSVlanProfile) + (object != null ? ", " + object : "") + ")");
        }
        boolean bl2 = false;
        int n = this.rds.findMatchingRow((Object)displayableSVlanProfile);
        int n2 = this.rds.firstMatchingRow((Object)displayableSVlanProfile, n);
        if (n2 < 0) {
            bl2 = true;
            int n3 = -(n2 + 1);
            if (object != null) {
                displayableSVlanProfile.updateSource(object);
            }
            this.rds.add(n3, (Object)displayableSVlanProfile);
            if (displayableSVlanProfile.getNumSources() > 0) {
                this.addObserver(displayableSVlanProfile);
            }
        } else {
            int n4 = this.rds.nextEqualRow(n2, (Object)displayableSVlanProfile, n);
            if (n4 >= 0) {
                int n5 = n4;
                if (bl) {
                    db.println("..._add - existing equal starting at row: " + n4);
                }
                int n6 = -1;
                int n7 = -1;
                DisplayableSVlanProfile displayableSVlanProfile2 = null;
                DisplayableSVlanProfile displayableSVlanProfile3 = null;
                DisplayableSVlanProfile displayableSVlanProfile4 = null;
                while (n4 >= 0) {
                    if (bl && n5 != n4) {
                        db.println("..._add - existing equal considering row: " + n4);
                    }
                    displayableSVlanProfile2 = (DisplayableSVlanProfile)this.rds.getObjectAtRow(n4);
                    if (displayableSVlanProfile3 == null && !displayableSVlanProfile2.wasEdited() && (displayableSVlanProfile3 = displayableSVlanProfile2.updateSourceInClone(displayableSVlanProfile, object)) != null) {
                        n6 = n4;
                        if (bl) {
                            db.println("..._mrow found : " + n6);
                        }
                    }
                    if (displayableSVlanProfile4 == null && !displayableSVlanProfile2.wasEdited() && displayableSVlanProfile2.containsSources(displayableSVlanProfile, object)) {
                        displayableSVlanProfile4 = displayableSVlanProfile2;
                        n7 = n4;
                        if (bl) {
                            db.println("..._drow found : " + n7);
                        }
                    }
                    if (displayableSVlanProfile3 != null && displayableSVlanProfile4 != null) break;
                    n2 = n4 + 1;
                    n4 = this.rds.nextEqualRow(n2, (Object)displayableSVlanProfile, n);
                }
                if (n6 < 0) {
                    n7 = -1;
                }
                if (db.on() && n6 >= 0 && n7 >= 0) {
                    db.println("mrow: " + n6 + " / drow: " + n7);
                }
                if (n7 >= 0 && n7 > n6) {
                    this.rds.remove(n7, displayableSVlanProfile4);
                    this.deleteObserver(displayableSVlanProfile4);
                    displayableSVlanProfile4.dispose();
                }
                if (displayableSVlanProfile3 != null) {
                    displayableSVlanProfile2 = (DisplayableSVlanProfile)this.rds.getObjectAtRow(n6);
                    if (bl) {
                        db.println("..._add - replace: " + this.dump(displayableSVlanProfile3));
                    }
                    int n8 = this._findEqual(displayableSVlanProfile3);
                    if (bl) {
                        db.println("...rrow: " + n8);
                    }
                    if (n8 < 0) {
                        this.rds.replace(n6, (Object)displayableSVlanProfile3);
                    } else if (n8 != n6) {
                        this.rds.replace(n8, (Object)displayableSVlanProfile3);
                        if (n8 < n6) {
                            --n6;
                        }
                        this.rds.replace(n6, (Object)displayableSVlanProfile3);
                    }
                    if (displayableSVlanProfile2.isDisposed()) {
                        if (bl) {
                            db.println("..._add - replaced w/ clone - addObserver");
                            db.println("...drow: " + n7 + ", mrow: " + n6);
                        }
                        this.deleteObserver(displayableSVlanProfile2);
                        this.addObserver(displayableSVlanProfile3);
                    } else if (object == null) {
                        displayableSVlanProfile3.dispose();
                    }
                }
                if (n7 >= 0 && n7 < n6) {
                    this.rds.remove(n7, displayableSVlanProfile4);
                    this.deleteObserver(displayableSVlanProfile4);
                    displayableSVlanProfile4.dispose();
                }
                if (n6 < 0 && n7 < 0) {
                    this.rds.notifyChange(n5, (Object)displayableSVlanProfile2);
                }
            } else {
                bl2 = true;
                n4 = -(n4 + 1);
                if (object != null) {
                    displayableSVlanProfile.updateSource(object);
                }
                this.rds.add(n4, (Object)displayableSVlanProfile);
                if (displayableSVlanProfile.getNumSources() > 0) {
                    if (bl) {
                        db.println("..._add - no equal - addObserver");
                    }
                    this.addObserver(displayableSVlanProfile);
                }
            }
        }
        return bl2;
    }

    private boolean doesHaveRenamedEdit(DisplayableSVlanProfile displayableSVlanProfile, Object object) {
        boolean bl = false;
        int n = this.rds.getRowCount();
        String string = displayableSVlanProfile.getName();
        DisplayableSVlanProfile displayableSVlanProfile2 = null;
        for (int i = 0; i < n && !bl; ++i) {
            DisplayableSVlanProfile displayableSVlanProfile3 = (DisplayableSVlanProfile)this.rds.getObjectAtRow(i);
            boolean bl2 = bl = displayableSVlanProfile3.wasEdited() && string.equals(displayableSVlanProfile3.getOrigName()) && displayableSVlanProfile3.containsSources(displayableSVlanProfile, object);
            if (!bl) continue;
            displayableSVlanProfile2 = displayableSVlanProfile3;
        }
        if (db.on() && bl) {
            db.println("doesHaveRenamedEdit(" + displayableSVlanProfile + ", " + object + ") returned true");
            db.println("...for match: " + displayableSVlanProfile2);
        }
        return bl;
    }

    private int clearMatchingOrigName(String string) {
        int n = 0;
        int n2 = this.rds.getRowCount();
        for (int i = 0; i < n2; ++i) {
            DisplayableSVlanProfile displayableSVlanProfile = (DisplayableSVlanProfile)this.rds.getObjectAtRow(i);
            if (!displayableSVlanProfile.clearOrigName(string)) continue;
            ++n;
        }
        if (db.on()) {
            db.println("clearMatchingOrigName(" + string + ") returned: " + n);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(ISVlanProfile iSVlanProfile, Object object) {
        boolean bl = true;
        DisplayableSVlanProfile displayableSVlanProfile = null;
        INodeModelAndIndex iNodeModelAndIndex = null;
        if (object instanceof String) {
            displayableSVlanProfile = new DisplayableSVlanProfile(iSVlanProfile, (String)object);
        } else if (object instanceof INodeModelAndIndex) {
            iNodeModelAndIndex = (INodeModelAndIndex)object;
            displayableSVlanProfile = new DisplayableSVlanProfile(iSVlanProfile, iNodeModelAndIndex);
        }
        Object object2 = this.rds.getLock();
        synchronized (object2) {
            int n = this.rds.findMatchingRow((Object)displayableSVlanProfile);
            int n2 = this.rds.firstMatchingRow((Object)displayableSVlanProfile, n);
            if (n2 < 0) {
                bl = false;
            } else {
                int n3 = this.rds.nextEqualRow(n2, (Object)displayableSVlanProfile, n);
                DisplayableSVlanProfile displayableSVlanProfile2 = (DisplayableSVlanProfile)this.rds.getObjectAtRow(n3);
                boolean bl2 = false;
                if (object instanceof String) {
                    bl2 = displayableSVlanProfile2.removeSource((String)object);
                } else if (iNodeModelAndIndex != null) {
                    bl2 = displayableSVlanProfile2.removeSource(iNodeModelAndIndex);
                }
                if (bl2) {
                    if (displayableSVlanProfile2.getNumSources() == 0) {
                        this.rds.remove(n3, (Object)displayableSVlanProfile2);
                        displayableSVlanProfile2.dispose();
                        this.deleteObserver(displayableSVlanProfile2);
                    } else {
                        DisplayableSVlanProfile displayableSVlanProfile3 = (DisplayableSVlanProfile)displayableSVlanProfile2.clone();
                        this.rds.replace(n3, (Object)displayableSVlanProfile3);
                        if (displayableSVlanProfile2.isDisposed()) {
                            this.deleteObserver(displayableSVlanProfile2);
                            this.addObserver(displayableSVlanProfile3);
                        } else {
                            displayableSVlanProfile3.dispose();
                        }
                    }
                }
            }
        }
        return bl;
    }

    private int _findEqual(DisplayableSVlanProfile displayableSVlanProfile) {
        int n = -1;
        if (displayableSVlanProfile == null) {
            return -1;
        }
        int n2 = this.rds.findMatchingRow((Object)displayableSVlanProfile);
        int n3 = this.rds.firstMatchingRow((Object)displayableSVlanProfile, n2);
        if (n3 >= 0) {
            int n4;
            while ((n4 = this.rds.nextEqualRow(n3, (Object)displayableSVlanProfile, n2)) >= 0) {
                DisplayableSVlanProfile displayableSVlanProfile2 = (DisplayableSVlanProfile)this.rds.getObjectAtRow(n4);
                if (displayableSVlanProfile2.equalSources(displayableSVlanProfile)) {
                    n = n4;
                    if (!db.on()) break;
                    db.println("found at row " + n4 + " EQUAL sp: " + this.dump(displayableSVlanProfile2));
                    break;
                }
                n3 = n4 + 1;
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean remove(DisplayableSVlanProfile displayableSVlanProfile) {
        boolean bl = false;
        if (displayableSVlanProfile == null) {
            return bl;
        }
        if (db.on()) {
            db.println("remove(" + this.dump(displayableSVlanProfile) + ")");
        }
        Object object = this.rds.getLock();
        synchronized (object) {
            boolean bl2 = bl = this.rds.remove((Object)displayableSVlanProfile) >= 0;
            if (bl) {
                this.deleteObserver(displayableSVlanProfile);
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int remove(int[] nArray) {
        int n = nArray == null ? 0 : nArray.length;
        int n2 = 0;
        DisplayableSVlanProfile[] displayableSVlanProfileArray = new DisplayableSVlanProfile[n];
        Object object = this.rds.getLock();
        synchronized (object) {
            for (int i = 0; i < n; ++i) {
                displayableSVlanProfileArray[i] = (DisplayableSVlanProfile)this.rds.getObjectAtRow(nArray[i]);
            }
            n2 = this.rds.remove(nArray);
        }
        for (int i = 0; i < n; ++i) {
            DisplayableSVlanProfile displayableSVlanProfile = displayableSVlanProfileArray[i];
            if (displayableSVlanProfile == null) continue;
            this.deleteObserver(displayableSVlanProfile);
            displayableSVlanProfile.dispose();
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.deleteAllNeObservers();
        int n = this.rds.getRowCount();
        ArrayList arrayList = null;
        Iterator iterator = this.rds.getLock();
        synchronized (iterator) {
            arrayList = new ArrayList(n);
            this.rds.copy(arrayList);
            this.rds.clear();
        }
        for (DisplayableSVlanProfile displayableSVlanProfile : arrayList) {
            displayableSVlanProfile.dispose();
        }
    }

    public String dump(Object object) {
        if (object instanceof DisplayableSVlanProfile) {
            DisplayableSVlanProfile displayableSVlanProfile = (DisplayableSVlanProfile)object;
            String string = "";
            if (displayableSVlanProfile.isObserver(this)) {
                string = " observing";
            }
            return displayableSVlanProfile.toString() + string;
        }
        return object == null ? "null" : object.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean wereAnyEdited() {
        boolean bl = false;
        Object object = this.rds.getLock();
        synchronized (object) {
            int n = this.rds.getRowCount();
            for (int i = 0; i < n && !bl; ++i) {
                DisplayableSVlanProfile displayableSVlanProfile = (DisplayableSVlanProfile)this.rds.getObjectAtRow(i);
                bl = displayableSVlanProfile.wasEdited();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean wereAnyEdited(Collection<DisplayableSVlanProfile> collection) {
        boolean bl = false;
        Object object = this.rds.getLock();
        synchronized (object) {
            for (DisplayableSVlanProfile displayableSVlanProfile : collection) {
                DisplayableSVlanProfile displayableSVlanProfile2;
                int n = this.rds.findEqualObject((Object)displayableSVlanProfile);
                if (n < 0 || !(displayableSVlanProfile2 = (DisplayableSVlanProfile)this.rds.getObjectAtRow(n)).wasEdited()) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public String checkToBeStoredProfiles(Collection<DisplayableSVlanProfile> collection) {
        String string = null;
        if (collection == null || collection.size() == 0) {
            return string;
        }
        HashSet<String> hashSet = new HashSet<String>(collection.size());
        for (DisplayableSVlanProfile displayableSVlanProfile : collection) {
            String string2 = displayableSVlanProfile.getName();
            if (hashSet.contains(string2)) {
                string = "Stored SVLAN profiles must have unique names. The name: " + string2 + " is stored more than once.";
                break;
            }
            hashSet.add(string2);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPassing(boolean bl) {
        this.om.setPassing(bl);
        Collection collection = null;
        Iterator iterator = this.rds.getLock();
        synchronized (iterator) {
            collection = this.rds.getObjects();
        }
        for (DisplayableSVlanProfile displayableSVlanProfile : collection) {
            displayableSVlanProfile.setPassing(bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDirty() {
        DisplayableSVlanProfile displayableSVlanProfile;
        boolean bl;
        boolean bl2 = bl = this.om.getBlockingModeControllerState() > 0;
        if (bl) {
            return bl;
        }
        Collection collection = null;
        Iterator iterator = this.rds.getLock();
        synchronized (iterator) {
            collection = this.rds.getObjects();
        }
        iterator = collection.iterator();
        while (iterator.hasNext() && !(bl = (displayableSVlanProfile = (DisplayableSVlanProfile)iterator.next()).isDirty())) {
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceNeRefresh() {
        Collection collection = null;
        Iterator iterator = this.rds.getLock();
        synchronized (iterator) {
            collection = this.rds.getObjects();
        }
        for (DisplayableSVlanProfile displayableSVlanProfile : collection) {
            displayableSVlanProfile.forceNeRefresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSource(INodeModel iNodeModel) {
        this.deleteNeObserver(iNodeModel);
        Collection collection = null;
        Iterator iterator = this.rds.getLock();
        synchronized (iterator) {
            collection = this.rds.getObjects();
        }
        for (DisplayableSVlanProfile displayableSVlanProfile : collection) {
            displayableSVlanProfile.removeSource(iNodeModel);
        }
    }

    @Override
    public void update(Observable observable, Object object) {
        if (observable instanceof IObservable) {
            this.update((IObservable)observable, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(IObservable iObservable, Object object) {
        if (iObservable instanceof INetElement) {
            if (object == ModelUpdateType.DELETED) {
                INetElement iNetElement = (INetElement)iObservable;
                INodeModel iNodeModel = iNetElement.getNodeModel();
                this.removeSource(iNodeModel);
            }
            return;
        }
        if (object instanceof SVlanProfileChangedEvent) {
            SVlanProfileChangedEvent sVlanProfileChangedEvent = (SVlanProfileChangedEvent)object;
            if (db.on()) {
                db.println("update: received SVlanProfileChangedEvent " + sVlanProfileChangedEvent);
                db.println("...o was: " + iObservable);
            }
            INodeModelAndIndex iNodeModelAndIndex = sVlanProfileChangedEvent.nmi;
            DisplayableSVlanProfile displayableSVlanProfile = new DisplayableSVlanProfile(sVlanProfileChangedEvent.sourceProfile, iNodeModelAndIndex);
            boolean bl = false;
            Object object2 = this.rds.getLock();
            synchronized (object2) {
                bl = this._add(displayableSVlanProfile, iNodeModelAndIndex);
            }
            if (db.on()) {
                if (bl) {
                    db.println("...added    dsp: " + this.dump(displayableSVlanProfile));
                } else {
                    db.println("...changed  dsp: " + this.dump(displayableSVlanProfile));
                }
                db.println("...existing dsp: " + this.dump(iObservable));
            }
            if (sVlanProfileChangedEvent.eventType != null) {
                this.update(iObservable, (Object)sVlanProfileChangedEvent.eventType);
            }
        } else if (object == ModelUpdateType.DELETED) {
            if (db.on()) {
                db.println("update: received DELETED event from " + iObservable);
            }
            if (iObservable instanceof DisplayableSVlanProfile) {
                DisplayableSVlanProfile displayableSVlanProfile = (DisplayableSVlanProfile)iObservable;
                this.remove(displayableSVlanProfile);
            }
        } else if (object == ModelUpdateType.CHANGED) {
            if (db.on()) {
                db.println("update: received CHANGED event from " + iObservable);
            }
            if (iObservable instanceof DisplayableSVlanProfile) {
                DisplayableSVlanProfile displayableSVlanProfile = (DisplayableSVlanProfile)iObservable;
                INodeModelAndIndex iNodeModelAndIndex = displayableSVlanProfile.getModelIfSingleModelSourced();
                if (iNodeModelAndIndex != null) {
                    ISVlanProfileModel iSVlanProfileModel = DisplayableSVlanProfile.getModel(iNodeModelAndIndex);
                    if (iSVlanProfileModel != null) {
                        ISVlanProfile iSVlanProfile;
                        if (db.on()) {
                            db.println("new single-NE-source dsp: " + iNodeModelAndIndex);
                        }
                        if ((iSVlanProfile = (ISVlanProfile)iSVlanProfileModel.clone()) != null) {
                            DisplayableSVlanProfile displayableSVlanProfile2 = new DisplayableSVlanProfile(iSVlanProfile, iNodeModelAndIndex);
                            this.add(displayableSVlanProfile2);
                        }
                    }
                } else {
                    if (db.on()) {
                        db.println("multiple-NE-source dsp: " + this.dump(displayableSVlanProfile));
                    }
                    Object object3 = this.rds.getLock();
                    synchronized (object3) {
                        this._add(displayableSVlanProfile);
                    }
                }
            }
        } else if (object == ModelUpdateType.ADDED) {
            if (db.on()) {
                db.println("update: received ADDED event from " + iObservable);
            }
            if (iObservable instanceof ISVlanProfileModels) {
                ISVlanProfileModels iSVlanProfileModels = (ISVlanProfileModels)iObservable;
                ArrayList arrayList = new ArrayList();
                try {
                    iSVlanProfileModels.getSVlanProfileModels(arrayList);
                    Object object4 = this.rds.getLock();
                    synchronized (object4) {
                        for (ISVlanProfileModel iSVlanProfileModel : arrayList) {
                            ISVlanProfile iSVlanProfile = (ISVlanProfile)iSVlanProfileModel.clone();
                            if (iSVlanProfile == null) continue;
                            INodeModelAndIndex iNodeModelAndIndex = new INodeModelAndIndex((IModel)iSVlanProfileModel);
                            DisplayableSVlanProfile displayableSVlanProfile = new DisplayableSVlanProfile(iSVlanProfile, (INodeModelAndIndex)null);
                            this._add(displayableSVlanProfile, iNodeModelAndIndex);
                        }
                    }
                }
                catch (CTCUserException cTCUserException) {
                    if (db.on()) {
                        db.println("error encountered during the handling of a SVlanProfileModels ADDED event");
                        Debug.printStackTrace((Throwable)cTCUserException);
                    }
                }
            }
        } else if (db.on()) {
            db.println("update: received unhandled event " + object + " from " + iObservable);
        }
    }

    public static class Debug
    extends ContextedSDebug<SVlanProfileRowDataSource> {
        public Debug(String string) {
            super(string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void dump() {
            SVlanProfileRowDataSource sVlanProfileRowDataSource = (SVlanProfileRowDataSource)this.getContext();
            if (sVlanProfileRowDataSource == null) {
                return;
            }
            Collection<DisplayableSVlanProfile> collection = sVlanProfileRowDataSource.getAllDisplayableSVlanProfiles();
            this.println("# of DPs: " + collection.size());
            for (DisplayableSVlanProfile iterator : collection) {
                db.print("  " + sVlanProfileRowDataSource.dump(iterator));
                if (iterator.isObserver(sVlanProfileRowDataSource.om)) {
                    db.println("*");
                    continue;
                }
                db.println("");
            }
            IdentityHashMap identityHashMap = observedNes;
            synchronized (identityHashMap) {
                this.println("observed NEs: " + observedNes.size());
                for (INodeModel iNodeModel : observedNes.keySet()) {
                    db.println("  " + iNodeModel.getName());
                }
                this.println("removed NEs: " + removedNes.size());
                for (INodeModel iNodeModel : removedNes.keySet()) {
                    db.println("  " + iNodeModel.getName());
                }
            }
        }
    }
}

