/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.vlan;

import cerent.cms.model.IVlanModel;
import cerent.cms.ui.helper.PortHelper;
import cerent.cms.ui.vlan.VlanStpEntry;
import cerent.util.gui.row.AbstractColumnRenderer;
import cerent.util.gui.row.ColumnRenderer;
import java.awt.Color;
import java.awt.Component;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;

public class VlanStpColumnRenderer
extends AbstractColumnRenderer {
    private static final int SEL = 0;
    private static final int ITEM_TYPE = 1;
    private static final int ITEM_NAME = 2;
    private static final int STP_ID = 3;
    private static final int VLANS = 4;
    private static final int COLUMN_NO = 5;
    private static final String CK_IMG_PATH = "/images/check_blue.gif";
    private static final ImageIcon CK_IMG = new ImageIcon(VlanStpColumnRenderer.class.getResource("/images/check_blue.gif"), "true");
    private static final Color SEL_BG = new Color(205, 205, 255);
    private static final JLabel CHECKED = new JLabel(CK_IMG);
    private JLabel label = new JLabel();
    private static final int MAX_TT_LINES = 6;
    private static final int MAX_TT_LINE_LENGTH = 70;

    public VlanStpColumnRenderer(String string, int n, boolean bl, int n2) {
        super(string, n, bl, n2);
        this.label.setHorizontalAlignment(n2);
        this.label.setVerticalAlignment(1);
        this.label.setOpaque(true);
        this.label.setForeground(Color.black);
        this.label.setFont(this.label.getFont().deriveFont(0));
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        String string = "";
        String string2 = null;
        JLabel jLabel = this.label;
        VlanStpEntry vlanStpEntry = (VlanStpEntry)object;
        Color color = jTable.getForeground();
        Color color2 = vlanStpEntry.isSelected() ? SEL_BG : Color.white;
        switch (n2) {
            case 0: {
                if (!vlanStpEntry.isSelected()) break;
                jLabel = CHECKED;
                break;
            }
            case 1: {
                string = vlanStpEntry.getType();
                break;
            }
            case 2: {
                string = vlanStpEntry.getName();
                if (string != null) break;
                string = "slot " + vlanStpEntry.getSlot() + " / port " + PortHelper.getConcatenatedString((int[])vlanStpEntry.getPort());
                break;
            }
            case 3: {
                int n3 = vlanStpEntry.getStpId();
                if (n3 <= 0) {
                    string = "n/a";
                    string2 = "Spanning Tree ID Not Available";
                    break;
                }
                string = Integer.toString(vlanStpEntry.getStpId());
                break;
            }
            case 4: {
                string = vlanStpEntry.getVlanList();
                string2 = this.breakDown(string);
            }
        }
        this.label.setText(string);
        this.label.setToolTipText(string2);
        ((Component)jLabel).setForeground(color);
        ((Component)jLabel).setBackground(color2);
        return jLabel;
    }

    private String breakDown(String string) {
        if (string.length() > 70) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            StringBuffer stringBuffer = new StringBuffer();
            int n = 1;
            int n2 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (stringBuffer.length() + string2.length() - n2 > 70) {
                    if (n > 6) {
                        stringBuffer.append("...");
                        break;
                    }
                    stringBuffer.append("<p>");
                    n2 = stringBuffer.length();
                    ++n;
                }
                stringBuffer.append(string2);
                stringBuffer.append(" ");
            }
            string = stringBuffer.toString();
        }
        return "<html>" + string + "</html>";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int compareColumn(Object object, Object object2, int n) {
        int n2 = 0;
        VlanStpEntry vlanStpEntry = (VlanStpEntry)object;
        VlanStpEntry vlanStpEntry2 = (VlanStpEntry)object2;
        switch (n) {
            case 0: {
                if (vlanStpEntry.isSelected() == vlanStpEntry2.isSelected()) return 0;
                if (!vlanStpEntry.isSelected()) return 1;
                return -1;
            }
            case 1: {
                String string = vlanStpEntry.getType();
                String string2 = vlanStpEntry2.getType();
                return string.compareTo(string2);
            }
            case 2: {
                return vlanStpEntry.compareTo(vlanStpEntry2);
            }
            case 3: {
                if (vlanStpEntry.getStpId() < vlanStpEntry2.getStpId()) {
                    return -1;
                }
                if (vlanStpEntry.getStpId() <= vlanStpEntry2.getStpId()) return n2;
                return 1;
            }
            case 4: {
                IVlanModel[] iVlanModelArray = vlanStpEntry.getVlans();
                IVlanModel[] iVlanModelArray2 = vlanStpEntry2.getVlans();
                int n3 = 0;
                while (true) {
                    if (n3 < iVlanModelArray.length) {
                        short s;
                        if (n3 >= iVlanModelArray2.length) return 1;
                        short s2 = iVlanModelArray[n3].getId();
                        if (s2 != (s = iVlanModelArray2[n3].getId())) {
                            if (s2 >= s) return 1;
                            return -1;
                        }
                    } else {
                        if (n3 >= iVlanModelArray2.length) return n2;
                        return -1;
                    }
                    ++n3;
                }
            }
        }
        return n2;
    }

    static ColumnRenderer[] createTableRenderers() {
        ColumnRenderer[] columnRendererArray = new ColumnRenderer[5];
        for (int i = 0; i < columnRendererArray.length; ++i) {
            columnRendererArray[i] = VlanStpColumnRenderer.createColumnRenderer(i);
        }
        return columnRendererArray;
    }

    public static ColumnRenderer createColumnRenderer(int n) {
        int n2;
        boolean bl;
        int n3;
        String string;
        switch (n) {
            case 0: {
                string = "Sel";
                n3 = 40;
                bl = false;
                n2 = 0;
                break;
            }
            case 1: {
                string = "Type";
                n3 = 150;
                bl = true;
                n2 = 2;
                break;
            }
            case 2: {
                string = "Circuit Name/Port";
                n3 = 140;
                bl = true;
                n2 = 2;
                break;
            }
            case 3: {
                string = "STP ID";
                n3 = 60;
                bl = false;
                n2 = 0;
                break;
            }
            default: {
                string = "VLANs";
                n3 = 400;
                bl = true;
                n2 = 2;
            }
        }
        return new VlanStpColumnRenderer(string, n3, bl, n2);
    }

    static {
        CHECKED.setOpaque(true);
    }
}

