/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.vlan;

import cerent.cms.model.IVlanModel;
import cerent.cms.ui.helper.PortHelper;
import cerent.util.ComparisonUtil;

public class VlanStpEntry
implements Comparable {
    private boolean selected;
    private String type;
    private String name;
    private int slot;
    private int[] port;
    private int stpId;
    private IVlanModel[] vlans;
    private String vlanList = null;

    public VlanStpEntry(String string, String string2, int n, IVlanModel[] iVlanModelArray) {
        this.type = string;
        this.stpId = n;
        this.name = string2;
        this.vlans = iVlanModelArray;
    }

    public VlanStpEntry(String string, int n, int[] nArray, int n2, IVlanModel[] iVlanModelArray) {
        this.type = string;
        this.stpId = n2;
        this.slot = n;
        this.port = nArray;
        this.vlans = iVlanModelArray;
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public int getSlot() {
        return this.slot;
    }

    public int[] getPort() {
        return this.port;
    }

    public int getStpId() {
        return this.stpId;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean bl) {
        this.selected = bl;
    }

    public IVlanModel[] getVlans() {
        return this.vlans;
    }

    public int compareTo(Object object) {
        if (!(object instanceof VlanStpEntry)) {
            return -1;
        }
        VlanStpEntry vlanStpEntry = (VlanStpEntry)object;
        if (this.name == null) {
            if (vlanStpEntry.getName() != null) {
                return 1;
            }
            if (this.slot < vlanStpEntry.getSlot()) {
                return -1;
            }
            if (this.slot > vlanStpEntry.getSlot()) {
                return 1;
            }
            return ComparisonUtil.compare((int[])this.port, (int[])vlanStpEntry.getPort());
        }
        if (vlanStpEntry.getName() == null) {
            return -1;
        }
        return this.name.compareTo(vlanStpEntry.getName());
    }

    public String getVlanList() {
        if (this.vlanList == null) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            IVlanModel iVlanModel = null;
            if (this.name == null) {
                n = 1;
                iVlanModel = this.vlans[0];
            }
            while (n < this.vlans.length) {
                String string = iVlanModel == this.vlans[n] ? ",untag" : "";
                stringBuffer.append(this.vlans[n].getName() + "(" + this.vlans[n].getId() + string + ") ");
                ++n;
            }
            this.vlanList = stringBuffer.toString();
        }
        return this.vlanList;
    }

    public String toString() {
        if (this.name != null) {
            return this.name;
        }
        return "slot#" + this.slot + "/port#" + PortHelper.getConcatenatedString((int[])this.port);
    }
}

