/*
 * Decompiled with CFR 0.152.
 */
package cerent.util;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileWriter;
import java.io.IOException;

public class AccountableFileWriter
extends FileWriter {
    private File file;
    private FileWriterAccounts accounts;
    private int stackCounter;

    public AccountableFileWriter(File file) throws IOException {
        this(file, false);
    }

    public AccountableFileWriter(File file, boolean bl) throws IOException {
        super(file, bl);
        this.file = file;
        this.stackCounter = 0;
        this.accounts = new FileWriterAccounts();
        if (bl) {
            this.accounts.originalBytes = file.length();
        }
    }

    public AccountableFileWriter(FileDescriptor fileDescriptor) throws IOException {
        super(fileDescriptor);
        this.accounts = new FileWriterAccounts();
        this.accounts.corrupt = true;
        this.stackCounter = Integer.MIN_VALUE;
        throw new IOException();
    }

    public AccountableFileWriter(String string) throws IOException {
        this(string, false);
    }

    public AccountableFileWriter(String string, boolean bl) throws IOException {
        this(new File(string), bl);
    }

    @Override
    public void write(int n) throws IOException {
        ++this.stackCounter;
        try {
            super.write(n);
            if (this.stackCounter == 1) {
                this.accounts.bytesWritten++;
            }
        }
        catch (IOException iOException) {
            this.accounts.corrupt = true;
            throw iOException;
        }
        finally {
            --this.stackCounter;
        }
    }

    @Override
    public void write(char[] cArray, int n, int n2) throws IOException {
        ++this.stackCounter;
        try {
            super.write(cArray, n, n2);
            if (this.stackCounter == 1) {
                this.accounts.bytesWritten += n2;
            }
        }
        catch (IOException iOException) {
            this.accounts.corrupt = true;
            throw iOException;
        }
        finally {
            --this.stackCounter;
        }
    }

    @Override
    public void write(String string, int n, int n2) throws IOException {
        ++this.stackCounter;
        try {
            super.write(string, n, n2);
            if (this.stackCounter == 1) {
                this.accounts.bytesWritten += n2;
            }
        }
        catch (IOException iOException) {
            this.accounts.corrupt = true;
            throw iOException;
        }
        finally {
            --this.stackCounter;
        }
    }

    @Override
    public void write(char[] cArray) throws IOException {
        ++this.stackCounter;
        try {
            super.write(cArray);
            if (this.stackCounter == 1) {
                this.accounts.bytesWritten += cArray.length;
            }
        }
        catch (IOException iOException) {
            this.accounts.corrupt = true;
            throw iOException;
        }
        finally {
            --this.stackCounter;
        }
    }

    @Override
    public void write(String string) throws IOException {
        ++this.stackCounter;
        try {
            super.write(string);
            if (this.stackCounter == 1) {
                this.accounts.bytesWritten += string.length();
            }
        }
        catch (IOException iOException) {
            this.accounts.corrupt = true;
            throw iOException;
        }
        finally {
            --this.stackCounter;
        }
    }

    @Override
    public void close() throws IOException {
        throw new IOException();
    }

    public FileWriterAccounts closeAccountably() throws IOException {
        super.close();
        this.accounts.actualSize = this.file == null ? -1L : this.file.length();
        return this.accounts;
    }

    public class FileWriterAccounts {
        private boolean corrupt = false;
        private long originalBytes = 0L;
        private long bytesWritten = 0L;
        private long actualSize;

        FileWriterAccounts() {
        }

        public boolean corrupt() {
            return this.actualSize() < this.expectedSize() || this.corrupt;
        }

        public long originalBytes() {
            return this.originalBytes;
        }

        public long bytesWritten() {
            return this.bytesWritten;
        }

        public long expectedSize() {
            return this.originalBytes + this.bytesWritten;
        }

        public long actualSize() {
            return this.actualSize;
        }

        public String account() {
            String string = null;
            string = this.actualSize() < this.expectedSize() ? "Attempted to write " + this.expectedSize() + " bytes but only wrote " + this.actualSize() : (this.corrupt() ? "An IO Exception occurred: byte counts of " + this.expectedSize() + "/" + this.actualSize() + " are invalid" : "Successfully wrote " + this.actualSize() + " bytes");
            return string;
        }
    }
}

