/*
 * Decompiled with CFR 0.152.
 */
package cerent.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;

public class SocketURLStreamHandler
extends URLStreamHandler {
    @Override
    protected URLConnection openConnection(URL uRL) throws IOException {
        SocketURLConnection socketURLConnection = new SocketURLConnection(uRL);
        socketURLConnection.connect();
        return socketURLConnection;
    }

    private class SocketURLConnection
    extends URLConnection {
        private Socket socket;

        public SocketURLConnection(URL uRL) {
            super(uRL);
        }

        @Override
        public void connect() throws IOException {
            if (this.connected) {
                return;
            }
            int n = this.getURL().getPort();
            if (n < 0) {
                throw new IOException("The URL requires a port.");
            }
            this.socket = new Socket(this.getURL().getHost(), n);
            this.connected = true;
        }

        @Override
        public OutputStream getOutputStream() throws IOException {
            if (this.connected) {
                return this.socket.getOutputStream();
            }
            throw new IOException("The stream handler is not connected.");
        }

        @Override
        public InputStream getInputStream() throws IOException {
            if (this.connected) {
                return this.socket.getInputStream();
            }
            throw new IOException("The stream handler is not connected.");
        }
    }
}

