/*
 * Decompiled with CFR 0.152.
 */
package cerent.util;

import cerent.util.ISequenceNumberConstants;
import cerent.util.LRUMap;
import cerent.util.LongHolder;
import cerent.util.SDebug;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class TimeLRUMap
extends LRUMap {
    protected static final Long UNINITIALIZED_SEQ_NUM_OBJ = ISequenceNumberConstants.UNINITIALIZED_SEQ_NUM_OBJ;
    public static final int MINUTE_RESOLUTION = 60;
    final int ageCapacity;
    final int expandDelta;
    List toBeProcessed = new LinkedList();
    private boolean enableTouching;
    protected SDebug db;

    public TimeLRUMap(int n, int n2, int n3, SDebug sDebug) {
        super(n2, null);
        this.resizer = new Resizer();
        this.ageCapacity = n;
        if (n3 <= 0) {
            n3 = 100;
        }
        this.expandDelta = n3;
        this.toBeProcessed = Collections.synchronizedList(new LinkedList());
        this.db = sDebug;
        this.enableTouching = true;
    }

    public TimeLRUMap(SDebug sDebug) {
        this(10, sDebug);
    }

    public TimeLRUMap(int n, SDebug sDebug) {
        this(n, 10, 10, sDebug);
    }

    public boolean isTouchingEnabled() {
        return this.enableTouching;
    }

    public void enableTouching(boolean bl) {
        this.enableTouching = bl;
    }

    public void setDebug(SDebug sDebug) {
        this.db = sDebug;
    }

    public int getAgeCapacity() {
        return this.ageCapacity;
    }

    public int getResolution() {
        return 60;
    }

    protected void processRemovedLRU(Object object, Object object2) {
        if (object == null) {
            if (this.db != null && this.db.isFinestEnabled()) {
                this.db.finest("ignoring null key");
            }
            return;
        }
        if (this.db != null && this.db.on()) {
            long l = 0L;
            if (object2 != null) {
                l = ((LongHolder)object2).longValue();
            }
            this.db.println("key: " + object + " added to the to-be-processed list (" + l + ")");
        }
        this.toBeProcessed.add(object);
    }

    protected boolean isTooOld(long l, long l2) {
        int n = this.ageCapacity * 1000 * this.getResolution();
        boolean bl = l + (long)n < l2;
        return bl;
    }

    public void touch(Object object, long l) {
        this._touch(object, l);
    }

    public void touchSeq(Object object, Long l) {
        boolean bl = this._touch(object, TimeLRUMap.timestamp());
        if (bl) {
            this.requeued(object, l);
        }
    }

    public void touch(Object object) {
        this.touchSeq(object, UNINITIALIZED_SEQ_NUM_OBJ);
    }

    private synchronized boolean _touch(Object object, long l) {
        return this.__touch(object, l);
    }

    private boolean __touch(Object object, long l) {
        boolean bl;
        if (!this.enableTouching) {
            return false;
        }
        long l2 = TimeLRUMap.timestamp();
        LongHolder longHolder = new LongHolder(l);
        Object object2 = this.put(object, longHolder);
        LongHolder longHolder2 = null;
        if (object2 != null) {
            bl = true;
            if (this.db != null && this.db.isFinestEnabled()) {
                this.db.finest(object + " stamped " + TimeLRUMap.seconds(l));
            }
            longHolder2 = (LongHolder)this.remove(object);
            longHolder2.setValue(l);
            super.put(object, (Object)longHolder2);
        } else {
            bl = this.toBeProcessed.remove(object);
            if (!bl) {
                this.enqueued(object);
            }
        }
        return bl;
    }

    public boolean touchIfQueuedSeq(Object object, Long l) {
        boolean bl = this._touchIfQueued(object, TimeLRUMap.timestamp());
        if (bl) {
            this.requeued(object, l);
        }
        return bl;
    }

    private synchronized boolean _touchIfQueued(Object object, long l) {
        boolean bl = this._isQueued(object);
        if (bl) {
            this.__touch(object, l);
        }
        return bl;
    }

    private boolean _isQueued(Object object) {
        boolean bl = this.containsKey(object) || this.toBeProcessed.contains(object);
        return bl;
    }

    public synchronized boolean isQueued(Object object) {
        return this._isQueued(object);
    }

    protected void requeued(Object object, Long l) {
    }

    protected void enqueued(Object object) {
    }

    public Long dequeued(Object object) {
        return UNINITIALIZED_SEQ_NUM_OBJ;
    }

    public long getTimeStamp(Object object) {
        LongHolder longHolder = (LongHolder)this.get(object);
        long l = 0L;
        if (longHolder != null) {
            l = longHolder.longValue();
        } else {
            System.out.println("null timestamp for: " + object);
        }
        return l;
    }

    public synchronized Object removeObj(Object object) {
        return this.remove(object);
    }

    public synchronized int adjustSize() {
        return super.adjustSize();
    }

    protected synchronized List removeAllOld(boolean bl) {
        for (int i = this.size(); i > 0; --i) {
            Object object = this.getFirstKey();
            LongHolder longHolder = (LongHolder)this.getFirstValue();
            long l = longHolder.longValue();
            long l2 = TimeLRUMap.timestamp();
            if (bl && !this.isTooOld(l, l2)) break;
            super.remove(object);
            this.processRemovedLRU(object, longHolder);
        }
        return this.toBeProcessed;
    }

    public List removeAllOld() {
        return this.removeAllOld(true);
    }

    public synchronized List removeAll() {
        return this.removeAllOld(false);
    }

    public List getToBeProcessed() {
        return this.toBeProcessed;
    }

    protected static LongHolder stamp() {
        return new LongHolder(System.currentTimeMillis());
    }

    public static long timestamp() {
        return System.currentTimeMillis();
    }

    public static long seconds(long l) {
        long l2 = (l + 500L) / 1000L;
        return l2;
    }

    public void checkOrder() {
        List list = this.sequence();
        Object[] objectArray = list.toArray();
        Iterator iterator = list.iterator();
        LongHolder longHolder = null;
        int n = 0;
        while (iterator.hasNext()) {
            Object e = iterator.next();
            LongHolder longHolder2 = (LongHolder)this.getValue(n);
            if (longHolder != null && longHolder.longValue() > longHolder2.longValue()) {
                throw new IllegalStateException("An age order problem occurred in item #" + n + " : " + e);
            }
            longHolder = longHolder2;
            ++n;
        }
    }

    class Resizer
    implements LRUMap.Resizer {
        Resizer() {
        }

        public int getNewMaxSize(int n, Object object, Object object2) {
            int n2 = n;
            if (object2 != null) {
                long l;
                LongHolder longHolder = (LongHolder)object2;
                long l2 = longHolder.longValue();
                if (!TimeLRUMap.this.isTooOld(l2, l = TimeLRUMap.timestamp())) {
                    n2 += TimeLRUMap.this.expandDelta;
                }
            } else {
                int n3 = TimeLRUMap.this.getMaximumSize();
                if (n + TimeLRUMap.this.expandDelta < n3) {
                    n2 = n3 - TimeLRUMap.this.expandDelta;
                }
                if (n2 < 0) {
                    n2 = 0;
                }
            }
            if (TimeLRUMap.this.db != null && TimeLRUMap.this.db.isFinestEnabled() && n2 != n) {
                TimeLRUMap.this.db.finest("newSize " + (n2 > n ? "increased to " : "decreased to ") + n2 + " currentSize was " + n);
            }
            return n2;
        }
    }
}

