/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.gui;

import cerent.util.CEMC;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.WID;
import cerent.util.gui.AbstractPropertyEditor;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.SuffixAwareFileFilter;
import cerent.util.gui.UFileChooser;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;

public class FilePropertyEditor
extends AbstractPropertyEditor
implements DocumentListener {
    private static final String BROWSE = "Browse...";
    private JTextField txtInput = new JTextField(20);
    private JButton fileButton = new JButton("Browse...");
    private UFileChooser chooser = new UFileChooser();
    private boolean fromSetValue = false;
    private String approveButtonText = null;
    private boolean appendFilter = false;
    private String suffix = null;
    private boolean validateDoesExist = true;

    public FilePropertyEditor(String string) {
        this(new JLabel(string));
    }

    public FilePropertyEditor(Component component) {
        this.txtInput.getDocument().addDocumentListener(this);
        this.add(component);
        this.add(this.txtInput);
        this.add(this.fileButton);
        this.fileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                FilePropertyEditor.this.setSelectedFile();
                int n2 = n = FilePropertyEditor.this.approveButtonText != null ? FilePropertyEditor.this.chooser.showDialog((Component)FilePropertyEditor.this.getTopLevelAncestor(), FilePropertyEditor.this.approveButtonText) : FilePropertyEditor.this.chooser.showOpenDialog((Component)FilePropertyEditor.this.getTopLevelAncestor());
                if (n != 0) {
                    return;
                }
                String string = FilePropertyEditor.this.chooser.getSelectedFile().getAbsolutePath();
                if (FilePropertyEditor.this.appendFilter) {
                    string = FilePropertyEditor.this.appendFilterToPath(string);
                }
                FilePropertyEditor.this.txtInput.setText(string);
            }
        });
    }

    protected String appendFilterToPath(String string) {
        if (string != null && this.suffix != null && !string.endsWith("." + this.suffix)) {
            return string + "." + this.suffix;
        }
        return string;
    }

    public FileFilter getAcceptAllFileFilter() {
        return this.chooser.getAcceptAllFileFilter();
    }

    public void removeChoosableFileFilter(FileFilter fileFilter) {
        this.chooser.removeChoosableFileFilter(fileFilter);
    }

    public void setAcceptAllFileFilterUsed(boolean bl) {
        this.chooser.setAcceptAllFileFilterUsed(bl);
    }

    public void setFilter(String string, String string2) {
        this.suffix = string2;
        SuffixAwareFileFilter suffixAwareFileFilter = new SuffixAwareFileFilter(string, string2);
        this.chooser.addChoosableFileFilter((FileFilter)suffixAwareFileFilter);
    }

    public void setEditorSize(int n) {
        if (n > 0) {
            this.txtInput.setColumns(n);
        }
    }

    public void setFileSelectionMode(int n) {
        this.chooser.setFileSelectionMode(n);
    }

    public void setButtonText(String string) {
        if (string != null) {
            this.fileButton.setText(string);
        }
    }

    public void setApproveButtonText(String string) {
        if (string != null) {
            this.approveButtonText = string;
        }
    }

    public void setAppendFilter(boolean bl) {
        this.appendFilter = bl;
    }

    @Override
    public Object getValue() {
        return this.txtInput.getText();
    }

    @Override
    public void setValue(Object object) {
        if (object != null) {
            this.fromSetValue = true;
            this.txtInput.setText((String)object);
            this.setSelectedFile();
            this.fromSetValue = false;
        }
    }

    private void setSelectedFile() {
        String string = this.txtInput.getText();
        if (string != null && string.length() > 0) {
            this.chooser.setSelectedFile(new File(string));
        }
    }

    public boolean doesValidateExist() {
        return this.validateDoesExist;
    }

    public void setValidateExistence(boolean bl) {
        this.validateDoesExist = bl;
    }

    @Override
    public boolean onValidate() {
        if (!this.isEnabled()) {
            return true;
        }
        boolean bl = true;
        String string = (String)this.getValue();
        if (string != null && string.length() > 0) {
            Object object;
            try {
                object = new File(string);
                boolean bl2 = ((File)object).exists();
                bl = !(this.validateDoesExist ^ bl2);
            }
            catch (Exception exception) {
                bl = false;
            }
            if (!bl) {
                if (this.validateDoesExist) {
                    ErrorMsg.displayWarning((Component)this.getTopLevelAncestor(), (WID)CEMC.WID_FILE_DONT_EXIST_PARAM_1, (Object)string);
                    return false;
                }
                object = ErrorMsg.getString((EID)CEMC.WID_FILE_ALREADY_EXISTS_PARAM_1, (Object)string);
                return CerentDialog.yesNoWarningDialog((Component)this.getTopLevelAncestor(), (String)object, (String)"Save As");
            }
        }
        return true;
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.setDirty();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.setDirty();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.setDirty();
    }

    @Override
    public void requestEditorFocus() {
        this.txtInput.requestFocus();
    }

    private void setDirty() {
        if (!this.fromSetValue) {
            this.setDirty(true);
        }
        this.fromSetValue = false;
    }

    public void setTextEntryEnabled(boolean bl) {
        this.txtInput.setEnabled(bl);
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.txtInput.setEnabled(bl);
        this.fileButton.setEnabled(bl);
    }

    public void finalize() {
        this.chooser.dispose();
    }

    public void clearFilePath() {
        this.txtInput.setText(null);
    }
}

