/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.gui;

import java.awt.Toolkit;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class NumberTextField
extends JTextField {
    private String allowedChars;
    private String numString = "0123456789";

    public NumberTextField(int n) {
        this(n, null);
    }

    public NumberTextField(int n, String string) {
        super(n);
        this.allowedChars = string != null ? this.numString + string : this.numString;
    }

    @Override
    protected Document createDefaultModel() {
        return new NumberDocument(this.getColumns());
    }

    class NumberDocument
    extends PlainDocument {
        int documentMaxLength;

        public NumberDocument(int n) {
            this.documentMaxLength = n;
        }

        @Override
        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            boolean bl = true;
            if (string != null) {
                if (string.length() + this.getLength() > this.documentMaxLength) {
                    bl = false;
                } else {
                    for (int i = 0; bl && i < string.length(); ++i) {
                        char c = string.charAt(i);
                        if (NumberTextField.this.allowedChars.indexOf(c) != -1) continue;
                        bl = false;
                    }
                }
            }
            if (bl) {
                super.insertString(n, string, attributeSet);
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }
}

