/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.gui;

import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.ProgressDialogControl;
import cerent.util.gui.ProgressDialogResult;
import cerent.util.gui.UDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public class ProgressDialog
extends UDialog
implements Observer,
Runnable {
    private static final String STOP = "Stop";
    private static final SDebug db = new SDebug("ProgressDialog");
    private String note;
    private JLabel noteLabel;
    private int completion;
    private JProgressBar progressBar;
    private JButton stopButton;
    private boolean stoppable;
    private ProgressDialogControl control;
    private Exception exception = null;
    private boolean showResultDlg = true;

    private ProgressDialog(Frame frame, String string, Object object) {
        super(frame, string, true, object);
        this.setDefaultCloseOperation(0);
    }

    private ProgressDialog(Dialog dialog, String string, Object object) {
        super(dialog, string, true, object);
        this.setDefaultCloseOperation(0);
    }

    public void dispose() {
        if (!this.isShowing()) {
            if (ProgressDialog.db.on) {
                db.println("dispose: calling super.dispose");
            }
            super.dispose();
        } else if (this.stoppable) {
            if (ProgressDialog.db.on) {
                db.println("dispose: stopping control");
            }
            this.control.stop();
        } else if (ProgressDialog.db.on) {
            db.println("dispose: not allowed to stop");
        }
    }

    public static ProgressDialog start(Component component, String string, String string2, ProgressDialogControl progressDialogControl, int n, int n2, boolean bl) {
        return ProgressDialog.start(component, string, string2, progressDialogControl, n, n2, bl, true);
    }

    public static ProgressDialog start(Component component, String string, String string2, ProgressDialogControl progressDialogControl, int n, int n2, boolean bl, boolean bl2) {
        ProgressDialog progressDialog;
        Object[] objectArray = new Object[]{string2, new Boolean(bl)};
        if (component instanceof Frame) {
            progressDialog = new ProgressDialog((Frame)component, string, (Object)objectArray);
        } else if (component instanceof Dialog) {
            progressDialog = new ProgressDialog((Dialog)component, string, (Object)objectArray);
        } else {
            Frame frame = JOptionPane.getFrameForComponent(component);
            progressDialog = new ProgressDialog(frame, string, (Object)objectArray);
        }
        progressDialog.start(component, string, progressDialogControl, n, n2, bl2);
        return progressDialog;
    }

    public static ProgressDialog start(Component component, String string, String string2, ProgressDialogControl progressDialogControl, boolean bl) {
        return ProgressDialog.start(component, string, string2, progressDialogControl, 0, 0, bl);
    }

    private void start(Component component, String string, ProgressDialogControl progressDialogControl, int n, int n2, boolean bl) {
        this.control = progressDialogControl;
        this.showResultDlg = bl;
        TaskThread taskThread = new TaskThread(progressDialogControl);
        taskThread.start();
        AutoUpdateThread autoUpdateThread = null;
        try {
            Thread.sleep(200L);
        }
        catch (Exception exception) {
            db.finest("Exception in ProgressDialog start(), Thread.sleep(): " + exception);
        }
        if (!taskThread.isDone()) {
            if (n > 0) {
                autoUpdateThread = new AutoUpdateThread(n, n2);
                autoUpdateThread.start();
            }
            this.setVisible(true);
            if (autoUpdateThread != null) {
                autoUpdateThread.terminate();
            }
        }
        taskThread.displayResults(component, string);
        this.dispose();
    }

    public Exception getResultException() {
        return this.exception;
    }

    protected void initContentPane(JPanel jPanel, Object object) {
        this.completion = 0;
        Object[] objectArray = (Object[])object;
        this.note = (String)objectArray[0];
        Boolean bl = (Boolean)objectArray[1];
        this.stoppable = bl;
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setPreferredSize(new Dimension(200, 20));
        JPanel jPanel3 = new JPanel(new GridLayout(2, 1));
        jPanel3.add(this.progressBar);
        jPanel3.add(new JLabel(" "));
        jPanel2.add((Component)jPanel3, "South");
        this.noteLabel = new JLabel(this.note);
        this.noteLabel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        jPanel2.add((Component)this.noteLabel, "Center");
        jPanel.add((Component)jPanel2, "Center");
        if (this.stoppable) {
            this.stopButton = new JButton(STOP);
            this.stopButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ProgressDialog.this.control.stop();
                }
            });
            JPanel jPanel4 = new JPanel();
            jPanel4.add(this.stopButton);
            jPanel.add((Component)jPanel4, "South");
        }
        jPanel.revalidate();
    }

    @Override
    public void update(Observable observable, Object object) {
        if (object instanceof Integer) {
            this.completion = Math.max(0, (Integer)object);
            this.completion = Math.min(this.completion, 100);
        } else if (object instanceof String) {
            this.note = (String)object;
        } else {
            return;
        }
        SwingUtilities.invokeLater(this);
    }

    @Override
    public void run() {
        this.noteLabel.setText(this.note);
        this.progressBar.setValue(this.completion);
        this.pack();
        this.getContentPane().repaint();
    }

    class AutoUpdateThread
    extends Thread {
        private int freq;
        private int increment;
        private boolean done;
        private int counter;

        AutoUpdateThread(int n, int n2) {
            super("Progress Panel AutoUpdateThread");
            this.done = false;
            this.counter = 0;
            this.freq = n;
            this.increment = n2;
        }

        @Override
        public void run() {
            while (!this.done) {
                try {
                    Thread.sleep(this.freq);
                    this.counter += this.increment;
                    if (this.counter > 100) {
                        this.counter = 0;
                    }
                    ProgressDialog.this.update(null, new Integer(this.counter));
                }
                catch (Exception exception) {
                    db.finest("Exception in AutoUpdateThread/run(): " + exception);
                }
            }
        }

        void terminate() {
            this.done = true;
        }
    }

    class TaskThread
    extends Thread {
        private ProgressDialogControl control;
        private ProgressDialogResult result;
        private boolean done;
        private boolean progressDialogThreadUnblocked;

        TaskThread(ProgressDialogControl progressDialogControl) {
            super("Progress Panel TaskThread");
            this.result = null;
            this.done = false;
            this.progressDialogThreadUnblocked = false;
            this.control = progressDialogControl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.control.executeTask((Observer)ProgressDialog.this);
                this.result = this.control.getResult(null);
            }
            catch (Exception exception) {
                ProgressDialog.this.exception = exception;
                this.result = this.control.getResult(exception);
            }
            finally {
                TaskThread taskThread = this;
                synchronized (taskThread) {
                    this.done = true;
                    this.notifyAll();
                }
                while (!this.progressDialogThreadUnblocked) {
                    ProgressDialog.this.setVisible(false);
                    try {
                        Thread.sleep(500L);
                    }
                    catch (Exception exception) {
                        db.finest("Exception in TaskThread/run(), Thread.sleep(): " + exception);
                    }
                }
                this.control = null;
            }
        }

        boolean isDone() {
            return this.done;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void displayResults(Component component, String string) {
            this.progressDialogThreadUnblocked = true;
            TaskThread taskThread = this;
            synchronized (taskThread) {
                if (!this.done) {
                    try {
                        this.wait();
                    }
                    catch (Exception exception) {
                        db.finest("Exception in TaskThread/displayResults(): " + exception);
                    }
                }
            }
            if (!ProgressDialog.this.showResultDlg) {
                return;
            }
            if (this.result != null) {
                switch (this.result.getType()) {
                    case 0: {
                        CerentDialog.infoDialog((Component)component, (String)this.result.getMessages()[0], (String)string);
                        break;
                    }
                    case 1: {
                        if (this.result.getMessages() == null) {
                            ErrorMsg.displayWarning(component, this.result.getEmcKey());
                            break;
                        }
                        ErrorMsg.displayWarning(component, this.result.getEmcKey(), this.result.getMessages());
                        break;
                    }
                    case 2: {
                        if (this.result.getMessages() == null) {
                            ErrorMsg.displayError((Component)component, (EID)this.result.getEmcKey());
                            break;
                        }
                        ErrorMsg.displayError((Component)component, (EID)this.result.getEmcKey(), (Object[])this.result.getMessages());
                        break;
                    }
                    default: {
                        throw new IllegalStateException("The result type is unknown.");
                    }
                }
            }
        }
    }
}

