/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.gui;

import cerent.cms.ui.helper.ViewHelper;
import cerent.util.SDebug;
import cerent.util.gui.ExportTableDialog;
import cerent.util.gui.TableContentPrinter;
import cerent.util.gui.TableModelAdapter;
import cerent.util.gui.UFrame;
import cerent.util.gui.UScrollPane;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.Book;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import java.util.Date;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTable;

public class TablePrintPane
extends UFrame
implements ActionListener {
    protected JTable aTable;
    protected boolean useAdapter;
    protected TableModelAdapter theAdapter;
    private static final String APPLICATION_ICON = "/images/icons/CTC_icon.gif";
    private static final String PRINT_ICON = "/images/icons/print16.gif";
    private static final String EXPORT_ICON = "/images/icons/export16.gif";
    private static final String CLEAN_ICON = "/images/icons/Clean16.gif";
    protected static final String ACTION_PRINT = "Print...";
    protected static final String ACTION_EXPORT = "Export...";
    protected static final String ACTION_CLOSE = "Close";
    private static final SDebug db = new SDebug("TablePrintPane");
    JMenuItem printMenuItem;
    JMenuItem exportMenuItem;
    JMenuItem closeMenuItem;
    JMenuBar menuBar;

    public TablePrintPane(JTable jTable, String string) {
        super(null, string, false, APPLICATION_ICON);
        this.aTable = jTable;
        this.useAdapter = false;
        this.theAdapter = null;
        this.menuBar = this.createMenuBar();
        if (this.menuBar != null) {
            this.setJMenuBar(this.menuBar);
        }
    }

    public TablePrintPane(String string) {
        this(null, string);
    }

    public void setAdapter(TableModelAdapter tableModelAdapter) {
        this.useAdapter = tableModelAdapter != null;
        this.theAdapter = tableModelAdapter;
    }

    public TableModelAdapter getAdapter() {
        return this.theAdapter;
    }

    public void setTable(JTable jTable) {
        this.aTable = jTable;
        this.exportMenuItem.setEnabled(this.aTable != null);
    }

    public JTable getTable() {
        return this.aTable;
    }

    protected Printable getPrintableObject() {
        return this.getTableContentPrinter();
    }

    protected Printable getTableContentPrinter() {
        TableContentPrinter tableContentPrinter = null;
        if (this.aTable != null) {
            String string = this.getTitle() + ": " + new Date();
            tableContentPrinter = new TableContentPrinter(this.aTable, this.useAdapter, string, this.theAdapter);
        } else if (db.on()) {
            db.println("No table to print!");
        }
        return tableContentPrinter;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        block13: {
            String string = actionEvent.getActionCommand();
            if (string.equals(ACTION_CLOSE)) {
                this.dispose();
            } else if (string.equals(ACTION_PRINT)) {
                Printable printable = this.getPrintableObject();
                if (printable != null) {
                    PrinterJob printerJob = PrinterJob.getPrinterJob();
                    Book book = new Book();
                    if (printable instanceof TableContentPrinter) {
                        book.append(printable, printerJob.defaultPage(), ((TableContentPrinter)printable).calcPages());
                    } else {
                        book.append(printable, printerJob.defaultPage());
                    }
                    ViewHelper.instance().printBook(printerJob, book);
                } else if (db.on()) {
                    db.println("print object is null!");
                }
            } else if (string.equals(ACTION_EXPORT)) {
                ExportTableDialog exportTableDialog = new ExportTableDialog(null, "Export Table", true);
                exportTableDialog.pack();
                int n = exportTableDialog.showDialog();
                if (n == 0) {
                    int n2 = exportTableDialog.getExportTypeSelection();
                    String string2 = "Exported Data - " + this.getTitle() + " - " + new Date();
                    try {
                        ViewHelper.instance().exportTable(n2, this.useAdapter, this.theAdapter, string2, this.aTable);
                    }
                    catch (Exception exception) {
                        if (!db.on()) break block13;
                        db.println("Error in export " + exception.toString());
                    }
                }
            }
        }
    }

    protected void addBottomButtons(JPanel jPanel) {
    }

    protected void initFrameContents() {
        if (this.aTable == null) {
            return;
        }
        JPanel jPanel = new JPanel();
        this.addBottomButtons(jPanel);
        UScrollPane uScrollPane = new UScrollPane((Component)this.aTable);
        uScrollPane.setViewportView((Component)this.aTable);
        this.getContentPane().add((Component)uScrollPane, "Center");
        this.getContentPane().add((Component)jPanel, "South");
    }

    protected JMenuBar createMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        jMenu.setMnemonic(70);
        this.printMenuItem = this.addMenu(jMenu, PRINT_ICON, ACTION_PRINT, 80);
        this.exportMenuItem = this.addMenu(jMenu, EXPORT_ICON, ACTION_EXPORT, 48);
        this.closeMenuItem = this.addMenu(jMenu, CLEAN_ICON, ACTION_CLOSE, 67);
        jMenuBar.add(jMenu);
        return jMenuBar;
    }

    public JMenuBar getPaneMenuBar() {
        return this.menuBar;
    }

    protected JMenuItem addMenu(JMenu jMenu, String string, String string2, int n) {
        JMenuItem jMenuItem = new JMenuItem(string2, n);
        if (string != null) {
            jMenuItem.setIcon(new ImageIcon(this.getClass().getResource(string)));
        }
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand(string2);
        jMenu.add(jMenuItem);
        return jMenuItem;
    }

    @Override
    public void dispose() {
        this.closeMenuItem.removeActionListener(this);
        this.exportMenuItem.removeActionListener(this);
        this.printMenuItem.removeActionListener(this);
        super.dispose();
    }
}

