/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.gui.row;

import cerent.util.gui.row.AbstractColumnRenderer;
import java.awt.Color;
import java.awt.Component;
import java.util.Comparator;
import javax.swing.JTable;
import javax.swing.UIManager;

public class DefaultColumnRenderer
extends AbstractColumnRenderer {
    protected static final Color focusBackgroundColor = (Color)UIManager.get("Table.focusCellBackground");
    protected static final Color selectionBackgroundColor = (Color)UIManager.get("Table.selectionBackground");
    protected static final Color normalBackgroundColor = (Color)UIManager.get("Table.background");
    protected static final Color normalForegroundColor = (Color)UIManager.get("Table.foreground");
    private Class cl;
    protected IColumnAdapter adapter;
    private Comparator comparator;

    public DefaultColumnRenderer(String string, int n, int n2, boolean bl, Class clazz, IColumnAdapter iColumnAdapter, Comparator comparator) {
        super(string, n, bl, n2);
        DefaultColumnRenderer.checkClass(clazz);
        DefaultColumnRenderer.checkAdapter(iColumnAdapter);
        this.cl = clazz;
        this.adapter = iColumnAdapter;
        this.comparator = comparator;
    }

    private static void checkClass(Class clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("class must be non-null");
        }
    }

    public Class getColumnClass() {
        return this.cl;
    }

    private static void checkAdapter(IColumnAdapter iColumnAdapter) {
        if (iColumnAdapter == null) {
            throw new IllegalArgumentException("column adapter must be non-null");
        }
    }

    public IColumnAdapter getAdapter() {
        return this.adapter;
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        Component component = jTable.getDefaultRenderer(this.cl).getTableCellRendererComponent(jTable, this.adapter.getColumnData(object), bl, bl2, n, n2);
        return this.postProcess(component, object, bl, bl2, n, n2);
    }

    protected Component postProcess(Component component, Object object, boolean bl, boolean bl2, int n, int n2) {
        return component;
    }

    @Override
    public int compareColumn(Object object, Object object2, int n) {
        Object object3 = object == null ? null : this.adapter.getColumnData(object);
        Object object4 = object2 == null ? null : this.adapter.getColumnData(object2);
        return this.compare(object3, object4);
    }

    public int compare(Object object, Object object2) {
        int n;
        if (this.comparator == null) {
            if (object == null) {
                n = object2 == null ? 0 : 1;
            } else if (object == object2) {
                n = 0;
            } else if (object instanceof Comparable) {
                n = ((Comparable)object).compareTo(object2);
            } else if (object2 instanceof Comparable) {
                n = -((Comparable)object2).compareTo(object);
            } else {
                String string = object.toString();
                String string2 = object2.toString();
                n = this.compare(string, string2);
            }
        } else {
            n = this.comparator.compare(object, object2);
        }
        return n;
    }

    public static interface IColumnAdapter {
        public Object getColumnData(Object var1);
    }
}

