/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc.ui;

import cerent.version.NetInterfaceVersion;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.Calendar;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public class CTCVignette
extends JComponent {
    private static final String CTC_VIGNETTE = "/images/CTC_vignette.gif";
    private static final String FONT_NAME = "Sans Serif";
    private int WIDTH;
    private int HEIGHT;
    private ImageIcon vignette;
    private final String COPYRIGHT;

    public CTCVignette() {
        NetInterfaceVersion netInterfaceVersion = new NetInterfaceVersion();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(netInterfaceVersion.getBuildInformation().getDate());
        this.COPYRIGHT = "Copyright \u00a9 2000-" + calendar.get(1) + " Cisco Systems, Inc.";
        this.vignette = new ImageIcon(this.getClass().getResource(CTC_VIGNETTE));
        this.WIDTH = this.vignette.getImage().getWidth(this.vignette.getImageObserver());
        this.HEIGHT = this.vignette.getImage().getHeight(this.vignette.getImageObserver());
        this.setMinimumSize(new Dimension(this.WIDTH, this.HEIGHT));
        this.setPreferredSize(new Dimension(this.WIDTH, this.HEIGHT));
        this.setBackground(Color.white);
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.drawImage(this.vignette.getImage(), 0, 0, this);
        graphics2D.setColor(Color.black);
        Font font = new Font(FONT_NAME, 0, 12);
        int n = (int)(font.getMaxCharBounds(graphics2D.getFontRenderContext()).getHeight() / 2.0);
        graphics2D.setFont(font);
        graphics2D.drawString(this.COPYRIGHT, 5, this.HEIGHT - n);
    }
}

