/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc.ui;

import com.cisco.ctc.ui.CUESLoginAttributesPane;
import com.cisco.ctc.ui.CUESLoginWindow;
import com.cisco.ctc.ui.LoginDialog;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;

public class LoginAttributesPane
extends CUESLoginAttributesPane {
    public static final Dimension ATTR_PANE_DIM = new Dimension(320, 200);
    private static final String DIS_NW_TOOLTIP = "If checked, DCC connected nodes will not be discovered";
    private static final String DIS_CKT_TOOLTIP = "If checked, circuit operations will not be allowed\n until circuit management is enabled from CTC";
    private JComboBox addNodeCombo = null;
    private JCheckBox disableNetworkChkbox = null;
    private JCheckBox disableCircuitChkbox = null;

    public LoginAttributesPane(LoginDialog loginDialog) {
        super((CUESLoginWindow)loginDialog);
        this.initLocal();
    }

    protected void initLocal() {
        this.addNodeCombo = this.createComboBox(this.getAttributeFieldX(), 69, false);
        this.add(this.addNodeCombo);
        this.disableNetworkChkbox = this.createCheckBox("Disable Network Discovery", this.getWidth() - 310, 98, DIS_NW_TOOLTIP);
        this.add(this.disableNetworkChkbox);
        this.disableCircuitChkbox = this.createCheckBox("Disable Circuit Management", this.getWidth() - 310, 121, DIS_CKT_TOOLTIP);
        this.add(this.disableCircuitChkbox);
    }

    private JComboBox createComboBox(int n, int n2, boolean bl) {
        JComboBox jComboBox = new JComboBox();
        jComboBox.setFont(new Font("Arial", 0, 12));
        jComboBox.setSize(this.getTextFieldDimension());
        jComboBox.setLocation(n, n2);
        jComboBox.setEditable(bl);
        jComboBox.addKeyListener((KeyListener)((Object)this));
        return jComboBox;
    }

    private JCheckBox createCheckBox(String string, int n, int n2, String string2) {
        JCheckBox jCheckBox = new JCheckBox(string);
        jCheckBox.setSize(230, 22);
        jCheckBox.setLocation(n, n2);
        jCheckBox.setToolTipText(string2);
        jCheckBox.setFont(new Font("Arial", 0, 12));
        jCheckBox.setFocusPainted(false);
        jCheckBox.setForeground(Color.white);
        jCheckBox.setBackground(this.getBackground());
        return jCheckBox;
    }

    protected JButton createButton(String string, int n, int n2, boolean bl) {
        JButton jButton = new JButton(string);
        jButton.setHorizontalTextPosition(10);
        jButton.setMargin(new Insets(5, 1, 5, 2));
        jButton.setFont(new Font("Arial", 0, 12));
        jButton.setEnabled(bl);
        jButton.setSize(65, 22);
        jButton.setLocation(n, n2);
        jButton.addActionListener((ActionListener)((Object)this));
        jButton.addKeyListener((KeyListener)((Object)this));
        return jButton;
    }

    public JButton getDefaultButton() {
        return this.loginButton;
    }

    protected void processLogin() {
        super.processLogin();
        ((LoginDialog)this.parent).processLogin();
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setFont(new Font("Arial", 0, 12));
        graphics2D.setPaint(Color.white);
        graphics2D.drawString("Additional Nodes", 15, 86);
    }

    public boolean getDisableNetworkState() {
        return this.disableNetworkChkbox.isSelected();
    }

    public void setDisableNetworkState(boolean bl) {
        this.disableNetworkChkbox.setSelected(bl);
    }

    public boolean getDisableCircuitState() {
        return this.disableCircuitChkbox.isSelected();
    }

    public void setDisableCircuitState(boolean bl) {
        this.disableCircuitChkbox.setSelected(bl);
    }

    public String getAdditionalNodeGroup() {
        return (String)this.addNodeCombo.getSelectedItem();
    }

    public void setAdditionalNode(Set set, Object object) {
        String[] stringArray = set.toArray(new String[0]);
        for (int i = 0; i < stringArray.length; ++i) {
            this.addNodeCombo.addItem(stringArray[i]);
        }
        this.addNodeCombo.setSelectedItem(object);
    }

    public Dimension getPreferredSize() {
        return ATTR_PANE_DIM;
    }

    protected Dimension getTextFieldDimension() {
        return new Dimension(137, 20);
    }

    protected int getAttributeFieldX() {
        return this.getWidth() - 197;
    }

    protected Point getLoginButtonPoint() {
        return new Point(this.getWidth() - 250, this.getHeight() - 30);
    }

    protected Point getCancelButtonPoint() {
        return new Point(this.getWidth() - 170, this.getHeight() - 30);
    }
}

