/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc.ui;

import cerent.cms.ui.PrefsNodesPropertyPane;
import cerent.launcher.CtcHttpRetriever;
import cerent.util.BuildInfo;
import cerent.util.IPAddressTranslator;
import cerent.util.KDebug;
import cerent.util.Preferences;
import cerent.util.gui.CerentDialog;
import com.cisco.ctc.ui.CUESLoginWindow;
import com.cisco.ctc.ui.LoginAttributesPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Window;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.Border;

public class LoginDialog
extends CUESLoginWindow {
    public static final String PREFS_PATH = "ctc.recent";
    public static final String PREFS_NE_KEY = "nodes";
    public static final String PREFS_USER = "user";
    public static final String PREFS_GROUP = "group";
    public static final String PREFS_EXCL_DYN = "exclude_dyn";
    public static final String PREFS_CKT_MGT = "ckt_mgt";
    public static final String USER_PREF = "ctc";
    public static final String PREFS_INITIAL_WARNING = "initial.warning";
    public static final String APPLICATION_ICON = "/images/icons/CTC_icon.gif";
    public static final String PROD_NAME = "Cisco Transport Controller";
    public static final String NO_GROUP = "(None)";
    public static boolean warningAlreadyDisplayed;
    private String nodeName = null;
    private CUESLoginWindow.CUESLoginWindowContainer windowContainer = null;
    private static Preferences prefs;
    private static KDebug db;

    public LoginDialog(Object object, String string, String string2) {
        super(object, string, APPLICATION_ICON, PROD_NAME, BuildInfo.getShortVersionString(), string2);
        this.nodeName = string;
        this.initLocal();
    }

    protected void initAttributePane() {
        this.attributesPane = new LoginAttributesPane(this);
        this.add((Component)this.attributesPane);
    }

    protected void initLocal() {
        db.fine("<LoginDialog> reading NEs from preferences");
        Set set = PrefsNodesPropertyPane.getGroupNames();
        set.add(NO_GROUP);
        String string = prefs.getProperty(PREFS_PATH, PREFS_GROUP, null);
        if (string == null) {
            string = set.contains("Topology Hosts") ? "Topology Hosts" : NO_GROUP;
        }
        ((LoginAttributesPane)this.attributesPane).setAdditionalNode(set, string);
        boolean bl = prefs.getBoolean(PREFS_PATH, PREFS_EXCL_DYN, false);
        ((LoginAttributesPane)this.attributesPane).setDisableNetworkState(bl);
        bl = prefs.getBoolean(PREFS_PATH, PREFS_CKT_MGT, false);
        ((LoginAttributesPane)this.attributesPane).setDisableCircuitState(bl);
    }

    protected JComponent createCopyrightContainer(String string) {
        String string2 = this.getCopyRightText(string);
        JLabel jLabel = new JLabel(string2);
        jLabel.setFont(new Font("Arial", 0, 10));
        jLabel.setForeground(LIGHT_GREY_COLOR);
        jLabel.setBackground(Color.white);
        jLabel.setBorder(BorderFactory.createEmptyBorder(5, 2, 5, 5));
        return jLabel;
    }

    public void processLogin() {
        db.info("<LoginDialog> processLogin:BEGIN");
        this.setLoginStatus(true);
        this.savePreferences();
        this.dispose();
        db.info("<LoginDialog> processLogin:END");
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public String[] getNodes() {
        String string = ((LoginAttributesPane)this.attributesPane).getAdditionalNodeGroup();
        return PrefsNodesPropertyPane.getGroupMembers(string);
    }

    public String getAdditionalNodeGroup() {
        return ((LoginAttributesPane)this.attributesPane).getAdditionalNodeGroup();
    }

    public boolean getDisableNetworkState() {
        return ((LoginAttributesPane)this.attributesPane).getDisableNetworkState();
    }

    public boolean getDisableCircuitState() {
        return ((LoginAttributesPane)this.attributesPane).getDisableCircuitState();
    }

    protected Border createDefaultBorder() {
        return null;
    }

    public Dimension getPreferredSize() {
        WINDOW_DIM.setSize(625, 395);
        return WINDOW_DIM;
    }

    public Dimension getProductNameDimension() {
        PROD_NAME_DIM.setSize(195, LoginAttributesPane.ATTR_PANE_DIM.height);
        return PROD_NAME_DIM;
    }

    public Dimension getPhotoDimension() {
        PHOTO_AREA_DIM.setSize(150, LoginAttributesPane.ATTR_PANE_DIM.height);
        return PHOTO_AREA_DIM;
    }

    private void savePreferences() {
        prefs.setProperty(PREFS_PATH, PREFS_GROUP, this.getAdditionalNodeGroup());
        prefs.setBoolean(PREFS_PATH, PREFS_EXCL_DYN, this.getDisableNetworkState());
        prefs.setBoolean(PREFS_PATH, PREFS_CKT_MGT, this.getDisableCircuitState());
    }

    protected String getCopyRightText(String string) {
        String string2 = this.copyrightYear + "<BR>" + "Cisco, Cisco Systems and Cisco Systems logo are registered trademarks of<BR>" + "Cisco Systems, Inc. and/or its affiliates in the U.S and certain other countries.<P>";
        return "<html>" + string2 + "</html>";
    }

    protected String getLegalDisclaimer(String string) {
        String string2 = "";
        try {
            String string3;
            try {
                InetAddress inetAddress = IPAddressTranslator.instance().findVirtualAddress(InetAddress.getByName(string));
                string3 = inetAddress.getHostAddress();
            }
            catch (UnknownHostException unknownHostException) {
                string3 = string;
            }
            string2 = CtcHttpRetriever.getLegalDisclaimer((String)string3);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            db.info("<LoginDialog> No Legal Disclaimer Method");
        }
        catch (Exception exception) {
            db.info("<LoginDialog> " + exception.toString());
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispose() {
        Object object = this.owner;
        synchronized (object) {
            this.owner.notifyAll();
        }
        this.windowContainer.dispose();
    }

    public void showWindow() {
        Object object;
        boolean bl = prefs.getBoolean(USER_PREF, PREFS_INITIAL_WARNING, true);
        this.windowContainer = new CUESLoginWindow.CUESLoginWindowContainer((CUESLoginWindow)this, "Login - " + this.nodeName, APPLICATION_ICON);
        this.windowContainer.add((Component)((Object)this));
        this.windowContainer.setSize(this.getPreferredSize());
        this.setCenter((Window)this.windowContainer);
        if (bl && !warningAlreadyDisplayed && ((String)(object = this.getLegalDisclaimer(this.nodeName))).length() > 0) {
            boolean bl2 = CerentDialog.warningDialog((Component)((Object)this), (JLabel)new JLabel("<html>" + (String)object + "</html>"), (String)"Attention!", (boolean)true);
            warningAlreadyDisplayed = true;
            if (!bl2) {
                this.dispose();
                System.exit(0);
            }
        }
        this.windowContainer.setVisible(true);
        object = ((LoginAttributesPane)this.attributesPane).getDefaultButton();
        this.windowContainer.getRootPane().setDefaultButton((JButton)object);
    }

    static {
        prefs = Preferences.instance();
        db = new KDebug("LoginDialog");
    }
}

