/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc.ui.sot;

import cerent.util.ComparisonUtil;
import cerent.util.gui.row.AbstractColumnRenderer;
import cerent.util.gui.row.ColumnRenderer;
import com.cisco.ctc.ui.sot.SoTl1DataSource;
import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTable;

public class SoTl1ColumnRenderer
extends AbstractColumnRenderer {
    private static final int PNETID = 0;
    private static final int GNEHOST = 1;
    private static final int TL1ENC = 3;
    private static final int TL1PORT = 2;
    private static final int GNETID = 4;
    private static final int STATE = 5;
    private static final int PNEIP = 6;
    private static final int SOCKETS = 7;
    private static final int RETRIES = 8;
    private static final int RX = 9;
    private static final int TX = 10;
    private static final int NB_COLS = 11;
    private static final Color SEL_BG = new Color(205, 205, 255);
    private JLabel label = new JLabel();

    public SoTl1ColumnRenderer(String string, int n, boolean bl, int n2) {
        super(string, n, bl, n2);
        this.label.setHorizontalAlignment(n2);
        this.label.setVerticalAlignment(1);
        this.label.setOpaque(true);
        this.label.setForeground(Color.black);
        this.label.setFont(this.label.getFont().deriveFont(0));
        this.label.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        String string = "";
        String string2 = null;
        SoTl1DataSource.TunnelEntry tunnelEntry = (SoTl1DataSource.TunnelEntry)object;
        Color color = jTable.getForeground();
        Color color2 = bl ? SEL_BG : Color.white;
        switch (n2) {
            case 1: {
                string = tunnelEntry.getGneHost();
                break;
            }
            case 0: {
                string = tunnelEntry.getPneTid();
                break;
            }
            case 4: {
                if (tunnelEntry.getGneTid() == null) break;
                string = tunnelEntry.getGneTid();
                break;
            }
            case 3: {
                string = tunnelEntry.getEncoding();
                break;
            }
            case 2: {
                string = Integer.toString(tunnelEntry.getGnePort());
                break;
            }
            case 5: {
                string = tunnelEntry.getState();
                break;
            }
            case 6: {
                string = tunnelEntry.getPneIp();
                break;
            }
            case 7: {
                int n3 = tunnelEntry.getSockets();
                if (n3 <= 0) break;
                string = Integer.toString(n3);
                break;
            }
            case 9: {
                long l = tunnelEntry.getRx();
                if (l <= 0L) break;
                string = Long.toString(l);
                break;
            }
            case 10: {
                long l = tunnelEntry.getTx();
                if (l <= 0L) break;
                string = Long.toString(l);
                break;
            }
            case 8: {
                int n4 = tunnelEntry.getRetries();
                if (n4 <= 0) break;
                string = Integer.toString(n4);
            }
        }
        this.label.setText(string);
        this.label.setToolTipText(string2);
        this.label.setForeground(color);
        this.label.setBackground(color2);
        return this.label;
    }

    @Override
    public int compareColumn(Object object, Object object2, int n) {
        int n2 = 0;
        SoTl1DataSource.TunnelEntry tunnelEntry = (SoTl1DataSource.TunnelEntry)object;
        SoTl1DataSource.TunnelEntry tunnelEntry2 = (SoTl1DataSource.TunnelEntry)object2;
        switch (n) {
            case 1: {
                n2 = tunnelEntry.getGneHost().compareTo(tunnelEntry2.getGneHost());
                break;
            }
            case 0: {
                n2 = tunnelEntry.getPneTid().compareTo(tunnelEntry2.getPneTid());
                break;
            }
            case 6: {
                n2 = tunnelEntry.getPneIp().compareTo(tunnelEntry2.getPneIp());
                break;
            }
            case 4: {
                String string = tunnelEntry.getGneTid();
                String string2 = tunnelEntry2.getGneTid();
                if (string == null) {
                    string = "";
                }
                if (string2 == null) {
                    string2 = "";
                }
                n2 = tunnelEntry.getGneTid().compareTo(tunnelEntry2.getGneTid());
                break;
            }
            case 3: {
                n2 = tunnelEntry.getEncoding().compareTo(tunnelEntry2.getEncoding());
                break;
            }
            case 2: {
                n2 = ComparisonUtil.compare((int)tunnelEntry.getGnePort(), (int)tunnelEntry2.getGnePort());
                break;
            }
            case 5: {
                n2 = tunnelEntry.getState().compareTo(tunnelEntry2.getState());
                break;
            }
            case 7: {
                n2 = ComparisonUtil.compare((int)tunnelEntry.getSockets(), (int)tunnelEntry2.getSockets());
                break;
            }
            case 9: {
                n2 = ComparisonUtil.compare((long)tunnelEntry.getRx(), (long)tunnelEntry2.getRx());
                break;
            }
            case 10: {
                n2 = ComparisonUtil.compare((long)tunnelEntry.getTx(), (long)tunnelEntry2.getTx());
                break;
            }
            case 8: {
                n2 = ComparisonUtil.compare((int)tunnelEntry.getRetries(), (int)tunnelEntry2.getRetries());
            }
        }
        return n2;
    }

    static ColumnRenderer[] createTableRenderers() {
        ColumnRenderer[] columnRendererArray = new ColumnRenderer[11];
        for (int i = 0; i < columnRendererArray.length; ++i) {
            columnRendererArray[i] = SoTl1ColumnRenderer.createColumnRenderer(i);
        }
        return columnRendererArray;
    }

    public static ColumnRenderer createColumnRenderer(int n) {
        int n2;
        String string;
        boolean bl = true;
        int n3 = 2;
        switch (n) {
            case 1: {
                string = "GNE Host";
                n2 = 80;
                break;
            }
            case 0: {
                string = "Far End TID";
                n2 = 110;
                break;
            }
            case 4: {
                string = "GNE TID";
                n2 = 110;
                break;
            }
            case 5: {
                string = "State";
                n2 = 90;
                n3 = 0;
                break;
            }
            case 6: {
                string = "Far End IP";
                n2 = 90;
                n3 = 0;
                break;
            }
            case 3: {
                string = "TL1 Encoding";
                n2 = 90;
                break;
            }
            case 2: {
                string = "Port";
                n2 = 60;
                bl = false;
                n3 = 0;
                break;
            }
            case 7: {
                string = "Sockets";
                n2 = 60;
                bl = false;
                n3 = 0;
                break;
            }
            case 9: {
                string = "Rx Bytes";
                n2 = 70;
                bl = false;
                n3 = 4;
                break;
            }
            case 10: {
                string = "Tx Bytes";
                n2 = 70;
                bl = false;
                n3 = 4;
                break;
            }
            default: {
                string = "Retries";
                n2 = 50;
                bl = false;
                n3 = 0;
            }
        }
        return new SoTl1ColumnRenderer(string, n2, bl, n3);
    }
}

