/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc.ui.sot;

import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.NEMC;
import com.cisco.sot.Tl1Tunnel;
import com.cisco.sot.Tl1TunnelAddr;
import com.cisco.sot.Tl1TunnelAddrBook;
import com.cisco.sot.Tl1TunnelDialog;
import com.cisco.sot.Tl1TunnelFactory;
import com.cisco.sot.Tl1TunnelUidPid;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import javax.swing.text.MaskFormatter;

public class SoTl1Dialog
extends JDialog
implements DocumentListener,
ActionListener {
    private JTextField tfGneHostName;
    private JTextField tfPneTid;
    private JComboBox cbTl1Encoding;
    private JCheckBox cbGneLogin;
    private JFormattedTextField tfTl1Port;
    private JRadioButton rbTl1DefaultPort;
    private JRadioButton rbTl1OtherPort;
    private JTextField tfGneTid;
    private JButton bOk = new JButton("OK");
    private JButton bCancel = new JButton("Cancel");
    private JTextArea taLog;
    private JScrollPane spLog;
    private Tl1TunnelAddrBook addrBook = Tl1TunnelAddrBook.instance();
    private Rectangle visible = new Rectangle(1, 1);
    private boolean connect;
    private Tl1TunnelAddr inputTunnelAddr;
    private Tl1Tunnel tunnel;
    private Tl1TunnelAddr tunnelAddr;

    public SoTl1Dialog(JFrame jFrame) {
        super((Frame)jFrame, true);
    }

    public Tl1Tunnel getTl1Tunnel(Tl1TunnelAddr tl1TunnelAddr) {
        this.connect = true;
        if (tl1TunnelAddr != null) {
            this.inputTunnelAddr = tl1TunnelAddr;
            new Thread((Runnable)new TunnelCreator(this.inputTunnelAddr), "TL1 Tunnel Opener").start();
            this.display("Open TL1 Tunnel");
        }
        return this.tunnel;
    }

    public Tl1TunnelAddr getTl1TunnelAddr(Tl1TunnelAddr tl1TunnelAddr) {
        this.connect = false;
        this.inputTunnelAddr = tl1TunnelAddr;
        this.display(tl1TunnelAddr == null ? "Create TL1 Tunnel" : "Edit TL1 Tunnel");
        return this.tunnelAddr;
    }

    private void watchDocument(Component component) {
        if (component instanceof JTextComponent) {
            JTextComponent jTextComponent = (JTextComponent)component;
            jTextComponent.getDocument().addDocumentListener(this);
        }
    }

    private void addRow(JPanel jPanel, String string, JComponent jComponent, JComponent jComponent2, GridBagConstraints gridBagConstraints) {
        Tl1TunnelDialog.addRow((JPanel)jPanel, (String)string, (JComponent)jComponent, (JComponent)jComponent2, (GridBagConstraints)gridBagConstraints);
    }

    private void display(String string) {
        this.setTitle(string);
        this.setDefaultCloseOperation(2);
        this.getRootPane().setDefaultButton(this.bOk);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.setBackground(Color.white);
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new GridLayout(0, 2, 5, 5));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.tfPneTid = new JTextField();
        JLabel jLabel = new JLabel("Far End TID:");
        jPanel2.add(jLabel);
        jPanel2.add(this.tfPneTid);
        jPanel.add((Component)jPanel2, "North");
        jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBorder(BorderFactory.createTitledBorder("Gateway NE"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = new Insets(6, 5, 6, 5);
        Insets insets2 = new Insets(0, 5, 6, 5);
        Insets insets3 = new Insets(6, 5, 0, 5);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = insets;
        this.tfGneHostName = new JTextField();
        this.addRow(jPanel2, "Host Name/IP Address:", null, this.tfGneHostName, gridBagConstraints);
        this.rbTl1DefaultPort = new JRadioButton("Use Default TL1 Port");
        gridBagConstraints.insets = insets3;
        this.addRow(jPanel2, null, this.rbTl1DefaultPort, null, gridBagConstraints);
        this.rbTl1OtherPort = new JRadioButton("Use Other TL1 Port:");
        MaskFormatter maskFormatter = new MaskFormatter();
        try {
            maskFormatter.setMask("#####");
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        this.tfTl1Port = new JFormattedTextField(maskFormatter);
        this.tfTl1Port.setFocusLostBehavior(3);
        gridBagConstraints.insets = insets2;
        this.addRow(jPanel2, null, this.rbTl1OtherPort, this.tfTl1Port, gridBagConstraints);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.rbTl1DefaultPort);
        buttonGroup.add(this.rbTl1OtherPort);
        this.rbTl1DefaultPort.addActionListener(this);
        this.rbTl1OtherPort.addActionListener(this);
        this.cbTl1Encoding = new JComboBox<String>(Tl1TunnelDialog.TL1_ENCODINGS);
        gridBagConstraints.insets = insets;
        this.addRow(jPanel2, "TL1 Encoding Mode:", null, this.cbTl1Encoding, gridBagConstraints);
        this.cbTl1Encoding.addActionListener(this);
        this.cbGneLogin = new JCheckBox("GNE Login Required", false);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = insets3;
        jPanel2.add((Component)this.cbGneLogin, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 1;
        this.tfGneTid = new JTextField();
        gridBagConstraints.insets = insets2;
        JLabel jLabel2 = new JLabel("TID:");
        jLabel2.setHorizontalAlignment(4);
        this.addRow(jPanel2, "    ", jLabel2, this.tfGneTid, gridBagConstraints);
        jPanel.add(jPanel2);
        if (!this.connect && this.inputTunnelAddr == null) {
            this.tfGneHostName.setEditable(true);
            this.tfGneHostName.addActionListener(this);
            this.tfPneTid.setEditable(true);
            this.tfPneTid.addActionListener(this);
        } else {
            this.tfGneHostName.setEditable(false);
            this.tfPneTid.setEditable(false);
        }
        Box box = Box.createHorizontalBox();
        this.getRootPane().setDefaultButton(this.bOk);
        box.add(Box.createHorizontalGlue());
        if (!this.connect) {
            box.add(this.bOk);
            this.bOk.addActionListener(this);
            box.add(Box.createHorizontalStrut(20));
        }
        box.add(this.bCancel);
        this.bCancel.addActionListener(this);
        box.add(Box.createHorizontalGlue());
        box.setBorder(BorderFactory.createEmptyBorder(10, 5, 5, 5));
        ++gridBagConstraints.gridy;
        jPanel.add((Component)box, "South");
        if (!this.connect) {
            this.watchDocument(this.tfGneHostName);
            this.watchDocument(this.tfPneTid);
            this.watchDocument(this.tfGneTid);
            this.cbGneLogin.addActionListener(this);
            this.watchDocument(this.tfTl1Port);
        } else {
            this.cbGneLogin.setEnabled(false);
            this.tfTl1Port.setEditable(false);
            this.cbTl1Encoding.setEnabled(false);
            this.tfGneTid.setEditable(false);
        }
        if (this.connect) {
            container.add((Component)jPanel, "North");
            this.taLog = new JTextArea(6, 50);
            this.spLog = new JScrollPane(this.taLog);
            this.spLog.setVerticalScrollBarPolicy(20);
            this.spLog.setBorder(BorderFactory.createTitledBorder("TL1 Log"));
            this.taLog.setBorder(BorderFactory.createBevelBorder(1));
            this.taLog.setMinimumSize(new Dimension(400, 160));
            this.taLog.setOpaque(true);
            this.taLog.setEditable(false);
            this.taLog.setBackground(new Color(230, 230, 230));
            container.add(this.spLog);
        } else {
            container.add(jPanel);
        }
        container.setBackground(jPanel2.getBackground());
        this.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        int n = (dimension.width - dimension2.width) / 2;
        int n2 = (dimension.height - dimension2.height) / 2;
        this.setLocation(n, n2);
        if (this.inputTunnelAddr != null) {
            this.tfGneHostName.setText(this.inputTunnelAddr.host);
            this.tfPneTid.setText(this.inputTunnelAddr.pneTid);
            this.cbTl1Encoding.setSelectedIndex(Tl1TunnelDialog.getCbTl1Encoding((int)this.inputTunnelAddr.encoding));
            this.cbGneLogin.setSelected(this.inputTunnelAddr.gneTid != null);
            if (this.inputTunnelAddr.gneTid != null) {
                this.tfGneTid.setText(this.inputTunnelAddr.gneTid);
            }
            if (this.inputTunnelAddr.isDefaultPort()) {
                this.rbTl1DefaultPort.setSelected(true);
                this.rbTl1OtherPort.setSelected(false);
            } else {
                this.rbTl1DefaultPort.setSelected(false);
                this.rbTl1OtherPort.setSelected(true);
                this.tfTl1Port.setText(Integer.toString(this.inputTunnelAddr.gneTl1Port));
            }
        } else {
            this.cbTl1Encoding.setSelectedIndex(0);
            this.rbTl1DefaultPort.setSelected(true);
            this.rbTl1OtherPort.setSelected(false);
        }
        this.syncPort();
        if (!this.connect) {
            this.tfPneTid.requestFocus();
        }
        this.syncButton();
        this.show();
    }

    private void appendText(String string) {
        if (this.taLog != null) {
            final String string2 = string;
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    SoTl1Dialog.this.taLog.append(string2);
                    SoTl1Dialog.this.visible.setLocation(0, SoTl1Dialog.this.taLog.getHeight() - 1);
                    SoTl1Dialog.this.taLog.scrollRectToVisible(SoTl1Dialog.this.visible);
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.isVisible()) {
            Object object = actionEvent.getSource();
            if (object == this.bOk) {
                int n;
                try {
                    n = Integer.parseInt(this.tfTl1Port.getText().trim());
                }
                catch (NumberFormatException numberFormatException) {
                    n = 0;
                }
                String string = this.tfGneHostName.getText();
                String string2 = null;
                if (this.cbGneLogin.isSelected()) {
                    string2 = this.tfGneTid.getText().trim();
                }
                try {
                    int n2 = Tl1TunnelDialog.getTl1Encoding((int)this.cbTl1Encoding.getSelectedIndex());
                    this.tunnelAddr = new Tl1TunnelAddr(string, this.tfPneTid.getText(), n2, string2, n, null, null);
                    this.dispose();
                }
                catch (UnknownHostException unknownHostException) {
                    this.appendText("The GNE hostname " + string + " is invalid.\n");
                    ErrorMsg.displayError((Component)this, (EID)NEMC.EID_INV_GNE_HOST_PARAM_1, (Object)string);
                }
            } else if (object == this.bCancel) {
                this.dispose();
            } else if (object == this.cbTl1Encoding || object == this.rbTl1OtherPort || object == this.rbTl1DefaultPort || object == this.cbGneLogin) {
                this.syncPort();
            }
        }
    }

    private void syncPort() {
        if (this.rbTl1DefaultPort.isSelected()) {
            int n = Tl1TunnelDialog.getTl1Port((int)this.cbTl1Encoding.getSelectedIndex());
            this.tfTl1Port.setText(Integer.toString(n));
            this.tfTl1Port.setEditable(false);
            this.tfTl1Port.setEnabled(false);
        } else {
            this.tfTl1Port.setEditable(true);
            this.tfTl1Port.setEnabled(true);
        }
        this.tfGneTid.setEnabled(this.cbGneLogin.isSelected() && !this.connect);
        this.tfGneTid.setEditable(this.tfGneTid.isEnabled());
    }

    private void syncButton() {
        if (!this.connect) {
            boolean bl;
            String string = this.tfGneHostName.getText();
            boolean bl2 = bl = string.trim().length() > 0;
            if (bl) {
                string = this.tfPneTid.getText();
                boolean bl3 = bl = string.trim().length() > 0;
                if (bl) {
                    string = this.tfTl1Port.getText().trim();
                    boolean bl4 = bl = string.length() > 0;
                }
            }
            if (bl && this.cbGneLogin.isSelected()) {
                string = this.tfGneTid.getText().trim();
                bl = string.length() > 0;
            }
            this.bOk.setEnabled(bl);
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.syncButton();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.syncButton();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.syncButton();
    }

    private class TunnelCreator
    implements Runnable,
    Observer {
        private Tl1TunnelAddr addr;

        TunnelCreator(Tl1TunnelAddr tl1TunnelAddr) {
            this.addr = tl1TunnelAddr;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            SoTl1Dialog.this.appendText("Opening Tunnel " + this.addr.host + "/" + this.addr.pneTid + "...\n");
            SoTl1Dialog.this.tunnel = null;
            Throwable throwable = null;
            try {
                if (this.addr.gneTid != null) {
                    Tl1TunnelUidPid tl1TunnelUidPid = new Tl1TunnelUidPid((JDialog)SoTl1Dialog.this, "Login to Gateway NE " + this.addr.gneTid, "Enter the GNE TL1 user name and password");
                    tl1TunnelUidPid.show();
                    this.addr.gneUsername = tl1TunnelUidPid.getUid();
                    this.addr.gnePassword = tl1TunnelUidPid.getPid();
                    if (this.addr.gneUsername == null) {
                        return;
                    }
                }
                SoTl1Dialog.this.tunnel = Tl1TunnelFactory.instance().createTl1Tunnel(this.addr, 20000, (Observer)this);
                SoTl1Dialog.this.appendText("Connection succeeded\n");
                SoTl1Dialog.this.addrBook.setMruTunnel(this.addr);
            }
            catch (Exception exception) {
                SoTl1Dialog.this.appendText("Connection failed:" + exception.getMessage() + "\n\n");
                throwable = exception;
            }
            finally {
                if (throwable != null) {
                    ErrorMsg.displayError((Component)SoTl1Dialog.this, (EID)NEMC.EID_OPEN_TL1TUNNEL_FAILED_PARAM_1, (Object)throwable.getMessage());
                }
                SoTl1Dialog.this.dispose();
            }
        }

        @Override
        public void update(Observable observable, Object object) {
            if (object instanceof String) {
                SoTl1Dialog.this.appendText((String)object + "\n");
            }
        }
    }
}

