/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc.util.map;

import com.cisco.ctc.util.map.DetailedMapNode;
import com.cisco.ctc.util.map.MapPolygon;
import com.cisco.ctc.util.map.MapPort;
import ilog.views.IlvGraphic;

public abstract class AbstractInternalPG {
    protected DetailedMapNode parentNode = null;
    protected MapPort[] ports = new MapPort[0];
    protected MapPort[] internalPorts = new MapPort[0];
    protected MapPolygon shapeObject;
    protected int side;
    private Object userObject = null;
    private Object userCookie = null;

    public AbstractInternalPG(DetailedMapNode detailedMapNode) {
        this.parentNode = detailedMapNode;
        this.shapeObject = this.getShapeObject();
        if (this.shapeObject != null) {
            this.getParentNode().addComponent((IlvGraphic)this.shapeObject, 6);
            this.shapeObject.setSelectable(false);
            this.shapeObject.setMovable(false);
        }
        this.graphicallyInit();
    }

    protected abstract MapPolygon getShapeObject();

    protected abstract MapPort[] getInternalPorts();

    protected abstract void graphicallyInit();

    public abstract void updatePositionInNode();

    protected void addInternalPort(MapPort mapPort) {
        this.getParentNode().addComponent((IlvGraphic)mapPort, 7);
        this.getParentNode().getGraph().setSelectable((IlvGraphic)mapPort, false);
    }

    protected DetailedMapNode getParentNode() {
        return this.parentNode;
    }

    public void init(Object object, Object object2) throws Exception {
        this.setUserObject(object);
        this.setUserCookie(object2);
    }

    public void setUserObject(Object object) {
        this.userObject = object;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public void setUserCookie(Object object) {
        this.userCookie = object;
    }

    public Object getUserCookie() {
        return this.userCookie;
    }

    public int getSide() {
        return this.side;
    }

    public void setSide(int n) {
        this.side = n;
    }

    public MapPort[] getPorts() {
        return this.ports;
    }

    public void setPorts(MapPort[] mapPortArray) {
        this.ports = mapPortArray;
        this.internalPorts = this.getInternalPorts();
        for (int i = 0; i < this.internalPorts.length; ++i) {
            MapPort mapPort = this.internalPorts[i];
            this.addInternalPort(mapPort);
        }
    }

    public void destroy() {
        int n;
        if (this.ports != null) {
            for (n = 0; n < this.ports.length; ++n) {
                if (this.ports[n] == null) continue;
                this.ports[n].destroy();
            }
        }
        if (this.internalPorts != null) {
            for (n = 0; n < this.internalPorts.length; ++n) {
                if (this.internalPorts[n] == null) continue;
                this.internalPorts[n].destroy();
            }
        }
    }
}

