/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc.util.map;

import com.cisco.ctc.util.map.AbstractGraph;
import com.cisco.ctc.util.map.AbstractNode;
import com.cisco.ctc.util.map.LinkBundle;
import com.cisco.ctc.util.map.MapImageIcon;
import com.cisco.ctc.util.map.MapLabel;
import com.cisco.ctc.util.map.MapLinkConnector;
import com.cisco.ctc.util.map.MapObjectAdapter;
import com.cisco.ctc.util.map.MapToolkit;
import com.cisco.ctc.util.map.MapTransformer;
import ilog.views.IlvGraphic;
import ilog.views.IlvLinkImage;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.event.ManagerContentChangedEvent;
import ilog.views.event.ManagerContentChangedListener;
import ilog.views.event.ObjectBBoxChangedEvent;
import ilog.views.event.ObjectRemovedEvent;
import ilog.views.graphic.composite.IlvCompositeGraphic;
import ilog.views.graphic.composite.IlvCompositeLink;
import ilog.views.graphic.composite.layout.IlvAttachmentConstraint;
import ilog.views.graphic.composite.layout.IlvAttachmentLocation;
import ilog.views.graphic.composite.layout.IlvLayoutManager;
import ilog.views.graphic.composite.layout.IlvLinkAttachmentLocation;
import ilog.views.graphic.composite.layout.IlvStackerLayout;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.TreeMap;

public abstract class AbstractLink
extends IlvCompositeLink
implements ManagerContentChangedListener {
    protected MapToolkit mtk;
    protected AbstractNode src;
    protected AbstractNode dst;
    private String bundleKey;
    private MapLabel centerLabel = null;
    private String fromLabel = null;
    private String toLabel = null;
    protected MapImageIcon linkIcon = null;
    private TreeMap srcIcons = new TreeMap();
    private TreeMap dstIcons = new TreeMap();
    private TreeMap annotations = new TreeMap();
    private MapLinkConnector sourceConnector = null;
    private MapLinkConnector targetConnector = null;
    private boolean srcArrowEnabled = false;
    private boolean dstArrowEnabled = false;
    private String linkClass = null;
    private static Font annotationFont;
    private boolean registered = false;
    private Color linkColor = Color.green;

    public AbstractLink(MapToolkit mapToolkit, AbstractNode abstractNode, AbstractNode abstractNode2, String string) {
        super((IlvGraphic)abstractNode, (IlvGraphic)abstractNode2, false);
        this.mtk = mapToolkit;
        this.src = abstractNode;
        this.dst = abstractNode2;
        this.linkClass = string == null ? "Miscellaneous" : string;
        this.setBundleKey();
        this.initDefaults();
    }

    private void setBundleKey() {
        this.bundleKey = this.src.getID() + "-" + this.dst.getID();
        LinkBundle linkBundle = this.mtk.getLinkBundle(this.bundleKey);
        if (linkBundle == null) {
            this.bundleKey = this.dst.getID() + "-" + this.src.getID();
        }
    }

    void initDefaults() {
        annotationFont = new Font("Arial", 0, 12);
        this.setLineThickness(1);
        this.setLineColor(this.linkColor);
        Image image = this.getLinkIcon(this.linkClass);
        if (image != null) {
            this.linkIcon = new MapImageIcon(image);
            this.placeIcons();
            this.initOrientedIcon();
        }
    }

    public final String getLinkClass() {
        return this.linkClass;
    }

    protected Image getLinkIcon(String string) {
        return null;
    }

    public AbstractGraph getGraph() {
        if (super.getGraphicBag() instanceof AbstractGraph) {
            return (AbstractGraph)super.getGraphicBag();
        }
        return null;
    }

    public void setLineColor(Color color) {
        super.setForeground(color);
        this.linkColor = color;
        this.reDraw();
    }

    void setSelectedColor(Color color) {
        super.setForeground(color);
        this.reDraw();
    }

    public Color getLineColor() {
        return this.linkColor;
    }

    public void setLineThickness(int n) {
        super.setLineWidth((float)n);
    }

    public float getLineThickness(MapTransformer mapTransformer) {
        return super.getLineWidth(mapTransformer.getTransform());
    }

    public double getLocX() {
        return MapObjectAdapter.getLocX((IlvGraphic)this);
    }

    public double getLocY() {
        return MapObjectAdapter.getLocY((IlvGraphic)this);
    }

    public double getCenterX() {
        return MapObjectAdapter.getCenterX((IlvGraphic)this);
    }

    public double getCenterY() {
        return MapObjectAdapter.getCenterY((IlvGraphic)this);
    }

    public double getWidth() {
        return MapObjectAdapter.getWidth((IlvGraphic)this);
    }

    public double getHeight() {
        return MapObjectAdapter.getHeight((IlvGraphic)this);
    }

    public void addSrcDecorativeIcon(String string, MapImageIcon mapImageIcon) {
        this.addDecorativeIcon(string, mapImageIcon, this.srcIcons);
    }

    public void addTargetDecorativeIcon(String string, MapImageIcon mapImageIcon) {
        this.addDecorativeIcon(string, mapImageIcon, this.dstIcons);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDecorativeIcon(String string, MapImageIcon mapImageIcon, TreeMap treeMap) {
        if (string != null && mapImageIcon != null) {
            TreeMap treeMap2 = treeMap;
            synchronized (treeMap2) {
                treeMap.put(string, mapImageIcon);
            }
            this.placeIcons();
            this.refreshContainersUI();
        }
    }

    public void removeSrcDecorativeIcon(String string) {
        this.removeDecorativeIcon(string, this.srcIcons);
    }

    public void removeTargetDecorativeIcon(String string) {
        this.removeDecorativeIcon(string, this.dstIcons);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDecorativeIcon(String string, TreeMap treeMap) {
        TreeMap treeMap2 = treeMap;
        synchronized (treeMap2) {
            if (treeMap.containsKey(string)) {
                treeMap.remove(string);
                this.placeIcons();
                this.refreshContainersUI();
            }
        }
    }

    public TreeMap getSrcDecorativeIcons() {
        return this.getDecorativeIcons(this.srcIcons);
    }

    public TreeMap getDstDecorativeIcons() {
        return this.getDecorativeIcons(this.dstIcons);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TreeMap getDecorativeIcons(TreeMap treeMap) {
        TreeMap treeMap2 = new TreeMap();
        TreeMap treeMap3 = treeMap;
        synchronized (treeMap3) {
            treeMap2.putAll(treeMap);
        }
        return treeMap2;
    }

    public void removeAllSrcDecorativeIcons() {
        this.removeAllDecorativeIcons(this.srcIcons);
    }

    public void removeAllDstDecorativeIcons() {
        this.removeAllDecorativeIcons(this.dstIcons);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllDecorativeIcons() {
        TreeMap treeMap = this.srcIcons;
        synchronized (treeMap) {
            this.srcIcons = new TreeMap();
        }
        treeMap = this.dstIcons;
        synchronized (treeMap) {
            this.dstIcons = new TreeMap();
        }
        this.placeIcons();
        this.refreshContainersUI();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAllDecorativeIcons(TreeMap treeMap) {
        TreeMap treeMap2 = treeMap;
        synchronized (treeMap2) {
            treeMap = new TreeMap();
        }
        this.placeIcons();
        this.refreshContainersUI();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAnnotation(String string, String string2) {
        if (string != null && string2 != null) {
            TreeMap treeMap = this.annotations;
            synchronized (treeMap) {
                this.annotations.put(string, string2);
            }
            this.placeIcons();
        }
    }

    public void setAnnotationFont(Font font) {
        if (font != null) {
            annotationFont = font;
        }
    }

    public static Font getAnnotationFont() {
        return annotationFont;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAnnotation(String string) {
        TreeMap treeMap = this.annotations;
        synchronized (treeMap) {
            if (this.annotations.containsKey(string)) {
                this.annotations.remove(string);
                this.placeIcons();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllAnnotations() {
        TreeMap treeMap = this.annotations;
        synchronized (treeMap) {
            this.annotations = new TreeMap();
        }
        this.placeIcons();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TreeMap getAnnotations() {
        TreeMap treeMap = new TreeMap();
        TreeMap treeMap2 = this.annotations;
        synchronized (treeMap2) {
            treeMap.putAll(this.annotations);
        }
        return treeMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAnnotationText() {
        StringBuffer stringBuffer = new StringBuffer();
        TreeMap treeMap = this.annotations;
        synchronized (treeMap) {
            String[] stringArray = this.annotations.values().toArray(new String[0]);
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuffer.append(stringArray[i]);
                if (i == stringArray.length - 1) continue;
                stringBuffer.append(", ");
            }
        }
        if (stringBuffer.toString().length() == 0) {
            return null;
        }
        return stringBuffer.toString();
    }

    public void placeIcons() {
        IlvGraphic[] ilvGraphicArray = this.getChildren();
        if (ilvGraphicArray != null) {
            this.setChildren(null);
        }
        int n = 0;
        double d = 0.0;
        String string = this.getAnnotationText();
        String string2 = this.getLinkLabelText();
        if (string == null && string2 == null) {
            if (this.linkIcon != null && this.mtk.isLinkIconEnabled()) {
                this.setChildren(n, (IlvGraphic)this.linkIcon);
                this.setConstraints(n++, new IlvAttachmentConstraint(IlvAttachmentLocation.CenterPostOrderFirst, IlvLinkAttachmentLocation.MiddleLink));
            }
        } else {
            LinkBundle linkBundle = this.mtk.getLinkBundle(this.getBundleKey());
            if (linkBundle != null && linkBundle.contains((IlvLinkImage)this)) {
                d = linkBundle.getRotationAngle();
            } else if (this.getGraph() != null) {
                d = this.getRotationAngle();
            }
            StringBuffer stringBuffer = new StringBuffer();
            if (string2 != null) {
                stringBuffer.append(string2);
            }
            if (string != null) {
                stringBuffer.append(" " + string);
            }
            this.centerLabel = new MapLabel();
            this.centerLabel.setText(stringBuffer.toString());
            this.centerLabel.setFont(annotationFont);
            this.setChildren(n, (IlvGraphic)this.centerLabel);
            this.setConstraints(n++, new IlvAttachmentConstraint(IlvAttachmentLocation.CenterPostOrderFirst, IlvLinkAttachmentLocation.MiddleLink));
            this.centerLabel.setRotation(d);
        }
        if (this.srcIcons.size() > 0) {
            this.placeIcons(this.srcIcons, n++, true);
        }
        if (this.dstIcons.size() > 0) {
            this.placeIcons(this.dstIcons, n++, false);
        }
        this.placeDwdmSide(n);
        this.reDraw();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void placeIcons(TreeMap treeMap, int n, boolean bl) {
        IlvCompositeGraphic ilvCompositeGraphic = new IlvCompositeGraphic();
        ilvCompositeGraphic.setLayout((IlvLayoutManager)new IlvStackerLayout());
        TreeMap treeMap2 = treeMap;
        synchronized (treeMap2) {
            Collection collection = treeMap.values();
            if (collection.size() == 0) {
                return;
            }
            int n2 = 0;
            for (MapImageIcon mapImageIcon : collection) {
                ilvCompositeGraphic.setChildren(n2++, (IlvGraphic)mapImageIcon);
            }
            IlvAttachmentLocation ilvAttachmentLocation = null;
            ilvAttachmentLocation = bl ? IlvLinkAttachmentLocation.FromLink : IlvLinkAttachmentLocation.ToLink;
            this.setChildren(n, (IlvGraphic)ilvCompositeGraphic);
            this.setConstraints(n, new IlvAttachmentConstraint(IlvAttachmentLocation.CenterPostOrderFirst, ilvAttachmentLocation));
        }
    }

    protected String getLinkLabelText() {
        String string = null;
        IlvPoint[] ilvPointArray = this.getLinkPoints(this.mtk.getTransformer());
        if (ilvPointArray.length != 2 || this.fromLabel == null && this.toLabel == null) {
            return string;
        }
        double d = ilvPointArray[0].getX();
        double d2 = ilvPointArray[0].getY();
        double d3 = ilvPointArray[1].getX();
        double d4 = ilvPointArray[1].getY();
        if (d < d3) {
            string = this.buildLabelText(this.fromLabel, this.toLabel);
        } else if (d3 < d) {
            string = this.buildLabelText(this.toLabel, this.fromLabel);
        } else if (d == d3) {
            string = d2 < d4 ? this.buildLabelText(this.fromLabel, this.toLabel) : this.buildLabelText(this.toLabel, this.fromLabel);
        }
        return string;
    }

    private String buildLabelText(String string, String string2) {
        String string3 = null;
        string3 = string == null ? string2 : (string2 == null ? string : string + " - " + string2);
        return string3;
    }

    public final String getToolTipText(IlvPoint ilvPoint, IlvTransformer ilvTransformer) {
        return this.getToolTipText();
    }

    public String getToolTipText() {
        return " linkClass=" + this.linkClass;
    }

    public void reDraw() {
        super.reDraw();
    }

    public void setSourceConnector(MapLinkConnector mapLinkConnector) {
        this.sourceConnector = mapLinkConnector;
    }

    public void setTargetConnector(MapLinkConnector mapLinkConnector) {
        this.targetConnector = mapLinkConnector;
    }

    public MapLinkConnector getSourceConnector() {
        return this.sourceConnector;
    }

    public MapLinkConnector getTargetConnector() {
        return this.targetConnector;
    }

    public void setSrcArrow() {
        this.srcArrowEnabled = true;
        this.dstArrowEnabled = false;
        this.reDraw();
    }

    public void setTargetArrow() {
        this.srcArrowEnabled = false;
        this.dstArrowEnabled = true;
        this.reDraw();
    }

    public void setBothArrows() {
        this.dstArrowEnabled = true;
        this.srcArrowEnabled = true;
        this.reDraw();
    }

    public void reverseArrow() {
        if (!this.dstArrowEnabled || !this.srcArrowEnabled) {
            if (this.srcArrowEnabled) {
                this.srcArrowEnabled = false;
                this.dstArrowEnabled = true;
            } else {
                this.srcArrowEnabled = true;
                this.dstArrowEnabled = false;
            }
            this.reDraw();
        }
    }

    public void removeArrows() {
        this.dstArrowEnabled = false;
        this.srcArrowEnabled = false;
        this.reDraw();
    }

    public boolean isSrcArrowEnabled() {
        return this.srcArrowEnabled;
    }

    public boolean isTargetArrowEnabled() {
        return this.dstArrowEnabled;
    }

    protected final void drawArrow(Graphics graphics, IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer) {
        if (this.srcArrowEnabled || this.dstArrowEnabled) {
            this.setOriented(true);
            if (this.srcArrowEnabled) {
                super.drawArrow(graphics, ilvPoint2, ilvPoint, ilvTransformer);
            }
            if (this.dstArrowEnabled) {
                super.drawArrow(graphics, ilvPoint, ilvPoint2, ilvTransformer);
            }
        } else {
            this.setOriented(false);
        }
    }

    public IlvRect boundingBox(IlvTransformer ilvTransformer) {
        if (!this.registered) {
            this.addObserver();
        }
        return super.boundingBox(ilvTransformer);
    }

    private void addObserver() {
        if (this.getGraph() != null) {
            this.getGraph().addManagerContentChangedListener(this);
            this.registered = true;
        }
    }

    public void contentsChanged(ManagerContentChangedEvent managerContentChangedEvent) {
        switch (managerContentChangedEvent.getType()) {
            case 2: {
                ObjectRemovedEvent objectRemovedEvent = (ObjectRemovedEvent)managerContentChangedEvent;
                if (objectRemovedEvent.getGraphicObject() != this) break;
                objectRemovedEvent.getManager().removeManagerContentChangedListener((ManagerContentChangedListener)this);
                this.registered = false;
                break;
            }
            case 4: {
                ObjectBBoxChangedEvent objectBBoxChangedEvent = (ObjectBBoxChangedEvent)managerContentChangedEvent;
                if (objectBBoxChangedEvent.getGraphicObject() != this) break;
                this.placeIcons();
            }
        }
    }

    public final void draw(Graphics graphics, IlvTransformer ilvTransformer) {
        this.drawMe((Graphics2D)graphics, new MapTransformer(ilvTransformer));
    }

    protected void drawMe(Graphics2D graphics2D, MapTransformer mapTransformer) {
        super.draw((Graphics)graphics2D, mapTransformer.getTransform());
    }

    public Rectangle2D.Float getBounds() {
        return super.boundingBox();
    }

    public Rectangle2D.Float getBounds(MapTransformer mapTransformer) {
        return super.boundingBox(mapTransformer.getTransform());
    }

    public void setSrcLabel(String string) {
        this.fromLabel = string;
        this.placeIcons();
    }

    public String getSrcLabel() {
        return this.fromLabel;
    }

    public String getTargetLabel() {
        return this.toLabel;
    }

    public void setTargetLabel(String string) {
        this.toLabel = string;
        this.placeIcons();
    }

    protected void drawAnnotations(Graphics2D graphics2D, MapTransformer mapTransformer) {
        if (this.centerLabel != null) {
            this.centerLabel.draw(graphics2D, mapTransformer.getTransform());
        }
    }

    public boolean isSelected() {
        AbstractGraph abstractGraph = this.getGraph();
        if (abstractGraph == null) {
            LinkBundle linkBundle = this.mtk.getLinkBundle(this.getBundleKey());
            if (linkBundle != null && linkBundle.contains((IlvLinkImage)this)) {
                return linkBundle.isSelected((IlvLinkImage)this);
            }
        } else {
            return abstractGraph.isSelected((IlvGraphic)this);
        }
        return false;
    }

    public String getBundleKey() {
        return this.bundleKey;
    }

    double getRotationAngle() {
        return this.mtk.getRotationAngle((IlvLinkImage)this);
    }

    void refreshContainersUI() {
    }

    public void destroy() {
        IlvGraphic[] ilvGraphicArray;
        AbstractGraph abstractGraph = this.getGraph();
        if (abstractGraph != null && abstractGraph.contains((Object)this)) {
            abstractGraph.remove((IlvGraphic)this);
        }
        if ((ilvGraphicArray = this.getChildren()) != null) {
            for (int i = 0; i < ilvGraphicArray.length; ++i) {
                this.setChildren(i, null);
            }
        }
    }

    private void initOrientedIcon() {
        this.placeOrientedIcon();
        this.src.setOtsLink(this);
        this.dst.setOtsLink(this);
    }

    protected void placeOrientedIcon() {
    }

    protected void placeDwdmSide(int n) {
    }

    public void safeSetChildren(int n, IlvGraphic ilvGraphic, int n2, IlvAttachmentConstraint ilvAttachmentConstraint) {
        this.setChildren(n, ilvGraphic);
        if (n2 != -1) {
            this.setConstraints(n2, ilvAttachmentConstraint);
        }
    }

    public MapToolkit getMtk() {
        return this.mtk;
    }
}

