/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc.util.map;

import cerent.cms.ui.network.NetMapLink;
import com.cisco.ctc.util.map.AbstractGraph;
import com.cisco.ctc.util.map.AbstractLink;
import com.cisco.ctc.util.map.Link;
import com.cisco.ctc.util.map.LinkBundle;
import com.cisco.ctc.util.map.MapEllipse;
import com.cisco.ctc.util.map.MapImageIcon;
import com.cisco.ctc.util.map.MapLabel;
import com.cisco.ctc.util.map.MapLine;
import com.cisco.ctc.util.map.MapLinkConnector;
import com.cisco.ctc.util.map.MapObjectAdapter;
import com.cisco.ctc.util.map.MapPolygon;
import com.cisco.ctc.util.map.MapRect;
import com.cisco.ctc.util.map.MapToolkit;
import com.cisco.ctc.util.map.MapTransformer;
import com.cisco.fv.grapher.FunctNetMapLink;
import ilog.views.IlvGraphic;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.event.ManagerContentChangedEvent;
import ilog.views.event.ManagerContentChangedListener;
import ilog.views.event.ObjectBBoxChangedEvent;
import ilog.views.event.ObjectRemovedEvent;
import ilog.views.graphic.composite.IlvCompositeGraphic;
import ilog.views.graphic.composite.layout.IlvAttachmentConstraint;
import ilog.views.graphic.composite.layout.IlvAttachmentLayout;
import ilog.views.graphic.composite.layout.IlvAttachmentLocation;
import ilog.views.graphic.composite.layout.IlvLayoutManager;
import ilog.views.linkconnector.IlvClippingLinkConnector;
import ilog.views.linkconnector.IlvPinLinkConnector;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

public abstract class AbstractNode
extends IlvCompositeGraphic
implements ManagerContentChangedListener {
    private static final int CHILD_ICON = 0;
    private static final int CHILD_OBJECT = 0;
    protected static final int CHILD_LABEL = 1;
    protected double DEFAULT_HEIGHT = 80.0;
    protected double DEFAULT_WIDTH = 80.0;
    protected MapToolkit mtk;
    private IlvPinLinkConnector connectorBag = null;
    private IlvGraphic contentObject = null;
    private int ID = 0;
    private String nameString = null;
    private String descString = null;
    private ArrayList children = new ArrayList();
    private boolean registered = false;
    private int fontStyle = 0;
    protected static final int RECTANGLE = 0;
    protected static final int ELLIPSE = 1;
    private ArrayList<NetMapLink> otsLinks;
    private ArrayList<FunctNetMapLink> functOtsLinks;
    private AbstractGraph childGraph = null;

    public AbstractNode(MapToolkit mapToolkit) {
        this.mtk = mapToolkit;
        this.otsLinks = new ArrayList();
        this.functOtsLinks = new ArrayList();
        if (!mapToolkit.isDetailed()) {
            new IlvClippingLinkConnector((IlvGraphic)this);
        }
        IlvAttachmentLayout ilvAttachmentLayout = new IlvAttachmentLayout();
        this.setLayout((IlvLayoutManager)ilvAttachmentLayout);
        Image image = this.getIcon();
        if (image == null) {
            this.setContentObject();
        } else {
            this.setIcon(image);
        }
    }

    MapToolkit getMTK() {
        return this.mtk;
    }

    protected int getContentObjectType() {
        return 0;
    }

    private void setContentObject() {
        int n = this.getContentObjectType();
        this.contentObject = n == 1 ? new MapEllipse(0.0f, 0.0f, this.getDefaultWidth(), this.getDefaultHeight()) : new MapRect(0.0f, 0.0f, this.getDefaultWidth(), this.getDefaultHeight());
        this.setChildren(0, this.contentObject);
    }

    protected float getDefaultWidth() {
        return (float)this.DEFAULT_WIDTH;
    }

    protected float getDefaultHeight() {
        return (float)this.DEFAULT_HEIGHT;
    }

    protected void setColor(Color color) {
        if (this.contentObject != null) {
            if (this.contentObject instanceof MapRect) {
                ((MapRect)this.contentObject).setColor(color);
                return;
            }
            if (this.contentObject instanceof MapEllipse) {
                ((MapEllipse)this.contentObject).setColor(color);
                return;
            }
        }
    }

    protected Color getColor() {
        if (this.contentObject != null) {
            if (this.contentObject instanceof MapRect) {
                return ((MapRect)this.contentObject).getColor();
            }
            if (this.contentObject instanceof MapEllipse) {
                return ((MapEllipse)this.contentObject).getColor();
            }
        }
        return null;
    }

    protected Image getIcon() {
        return null;
    }

    protected void setIcon(Image image) {
        if (image != null) {
            if (this.isSelected()) {
                this.getGraph().setSelected((IlvGraphic)this, false, true);
            }
            IlvRect ilvRect = this.boundingBox(this.mtk.getTransformer());
            MapImageIcon mapImageIcon = new MapImageIcon(image);
            MapImageIcon mapImageIcon2 = (MapImageIcon)this.getChildren(0);
            if (mapImageIcon2 == null) {
                double d = this.getCenterX();
                double d2 = this.getCenterY();
                this.setChildren(0, (IlvGraphic)mapImageIcon);
                this.setConstraints(0, new IlvAttachmentConstraint(IlvAttachmentLocation.Center, IlvAttachmentLocation.Center));
                this.setCenter(d, d2);
            } else {
                mapImageIcon2.setImage(image);
            }
            IlvRect ilvRect2 = this.boundingBox(this.mtk.getTransformer());
            this.mtk.reDraw(ilvRect.createUnion((Rectangle2D)ilvRect2));
        }
    }

    public IlvRect boundingBox(IlvTransformer ilvTransformer) {
        if (!this.registered) {
            this.addObserver();
        }
        return super.boundingBox(ilvTransformer);
    }

    protected Rectangle2D getBounds(MapTransformer mapTransformer) {
        if (this.contentObject != null) {
            return this.contentObject.boundingBox(mapTransformer.getTransform());
        }
        return this.boundingBox(mapTransformer.getTransform());
    }

    private void addObserver() {
        if (this.getGraphicBag() != null) {
            this.getGraph().addManagerContentChangedListener(this);
            this.registered = true;
        }
    }

    public void setName(String string) {
        this.nameString = string;
        this.updateLabel();
    }

    public void setDesc(String string) {
        this.descString = string;
        this.updateLabel();
    }

    public void addDesc(String string) {
        if (string != null) {
            this.descString = this.descString == null ? string : this.descString + "\n" + string;
            this.updateLabel();
        }
    }

    public void setFontStyle(int n) {
        this.fontStyle = n;
        this.updateLabel();
    }

    private void updateLabel() {
        Object object;
        double d = this.getCenterX();
        double d2 = this.getCenterY();
        IlvRect ilvRect = this.boundingBox(this.mtk.getTransformer());
        if (this.nameString == null && this.descString == null) {
            object = this.getChildren(1);
            if (object != null) {
                this.setChildren(1, null);
                this.setCenter(d, d2);
            }
        } else {
            object = null;
            if (this.nameString != null) {
                object = this.isVirtual() ? "(" + this.nameString + ")" : this.nameString;
            }
            if (this.descString != null) {
                object = object == null ? this.descString : (String)object + "\n" + this.descString;
            }
            MapLabel mapLabel = new MapLabel();
            Font font = mapLabel.getFont();
            Font font2 = new Font(font.getName(), this.fontStyle, font.getSize());
            mapLabel.setText((String)object);
            mapLabel.setFont(font2);
            mapLabel.setTopMargin(3.0f);
            this.setChildren(1, (IlvGraphic)mapLabel);
            this.setConstraints(1, new IlvAttachmentConstraint(IlvAttachmentLocation.TopCenter, IlvAttachmentLocation.BottomCenter));
            this.setCenter(d, d2);
        }
        object = this.boundingBox(this.mtk.getTransformer());
        this.mtk.reDraw(ilvRect.createUnion((Rectangle2D)object));
    }

    public String getName() {
        return this.nameString;
    }

    public String getDesc() {
        return this.descString;
    }

    public double getCenterX() {
        return MapObjectAdapter.getCenterX((IlvGraphic)this);
    }

    public double getCenterY() {
        return MapObjectAdapter.getCenterY((IlvGraphic)this);
    }

    public void setCenter(double d, double d2) {
        MapObjectAdapter.setCenter(this.getGraph(), (IlvGraphic)this, d, d2);
    }

    public double getLocX() {
        return MapObjectAdapter.getLocX((IlvGraphic)this);
    }

    public double getLocY() {
        return MapObjectAdapter.getLocY((IlvGraphic)this);
    }

    public double getWidth() {
        return MapObjectAdapter.getWidth((IlvGraphic)this);
    }

    public double getHeight() {
        return MapObjectAdapter.getHeight((IlvGraphic)this);
    }

    public void setSize(double d, double d2) {
        MapObjectAdapter.setSize((IlvGraphic)this, d, d2);
    }

    public boolean contains(double d, double d2) {
        return super.boundingBox().contains(d, d2);
    }

    public AbstractGraph getGraph() {
        return (AbstractGraph)super.getGraphicBag();
    }

    public final String getToolTipText(IlvPoint ilvPoint, IlvTransformer ilvTransformer) {
        return this.getToolTipText();
    }

    public String getToolTipText() {
        return this.getName();
    }

    public Link[] getLinks() {
        Object[] objectArray;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        AbstractGraph abstractGraph = this.getGraph();
        if (abstractGraph != null && (objectArray = abstractGraph.getConnectedLinks(this)) != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] instanceof LinkBundle) {
                    LinkBundle linkBundle = (LinkBundle)objectArray[i];
                    Link[] linkArray = linkBundle.getLinks();
                    if (linkArray == null) continue;
                    for (int j = 0; j < linkArray.length; ++j) {
                        arrayList.add(linkArray[j]);
                    }
                    continue;
                }
                if (!(objectArray[i] instanceof Link)) continue;
                arrayList.add(objectArray[i]);
            }
        }
        return arrayList.toArray(new Link[0]);
    }

    private void initConnectorBag() {
        this.connectorBag = new IlvPinLinkConnector((IlvGraphic)this);
    }

    MapLinkConnector createLinkConnector(float f, float f2) {
        if (this.connectorBag == null) {
            this.initConnectorBag();
        }
        return new MapLinkConnector(this, f, f2);
    }

    IlvPinLinkConnector getLinkConnectorBag() {
        return this.connectorBag;
    }

    private float clipPortX(Rectangle2D.Float float_, float f) {
        float f2 = (float)MapObjectAdapter.getWidth(this.contentObject);
        float f3 = (float)float_.getWidth();
        if (f < 0.0f) {
            f = 0.0f;
        } else if (f + f3 > f2) {
            f = f2 - f3;
        }
        return f;
    }

    private float clipPortY(Rectangle2D.Float float_, float f) {
        float f2 = (float)MapObjectAdapter.getHeight(this.contentObject);
        float f3 = (float)float_.getHeight();
        if (f < 0.0f) {
            f = 0.0f;
        } else if (f + f3 > f2) {
            f = f2 - f3;
        }
        return f;
    }

    boolean addComponent(IlvGraphic ilvGraphic, int n) {
        if (this.getGraph() == null || this.contentObject == null || this.children.contains(ilvGraphic)) {
            return false;
        }
        this.getGraph().addObject(ilvGraphic, n, false);
        this.children.add(ilvGraphic);
        return true;
    }

    void removeComponent(IlvGraphic ilvGraphic) {
        if (this.getGraph() == null) {
            return;
        }
        this.children.remove(ilvGraphic);
        this.getGraph().removeObject(ilvGraphic, true);
    }

    Object[] getComponents() {
        return this.children.toArray(new Object[0]);
    }

    public void setLocation(double d, double d2) {
        MapObjectAdapter.setLocation(this.getGraph(), (IlvGraphic)this, d, d2);
    }

    public void setLocation(IlvGraphic ilvGraphic, float f, float f2) {
        f = this.clipPortX((Rectangle2D.Float)ilvGraphic.boundingBox(), f);
        f2 = this.clipPortY((Rectangle2D.Float)ilvGraphic.boundingBox(), f2);
        double d = MapObjectAdapter.getLocX(this.contentObject) + (double)f;
        double d2 = MapObjectAdapter.getLocY(this.contentObject) + (double)f2;
        if (ilvGraphic instanceof MapRect) {
            ((MapRect)ilvGraphic).setLocation(d, d2);
        } else if (ilvGraphic instanceof MapEllipse) {
            ((MapEllipse)ilvGraphic).setLocation(d, d2);
        } else if (ilvGraphic instanceof MapPolygon) {
            ((MapPolygon)ilvGraphic).setLocation(d, d2);
        } else if (ilvGraphic instanceof MapLine) {
            ((MapLine)ilvGraphic).setLocation(d, d2);
        }
    }

    private void updateChildrenPosition(ObjectBBoxChangedEvent objectBBoxChangedEvent) {
        IlvRect ilvRect = objectBBoxChangedEvent.getOldBoundingBox();
        IlvRect ilvRect2 = objectBBoxChangedEvent.getNewBoundingBox();
        float f = (float)(ilvRect2.getX() - ilvRect.getX());
        float f2 = (float)(ilvRect2.getY() - ilvRect.getY());
        for (Object e : this.children) {
            if (!(e instanceof IlvGraphic)) continue;
            IlvGraphic ilvGraphic = (IlvGraphic)e;
            ilvGraphic.translate(f, f2);
        }
    }

    public void otsLinkAdjust() {
        if (this.otsLinks.size() > 0) {
            for (NetMapLink detailedMapLink : this.otsLinks) {
                detailedMapLink.placeOrientedIcon();
            }
        }
        if (this.functOtsLinks.size() > 0) {
            for (FunctNetMapLink functNetMapLink : this.functOtsLinks) {
                functNetMapLink.placeOrientedIcon();
            }
        }
    }

    public void setOtsLink(AbstractLink abstractLink) {
        if (abstractLink instanceof NetMapLink) {
            this.otsLinks.add((NetMapLink)abstractLink);
        }
        if (abstractLink instanceof FunctNetMapLink) {
            this.functOtsLinks.add((FunctNetMapLink)abstractLink);
        }
    }

    public void contentsChanged(ManagerContentChangedEvent managerContentChangedEvent) {
        switch (managerContentChangedEvent.getType()) {
            case 2: {
                ObjectRemovedEvent objectRemovedEvent = (ObjectRemovedEvent)managerContentChangedEvent;
                if (objectRemovedEvent.getGraphicObject() != this) break;
                objectRemovedEvent.getManager().removeManagerContentChangedListener((ManagerContentChangedListener)this);
                this.registered = false;
                break;
            }
            case 4: {
                ObjectBBoxChangedEvent objectBBoxChangedEvent = (ObjectBBoxChangedEvent)managerContentChangedEvent;
                if (objectBBoxChangedEvent.getGraphicObject() != this) break;
                this.updateChildrenPosition(objectBBoxChangedEvent);
            }
        }
    }

    public void reDraw() {
        super.reDraw();
    }

    public final void draw(Graphics graphics, IlvTransformer ilvTransformer) {
        this.drawMe((Graphics2D)graphics, new MapTransformer(ilvTransformer));
    }

    protected void drawMe(Graphics2D graphics2D, MapTransformer mapTransformer) {
        super.draw((Graphics)graphics2D, mapTransformer.getTransform());
    }

    private void removeChildren() {
        AbstractGraph abstractGraph = this.getGraph();
        for (IlvGraphic ilvGraphic : this.children) {
            if (abstractGraph == null || !abstractGraph.contains(ilvGraphic)) continue;
            abstractGraph.remove(ilvGraphic);
        }
    }

    public boolean isSelected() {
        if (this.getGraph() != null) {
            return this.getGraph().isSelected((IlvGraphic)this);
        }
        return false;
    }

    public void setID(int n) {
        this.ID = n;
    }

    int getID() {
        return this.ID;
    }

    public boolean isVirtual() {
        return false;
    }

    public void destroy() {
        this.removeChildren();
        AbstractGraph abstractGraph = this.getGraph();
        if (abstractGraph != null && abstractGraph.contains((Object)this)) {
            abstractGraph.remove((IlvGraphic)this);
        }
    }

    public void setChildGrapher(AbstractGraph abstractGraph) {
        this.childGraph = abstractGraph;
    }

    public AbstractGraph getChildGrapher() {
        return this.childGraph;
    }
}

