/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc.util.map;

import cerent.cms.fv.IFvSideModel;
import cerent.cms.fv.net.IFvVirtualLink;
import cerent.cms.ui.DwdmSide;
import cerent.util.gui.ActionOrganizer;
import cerent.util.gui.UPopupMenu;
import cerent.util.view.fv.IPowerBallon;
import cerent.util.view.fv.ViewCardGrapher;
import cerent.util.view.fv.ViewDomainGrapher;
import cerent.util.view.fv.ViewManagerToolKit;
import cerent.util.view.fv.ViewPortGraphic;
import cerent.util.view.fv.helper.FunctException;
import com.cisco.ctc.util.map.AbstractGraph;
import com.cisco.ctc.util.map.AbstractLink;
import com.cisco.ctc.util.map.AbstractView;
import com.cisco.ctc.util.map.Link;
import com.cisco.ctc.util.map.LinkBundle;
import com.cisco.ctc.util.map.MapDwdmGraph;
import com.cisco.ctc.util.map.MapImageIcon;
import com.cisco.ctc.util.map.MapLabel;
import com.cisco.ctc.util.map.MapLinkConnector;
import com.cisco.ctc.util.map.MapObjectAdapter;
import com.cisco.ctc.util.map.MapToolkit;
import com.cisco.ctc.util.map.MapTransformer;
import com.cisco.fv.grapher.FunctNetMapLink;
import com.cisco.fv.grapher.FunctNetMapNode;
import com.cisco.fv.grapher.FvNetworkMap;
import com.cisco.fv.grapher.util.FvMapGraph;
import com.cisco.fv.grapher.util.LinkBalloon;
import com.cisco.fv.power.PowerBallon;
import com.cisco.fv.power.SpanLossBalloon;
import ilog.views.IlvApplyObject;
import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicBag;
import ilog.views.IlvLinkImage;
import ilog.views.IlvManager;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.event.ManagerContentChangedEvent;
import ilog.views.event.ManagerContentChangedListener;
import ilog.views.event.ObjectBBoxChangedEvent;
import ilog.views.event.ObjectRemovedEvent;
import ilog.views.graphic.composite.IlvCompositeGraphic;
import ilog.views.graphic.composite.IlvCompositeLink;
import ilog.views.graphic.composite.layout.IlvAttachmentConstraint;
import ilog.views.graphic.composite.layout.IlvAttachmentLocation;
import ilog.views.graphic.composite.layout.IlvLayoutManager;
import ilog.views.graphic.composite.layout.IlvLinkAttachmentLocation;
import ilog.views.graphic.composite.layout.IlvStackerLayout;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeMap;
import javax.swing.JComponent;

public class InterGraphLink
extends IlvCompositeLink
implements ManagerContentChangedListener,
ActionListener,
IPowerBallon {
    private static final double UP = -90.0;
    private static final double DOWN = 90.0;
    private static final double RIGHT = 0.0;
    private static final double LEFT = 180.0;
    private static final double MAX_X_PIXEL_DISTANCE = 70.0;
    protected MapToolkit mtk;
    protected IlvGraphic src;
    protected IlvGraphic dst;
    private IlvGraphic portSource;
    private IlvGraphic portDst;
    private String bundleKey;
    private MapLabel centerLabel = null;
    private String fromLabel = null;
    private String toLabel = null;
    protected MapImageIcon linkIcon = null;
    private TreeMap srcIcons = new TreeMap();
    private TreeMap dstIcons = new TreeMap();
    private TreeMap annotations = new TreeMap();
    private MapLinkConnector sourceConnector = null;
    private MapLinkConnector targetConnector = null;
    private boolean srcArrowEnabled = false;
    private boolean dstArrowEnabled = false;
    private String linkClass = null;
    private static Font annotationFont;
    private boolean registered = false;
    private Color linkColor = Color.green;
    private Link actualNetLink;
    private LinkBalloon spanLossInfoBalloon;
    private int spanLossChildIndex;
    private boolean hasSpanLossBalloon = false;
    private boolean balloonOpened = false;
    private ActionOrganizer actOrg = null;
    private static final String PWR_CMD = "Hide/Show SpanLoss";
    protected static final String FLIP_CMD = "Flip Span Loss";
    private static final int OSC = 0;
    private static final int VIRTUAL = 1;
    private MapDwdmGraph sideLabel;
    private IlvAttachmentConstraint srcSideLabelConstrain = null;
    private IlvAttachmentConstraint dstSideLabelConstrain = null;
    private MapLabel srcSideLabel;
    private MapLabel dstSideLabel;
    private boolean isTxLink;
    private boolean orgLinkHiddenFromHere = false;
    private boolean isOnCircuit;
    private IlvGraphic actualAssSrc;
    private IlvGraphic actualAssDst;
    private int linkType;
    IlvAttachmentLocation[] attachFrom = new IlvAttachmentLocation[]{IlvLinkAttachmentLocation.FromLink, IlvLinkAttachmentLocation.ToLink};
    IlvAttachmentLocation[] attachTo = new IlvAttachmentLocation[]{IlvLinkAttachmentLocation.ToLink, IlvLinkAttachmentLocation.FromLink};
    IlvAttachmentLocation[] attachBalloon = new IlvAttachmentLocation[]{IlvLinkAttachmentLocation.ToLink, IlvLinkAttachmentLocation.FromLink};

    public InterGraphLink(AbstractView abstractView, IlvGraphic ilvGraphic, IlvGraphic ilvGraphic2, IlvGraphic ilvGraphic3, IlvGraphic ilvGraphic4, String string, Link link, int n, int n2, boolean bl, boolean bl2) {
        super(ilvGraphic, ilvGraphic2, false);
        this.mtk = (MapToolkit)abstractView;
        this.src = ilvGraphic;
        this.dst = ilvGraphic2;
        this.portSource = ilvGraphic3;
        this.portDst = ilvGraphic4;
        this.linkClass = string == null ? "Miscellaneous" : string;
        this.actualNetLink = link;
        this.linkType = 1;
        if (link.getUserObject() instanceof IFvVirtualLink) {
            this.linkType = 1;
        }
        this.isTxLink = bl2;
        this.setBundleKey();
        this.initDefaults();
    }

    public void placeBalloons() {
        if (((FunctNetMapLink)this.actualNetLink).getSpanLossInfoBalloon() == null) {
            return;
        }
        if (this.spanLossInfoBalloon == null) {
            int n;
            this.spanLossInfoBalloon = new LinkBalloon("power", LinkBalloon.BASE_COLOR, 10);
            this.spanLossChildIndex = n = this.getChildren() != null ? this.getChildren().length : 0;
            this.setChildren(n, (IlvGraphic)this.spanLossInfoBalloon);
            this.setConstraints(n++, new IlvAttachmentConstraint(IlvAttachmentLocation.BottomCenter, this.attachBalloon[this.linkType]));
            this.hasSpanLossBalloon = true;
            this.spanLossInfoBalloon.showIt(false);
            if (this.hasSpanLossBalloon) {
                this.showBalloon(this.balloonOpened);
            }
        }
    }

    public void showBalloon(boolean bl) {
        if (this.actualNetLink instanceof FunctNetMapLink) {
            if (this.spanLossInfoBalloon == null) {
                return;
            }
            FunctNetMapLink functNetMapLink = (FunctNetMapLink)this.actualNetLink;
            String string = functNetMapLink.getBaloonPowerInfo();
            if (bl && (string == null || string.length() == 0)) {
                return;
            }
            boolean bl2 = functNetMapLink.isBalloonOpened();
            if (this.orgLinkHiddenFromHere && bl2 != bl) {
                functNetMapLink.showBalloon(bl);
                this.orgLinkHiddenFromHere = false;
            }
            bl = functNetMapLink.isBalloonOpened();
            this.spanLossInfoBalloon.setLinkLabel(string);
            FvNetworkMap fvNetworkMap = FvNetworkMap.getInstance();
            if (bl) {
                if (PowerBallon.getInstance().isForCircuit()) {
                    if (fvNetworkMap != null && fvNetworkMap.isZoomLevelVisible()) {
                        this.spanLossInfoBalloon.showIt(bl && this.isOnCircuit);
                    }
                } else if (fvNetworkMap != null && fvNetworkMap.isZoomLevelVisible()) {
                    this.spanLossInfoBalloon.showIt(bl);
                }
            } else if (fvNetworkMap != null && fvNetworkMap.isZoomLevelVisible()) {
                this.spanLossInfoBalloon.showIt(bl);
            }
            this.balloonOpened = bl;
        }
    }

    private int getNodeId(IlvGraphic ilvGraphic) {
        int n = 0;
        if (ilvGraphic instanceof FvMapGraph) {
            n = ((FunctNetMapNode)((FvMapGraph)ilvGraphic).getCollapsedGraphic()).getNodeModel().getNodeId();
        } else if (ilvGraphic instanceof ViewPortGraphic && ((ViewPortGraphic)ilvGraphic).getPortModel() != null) {
            n = ((ViewPortGraphic)ilvGraphic).getPortModel().getIFvNodeModel().getNodeId();
        }
        return n;
    }

    private void setBundleKey() {
    }

    void initDefaults() {
        Object object;
        annotationFont = new Font("Arial", 0, 12);
        this.setLineThickness(this.actualNetLink.getLineWidth());
        this.setLineColor(this.actualNetLink.getForeground());
        if (this.actualNetLink instanceof FunctNetMapLink) {
            object = (FunctNetMapLink)this.actualNetLink;
            this.setBalloonUnderCircuit(((FunctNetMapLink)object).isOnCircuit());
        }
        if ((object = this.getLinkIcon(this.linkClass)) != null) {
            this.linkIcon = new MapImageIcon((Image)object);
            this.placeIcons();
            this.initOrientedIcon();
        }
    }

    public final String getLinkClass() {
        return this.linkClass;
    }

    protected Image getLinkIcon(String string) {
        return this.actualNetLink.getLinkIcon(string);
    }

    public AbstractGraph getGraph() {
        if (super.getGraphicBag() instanceof AbstractGraph) {
            return (AbstractGraph)super.getGraphicBag();
        }
        return null;
    }

    public void setLineColor(Color color) {
        super.setForeground(color);
        this.linkColor = color;
        this.reDraw();
    }

    void setSelectedColor(Color color) {
        super.setForeground(color);
        this.reDraw();
    }

    public Color getLineColor() {
        return this.linkColor;
    }

    public void setLineThickness(float f) {
        super.setLineWidth(f);
    }

    public float getLineThickness(MapTransformer mapTransformer) {
        return super.getLineWidth(mapTransformer.getTransform());
    }

    public double getLocX() {
        return MapObjectAdapter.getLocX((IlvGraphic)this);
    }

    public double getLocY() {
        return MapObjectAdapter.getLocY((IlvGraphic)this);
    }

    public double getCenterX() {
        return MapObjectAdapter.getCenterX((IlvGraphic)this);
    }

    public double getCenterY() {
        return MapObjectAdapter.getCenterY((IlvGraphic)this);
    }

    public double getWidth() {
        return MapObjectAdapter.getWidth((IlvGraphic)this);
    }

    public double getHeight() {
        return MapObjectAdapter.getHeight((IlvGraphic)this);
    }

    public void addSrcDecorativeIcon(String string, MapImageIcon mapImageIcon) {
        this.addDecorativeIcon(string, mapImageIcon, this.srcIcons);
    }

    public void addTargetDecorativeIcon(String string, MapImageIcon mapImageIcon) {
        this.addDecorativeIcon(string, mapImageIcon, this.dstIcons);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDecorativeIcon(String string, MapImageIcon mapImageIcon, TreeMap treeMap) {
        if (string != null && mapImageIcon != null) {
            TreeMap treeMap2 = treeMap;
            synchronized (treeMap2) {
                treeMap.put(string, mapImageIcon);
            }
            this.placeIcons();
            this.refreshContainersUI();
        }
    }

    public void removeSrcDecorativeIcon(String string) {
        this.removeDecorativeIcon(string, this.srcIcons);
    }

    public void removeTargetDecorativeIcon(String string) {
        this.removeDecorativeIcon(string, this.dstIcons);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDecorativeIcon(String string, TreeMap treeMap) {
        TreeMap treeMap2 = treeMap;
        synchronized (treeMap2) {
            if (treeMap.containsKey(string)) {
                treeMap.remove(string);
                this.placeIcons();
                this.refreshContainersUI();
            }
        }
    }

    public TreeMap getSrcDecorativeIcons() {
        return this.getDecorativeIcons(this.srcIcons);
    }

    public TreeMap getDstDecorativeIcons() {
        return this.getDecorativeIcons(this.dstIcons);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TreeMap getDecorativeIcons(TreeMap treeMap) {
        TreeMap treeMap2 = new TreeMap();
        TreeMap treeMap3 = treeMap;
        synchronized (treeMap3) {
            treeMap2.putAll(treeMap);
        }
        return treeMap2;
    }

    public void removeAllSrcDecorativeIcons() {
        this.removeAllDecorativeIcons(this.srcIcons);
    }

    public void removeAllDstDecorativeIcons() {
        this.removeAllDecorativeIcons(this.dstIcons);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllDecorativeIcons() {
        TreeMap treeMap = this.srcIcons;
        synchronized (treeMap) {
            this.srcIcons = new TreeMap();
        }
        treeMap = this.dstIcons;
        synchronized (treeMap) {
            this.dstIcons = new TreeMap();
        }
        this.placeIcons();
        this.refreshContainersUI();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAllDecorativeIcons(TreeMap treeMap) {
        TreeMap treeMap2 = treeMap;
        synchronized (treeMap2) {
            treeMap = new TreeMap();
        }
        this.placeIcons();
        this.refreshContainersUI();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAnnotation(String string, String string2) {
        if (string != null && string2 != null) {
            TreeMap treeMap = this.annotations;
            synchronized (treeMap) {
                this.annotations.put(string, string2);
            }
            this.placeIcons();
        }
    }

    public void setAnnotationFont(Font font) {
        if (font != null) {
            annotationFont = font;
        }
    }

    public static Font getAnnotationFont() {
        return annotationFont;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAnnotation(String string) {
        TreeMap treeMap = this.annotations;
        synchronized (treeMap) {
            if (this.annotations.containsKey(string)) {
                this.annotations.remove(string);
                this.placeIcons();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllAnnotations() {
        TreeMap treeMap = this.annotations;
        synchronized (treeMap) {
            this.annotations = new TreeMap();
        }
        this.placeIcons();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TreeMap getAnnotations() {
        TreeMap treeMap = new TreeMap();
        TreeMap treeMap2 = this.annotations;
        synchronized (treeMap2) {
            treeMap.putAll(this.annotations);
        }
        return treeMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAnnotationText() {
        StringBuffer stringBuffer = new StringBuffer();
        TreeMap treeMap = this.annotations;
        synchronized (treeMap) {
            String[] stringArray = this.annotations.values().toArray(new String[0]);
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuffer.append(stringArray[i]);
                if (i == stringArray.length - 1) continue;
                stringBuffer.append(", ");
            }
        }
        if (stringBuffer.toString().length() == 0) {
            return null;
        }
        return stringBuffer.toString();
    }

    public void placeIcons() {
        int n;
        LinkBalloon linkBalloon = null;
        IlvGraphic[] ilvGraphicArray = this.getChildren();
        int n2 = 0;
        if (ilvGraphicArray == null) {
            this.placeAllIcons();
            return;
        }
        n2 = ilvGraphicArray.length;
        for (n = 0; n < n2; ++n) {
            if (!(ilvGraphicArray[n] instanceof LinkBalloon)) continue;
            linkBalloon = (LinkBalloon)ilvGraphicArray[n];
        }
        this.placeAllIcons();
        if (this.getChildren() == null) {
            return;
        }
        if (linkBalloon != null) {
            n = this.getChildren() != null ? this.getChildren().length : 0;
            this.setChildren(n, (IlvGraphic)linkBalloon);
            this.setConstraints(n++, new IlvAttachmentConstraint(IlvAttachmentLocation.BottomCenter, this.attachBalloon[this.linkType]));
            this.spanLossInfoBalloon = linkBalloon;
        }
    }

    public void placeAllIcons() {
        int n;
        IlvGraphic[] ilvGraphicArray = this.getChildren();
        if (ilvGraphicArray != null) {
            for (n = 0; n < ilvGraphicArray.length; ++n) {
                this.setChildren(n, null);
            }
        }
        n = 0;
        double d = 0.0;
        String string = this.getAnnotationText();
        String string2 = this.getLinkLabelText();
        if (string == null && string2 == null) {
            if (this.linkIcon != null && this.mtk.isLinkIconEnabled()) {
                this.setChildren(n, (IlvGraphic)this.linkIcon);
                this.setConstraints(n++, new IlvAttachmentConstraint(IlvAttachmentLocation.CenterPostOrderFirst, IlvLinkAttachmentLocation.MiddleLink));
            }
        } else {
            LinkBundle linkBundle = this.mtk.getLinkBundle(this.getBundleKey());
            if (linkBundle != null && linkBundle.contains((IlvLinkImage)this)) {
                d = linkBundle.getRotationAngle();
            } else if (this.getGraph() != null) {
                d = this.getRotationAngle();
            }
            StringBuffer stringBuffer = new StringBuffer();
            if (string2 != null) {
                stringBuffer.append(string2);
            }
            if (string != null) {
                stringBuffer.append(" " + string);
            }
            this.centerLabel = new MapLabel();
            this.centerLabel.setText(stringBuffer.toString());
            this.centerLabel.setFont(annotationFont);
            this.setChildren(n, (IlvGraphic)this.centerLabel);
            this.setConstraints(n++, new IlvAttachmentConstraint(IlvAttachmentLocation.CenterPostOrderFirst, IlvLinkAttachmentLocation.MiddleLink));
            this.centerLabel.setRotation(d);
        }
        if (this.srcIcons.size() > 0) {
            this.placeIcons(this.srcIcons, n++, true);
        }
        if (this.dstIcons.size() > 0) {
            this.placeIcons(this.dstIcons, n++, false);
        }
        try {
            this.placeDwdmSide(n);
        }
        catch (FunctException functException) {
            // empty catch block
        }
        this.reDraw();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void placeIcons(TreeMap treeMap, int n, boolean bl) {
        IlvCompositeGraphic ilvCompositeGraphic = new IlvCompositeGraphic();
        ilvCompositeGraphic.setLayout((IlvLayoutManager)new IlvStackerLayout());
        TreeMap treeMap2 = treeMap;
        synchronized (treeMap2) {
            Collection collection = treeMap.values();
            if (collection.size() == 0) {
                return;
            }
            int n2 = 0;
            for (MapImageIcon mapImageIcon : collection) {
                ilvCompositeGraphic.setChildren(n2++, (IlvGraphic)mapImageIcon);
            }
            IlvAttachmentLocation ilvAttachmentLocation = null;
            ilvAttachmentLocation = bl ? IlvLinkAttachmentLocation.FromLink : IlvLinkAttachmentLocation.ToLink;
            this.setChildren(n, (IlvGraphic)ilvCompositeGraphic);
            this.setConstraints(n, new IlvAttachmentConstraint(IlvAttachmentLocation.CenterPostOrderFirst, ilvAttachmentLocation));
        }
    }

    protected String getLinkLabelText() {
        String string = null;
        IlvPoint[] ilvPointArray = this.getLinkPoints(this.mtk.getTransformer());
        if (ilvPointArray.length != 2 || this.fromLabel == null && this.toLabel == null) {
            return string;
        }
        double d = ilvPointArray[0].getX();
        double d2 = ilvPointArray[0].getY();
        double d3 = ilvPointArray[1].getX();
        double d4 = ilvPointArray[1].getY();
        if (d < d3) {
            string = this.buildLabelText(this.fromLabel, this.toLabel);
        } else if (d3 < d) {
            string = this.buildLabelText(this.toLabel, this.fromLabel);
        } else if (d == d3) {
            string = d2 < d4 ? this.buildLabelText(this.fromLabel, this.toLabel) : this.buildLabelText(this.toLabel, this.fromLabel);
        }
        return string;
    }

    private String buildLabelText(String string, String string2) {
        String string3 = null;
        string3 = string == null ? string2 : (string2 == null ? string : string + " - " + string2);
        return string3;
    }

    public final String getToolTipText(IlvPoint ilvPoint, IlvTransformer ilvTransformer) {
        return this.getToolTipText();
    }

    public String getToolTipText() {
        return "";
    }

    public void reDraw() {
        super.reDraw();
    }

    public void setSourceConnector(MapLinkConnector mapLinkConnector) {
        this.sourceConnector = mapLinkConnector;
    }

    public void setTargetConnector(MapLinkConnector mapLinkConnector) {
        this.targetConnector = mapLinkConnector;
    }

    public MapLinkConnector getSourceConnector() {
        return this.sourceConnector;
    }

    public MapLinkConnector getTargetConnector() {
        return this.targetConnector;
    }

    public void setSrcArrow() {
        this.srcArrowEnabled = true;
        this.dstArrowEnabled = false;
        this.reDraw();
    }

    public void setTargetArrow() {
        this.srcArrowEnabled = false;
        this.dstArrowEnabled = true;
        this.reDraw();
    }

    public void setBothArrows() {
        this.dstArrowEnabled = true;
        this.srcArrowEnabled = true;
        this.reDraw();
    }

    public void reverseArrow() {
        if (!this.dstArrowEnabled || !this.srcArrowEnabled) {
            if (this.srcArrowEnabled) {
                this.srcArrowEnabled = false;
                this.dstArrowEnabled = true;
            } else {
                this.srcArrowEnabled = true;
                this.dstArrowEnabled = false;
            }
            this.reDraw();
        }
    }

    public void removeArrows() {
        this.dstArrowEnabled = false;
        this.srcArrowEnabled = false;
        this.reDraw();
    }

    public boolean isSrcArrowEnabled() {
        return this.srcArrowEnabled;
    }

    public boolean isTargetArrowEnabled() {
        return this.dstArrowEnabled;
    }

    protected final void drawArrow(Graphics graphics, IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer) {
        if (this.srcArrowEnabled || this.dstArrowEnabled) {
            this.setOriented(true);
            if (this.srcArrowEnabled) {
                super.drawArrow(graphics, ilvPoint2, ilvPoint, ilvTransformer);
            }
            if (this.dstArrowEnabled) {
                super.drawArrow(graphics, ilvPoint, ilvPoint2, ilvTransformer);
            }
        } else {
            this.setOriented(false);
        }
    }

    public IlvRect boundingBox(IlvTransformer ilvTransformer) {
        if (!this.registered) {
            this.addObserver();
        }
        return super.boundingBox(ilvTransformer);
    }

    private void addObserver() {
        if (this.getGraph() != null) {
            this.getGraph().addManagerContentChangedListener(this);
            this.registered = true;
        }
    }

    public void contentsChanged(ManagerContentChangedEvent managerContentChangedEvent) {
        switch (managerContentChangedEvent.getType()) {
            case 2: {
                ObjectRemovedEvent objectRemovedEvent = (ObjectRemovedEvent)managerContentChangedEvent;
                if (objectRemovedEvent.getGraphicObject() != this) break;
                objectRemovedEvent.getManager().removeManagerContentChangedListener((ManagerContentChangedListener)this);
                this.registered = false;
                break;
            }
            case 4: {
                ObjectBBoxChangedEvent objectBBoxChangedEvent = (ObjectBBoxChangedEvent)managerContentChangedEvent;
                if (objectBBoxChangedEvent.getGraphicObject() != this) break;
                this.placeIcons();
            }
        }
    }

    public final void draw(Graphics graphics, IlvTransformer ilvTransformer) {
        this.drawMe((Graphics2D)graphics, new MapTransformer(ilvTransformer));
    }

    protected void drawMe(Graphics2D graphics2D, MapTransformer mapTransformer) {
        super.draw((Graphics)graphics2D, mapTransformer.getTransform());
    }

    public Rectangle2D.Float getBounds() {
        return super.boundingBox();
    }

    public Rectangle2D.Float getBounds(MapTransformer mapTransformer) {
        return super.boundingBox(mapTransformer.getTransform());
    }

    public void setSrcLabel(String string) {
        this.fromLabel = string;
        this.placeIcons();
    }

    public String getSrcLabel() {
        return this.fromLabel;
    }

    public String getTargetLabel() {
        return this.toLabel;
    }

    public void setTargetLabel(String string) {
        this.toLabel = string;
        this.placeIcons();
    }

    protected void drawAnnotations(Graphics2D graphics2D, MapTransformer mapTransformer) {
        if (this.centerLabel != null) {
            this.centerLabel.draw(graphics2D, mapTransformer.getTransform());
        }
    }

    public boolean isSelected() {
        AbstractGraph abstractGraph = this.getGraph();
        if (abstractGraph == null) {
            LinkBundle linkBundle = this.mtk.getLinkBundle(this.getBundleKey());
            if (linkBundle != null && linkBundle.contains((IlvLinkImage)this)) {
                return linkBundle.isSelected((IlvLinkImage)this);
            }
        } else {
            return abstractGraph.isSelected((IlvGraphic)this);
        }
        return false;
    }

    public String getBundleKey() {
        return this.bundleKey;
    }

    double getRotationAngle() {
        return this.mtk.getRotationAngle((IlvLinkImage)this);
    }

    void refreshContainersUI() {
    }

    public void destroy() {
        AbstractGraph abstractGraph = this.getGraph();
        if (abstractGraph != null && abstractGraph.contains(this)) {
            abstractGraph.remove((IlvGraphic)this);
            abstractGraph.removeManagerContentChangedListener(this);
        }
    }

    private void initOrientedIcon() {
        this.placeOrientedIcon();
    }

    public void placeOrientedIcon() {
        if (!this.getLinkClass().equals("OTS")) {
            return;
        }
        double d = this.needRotation();
        if (d != 0.0) {
            this.linkIcon.mirror(d);
            this.reDraw();
        }
    }

    private double needRotation() {
        double d = MapObjectAdapter.getCenterX(this.getFrom());
        double d2 = MapObjectAdapter.getCenterX(this.getTo());
        double d3 = MapObjectAdapter.getCenterY(this.getFrom());
        double d4 = MapObjectAdapter.getCenterY(this.getTo());
        IlvPoint ilvPoint = new IlvPoint();
        IlvPoint ilvPoint2 = new IlvPoint();
        this.getConnectionPoints(ilvPoint, ilvPoint2, null);
        if (this.portSource instanceof ViewPortGraphic) {
            d = ilvPoint.getX();
            d3 = ilvPoint.getY();
        }
        if (this.portDst instanceof ViewPortGraphic) {
            d2 = ilvPoint2.getX();
            d4 = ilvPoint2.getY();
        }
        double d5 = 0.0;
        double d6 = 0.0;
        boolean bl = Math.abs(d - d2) <= 70.0;
        d5 = bl ? this.verticalRotation(d3, d4) : this.orrizontalRotation(d, d2);
        return d5 + d6;
    }

    private double verticalRotation(double d, double d2) {
        double d3 = 0.0 - this.linkIcon.getCurrentRotation();
        double d4 = 0.0;
        d4 = d < d2 ? d3 + 90.0 : d3 + -90.0;
        return d4;
    }

    private double orrizontalRotation(double d, double d2) {
        double d3 = 0.0 - this.linkIcon.getCurrentRotation();
        double d4 = 0.0;
        d4 = d > d2 ? d3 + 180.0 : d3 + 0.0;
        return d4;
    }

    public void placeDwdmSide(int n) throws FunctException {
        try {
            if ((this.getLinkClass().equals("OTS") || this.getLinkClass().equals("PPC")) && this.actualNetLink instanceof FunctNetMapLink) {
                ArrayList<String> arrayList;
                FunctNetMapLink functNetMapLink = (FunctNetMapLink)this.actualNetLink;
                if (this.sideLabel == null) {
                    this.sideLabel = functNetMapLink.getSideLabel();
                }
                if (this.srcSideLabelConstrain == null) {
                    this.srcSideLabelConstrain = new IlvAttachmentConstraint(IlvAttachmentLocation.CenterPostOrderFirst, this.attachFrom[this.linkType]);
                }
                if (this.dstSideLabelConstrain == null) {
                    this.dstSideLabelConstrain = new IlvAttachmentConstraint(IlvAttachmentLocation.CenterPostOrderFirst, this.attachTo[this.linkType]);
                }
                this.srcSideLabel = new MapLabel();
                this.dstSideLabel = new MapLabel();
                this.srcSideLabel.setText(this.sideLabel.getSrcSideLabel().getText());
                this.srcSideLabel.setFont(AbstractLink.getAnnotationFont());
                this.dstSideLabel.setText(this.sideLabel.getDstSideLabel().getText());
                this.dstSideLabel.setFont(AbstractLink.getAnnotationFont());
                MapLabel mapLabel = null;
                if (this.src instanceof ViewCardGrapher && ((ViewCardGrapher)this.src).getCardModel() != null && (arrayList = this.sidesOfCard((ViewCardGrapher)this.src)).contains(this.srcSideLabel.getText())) {
                    mapLabel = this.srcSideLabel;
                    this.srcSideLabel = this.dstSideLabel;
                    this.dstSideLabel = mapLabel;
                }
                if (this.dst instanceof ViewCardGrapher && ((ViewCardGrapher)this.dst).getCardModel() != null && (arrayList = this.sidesOfCard((ViewCardGrapher)this.dst)).contains(this.dstSideLabel.getText())) {
                    mapLabel = this.srcSideLabel;
                    this.srcSideLabel = this.dstSideLabel;
                    this.dstSideLabel = mapLabel;
                }
                if (this.isTxLink) {
                    this.setChildren(++n, (IlvGraphic)this.srcSideLabel);
                    this.setConstraints(n, this.srcSideLabelConstrain);
                    this.setChildren(++n, (IlvGraphic)this.dstSideLabel);
                    this.setConstraints(n, this.dstSideLabelConstrain);
                    this.srcSideLabel.setVisible(true);
                    this.dstSideLabel.setVisible(true);
                }
            }
        }
        catch (Exception exception) {
            throw new FunctException("Error in Side Icon");
        }
    }

    private ArrayList<String> sidesOfCard(ViewCardGrapher viewCardGrapher) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = viewCardGrapher.getCardModel().getSide();
        arrayList.add(DwdmSide.getSideLabelFromOffset(n));
        List list = ((ViewDomainGrapher)viewCardGrapher.getGraphParent()).getOtherSides();
        if (list.size() > 0) {
            for (IFvSideModel iFvSideModel : list) {
                arrayList.add(iFvSideModel.getNameLabel());
            }
        }
        return arrayList;
    }

    public void setLinkVisible(final boolean bl) {
        this.getGraphicBag().applyToObject((IlvGraphic)this, new IlvApplyObject(){

            public void apply(IlvGraphic ilvGraphic, Object object) {
                ilvGraphic.setVisible(bl);
                if (InterGraphLink.this.srcSideLabel != null) {
                    InterGraphLink.this.srcSideLabel.setVisible(bl);
                    InterGraphLink.this.srcSideLabel.reDraw();
                }
                if (InterGraphLink.this.dstSideLabel != null) {
                    InterGraphLink.this.dstSideLabel.setVisible(bl);
                    InterGraphLink.this.dstSideLabel.reDraw();
                }
                ilvGraphic.reDraw();
            }
        }, null, true);
    }

    public AbstractLink getActualNetLink() {
        return this.actualNetLink;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == PWR_CMD) {
            this.orgLinkHiddenFromHere = true;
            SpanLossBalloon.getInstance().startCalculation(this);
        } else if (string == FLIP_CMD) {
            this.safeRotateBalloons();
        }
    }

    public void onInitPopupMenu(UPopupMenu uPopupMenu) {
        this.actOrg = new ActionOrganizer(this);
        this.initPopupMenu(uPopupMenu);
        this.mtk.initPopupMenu(this, this.actOrg, uPopupMenu);
        this.actOrg = null;
    }

    protected void initPopupMenu(UPopupMenu uPopupMenu) {
        if (this.hasSpanLossBalloon) {
            this.actOrg.addMenuItem((JComponent)uPopupMenu, null, PWR_CMD, 79);
            this.actOrg.addMenuItem((JComponent)uPopupMenu, null, FLIP_CMD, 70);
        }
    }

    public void setBalloonUnderCircuit(boolean bl) {
        this.isOnCircuit = bl;
    }

    public void setAssociatedSrc(IlvGraphic ilvGraphic) {
        this.actualAssSrc = ilvGraphic;
    }

    public IlvGraphic getAssociatedSrc() {
        return this.actualAssSrc;
    }

    public void setAssociatedDst(IlvGraphic ilvGraphic) {
        this.actualAssDst = ilvGraphic;
    }

    public IlvGraphic getAssociatedDst() {
        return this.actualAssDst;
    }

    public boolean isBalloonOpened() {
        return this.balloonOpened;
    }

    public void spanLossIsReady() {
        this.showBalloon(!this.balloonOpened);
    }

    public void powerPortIsReady() {
    }

    public ArrayList<Integer> getConnectedNodeId() {
        ViewManagerToolKit viewManagerToolKit;
        FvMapGraph fvMapGraph;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (this.portSource instanceof FvMapGraph) {
            fvMapGraph = (FvMapGraph)this.portSource;
            arrayList.add(fvMapGraph.getNode().getNodeId());
        } else if (this.portSource instanceof ViewPortGraphic && (viewManagerToolKit = (fvMapGraph = (ViewPortGraphic)this.portSource).getToolKit()) != null) {
            arrayList.add(viewManagerToolKit.getNodeModel().getNodeId());
        }
        if (this.portDst instanceof FvMapGraph) {
            fvMapGraph = (FvMapGraph)this.portDst;
            arrayList.add(fvMapGraph.getNode().getNodeId());
        } else if (this.portDst instanceof ViewPortGraphic && (viewManagerToolKit = (fvMapGraph = (ViewPortGraphic)this.portDst).getToolKit()) != null) {
            arrayList.add(viewManagerToolKit.getNodeModel().getNodeId());
        }
        return arrayList;
    }

    public boolean connectNode(int n) {
        boolean bl = false;
        ArrayList<Integer> arrayList = this.getConnectedNodeId();
        for (Integer n2 : arrayList) {
            if (bl) continue;
            bl = n2 == n;
        }
        return bl;
    }

    public void safeSetChildren(int n, IlvGraphic ilvGraphic, int n2, IlvAttachmentConstraint ilvAttachmentConstraint) {
        IlvGraphicBag ilvGraphicBag = this.getGraphicBag();
        if (ilvGraphicBag == null) {
            this.setChildren(n, ilvGraphic);
            if (n2 != -1) {
                this.setConstraints(n2, ilvAttachmentConstraint);
            }
        } else {
            IlvManager ilvManager;
            IlvManager ilvManager2 = ilvManager = ilvGraphicBag instanceof IlvManager ? (IlvManager)ilvGraphicBag : null;
            if (ilvManager != null) {
                ilvManager.setContentsAdjusting(true, true);
            }
            ilvGraphicBag.applyToObject((IlvGraphic)this, (IlvApplyObject)new SetChildren(n, ilvGraphic, n2, ilvAttachmentConstraint), (Object)this, true);
            if (ilvManager != null) {
                ilvManager.setContentsAdjusting(false, true);
            }
        }
    }

    public void safeRotateBalloons() {
        if (this.spanLossInfoBalloon == null) {
            return;
        }
        IlvGraphicBag ilvGraphicBag = this.getGraphicBag();
        if (ilvGraphicBag == null) {
            IlvAttachmentConstraint ilvAttachmentConstraint = (IlvAttachmentConstraint)this.getConstraints(this.spanLossChildIndex);
            if (ilvAttachmentConstraint.getHotSpot() == IlvAttachmentLocation.BottomCenter) {
                ilvAttachmentConstraint.setHotSpot(IlvAttachmentLocation.TopCenter);
                this.spanLossInfoBalloon.setOrientation(6);
            } else {
                ilvAttachmentConstraint.setHotSpot(IlvAttachmentLocation.BottomCenter);
                this.spanLossInfoBalloon.setOrientation(2);
            }
            this.setConstraints(this.spanLossChildIndex, ilvAttachmentConstraint);
            this.doLayout();
        } else {
            IlvManager ilvManager;
            IlvManager ilvManager2 = ilvManager = ilvGraphicBag instanceof IlvManager ? (IlvManager)ilvGraphicBag : null;
            if (ilvManager != null) {
                ilvManager.setContentsAdjusting(true, true);
            }
            ilvGraphicBag.applyToObject((IlvGraphic)this, new IlvApplyObject(){

                public void apply(IlvGraphic ilvGraphic, Object object) {
                    IlvAttachmentConstraint ilvAttachmentConstraint = (IlvAttachmentConstraint)((InterGraphLink)ilvGraphic).getConstraints(InterGraphLink.this.spanLossChildIndex);
                    if (ilvAttachmentConstraint.getHotSpot() == IlvAttachmentLocation.BottomCenter) {
                        ilvAttachmentConstraint.setHotSpot(IlvAttachmentLocation.TopCenter);
                        InterGraphLink.this.spanLossInfoBalloon.setOrientation(6);
                    } else {
                        ilvAttachmentConstraint.setHotSpot(IlvAttachmentLocation.BottomCenter);
                        InterGraphLink.this.spanLossInfoBalloon.setOrientation(2);
                    }
                    ((InterGraphLink)ilvGraphic).setConstraints(InterGraphLink.this.spanLossChildIndex, ilvAttachmentConstraint);
                    ((InterGraphLink)ilvGraphic).doLayout();
                }
            }, (Object)this, true);
            if (ilvManager != null) {
                ilvManager.setContentsAdjusting(false, true);
            }
        }
    }

    static class SetChildren
    implements IlvApplyObject {
        IlvGraphic children;
        int index;
        int indexConstraints;
        IlvAttachmentConstraint constraints;

        SetChildren(int n, IlvGraphic ilvGraphic, int n2, IlvAttachmentConstraint ilvAttachmentConstraint) {
            this.children = ilvGraphic;
            this.index = n;
            this.indexConstraints = n2;
            this.constraints = ilvAttachmentConstraint;
        }

        public void apply(IlvGraphic ilvGraphic, Object object) {
            ((IlvCompositeLink)ilvGraphic).setChildren(this.index, this.children);
            if (this.indexConstraints != -1) {
                ((IlvCompositeLink)ilvGraphic).setConstraints(this.indexConstraints, (Object)this.constraints);
            }
        }
    }
}

