/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc.util.map;

import cerent.util.IDebugDiag;
import cerent.util.KDebug;
import cerent.util.SDebug;
import com.cisco.ctc.util.map.Link;
import com.cisco.ctc.util.map.LinkBundle;
import com.cisco.ctc.util.map.MapLink;
import com.cisco.ctc.util.map.MapLinkBundle;
import com.cisco.ctc.util.map.MapNode;
import com.cisco.ctc.util.map.MapToolkit;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

public class MTKDebug
extends SDebug
implements IDebugDiag {
    private MapToolkit mtk;

    MTKDebug(SDebug sDebug, MapToolkit mapToolkit) {
        super((KDebug)sDebug, "mtk");
        this.mtk = mapToolkit;
    }

    public final void links() {
        Collection collection = this.mtk.getLinkUserObjects();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            MapLink mapLink = this.mtk.getMapLink(iterator.next());
            if (mapLink == null) continue;
            this.println(mapLink.toString());
        }
    }

    public final void bundles() {
        Object object;
        Object object22;
        Collection collection = this.mtk.getBundleKeys();
        this.println("# of link bundles: " + collection.size());
        for (Object object22 : collection) {
            this.println("bundle key: '" + (String)object22 + "'");
            object = this.mtk.getLinkBundle((String)object22);
            this.printLinkBundle((LinkBundle)object, 0);
        }
        Collection collection2 = this.mtk.getMapBundleKeys();
        this.println("# of map link bundle classes: " + collection2.size());
        object22 = collection2.iterator();
        while (object22.hasNext()) {
            object = (String)object22.next();
            this.println("mbundle (link class) key: '" + (String)object + "'");
            Map map = this.mtk.getMapLinkBundle((String)object);
            if (map == null) continue;
            int n = 0;
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                this.println("mbundle #" + n);
                MapLinkBundle mapLinkBundle = (MapLinkBundle)map.get(iterator.next());
                this.printLinkBundle(mapLinkBundle, 0);
                ++n;
            }
        }
    }

    private void printLinkBundle(LinkBundle linkBundle, int n) {
        if (linkBundle == null) {
            return;
        }
        Link[] linkArray = linkBundle.getLinks();
        int n2 = linkArray == null ? 0 : linkArray.length;
        this.printIndent(n);
        this.println("bundle: " + linkBundle + " with " + n2 + " links");
        for (int i = 0; i < n2; ++i) {
            Link link = linkArray[i];
            if (link instanceof MapLinkBundle) {
                this.printLinkBundle((MapLinkBundle)link, n + 2);
                continue;
            }
            this.printIndent(n + 2);
            this.println(linkArray[i].toString());
        }
    }

    private void printLinkBundle(MapLinkBundle mapLinkBundle, int n) {
        if (mapLinkBundle == null) {
            return;
        }
        MapLink[] mapLinkArray = mapLinkBundle.getLinks();
        int n2 = mapLinkArray == null ? 0 : mapLinkArray.length;
        this.printIndent(n);
        this.println("map bundle: " + mapLinkBundle + " with " + n2 + " links");
        for (int i = 0; i < n2; ++i) {
            MapLink mapLink = mapLinkArray[i];
            this.printIndent(n + 2);
            this.println(mapLinkArray[i].toString());
        }
    }

    private void printIndent(int n) {
        for (int i = 0; i < n; ++i) {
            this.print(" ");
        }
    }

    public final void nodes() {
        MapNode[] mapNodeArray = this.mtk.getMapNodes();
        for (int i = 0; i < mapNodeArray.length; ++i) {
            this.println("node=" + mapNodeArray[i].getName() + " ID=" + mapNodeArray[i].getID());
        }
    }

    public void dumpDiag() {
        this.nodes();
        this.links();
    }

    public void println(String string) {
        if (this.on()) {
            super.println(string);
        }
    }
}

