/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc.util.map;

import cerent.util.SDebug;
import com.cisco.ctc.util.map.AbstractGraph;
import com.cisco.ctc.util.map.MapObjectAdapter;
import ilog.views.IlvGraphic;
import ilog.views.IlvPoint;
import ilog.views.graphic.IlvIcon;
import java.awt.Image;
import java.net.URL;
import javax.swing.ImageIcon;

public class MapImage
extends IlvIcon {
    private double rotatedAngle = 0.0;

    public MapImage(Image image) {
        super.setImage(image);
        super.setAutoResizing(true);
    }

    public MapImage(URL uRL) {
        ImageIcon imageIcon;
        if (uRL != null && (imageIcon = new ImageIcon(uRL)) != null) {
            super.setImage(imageIcon.getImage());
            super.setAutoResizing(true);
        }
    }

    public Image getImage() {
        return super.getImage();
    }

    public AbstractGraph getGraph() {
        return (AbstractGraph)super.getGraphicBag();
    }

    public void setCenter(double d, double d2) {
        MapObjectAdapter.setCenter(this.getGraph(), (IlvGraphic)this, d, d2);
    }

    public void setLocation(double d, double d2) {
        MapObjectAdapter.setLocation(this.getGraph(), (IlvGraphic)this, d, d2);
    }

    public double getCenterX() {
        return MapObjectAdapter.getCenterX((IlvGraphic)this);
    }

    public double getCenterY() {
        return MapObjectAdapter.getCenterY((IlvGraphic)this);
    }

    public double getWidth() {
        return MapObjectAdapter.getWidth((IlvGraphic)this);
    }

    public double getHeight() {
        return MapObjectAdapter.getHeight((IlvGraphic)this);
    }

    public void resize(float f, float f2) {
    }

    public void setRotation(double d) {
        if (this.rotatedAngle != 0.0) {
            double d2 = 360.0 - this.rotatedAngle;
            super.rotate(new IlvPoint((float)this.getCenterX(), (float)this.getCenterY()), d2);
        }
        this.rotatedAngle = d;
        super.rotate(new IlvPoint((float)this.getCenterX(), (float)this.getCenterY()), d);
    }

    public void mirror(double d) {
        this.rotatedAngle += d;
        super.rotate(new IlvPoint((float)this.getCenterX(), (float)this.getCenterY()), d);
        if (this.rotatedAngle >= 360.0) {
            this.rotatedAngle = 0.0;
        }
    }

    public double getCurrentRotation() {
        return this.rotatedAngle;
    }

    public static Image createImage(String string) {
        Image image = null;
        try {
            URL uRL = MapImage.class.getResource(string);
            image = new ImageIcon(uRL).getImage();
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
        return image;
    }
}

