/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc.util.map;

import com.cisco.ctc.util.map.AbstractGraph;
import com.cisco.ctc.util.map.AbstractLink;
import com.cisco.ctc.util.map.AbstractNode;
import com.cisco.ctc.util.map.MapTransformer;
import com.cisco.fv.grapher.util.FvMapGraph;
import ilog.views.IlvLinkImage;
import ilog.views.IlvPoint;
import ilog.views.IlvTransformer;
import ilog.views.linkconnector.IlvDefaultGrapherPin;
import ilog.views.linkconnector.IlvGrapherPin;
import ilog.views.linkconnector.IlvPinLinkConnector;
import java.awt.geom.Point2D;

public class MapLinkConnector
extends IlvDefaultGrapherPin {
    private AbstractNode node;
    private AbstractGraph graphNode;
    private AbstractLink link = null;
    private IlvPinLinkConnector c;

    MapLinkConnector(AbstractNode abstractNode, float f, float f2) {
        super(abstractNode.getLinkConnectorBag(), new IlvPoint(f + (float)abstractNode.boundingBox().getX(), f2 + (float)abstractNode.boundingBox().getY()), abstractNode.getGraph().getTransformer());
        this.node = abstractNode;
        this.c = abstractNode.getLinkConnectorBag();
    }

    public MapLinkConnector(FvMapGraph fvMapGraph, float f, float f2) {
        super(fvMapGraph.getLinkConnectorBag(), new IlvPoint(f + (float)fvMapGraph.boundingBox().getX(), f2 + (float)fvMapGraph.boundingBox().getY()), fvMapGraph.getParent().getTransformer());
        this.graphNode = fvMapGraph;
        this.c = fvMapGraph.getLinkConnectorBag();
    }

    public void attach(AbstractLink abstractLink) {
        boolean bl = abstractLink.getFrom() == this.node;
        this.c.connectLink((IlvLinkImage)abstractLink, (IlvGrapherPin)this, bl);
        if (bl) {
            abstractLink.setSourceConnector(this);
        } else {
            abstractLink.setTargetConnector(this);
        }
        this.link = abstractLink;
    }

    void detach(AbstractLink abstractLink) {
        boolean bl = abstractLink.getFrom() == this.node || abstractLink.getFrom() == this.graphNode;
        this.c.disconnectLink((IlvLinkImage)abstractLink, bl);
        if (bl) {
            abstractLink.setSourceConnector(null);
        } else {
            abstractLink.setTargetConnector(null);
        }
        this.link = null;
    }

    public void setCenter(double d, double d2) {
        this.setCenter(new Point2D.Float((float)d, (float)d2));
        if (this.link != null) {
            this.link.placeIcons();
        }
    }

    public void setCenter(Point2D point2D) {
        IlvPoint ilvPoint = new IlvPoint((float)point2D.getX() + this.getXOffset(), (float)point2D.getY() + this.getYOffset());
        super.setPosition(ilvPoint, this.node.getGraph().getTransformer());
        if (this.link != null) {
            this.link.placeIcons();
        }
    }

    Point2D translateWorldToLocal(Point2D point2D) {
        float f = (float)point2D.getX();
        float f2 = (float)point2D.getY();
        float f3 = this.getXOffset();
        float f4 = this.getYOffset();
        return new Point2D.Float(f - f3, f2 - f4);
    }

    Point2D getWorldPoint(MapTransformer mapTransformer) {
        IlvTransformer ilvTransformer = mapTransformer == null ? this.node.getGraph().getTransformer() : mapTransformer.getTransform();
        IlvPoint ilvPoint = this.getPosition(ilvTransformer);
        return new Point2D.Double(ilvPoint.getX(), ilvPoint.getY());
    }

    private float getXOffset() {
        return (float)this.node.boundingBox().getX();
    }

    private float getYOffset() {
        return (float)this.node.boundingBox().getY();
    }

    public double getCenterX() {
        IlvPoint ilvPoint = this.getPosition(this.node.getGraph().getTransformer());
        return ilvPoint.getX() - (double)this.getXOffset();
    }

    public double getCenterY() {
        IlvPoint ilvPoint = this.getPosition(this.node.getGraph().getTransformer());
        return ilvPoint.getY() - (double)this.getYOffset();
    }

    public AbstractNode getConnectedNode() {
        return this.node;
    }
}

