/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc.util.map;

import cerent.cms.model.IModel;
import cerent.cms.model.INodeAdapter;
import cerent.cms.model.INodeModel;
import cerent.cms.model.ModelReachabilityAdapter;
import cerent.cms.model.NetworkModel;
import cerent.util.IReachabilityAdapter;
import cerent.util.Pair;
import cerent.util.ReachabilityNavigator;
import cerent.util.SDebug;
import cerent.util.gui.UFrame;
import com.cisco.ctc.util.map.AbstractView;
import com.cisco.ctc.util.map.DefaultMapFactory;
import com.cisco.ctc.util.map.IMapFactory;
import com.cisco.ctc.util.map.MapNode;
import com.cisco.ctc.util.map.MapToolkit;
import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ReachabilityMapToolkit
extends MapToolkit {
    private Object rootObject;
    private HashMap<MapNode, MapNode> mapNodeNeighbors;
    private float siblingOffset;
    static final SDebug db = new Debug("ReachabilityMapToolkit");

    public ReachabilityMapToolkit(SDebug sDebug, IMapFactory iMapFactory, IReachabilityAdapter iReachabilityAdapter, Object object, Map<? extends Object, ? extends Object> map, float f) {
        super(sDebug, iMapFactory);
        this.rootObject = object;
        this.mapNodeNeighbors = new HashMap();
        this.siblingOffset = f;
        this.populate(map, iReachabilityAdapter);
    }

    private void populate(Map<? extends Object, ? extends Object> map, IReachabilityAdapter iReachabilityAdapter) {
        Set<? extends Object> set2 = map.keySet();
        for (Object set3 : set2) {
            MapNode mapNode = this.addNode(set3, "", 0.0, 0.0, set3);
            mapNode.setColor(Color.white);
            mapNode.setDesc(iReachabilityAdapter.getNodeLabel(set3));
        }
        Object object = this.getDebug();
        Set<? extends Object> set = map.keySet();
        for (Object e : set) {
            Object object2 = map.get(e);
            if (object2 == null) continue;
            MapNode mapNode = this.getMapNode(e);
            MapNode mapNode2 = this.getMapNode(object2);
            object.println("west: " + mapNode + " ; east: " + mapNode2);
            this.mapNodeNeighbors.put(mapNode, mapNode2);
        }
    }

    public void addLinks(Set<Pair<? extends Object, ? extends Object>> set) {
        String string = "cerent.util.Pair";
        for (Pair<? extends Object, ? extends Object> pair : set) {
            this.addLink(pair, pair.getFirst(), pair.getSecond(), string, null);
        }
    }

    @Override
    protected void doLayoutAlgorithm(Rectangle2D rectangle2D) {
        this.doLayoutAlgorithm();
    }

    public void doLayoutAlgorithm() {
        this.doTreeLayout(this.getMapNode(this.rootObject), this.mapNodeNeighbors, this.siblingOffset);
    }

    @Override
    void postAutoLayout() {
    }

    private static Pair<Map<?, ?>, Set<Pair<? extends Object, ? extends Object>>> create(IReachabilityAdapter iReachabilityAdapter) {
        ReachabilityNavigator reachabilityNavigator = new ReachabilityNavigator(iReachabilityAdapter).init();
        return new Pair((Object)reachabilityNavigator.getWestEastNeighbors(), (Object)reachabilityNavigator.getNodeAdajencies());
    }

    public static class Debug
    extends SDebug {
        public Debug(String string) {
            super(string);
        }

        public final void displayGraph(String string, String string2, int n) throws Exception {
            UFrame uFrame2;
            Set set;
            Object object2;
            INodeModel iNodeModel = NetworkModel.instance().getCmsHostModel();
            this.println("Found node: " + iNodeModel);
            if (iNodeModel == null) {
                return;
            }
            INodeAdapter iNodeAdapter = iNodeModel.getNodeAdapter();
            IModel iModel = iNodeAdapter.getModel(string2, n);
            IReachabilityAdapter iReachabilityAdapter = ModelReachabilityAdapter.createModelReachabilityAdapter((IModel)iModel, (String)string);
            Pair pair = ReachabilityMapToolkit.create(iReachabilityAdapter);
            Map map = (Map)pair.getFirst();
            Set set2 = map.keySet();
            Set set3 = (Set)pair.getSecond();
            if (db.on()) {
                this.println("# nodes: " + set2.size());
                this.println("# links: " + set3.size());
                for (Object object2 : set3) {
                    this.println("  " + object2);
                }
                set = map.keySet();
                for (UFrame uFrame2 : set) {
                    Object v = map.get(uFrame2);
                    if (v != null) {
                        db.println("west: " + uFrame2 + " ; east: " + v);
                        continue;
                    }
                    db.println("west only: " + uFrame2);
                }
            }
            set = new DefaultMapFactory(){

                @Override
                public MapNode createNode(MapToolkit mapToolkit, boolean bl, final Object object) {
                    return new MapNode(mapToolkit){

                        @Override
                        protected float getDefaultWidth() {
                            return super.getDefaultWidth() / 4.0f;
                        }

                        @Override
                        protected float getDefaultHeight() {
                            return super.getDefaultWidth() / 4.0f;
                        }

                        @Override
                        public String toString() {
                            return "MAP node to: " + object;
                        }
                    };
                }
            };
            object2 = new ReachabilityMapToolkit(db, (IMapFactory)((Object)set), iReachabilityAdapter, iModel, (Map)pair.getFirst(), 20.0f);
            ((ReachabilityMapToolkit)object2).addLinks(set3);
            ((ReachabilityMapToolkit)object2).doLayoutAlgorithm();
            uFrame2 = new UFrame(((AbstractView)((Object)object2)).getGraphWindow(), iReachabilityAdapter.getGraphTitle(), false, null);
            uFrame2.display();
        }
    }
}

