/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc.util.map.linkbundle;

import cerent.util.SDebug;
import com.cisco.ctc.util.map.linkbundle.IlvLinkBundle;
import com.cisco.ctc.util.map.linkbundle.IlvLinkBundleFrame;
import com.cisco.ctc.util.map.linkbundle.IlvLinkBundleLayoutManager;
import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicUtil;
import ilog.views.IlvLinkImage;
import ilog.views.IlvPoint;
import ilog.views.IlvPolyPointsInterface;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.IlvUtil;
import ilog.views.graphic.IlvSplineLinkImage;
import ilog.views.internal.impl.IlvUtility2D;
import ilog.views.io.IlvFieldNotFoundException;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvPersistentObject;
import ilog.views.io.IlvReadFileException;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.Serializable;

public class IlvDefaultLinkBundleFrame
implements IlvLinkBundleFrame,
Serializable,
IlvPersistentObject {
    private static final float DEFAULT_MARGIN = 5.0f;
    private static final Color DEFAULT_BACKGROUND = Color.green;
    private static final float CONTAINS_THRESHOLD = IlvUtil.GetDeltaLine();
    private float _margin = 5.0f;
    private Paint _background = DEFAULT_BACKGROUND;
    private IlvPoint[] _smoothBezierPoints;

    public IlvDefaultLinkBundleFrame() {
    }

    public IlvDefaultLinkBundleFrame(IlvDefaultLinkBundleFrame ilvDefaultLinkBundleFrame) {
        this.setMargin(ilvDefaultLinkBundleFrame.getMargin());
        this.setBackground(ilvDefaultLinkBundleFrame.getBackground());
    }

    @Override
    public IlvLinkBundleFrame copy() {
        return new IlvDefaultLinkBundleFrame(this);
    }

    public IlvDefaultLinkBundleFrame(IlvInputStream ilvInputStream) throws IOException, IlvReadFileException {
        try {
            this._margin = ilvInputStream.readFloat("margin");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            SDebug.printStackTrace((Throwable)ilvFieldNotFoundException);
        }
        this._background = IlvUtility2D.readPaint((IlvInputStream)ilvInputStream);
    }

    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        if (this._margin != 5.0f) {
            ilvOutputStream.write("margin", this._margin);
        }
        IlvUtility2D.writePaint((IlvOutputStream)ilvOutputStream, (Paint)this._background);
    }

    @Override
    public float getMargin(IlvLinkBundle ilvLinkBundle, IlvTransformer ilvTransformer) {
        return ilvTransformer == null ? this._margin : this._margin * (float)ilvTransformer.zoomFactor();
    }

    @Override
    public IlvRect boundingBox(IlvLinkBundle ilvLinkBundle, IlvTransformer ilvTransformer) {
        Rectangle2D rectangle2D = this.drawOrComputeBundleFrameShape(null, ilvLinkBundle, ilvTransformer, false).getBounds2D();
        return new IlvRect((float)rectangle2D.getX(), (float)rectangle2D.getY(), (float)rectangle2D.getWidth(), (float)rectangle2D.getHeight());
    }

    public float getMargin() {
        return this._margin;
    }

    public void setMargin(float f) {
        this._margin = f;
    }

    public Paint getBackground() {
        return this._background;
    }

    public void setBackground(Paint paint) {
        this._background = paint;
    }

    @Override
    public void draw(IlvLinkBundle ilvLinkBundle, Graphics graphics, IlvTransformer ilvTransformer) {
        this.drawOrComputeBundleFrameShape((Graphics2D)graphics, ilvLinkBundle, ilvTransformer, true);
    }

    private Shape drawOrComputeBundleFrameShape(Graphics2D graphics2D, IlvLinkBundle ilvLinkBundle, IlvTransformer ilvTransformer, boolean bl) {
        IlvLinkImage ilvLinkImage;
        int n;
        int n2 = ilvLinkBundle.getSublinksCount();
        GeneralPath generalPath = new GeneralPath();
        IlvGraphic ilvGraphic = ilvLinkBundle.getFrom();
        IlvGraphic ilvGraphic2 = ilvLinkBundle.getTo();
        IlvLinkBundle ilvLinkBundle2 = null;
        IlvLinkBundle ilvLinkBundle3 = null;
        if (n2 > 0) {
            ilvLinkBundle2 = ilvLinkBundle.getSublink(0);
            ilvLinkBundle3 = n2 > 1 ? ilvLinkBundle.getSublink(n2 - 1) : ilvLinkBundle2;
        } else {
            ilvLinkBundle3 = ilvLinkBundle2 = ilvLinkBundle;
        }
        IlvLinkBundleLayoutManager ilvLinkBundleLayoutManager = ilvLinkBundle.getLayoutManager();
        IlvPolyPointsInterface ilvPolyPointsInterface = ilvLinkBundleLayoutManager.getMargin(ilvLinkBundle, true, ilvTransformer);
        IlvPolyPointsInterface ilvPolyPointsInterface2 = ilvLinkBundleLayoutManager.getMargin(ilvLinkBundle, false, ilvTransformer);
        IlvPoint ilvPoint = this.getConnectionPoint((IlvLinkImage)ilvLinkBundle2, ilvGraphic, ilvTransformer);
        generalPath.moveTo(ilvPoint.x, ilvPoint.y);
        for (n = 1; n < n2; ++n) {
            ilvLinkImage = ilvLinkBundle.getSublink(n);
            ilvPoint = this.getConnectionPoint(ilvLinkImage, ilvGraphic, ilvTransformer);
            generalPath.lineTo(ilvPoint.x, ilvPoint.y);
        }
        n = 0;
        float f = 0.0f;
        boolean bl2 = false;
        IlvPoint[] ilvPointArray = this.getPoints(ilvPolyPointsInterface2, null, bl2);
        if (ilvLinkBundle3 instanceof IlvSplineLinkImage) {
            n = 1;
            f = ((IlvSplineLinkImage)ilvLinkBundle3).getSmoothness();
        }
        Shape shape = n != 0 ? this.createSplineShape(ilvPointArray, f, bl2) : this.createPolylineShape(ilvPointArray, bl2);
        generalPath.append(shape, true);
        ilvPoint = this.getConnectionPoint((IlvLinkImage)ilvLinkBundle3, ilvGraphic2, ilvTransformer);
        generalPath.lineTo(ilvPoint.x, ilvPoint.y);
        for (int i = n2 - 2; i >= 0; --i) {
            ilvLinkImage = ilvLinkBundle.getSublink(i);
            ilvPoint = this.getConnectionPoint(ilvLinkImage, ilvGraphic2, ilvTransformer);
            generalPath.lineTo(ilvPoint.x, ilvPoint.y);
        }
        n = 0;
        f = 0.0f;
        bl2 = true;
        ilvPointArray = this.getPoints(ilvPolyPointsInterface, null, bl2);
        if (ilvLinkBundle2 instanceof IlvSplineLinkImage) {
            n = 1;
            f = ((IlvSplineLinkImage)ilvLinkBundle2).getSmoothness();
        }
        Shape shape2 = n != 0 ? this.createSplineShape(ilvPointArray, f, bl2) : this.createPolylineShape(ilvPointArray, bl2);
        generalPath.append(shape2, true);
        generalPath.closePath();
        if (bl) {
            Paint paint = this.getBackground();
            if (!(paint instanceof Color)) {
                graphics2D.setPaint(IlvUtility2D.AdaptPaint((Shape)generalPath, (Paint)paint));
            } else {
                graphics2D.setPaint(paint);
            }
            graphics2D.fill(generalPath);
        }
        return generalPath;
    }

    IlvPoint getConnectionPoint(IlvLinkImage ilvLinkImage, IlvGraphic ilvGraphic, IlvTransformer ilvTransformer) {
        if (ilvLinkImage.getFrom() == ilvGraphic) {
            return ilvLinkImage.getPointAt(0, ilvTransformer);
        }
        if (ilvLinkImage.getTo() == ilvGraphic) {
            return ilvLinkImage.getPointAt(ilvLinkImage.getPointsCardinal() - 1, ilvTransformer);
        }
        throw new RuntimeException("Node " + ilvGraphic + " is not the origin, nor the destination of " + ilvLinkImage);
    }

    private Shape createShape(IlvLinkBundle ilvLinkBundle, IlvTransformer ilvTransformer) {
        IlvLinkBundle ilvLinkBundle2 = ilvLinkBundle.isCollapsed() ? (ilvLinkBundle.getOverviewLink() != null ? ilvLinkBundle.getOverviewLink() : ilvLinkBundle) : ilvLinkBundle;
        return this.createShape((IlvLinkImage)ilvLinkBundle2, ilvTransformer);
    }

    private Shape createShape(IlvSplineLinkImage ilvSplineLinkImage, IlvGraphic ilvGraphic, IlvTransformer ilvTransformer) {
        boolean bl = ilvGraphic != ilvSplineLinkImage.getFrom();
        IlvPoint[] ilvPointArray = ilvSplineLinkImage.getLinkPoints(ilvTransformer);
        return this.createSplineShape(ilvPointArray, ilvSplineLinkImage.getSmoothness(), bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Shape createSplineShape(IlvPoint[] ilvPointArray, float f, boolean bl) {
        int n = ilvPointArray.length;
        GeneralPath generalPath = new GeneralPath();
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            IlvPoint ilvPoint;
            IlvPoint ilvPoint2;
            if (n > 2 && f != -1.0f) {
                this._smoothBezierPoints = IlvGraphicUtil.GetSmoothSpline((IlvPoint[])ilvPointArray, (int)n, (float)f, (boolean)false, (IlvPoint[])this._smoothBezierPoints);
                n = (n - 2) * 3 + 1;
                ilvPointArray = this._smoothBezierPoints;
            }
            int n2 = 3 * ((n - 1) / 3);
            IlvPoint ilvPoint3 = this.getPoint(ilvPointArray, 0, bl);
            generalPath.moveTo(ilvPoint3.x, ilvPoint3.y);
            int n3 = 1;
            while (n3 < n2) {
                ilvPoint2 = this.getPoint(ilvPointArray, n3++, bl);
                ilvPoint = this.getPoint(ilvPointArray, n3++, bl);
                IlvPoint ilvPoint4 = this.getPoint(ilvPointArray, n3++, bl);
                generalPath.curveTo(ilvPoint2.x, ilvPoint2.y, ilvPoint.x, ilvPoint.y, ilvPoint4.x, ilvPoint4.y);
            }
            if (n - ++n2 == 2) {
                ilvPoint2 = this.getPoint(ilvPointArray, n2, bl);
                ilvPoint = this.getPoint(ilvPointArray, n2 + 1, bl);
                generalPath.curveTo(ilvPoint2.x, ilvPoint2.y, ilvPoint2.x, ilvPoint2.y, ilvPoint.x, ilvPoint.y);
            } else if (n - n2 == 1) {
                ilvPoint3 = this.getPoint(ilvPointArray, n2, bl);
                generalPath.lineTo(ilvPoint3.x, ilvPoint3.y);
            }
        }
        return generalPath;
    }

    private IlvPoint getPoint(IlvPoint[] ilvPointArray, int n, boolean bl) {
        if (bl) {
            n = ilvPointArray.length - n - 1;
        }
        return ilvPointArray[n];
    }

    private Shape createShape(IlvLinkImage ilvLinkImage, IlvTransformer ilvTransformer) {
        return this.createShape(ilvLinkImage, ilvLinkImage.getFrom(), ilvTransformer);
    }

    private Shape createShape(IlvLinkImage ilvLinkImage, IlvGraphic ilvGraphic, IlvTransformer ilvTransformer) {
        if (ilvLinkImage instanceof IlvSplineLinkImage) {
            return this.createShape((IlvSplineLinkImage)ilvLinkImage, ilvGraphic, ilvTransformer);
        }
        if (ilvLinkImage instanceof IlvLinkBundle) {
            return this.createShape((IlvLinkBundle)ilvLinkImage, ilvTransformer);
        }
        boolean bl = ilvGraphic != ilvLinkImage.getFrom();
        return this.createPolylineShape((IlvPolyPointsInterface)ilvLinkImage, ilvTransformer, bl);
    }

    private IlvPoint[] getPoints(IlvPolyPointsInterface ilvPolyPointsInterface, IlvTransformer ilvTransformer, boolean bl) {
        int n = ilvPolyPointsInterface.getPointsCardinal();
        IlvPoint[] ilvPointArray = new IlvPoint[n];
        if (bl) {
            for (int i = 0; i < n; ++i) {
                ilvPointArray[i] = ilvPolyPointsInterface.getPointAt(i, ilvTransformer);
            }
        } else {
            for (int i = 0; i < n; ++i) {
                ilvPointArray[i] = ilvPolyPointsInterface.getPointAt(i, ilvTransformer);
            }
        }
        return ilvPointArray;
    }

    private Shape createPolylineShape(IlvPolyPointsInterface ilvPolyPointsInterface, IlvTransformer ilvTransformer, boolean bl) {
        GeneralPath generalPath = new GeneralPath();
        int n = ilvPolyPointsInterface.getPointsCardinal();
        if (bl) {
            IlvPoint ilvPoint = ilvPolyPointsInterface.getPointAt(n - 1, ilvTransformer);
            generalPath.moveTo(ilvPoint.x, ilvPoint.y);
            for (int i = n - 2; i >= 0; --i) {
                ilvPoint = ilvPolyPointsInterface.getPointAt(i, ilvTransformer);
                generalPath.lineTo(ilvPoint.x, ilvPoint.y);
            }
        } else {
            IlvPoint ilvPoint = ilvPolyPointsInterface.getPointAt(0, ilvTransformer);
            generalPath.moveTo(ilvPoint.x, ilvPoint.y);
            for (int i = 1; i < n; ++i) {
                ilvPoint = ilvPolyPointsInterface.getPointAt(i, ilvTransformer);
                generalPath.lineTo(ilvPoint.x, ilvPoint.y);
            }
        }
        return generalPath;
    }

    private Shape createPolylineShape(IlvPoint[] ilvPointArray, boolean bl) {
        GeneralPath generalPath = new GeneralPath();
        int n = ilvPointArray.length;
        if (bl) {
            generalPath.moveTo(ilvPointArray[n - 1].x, ilvPointArray[n - 1].y);
            for (int i = n - 2; i >= 0; --i) {
                generalPath.lineTo(ilvPointArray[i].x, ilvPointArray[i].y);
            }
        } else {
            generalPath.moveTo(ilvPointArray[0].x, ilvPointArray[0].y);
            for (int i = 1; i < n; ++i) {
                generalPath.lineTo(ilvPointArray[i].x, ilvPointArray[i].y);
            }
        }
        return generalPath;
    }

    @Override
    public boolean contains(IlvLinkBundle ilvLinkBundle, IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer) {
        IlvRect ilvRect = ilvLinkBundle.boundingBox(ilvTransformer);
        float f = this.getMargin() + CONTAINS_THRESHOLD;
        ilvRect.expand(f);
        if (!ilvRect.inside(ilvPoint2.x, ilvPoint2.y)) {
            return false;
        }
        Shape shape = this.drawOrComputeBundleFrameShape(null, ilvLinkBundle, ilvTransformer, false);
        return shape.contains(ilvPoint2.x, ilvPoint2.y);
    }
}

