/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.fv.alarms;

import cerent.cms.fv.net.IFvNetElement;
import cerent.cms.model.ICircuitId;
import cerent.cms.model.event.EventInfo;
import cerent.cms.model.event.NetworkAlarmStore;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.OchccCircuit;
import cerent.util.KDebug;
import cerent.util.job.IJobControl;
import cerent.util.job.IJobGroupListener;
import cerent.util.job.JobController;
import cerent.util.job.JobControllerFactory;
import cerent.util.job.JobGroup;
import cerent.util.job.JobStatus;
import com.cisco.fv.FunctViewManagerDelegate;
import com.cisco.fv.alarms.FVEventPanel;
import com.cisco.fv.alarms.FVPaintAlarm;
import com.cisco.fv.alarms.FvNetworkAlarmStore;
import com.cisco.fv.circuit.model.FvSelectedCircuitModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class FvCircuitAlarmStore
extends FvNetworkAlarmStore {
    private ArrayList<EventInfo> selectedList = new ArrayList();
    private FvNetworkAlarmStore nFvAlarmStore;
    private FvSelectedCircuitModel circuit;
    private boolean circuitMaskAlarm = false;
    private FVEventPanel eventPanel;
    private JobGroupalarm jobGroup;
    private KDebug taskDb = new KDebug("JobCircuitAlarm");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ArrayList<EventInfo> prepareList() {
        ArrayList<EventInfo> arrayList = this.selectedList;
        synchronized (arrayList) {
            return this.selectedList;
        }
    }

    public FvCircuitAlarmStore(NetworkAlarmStore networkAlarmStore) {
        super(networkAlarmStore, "FvCircuitAlarmStore");
        FVPaintAlarm.getInstance().addAlarmStore(this);
        this.nFvAlarmStore = FunctViewManagerDelegate.getAlarmStore();
        this.nFvAlarmStore.addCircuitalarmstore(this);
        this.stopTaskUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void newCircuit(FvSelectedCircuitModel fvSelectedCircuitModel) {
        ArrayList<EventInfo> arrayList = this.selectedList;
        synchronized (arrayList) {
            this.circuit = fvSelectedCircuitModel;
            this.jobGroup = new JobGroupalarm(true);
        }
    }

    @Override
    public int getRowCount() {
        int n = this.prepareList().size();
        return n;
    }

    @Override
    public void updateReceived() {
        super.updateReceived();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCircuits() {
        ArrayList<EventInfo> arrayList = this.selectedList;
        synchronized (arrayList) {
            this.clearList();
            this.circuit = null;
            this.filterForCircuit(false);
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        this.nFvAlarmStore = null;
        this.circuit = null;
        if (this.jobGroup != null) {
            this.jobGroup.dispose();
            this.jobGroup = null;
        }
    }

    public void repaintAlarms() {
        if (this.circuit == null) {
            return;
        }
        this.jobGroup = new JobGroupalarm(false);
    }

    public void filterForCircuit(boolean bl) {
        this.circuitMaskAlarm = bl;
    }

    @Override
    protected void clearList() {
        this.selectedList.clear();
        super.clearList();
    }

    public void addEventPanel(FVEventPanel fVEventPanel) {
        this.eventPanel = fVEventPanel;
    }

    private class JobCircuitAlarm
    implements IJobControl {
        EventInfo info;
        private int alarmNumber;
        private FvSelectedCircuitModel circuit;

        public JobCircuitAlarm(EventInfo eventInfo, FvSelectedCircuitModel fvSelectedCircuitModel, int n) {
            this.info = eventInfo;
            this.alarmNumber = n;
            this.circuit = fvSelectedCircuitModel;
        }

        public void abortJob() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public JobStatus executeJob() throws Exception {
            INetCircuit iNetCircuit = (INetCircuit)this.circuit.getCircuitModel();
            INetCircuit iNetCircuit2 = (INetCircuit)this.circuit.getCircuitModel(true);
            try {
                block14: {
                    block13: {
                        block11: {
                            block12: {
                                boolean bl = false;
                                ICircuitId iCircuitId = iNetCircuit.getCircuitId();
                                int n = iNetCircuit.getCircuitOptChannel();
                                if (FvCircuitAlarmStore.this.taskDb.on()) {
                                    FvCircuitAlarmStore.this.taskDb.println(".... workining on alarm #" + this.alarmNumber);
                                }
                                if (iNetCircuit2 instanceof OchccCircuit) {
                                    bl = true;
                                    iNetCircuit = iNetCircuit2;
                                    iCircuitId = iNetCircuit.getCircuitId();
                                } else {
                                    boolean bl2 = bl = this.info.getWavelength() == n || this.info.getWavelength() == -1;
                                }
                                if (!bl) break block11;
                                if (!FvCircuitAlarmStore.this.getFilterPane().circuitAlarm(this.info, iCircuitId)) break block12;
                                FvCircuitAlarmStore.this.selectedList.add(this.info);
                                if (FvCircuitAlarmStore.this.taskDb.on()) {
                                    FvCircuitAlarmStore.this.taskDb.println("#" + this.alarmNumber + "        that IS circuit impacted");
                                }
                                break block13;
                            }
                            FvCircuitAlarmStore.this.noCircuitAffected.add(this.info);
                            if (FvCircuitAlarmStore.this.taskDb.on()) {
                                FvCircuitAlarmStore.this.taskDb.println("#" + this.alarmNumber + " that IS NOT circuit impacted");
                            }
                            break block14;
                        }
                        FvCircuitAlarmStore.this.noCircuitAffected.add(this.info);
                        if (FvCircuitAlarmStore.this.taskDb.on()) {
                            FvCircuitAlarmStore.this.taskDb.println("#" + this.alarmNumber + " that IS NOT circuit impacted (impacted)");
                        }
                        break;
                    }
                }
            }
            catch (Exception exception) {
                KDebug.printStackTrace((Throwable)exception);
            }
            finally {
                return new JobStatus(4);
            }
        }

        public String getName() {
            return this.info.getCondDesc() + "  " + this.info.getShelfId() + "-" + this.info.getSlot() + "-" + this.info.getPort();
        }
    }

    private class JobGroupalarm
    implements IJobGroupListener {
        private JobController jobcontroller;
        List<JobCircuitAlarm> jobs = new ArrayList<JobCircuitAlarm>();

        public JobGroupalarm(boolean bl) {
            this.jobcontroller = JobControllerFactory.createJC((int)10);
            FvCircuitAlarmStore.this.clearList();
            this.spawnAllTasks();
        }

        public void dispose() {
            this.jobcontroller = null;
            this.jobs.clear();
            this.jobs = null;
        }

        private void spawnAllTasks() {
            ArrayList<EventInfo> arrayList = FvCircuitAlarmStore.this.nFvAlarmStore.getCircuitAffected();
            if (FvCircuitAlarmStore.this.taskDb.on()) {
                FvCircuitAlarmStore.this.taskDb.println("with a number of " + arrayList.size() + " alarms: ");
            }
            if (arrayList.size() == 0) {
                JobControllerFactory.disposeJC((JobController)this.jobcontroller);
                return;
            }
            int n = 0;
            HashMap<Integer, IFvNetElement> hashMap = FvCircuitAlarmStore.this.circuit.getUsedNode();
            for (EventInfo eventInfo : arrayList) {
                if (hashMap.containsKey(eventInfo.getNodeId())) {
                    this.jobs.add(new JobCircuitAlarm(eventInfo, FvCircuitAlarmStore.this.circuit, n));
                    ++n;
                    continue;
                }
                FvCircuitAlarmStore.this.noCircuitAffected.add(eventInfo);
                if (!FvCircuitAlarmStore.this.taskDb.on()) continue;
                FvCircuitAlarmStore.this.taskDb.println("#" + n + " on node NOT part of the circuit");
            }
            this.jobcontroller.submitJob(new JobGroup((IJobControl[])this.jobs.toArray(new JobCircuitAlarm[0]), (IJobGroupListener)this, null));
        }

        public void jobGroupFinished(JobGroup jobGroup) {
            if (FvCircuitAlarmStore.this.taskDb.on()) {
                FvCircuitAlarmStore.this.taskDb.print("All Job Finish ... ");
            }
            FvCircuitAlarmStore.this.eventPanel.refresh();
            FvCircuitAlarmStore.this.filterForCircuit(true);
            if (FvCircuitAlarmStore.this.circuitMaskAlarm) {
                if (FvCircuitAlarmStore.this.taskDb.on()) {
                    FvCircuitAlarmStore.this.taskDb.println(" Paint nodes");
                }
                FVPaintAlarm.getInstance().setAlarmMask(true);
            }
            JobControllerFactory.disposeJC((JobController)this.jobcontroller);
        }
    }
}

