/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.fv.alarms;

import cerent.cms.fv.IFvEventInfo;
import cerent.cms.fv.IFvNodeModel;
import cerent.cms.fv.net.IFvNetElement;
import cerent.cms.fv.net.IFvNetNode;
import cerent.cms.model.Feature;
import cerent.cms.model.InvalidNodeId;
import cerent.cms.model.NodeModel;
import cerent.cms.model.event.AbstractAlarmStore;
import cerent.cms.model.event.EventFilter;
import cerent.cms.model.event.EventInfo;
import cerent.cms.model.event.NetworkAlarmStore;
import cerent.util.SDebug;
import com.cisco.fv.alarms.FVNetworkAlarmPane;
import com.cisco.fv.alarms.FvCircuitAlarmStore;
import com.cisco.fv.grapher.FvNetworkMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Observable;

public class FvNetworkAlarmStore
extends AbstractAlarmStore {
    private NetworkAlarmStore alarmStore;
    private FvCircuitAlarmStore circuitAlarmStore;
    private FVNetworkAlarmPane filterPane;
    protected ArrayList<EventInfo> circuitAffected;
    protected ArrayList<EventInfo> noCircuitAffected;
    private boolean listInitialized = false;
    private Thread alarmTask;
    private int update = 0;
    private boolean exitTask = false;

    public FvNetworkAlarmStore(NetworkAlarmStore networkAlarmStore, String string) {
        super(string);
        this.db = new SDebug(string);
        this.alarmStore = networkAlarmStore;
        this.circuitAffected = new ArrayList();
        this.noCircuitAffected = new ArrayList();
        this.alarmTask = new Thread((Runnable)new UpdateListTask(), this.getClass().getSimpleName());
        this.alarmTask.start();
    }

    @Override
    public Collection getAllObjects() {
        ArrayList<EventInfo> arrayList = this.prepareList();
        if (this.db.on()) {
            this.db.println("Number Of Objects = " + arrayList.size());
        }
        return (Collection)arrayList.clone();
    }

    protected ArrayList<EventInfo> prepareList() {
        if (!this.listInitialized) {
            this.listInitialized = true;
            if (this.db.on()) {
                this.db.print("List empty prepare : ");
            }
            Collection collection = this.alarmStore.getAllObjects();
            if (this.db.on()) {
                this.db.println("with a number of " + collection.size() + " alarms: ");
            }
            for (EventInfo eventInfo : collection) {
                if (this.iscircuiImpacted(eventInfo)) {
                    this.circuitAffected.add(eventInfo);
                    continue;
                }
                this.noCircuitAffected.add(eventInfo);
            }
        }
        if (this.db.on()) {
            this.db.println("circuit Affected are = " + this.circuitAffected.size());
        }
        if (this.db.on()) {
            this.db.println("NOT circuit Affected are = " + this.noCircuitAffected.size());
        }
        return this.circuitAffected;
    }

    public ArrayList<EventInfo> getCircuitAffected() {
        return this.circuitAffected;
    }

    public ArrayList<EventInfo> getNoCircuitAffected() {
        return this.noCircuitAffected;
    }

    @Override
    public Object getObjectAtRow(int n) {
        EventInfo eventInfo = this.prepareList().get(n);
        return eventInfo;
    }

    @Override
    public int getRowCount() {
        int n = 0;
        n = this.filterPane == null ? this.alarmStore.getRowCount() : this.prepareList().size();
        return n;
    }

    @Override
    public EventFilter getEventFilter() {
        return this.alarmStore.getEventFilter();
    }

    @Override
    protected void localUpdateStatus(EventInfo eventInfo) {
    }

    public void flushAlarmStore() {
        if (this.db.on()) {
            this.db.println("flushAlarmStore");
        }
        this.clearList();
        this.prepareList();
        this.alarmStore.flushAlarmStore();
        this.alarmStore.getAllPendingAlarms();
    }

    protected void clearList() {
        if (this.db.on()) {
            this.db.println("clearList");
        }
        this.circuitAffected.clear();
        this.noCircuitAffected.clear();
        this.listInitialized = false;
    }

    public void addFilterPane(FVNetworkAlarmPane fVNetworkAlarmPane) {
        this.filterPane = fVNetworkAlarmPane;
    }

    public FVNetworkAlarmPane getFilterPane() {
        return this.filterPane;
    }

    public NetworkAlarmStore getAlarmStore() {
        return this.alarmStore;
    }

    public void updateReceived() {
        ++this.update;
        if (this.db.on()) {
            this.db.println("updateReceived");
        }
        this.clearList();
    }

    @Override
    public void update(Observable observable, Object object) {
    }

    @Override
    public void destroy() {
        super.destroy();
        this.stopTaskUpdate();
        this.filterPane = null;
        this.circuitAlarmStore = null;
    }

    protected void stopTaskUpdate() {
        this.exitTask = true;
    }

    private boolean iscircuiImpacted(EventInfo eventInfo) {
        FvNetworkMap fvNetworkMap = FvNetworkMap.getInstance();
        IFvNetElement iFvNetElement = fvNetworkMap.getNetworkModel().findIFvNetElem(eventInfo.getNodeId());
        if (iFvNetElement != null) {
            IFvNetNode iFvNetNode = iFvNetElement.getNetworkNode();
            try {
                if (((NodeModel)iFvNetNode).provides(Feature.COLOR_DIR_LESS)) {
                    IFvNodeModel iFvNodeModel = iFvNetNode.getFvDelegate();
                    return iFvNodeModel.isDwdmCircuitImpacted((IFvEventInfo)eventInfo);
                }
                return this.filterPane.circuitAlarm(eventInfo);
            }
            catch (InvalidNodeId invalidNodeId) {
                return false;
            }
        }
        return false;
    }

    public void addCircuitalarmstore(FvCircuitAlarmStore fvCircuitAlarmStore) {
        this.circuitAlarmStore = fvCircuitAlarmStore;
    }

    private class UpdateListTask
    implements Runnable {
        private boolean startUpdate = false;
        private boolean readyTostart = false;

        private UpdateListTask() {
        }

        @Override
        public void run() {
            while (!FvNetworkAlarmStore.this.exitTask) {
                if (FvNetworkAlarmStore.this.update != 0) {
                    this.startUpdate = false;
                    this.readyTostart = true;
                } else if (this.readyTostart) {
                    this.startUpdate = true;
                }
                FvNetworkAlarmStore.this.update = 0;
                if (this.startUpdate) {
                    FvNetworkAlarmStore.this.prepareList();
                    FvNetworkAlarmStore.this.circuitAlarmStore.repaintAlarms();
                    this.startUpdate = false;
                    this.readyTostart = false;
                }
                this.waitResponse(2000L);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitResponse(long l) {
            UpdateListTask updateListTask = this;
            synchronized (updateListTask) {
                try {
                    this.wait(l);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }
}

