/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.fv.circuit.model;

import cerent.cms.fv.net.IFvNetLink;
import cerent.cms.fv.net.IFvNetNode;
import cerent.cms.model.InvalidNodeId;
import cerent.cms.ui.DwdmSide;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public abstract class CircuitTableRowModel {
    private ArrayList<Data> data;
    protected SDebug sd = new SDebug("CircuitTableRowModel");

    protected CircuitTableRowModel() {
        this.data = new ArrayList();
    }

    protected abstract void prepareRow();

    protected void addData(IFvNetNode iFvNetNode, int n, String string, String string2, String string3) {
        this.data.add(new Data(iFvNetNode, n, string, string2, string3));
    }

    protected void removeData(IFvNetNode iFvNetNode) {
        Iterator<Data> iterator = this.data.iterator();
        while (iterator.hasNext()) {
            Data data = iterator.next();
            if (data.node == null || data.node.getNodeId() != iFvNetNode.getNodeId()) continue;
            iterator.remove();
        }
    }

    public int size() {
        return this.data.size();
    }

    public int getType(int n) {
        return this.data.get((int)n).type;
    }

    public String getName(int n) {
        return this.data.get((int)n).name;
    }

    public String getPowerInSpann(int n) {
        return this.data.get((int)n).powerInSpann;
    }

    public String getPowerOut(int n) {
        return this.data.get((int)n).powerOut;
    }

    public void dispose() {
        this.data.clear();
    }

    protected void prepareLink(IFvNetNode iFvNetNode, IFvNetNode iFvNetNode2, IFvNetLink iFvNetLink) {
        Object object;
        String string;
        String string2;
        String[] stringArray;
        block10: {
            block9: {
                stringArray = this.calculateSpanLoss(iFvNetNode2, iFvNetLink);
                string2 = "";
                string = "";
                if (!iFvNetNode2.isInited() || !iFvNetNode2.isInited()) {
                    return;
                }
                try {
                    object = iFvNetNode2.getFvDelegate().getEntityModelByIndex(iFvNetLink.getSrcEntityIndex());
                    if (object == null) {
                        return;
                    }
                    string2 = "/" + DwdmSide.getSideFromOffset(object.getSide());
                }
                catch (InvalidNodeId invalidNodeId) {
                    if (!this.sd.on()) break block9;
                    this.sd.println("No Destination Side");
                }
            }
            try {
                object = iFvNetNode.getFvDelegate().getEntityModelByIndex(iFvNetLink.getDstEntityIndex());
                if (object == null) {
                    return;
                }
                string = "/" + DwdmSide.getSideFromOffset(object.getSide());
            }
            catch (InvalidNodeId invalidNodeId) {
                if (!this.sd.on()) break block10;
                this.sd.println("No Source Side");
            }
        }
        object = iFvNetNode.getName() + string + " -> " + iFvNetNode2.getName() + string2;
        if (stringArray != null) {
            this.addData(null, 3, (String)object, stringArray[2], null);
        } else {
            this.addData(null, 3, (String)object, "N/A", null);
        }
    }

    protected void prepareNode(IFvNetNode iFvNetNode) {
        String string = iFvNetNode.getName();
        if (iFvNetNode.isFVActive()) {
            if (iFvNetNode.isInited()) {
                ArrayList<HashMap<String, String>> arrayList = this.getNodePower(iFvNetNode);
                if (arrayList != null) {
                    for (HashMap<String, String> hashMap : arrayList) {
                        this.addData(iFvNetNode, 0, hashMap.get("NAME"), hashMap.get("PIN"), hashMap.get("POUT"));
                    }
                }
            } else if (this.sd.on()) {
                this.sd.println("The Node is not ready");
            }
        } else {
            this.removeData(iFvNetNode);
        }
    }

    abstract String[] calculateSpanLoss(IFvNetNode var1, IFvNetLink var2);

    abstract ArrayList<HashMap<String, String>> getNodePower(IFvNetNode var1);

    public abstract void prepareNodeData(IFvNetNode var1);

    private class Data {
        public int type;
        public String name;
        public String powerInSpann;
        public String powerOut;
        public IFvNetNode node;

        public Data(IFvNetNode iFvNetNode, int n, String string, String string2, String string3) {
            this.node = iFvNetNode;
            this.type = n;
            this.name = string;
            this.powerInSpann = string2;
            this.powerOut = string3;
        }
    }
}

