/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.fv.circuit.model;

import cerent.cms.fv.IFVPowerModel;
import cerent.cms.fv.IFvNodeModel;
import cerent.cms.fv.net.IFVCircuitSpan;
import cerent.cms.fv.net.IFvNetElement;
import cerent.cms.fv.net.IFvNetLink;
import cerent.cms.fv.net.IFvNetNode;
import cerent.cms.model.InvalidNodeId;
import cerent.cms.model.NodeModel;
import cerent.cms.model.OchncHelper;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.Network;
import cerent.util.IObservable;
import cerent.util.IObserver;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public class FVPowerModel
implements IFVPowerModel,
IObserver {
    static SDebug sd;

    public void dispose() {
        sd = null;
    }

    public FVPowerModel() {
        sd = new SDebug("FVPowerModel");
    }

    public ArrayList<HashMap<String, String>> getNodePower(IFvNetNode iFvNetNode) {
        try {
            IFvNodeModel iFvNodeModel = iFvNetNode.getFvDelegate();
            return iFvNodeModel.getAllUsefulPower(false, true);
        }
        catch (InvalidNodeId invalidNodeId) {
            return new ArrayList<HashMap<String, String>>();
        }
    }

    public String[] getSpanLoss(IFvNetNode iFvNetNode, IFvNetLink iFvNetLink) {
        if (iFvNetNode.isInited()) {
            try {
                return ((NodeModel)iFvNetNode).getSpanLoss(OchncHelper.getSideFromPortIndex((NodeModel)iFvNetNode, ((INetLink)iFvNetLink).getSrcEntityIndex()));
            }
            catch (RuntimeException runtimeException) {
                runtimeException.printStackTrace();
                return null;
            }
        }
        return null;
    }

    public List<IFvNetNode> getSpanNodes() {
        ArrayList<IFvNetNode> arrayList = new ArrayList<IFvNetNode>();
        Collection<IFvNetElement> collection = this.getNodes();
        for (IFvNetElement iFvNetElement : collection) {
            arrayList.add(iFvNetElement.getNetworkNode());
        }
        return arrayList;
    }

    private String printablePwr(int n) {
        String string = String.valueOf(n);
        int n2 = string.startsWith("-") ? 2 : 1;
        string = string.length() > n2 ? string.substring(0, string.length() - 1) + "." + string.substring(string.length() - 1) : (n2 == 2 ? string.substring(0, 1) + "0." + string.substring(1, string.length()) : "0." + string);
        return string;
    }

    public void update(IObservable iObservable, Object object) {
    }

    public Collection<IFvNetElement> getNodes() {
        return Network.instance().getAllElements();
    }

    public List<IFvNetLink> getCircuitLink() {
        return (List)Network.instance().getNetLinks();
    }

    public List<IFVCircuitSpan> getCircuitSpans() {
        return null;
    }
}

