/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.fv.circuit.model;

import cerent.cms.fv.IFVPowerModel;
import cerent.cms.fv.IFVSelectedPowerModel;
import cerent.cms.model.ICircuitId;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.ncp.INetCircuit;
import cerent.util.IObservable;
import cerent.util.IObserver;
import cerent.util.UObservable;
import com.cisco.fv.FunctViewManagerDelegate;
import com.cisco.fv.alarms.FVPaintAlarm;
import com.cisco.fv.circuit.model.FvSelectedCircuitModel;
import com.cisco.fv.grapher.FvNetworkMap;
import com.cisco.fv.grapher.circuit.FvNetworkCircuitPath;
import java.util.HashMap;

public class FvCircuitModels
extends UObservable
implements IObserver {
    private HashMap<ICircuitId, IFVSelectedPowerModel> selected = new HashMap();
    private IFVPowerModel aggregatedPower;
    private static FvCircuitModels _instance = null;

    protected FvCircuitModels() {
    }

    public static FvCircuitModels getInstance() {
        if (_instance == null) {
            _instance = new FvCircuitModels();
        }
        return _instance;
    }

    public boolean addCircuit(FvSelectedCircuitModel fvSelectedCircuitModel) {
        if (!this.selected.containsKey(fvSelectedCircuitModel.getCircuitId())) {
            if (this.selected.size() > 0) {
                this.deleteCircuits(false);
            }
            this.selected.put(fvSelectedCircuitModel.getCircuitId(), fvSelectedCircuitModel);
            ((INetCircuit)fvSelectedCircuitModel.getCircuitModel()).addObserver(this);
            this.notifyChanges(new NotifyCircuitModel(0, fvSelectedCircuitModel.getCircuitId()));
            return true;
        }
        return false;
    }

    public void deleteCircuit(IFVSelectedPowerModel iFVSelectedPowerModel) {
        if (((INetCircuit)iFVSelectedPowerModel.getCircuitModel()).isObserver(this)) {
            ((INetCircuit)iFVSelectedPowerModel.getCircuitModel()).deleteObserver(this);
        }
        this.selected.remove(((INetCircuit)iFVSelectedPowerModel.getCircuitModel()).getCircuitId());
        this.notifyChanges(new NotifyCircuitModel(1, ((INetCircuit)iFVSelectedPowerModel.getCircuitModel()).getCircuitId()));
        iFVSelectedPowerModel.dispose();
    }

    private void notifyChanges(NotifyCircuitModel notifyCircuitModel) {
        this.setChanged();
        this.notifyObservers(notifyCircuitModel);
    }

    public IFVSelectedPowerModel getCircuit(ICircuitId iCircuitId) {
        return this.selected.get(iCircuitId);
    }

    public void deleteCircuits(boolean bl) {
        IFVSelectedPowerModel[] iFVSelectedPowerModelArray = this.selected.values().toArray(new IFVSelectedPowerModel[0]);
        for (int i = 0; i < iFVSelectedPowerModelArray.length; ++i) {
            this.deleteCircuit(iFVSelectedPowerModelArray[i]);
        }
        this.selected.clear();
        FvNetworkMap fvNetworkMap = FunctViewManagerDelegate.getInstance().getNetworkMap();
        if (fvNetworkMap != null) {
            FvNetworkCircuitPath.getInstance().clearActiveCircuit(fvNetworkMap, bl);
        }
    }

    public void addAggregatedPower(IFVPowerModel iFVPowerModel) {
        this.aggregatedPower = iFVPowerModel;
        FunctViewManagerDelegate.getInstance().powerModelUpdate(this.aggregatedPower);
    }

    public IFVPowerModel getAggregatedPower() {
        return this.aggregatedPower;
    }

    public void dispose() {
        _instance = null;
        FVPaintAlarm.dispose();
        this.deleteCircuits(true);
    }

    public void update(IObservable iObservable, Object object) {
        if (iObservable instanceof INetCircuit && object == ModelUpdateType.DELETED) {
            IFVSelectedPowerModel iFVSelectedPowerModel = this.selected.get(((INetCircuit)iObservable).getCircuitId());
            this.deleteCircuit(iFVSelectedPowerModel);
            FvNetworkCircuitPath.getInstance().clearActiveCircuit(FunctViewManagerDelegate.getInstance().getNetworkMap(), true);
        }
    }

    public class NotifyCircuitModel {
        public int changes;
        public ICircuitId id;
        public static final int ADD = 0;
        public static final int DELETE = 1;
        public static final int CHANGE = 2;

        public NotifyCircuitModel(int n, ICircuitId iCircuitId) {
            this.changes = n;
            this.id = iCircuitId;
        }
    }
}

