/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.fv.circuit.model;

import cerent.cms.fv.IFVPowerModel;
import cerent.cms.fv.net.IFvNetElement;
import cerent.cms.fv.net.IFvNetLink;
import cerent.cms.fv.net.IFvNetNode;
import cerent.cms.topo.DwdmNetLink;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.NetElement;
import cerent.cms.topo.OchncFilterManager;
import cerent.cms.topo.VirtualNetLink;
import cerent.util.IObserver;
import cerent.util.SDebug;
import com.cisco.fv.circuit.model.CircuitTableRowModel;
import com.cisco.fv.circuit.model.FVPowerModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

public class PowerTableRowModel
extends CircuitTableRowModel {
    ArrayList<IFvNetNode> openNode = null;
    private SDebug sd = new SDebug("PowerTableRowModel");
    private FVPowerModel powerModel;
    private ArrayList<LinkStored> linkstored = new ArrayList();

    public PowerTableRowModel(IFVPowerModel iFVPowerModel) {
        this.powerModel = (FVPowerModel)iFVPowerModel;
        this.openNode = new ArrayList();
        this.prepareRow();
    }

    @Override
    protected void prepareRow() {
        this.linkstored.clear();
        ArrayList<IFvNetLink> arrayList = new ArrayList<IFvNetLink>();
        Collection<IFvNetElement> collection = this.powerModel.getNodes();
        for (IFvNetElement iFvNetElement : collection) {
            this.splitspans(iFvNetElement, arrayList);
        }
        if (arrayList.size() > 0) {
            this.prepareNodeAndLinks(arrayList);
        } else {
            this.prepareNodes(collection);
        }
    }

    private void prepareNodes(Collection<IFvNetElement> collection) {
        for (IFvNetElement iFvNetElement : collection) {
            IFvNetNode iFvNetNode = iFvNetElement.getNetworkNode();
            if (!iFvNetNode.isFVActive() || this.openNode.contains(iFvNetNode)) continue;
            this.prepareNode(iFvNetNode);
            this.openNode.add(iFvNetNode);
        }
    }

    private void splitspans(IFvNetElement iFvNetElement, ArrayList<IFvNetLink> arrayList) {
        Collection collection = ((NetElement)iFvNetElement).getAdjacencyList();
        for (IFvNetLink iFvNetLink : collection) {
            if (!(iFvNetLink instanceof VirtualNetLink) && !(iFvNetLink instanceof DwdmNetLink) || this.yetInserted(iFvNetLink)) continue;
            arrayList.add(iFvNetLink);
            INetLink iNetLink = OchncFilterManager.findLinkForReversePath((INetLink)iFvNetLink, this.sd);
            if (this.yetInserted(iNetLink)) continue;
            arrayList.add(iNetLink);
        }
    }

    private boolean yetInserted(IFvNetLink iFvNetLink) {
        if (iFvNetLink == null) {
            return true;
        }
        int n = iFvNetLink.getSource().getNetworkNode().getNodeId();
        int n2 = iFvNetLink.getDestination().getNetworkNode().getNodeId();
        if (n == 0 || n2 == 0) {
            return true;
        }
        LinkStored linkStored = new LinkStored(iFvNetLink);
        for (int i = 0; i < this.linkstored.size(); ++i) {
            if (!this.linkstored.get(i).equal(linkStored)) continue;
            return true;
        }
        this.linkstored.add(linkStored);
        return false;
    }

    private void prepareNodeAndLinks(ArrayList<IFvNetLink> arrayList) {
        int n = arrayList.size();
        int n2 = 0;
        while (n2 < n) {
            IFvNetLink iFvNetLink;
            INetLink iNetLink;
            if ((iNetLink = OchncFilterManager.findLinkForReversePath((INetLink)(iFvNetLink = arrayList.get(n2++)), this.sd)) == null) {
                this.prepareLink(iFvNetLink.getSource().getNetworkNode(), iFvNetLink.getDestination().getNetworkNode(), iFvNetLink);
                continue;
            }
            iNetLink = (INetLink)arrayList.get(n2++);
            if (iFvNetLink == null || iNetLink == null) continue;
            this.prepareNodeAndLink(iFvNetLink.getSource().getNetworkNode(), iNetLink.getSource().getNetworkNode(), iFvNetLink, iNetLink);
        }
    }

    private void prepareNodeAndLink(IFvNetNode iFvNetNode, IFvNetNode iFvNetNode2, IFvNetLink iFvNetLink, IFvNetLink iFvNetLink2) {
        if (iFvNetNode.isFVActive() && !this.openNode.contains(iFvNetNode)) {
            this.prepareNode(iFvNetNode);
            this.openNode.add(iFvNetNode);
        }
        this.prepareLink(iFvNetNode, iFvNetNode2, iFvNetLink2);
        this.prepareLink(iFvNetNode2, iFvNetNode, iFvNetLink);
        if (iFvNetNode2.isFVActive() && !this.openNode.contains(iFvNetNode2)) {
            this.prepareNode(iFvNetNode2);
            this.openNode.add(iFvNetNode2);
        }
    }

    @Override
    String[] calculateSpanLoss(IFvNetNode iFvNetNode, IFvNetLink iFvNetLink) {
        iFvNetLink.addObserver((IObserver)this.powerModel);
        return this.powerModel.getSpanLoss(iFvNetNode, iFvNetLink);
    }

    @Override
    ArrayList<HashMap<String, String>> getNodePower(IFvNetNode iFvNetNode) {
        return this.powerModel.getNodePower(iFvNetNode);
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    @Override
    public void prepareNodeData(IFvNetNode iFvNetNode) {
        this.prepareNode(iFvNetNode);
    }

    private class LinkStored {
        int srcId;
        int dstId;
        private IFvNetLink link;
        private int srcEntityId;
        private int dstEntityId;

        public LinkStored(IFvNetLink iFvNetLink) {
            this.link = iFvNetLink;
            this.srcId = iFvNetLink.getSource().getNetworkNode().getNodeId();
            this.dstId = iFvNetLink.getDestination().getNetworkNode().getNodeId();
            this.srcEntityId = iFvNetLink.getSrcEntityIndex();
            this.dstEntityId = iFvNetLink.getDstEntityIndex();
        }

        public boolean equal(LinkStored linkStored) {
            if (this.srcId == linkStored.srcId && this.dstId == linkStored.dstId && this.srcEntityId == linkStored.srcEntityId && this.dstEntityId == linkStored.dstEntityId) {
                return true;
            }
            return this.srcId == linkStored.dstId && this.dstId == linkStored.srcId && this.srcEntityId == linkStored.dstEntityId && this.dstEntityId == linkStored.srcEntityId;
        }
    }
}

