/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.fv.grapher;

import cerent.cms.fv.net.IFvMapPersist;
import cerent.cms.fv.net.IFvNetLink;
import cerent.cms.fv.net.IFvNetNode;
import cerent.cms.fv.net.IFvNetworkModel;
import cerent.cms.fv.net.IFvVirtualLinksDirector;
import cerent.cms.model.Attribute;
import cerent.cms.model.INodeModel;
import cerent.cms.topo.DwdmNetLink;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.OchncFilterManager;
import cerent.cms.topo.RoutableNetLink;
import cerent.cms.topo.VirtualNetLink;
import cerent.cms.ui.network.NetworkViewFilter;
import cerent.util.IFvDebug;
import cerent.util.SDebug;
import cerent.util.view.fv.ILinkDefine;
import cerent.util.view.fv.IPowerBallon;
import cerent.util.view.fv.ViewManagerToolKit;
import com.cisco.ctc.util.map.AbstractGraph;
import com.cisco.ctc.util.map.IMapFactory;
import com.cisco.ctc.util.map.InterGraphLink;
import com.cisco.ctc.util.map.Link;
import com.cisco.ctc.util.map.MapGraph;
import com.cisco.ctc.util.map.MapImage;
import com.cisco.ctc.util.map.MapLink;
import com.cisco.ctc.util.map.MapLinkBundle;
import com.cisco.ctc.util.map.MapLinkInfo;
import com.cisco.ctc.util.map.MapNode;
import com.cisco.ctc.util.map.Node;
import com.cisco.fv.FunctViewManagerDelegate;
import com.cisco.fv.grapher.AbstractFvNetworkMap;
import com.cisco.fv.grapher.FunctNetMapLink;
import com.cisco.fv.grapher.FunctNetMapNode;
import com.cisco.fv.grapher.circuit.FVNetCircuitPathElements;
import com.cisco.fv.grapher.util.FvMapGraph;
import com.cisco.fv.grapher.util.MapGrapherNode;
import com.cisco.fv.power.FvNodePwrBalloonTask;
import com.cisco.fv.power.PowerBallon;
import com.cisco.fv.power.SpanLossBalloon;
import ilog.views.IlvGraphic;
import ilog.views.IlvPoint;
import ilog.views.graphic.composite.IlvCompositeLink;
import java.awt.Color;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.AbstractSequentialList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;

public class FvNetworkMap
extends AbstractFvNetworkMap
implements IPowerBallon,
MouseWheelListener {
    private static FvNetworkMap instance;
    private NetworkViewFilter NVFilter;
    private Attribute currCriteria;
    private HashMap linksOriginalColor;

    public FvNetworkMap(IFvDebug iFvDebug, int n, IMapFactory iMapFactory, IFvNetworkModel iFvNetworkModel, IFvVirtualLinksDirector iFvVirtualLinksDirector, IFvMapPersist iFvMapPersist) {
        super(iFvDebug, n, iMapFactory, iFvNetworkModel, iFvVirtualLinksDirector, iFvMapPersist);
        if (instance == null) {
            instance = this;
        }
        this.linksOriginalColor = new HashMap();
        this.addMouseWheelListener(this);
    }

    public static FvNetworkMap getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void initializeMap(int n) {
        this.currCriteria = null;
        this.NVFilter = new NetworkViewFilter();
        FvNetworkMap fvNetworkMap = this;
        synchronized (fvNetworkMap) {
            Collection collection = this.netModel.getAllElements();
            for (INetElement iNetElement : collection) {
                iNetElement.addObserver(this);
            }
            this.initialize();
        }
    }

    private void initialize() {
        Attribute attribute = new Attribute("All", 0);
        this.setFilterCriteria(attribute);
    }

    private synchronized void setFilterCriteria(Attribute attribute) {
        this.setFilterCriteria(attribute, false);
    }

    private synchronized void setFilterCriteria(Attribute attribute, boolean bl) {
        if (this.currCriteria != attribute || bl) {
            Object object2;
            if (!this.isRootGraph()) {
                this.doGoToRootGraph();
            }
            if (this.currCriteria != null) {
                try {
                    this.reInitMap();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.currCriteria = attribute;
            this.NVFilter.removeAllMatchers();
            if (this.currCriteria.getKey().equals("DWDM")) {
                this.NVFilter.addMatcher(this.NVFilter.createNodeTypeMatcher(2));
                this.NVFilter.addMatcher(this.NVFilter.createNodeTypeMatcher(1));
            } else if (this.currCriteria.getKey().equals("TDM")) {
                this.NVFilter.addMatcher(this.NVFilter.createNodeTypeMatcher(3));
                this.NVFilter.addMatcher(this.NVFilter.createNodeTypeMatcher(1));
            }
            Collection collection = this.netModel.getAllElements();
            for (Object object2 : collection) {
                if (!this.NVFilter.doesMatch((INodeModel)object2.getNetworkNode())) continue;
                this.addNode(object2.getNetworkNode(), true, null);
            }
            object2 = this.netModel.getNetLinks();
            Iterator iterator = object2.iterator();
            while (iterator.hasNext()) {
                INetLink iNetLink = (INetLink)iterator.next();
                if (this.isLinkAcceptable(iNetLink) && this.NVFilter.doesMatch(iNetLink)) {
                    this.addLink(iNetLink, null);
                    continue;
                }
                iNetLink.deleteObserver(this);
            }
            this.updateView();
        }
    }

    public ViewManagerToolKit getTk(IFvNetNode iFvNetNode) {
        MapNode mapNode = this.getMapNode(iFvNetNode);
        if (mapNode instanceof FunctNetMapNode) {
            return ((FunctNetMapNode)mapNode).getNodeFv();
        }
        return null;
    }

    public LinkedList<MapLink> findMapLinks(IFvNetLink iFvNetLink) {
        LinkedList<MapLink> linkedList = new LinkedList<MapLink>();
        IFvNetNode iFvNetNode = iFvNetLink.getSource().getNetworkNode();
        IFvNetNode iFvNetNode2 = iFvNetLink.getDestination().getNetworkNode();
        for (IFvNetLink iFvNetLink2 : this.links.keySet()) {
            Object object;
            Object v = this.links.get(iFvNetLink2);
            if (v instanceof MapLinkInfo) {
                object = (MapLinkInfo)v;
                continue;
            }
            object = (MapLink)v;
            if (object == null) {
                return linkedList;
            }
            if ((!((Link)object).getSrc().getUserObject().equals(iFvNetNode) || !((Link)object).getDst().getUserObject().equals(iFvNetNode2)) && (!((Link)object).getSrc().getUserObject().equals(iFvNetNode2) || !((Link)object).getDst().getUserObject().equals(iFvNetNode))) continue;
            if (iFvNetLink instanceof VirtualNetLink) {
                if ((iFvNetLink2.getSrcEntityIndex() != iFvNetLink.getSrcEntityIndex() || iFvNetLink2.getDstEntityIndex() != iFvNetLink.getDstEntityIndex()) && (iFvNetLink2.getSrcEntityIndex() != iFvNetLink.getDstEntityIndex() || iFvNetLink2.getDstEntityIndex() != iFvNetLink.getSrcEntityIndex())) continue;
                linkedList.add((MapLink)object);
                continue;
            }
            linkedList.add((MapLink)object);
        }
        return linkedList;
    }

    public HashMap showSelectedCircuit(FVNetCircuitPathElements fVNetCircuitPathElements) {
        LinkedList<MapLink> linkedList = fVNetCircuitPathElements.getActiveLinks();
        fVNetCircuitPathElements.addInterLink(this.paintSelectedCircuit(linkedList, true));
        linkedList = fVNetCircuitPathElements.getStbLinks();
        if (linkedList.size() > 0) {
            this.paintSelectedCircuit(linkedList, false);
        }
        return this.linksOriginalColor;
    }

    private ArrayList<InterGraphLink> paintSelectedCircuit(LinkedList<MapLink> linkedList, boolean bl) {
        MapLink[] mapLinkArray;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        ArrayList<InterGraphLink> arrayList = new ArrayList<InterGraphLink>();
        LinkedList<Object> linkedList2 = new LinkedList<Object>();
        for (int i = 0; i < linkedList.size(); ++i) {
            object4 = linkedList.get(i);
            object3 = (MapGraph)((Link)object4).getSrc().getChildGrapher();
            object2 = (MapGraph)((Link)object4).getDst().getChildGrapher();
            if (!linkedList2.contains(object3)) {
                linkedList2.add(object3);
            }
            if (linkedList2.contains(object2)) continue;
            linkedList2.add(object2);
        }
        Iterator<Object> iterator = linkedList.iterator();
        object4 = this.getInterGraphLinks();
        object3 = new LinkedList();
        while (iterator.hasNext()) {
            object2 = (IFvNetLink)((MapLink)iterator.next()).getUserObject();
            for (int i = 0; i < ((LinkedList)object4).size(); ++i) {
                RoutableNetLink routableNetLink;
                object = (InterGraphLink)((LinkedList)object4).get(i);
                IFvNetLink iFvNetLink = (IFvNetLink)((MapLink)((InterGraphLink)object).getActualNetLink()).getUserObject();
                mapLinkArray = null;
                if (iFvNetLink instanceof DwdmNetLink) {
                    routableNetLink = (DwdmNetLink)iFvNetLink;
                    mapLinkArray = OchncFilterManager.findLinkForReversePath(routableNetLink, new SDebug("nothing"));
                } else if (iFvNetLink instanceof VirtualNetLink) {
                    routableNetLink = (VirtualNetLink)iFvNetLink;
                    mapLinkArray = OchncFilterManager.findLinkForReversePath(routableNetLink, new SDebug("nothing"));
                }
                if (iFvNetLink != object2 && mapLinkArray != object2) continue;
                ((LinkedList)object3).add(object);
            }
        }
        iterator = this.links.keySet().iterator();
        while (iterator.hasNext()) {
            MapLinkBundle mapLinkBundle;
            object2 = this.links.get(iterator.next());
            if (!(object2 instanceof MapLink)) continue;
            MapLink mapLink = (MapLink)object2;
            if (!linkedList.contains(mapLink) && !this.linksOriginalColor.containsKey(mapLink)) {
                if (!bl) continue;
                object = mapLink.getLineColor();
                mapLink.setLineColor(Color.gray);
                this.linksOriginalColor.put(mapLink, object);
                mapLinkBundle = this.getMapLinkBundle(mapLink);
                object = mapLinkBundle.getLineColor();
                mapLinkBundle.setLineColor(Color.gray);
                if (this.linksOriginalColor.containsKey(mapLinkBundle)) continue;
                this.linksOriginalColor.put(mapLinkBundle, object);
                continue;
            }
            if (this.linksOriginalColor.containsKey(mapLink) && bl || !linkedList.contains(mapLink)) continue;
            mapLink.setLineThickness(3);
            if (bl) continue;
            object = mapLink.getLineColor();
            mapLink.setLineColor(ILinkDefine.SELECT_INTER_STB_LNK_COLOR);
            if (!this.linksOriginalColor.containsKey(mapLink)) {
                this.linksOriginalColor.put(mapLink, object);
            }
            mapLinkBundle = this.getMapLinkBundle(mapLink);
            object = mapLinkBundle.getLineColor();
            boolean bl2 = false;
            mapLinkArray = mapLinkBundle.getLinks();
            for (int i = 0; i < mapLinkArray.length; ++i) {
                MapLink mapLink2 = mapLinkArray[i];
                if (!linkedList.contains(mapLink2)) continue;
                bl2 = true;
            }
            if (!bl2) {
                mapLinkBundle.setLineColor(ILinkDefine.SELECT_INTER_STB_LNK_COLOR);
            }
            if (this.linksOriginalColor.containsKey(mapLinkBundle)) continue;
            this.linksOriginalColor.put(mapLinkBundle, object);
        }
        iterator = ((AbstractSequentialList)object4).iterator();
        while (iterator.hasNext()) {
            Color color;
            object2 = (InterGraphLink)iterator.next();
            if (!((LinkedList)object3).contains(object2) && !this.linksOriginalColor.containsKey(object2)) {
                color = ((InterGraphLink)object2).getLineColor();
                if (!bl) continue;
                ((InterGraphLink)object2).setLineColor(Color.gray);
                ((InterGraphLink)object2).setLineThickness(1.0f);
                this.linksOriginalColor.put(object2, color);
                continue;
            }
            if (this.linksOriginalColor.containsKey(object2) && bl) continue;
            ((InterGraphLink)object2).setLineThickness(3.0f);
            arrayList.add((InterGraphLink)object2);
            color = ((InterGraphLink)object2).getLineColor();
            if (!((LinkedList)object3).contains(object2)) continue;
            if (!bl) {
                ((InterGraphLink)object2).setLineColor(ILinkDefine.SELECT_INTER_STB_LNK_COLOR);
            } else {
                ((InterGraphLink)object2).setLineColor(ILinkDefine.SELECT_INTER_LNK_COLOR);
            }
            if (this.linksOriginalColor.containsKey(object2)) continue;
            this.linksOriginalColor.put(object2, color);
        }
        return arrayList;
    }

    public void restoreLinkStates(HashMap hashMap) {
        if (hashMap != null) {
            Iterator<Object> iterator = this.links.keySet().iterator();
            Set set = hashMap.keySet();
            while (iterator.hasNext()) {
                MapLink mapLink;
                Object object2 = this.links.get(iterator.next());
                if (!(object2 instanceof MapLink) || (mapLink = (MapLink)object2) == null) continue;
                if (set != null && set.contains(mapLink)) {
                    mapLink.setLineColor((Color)hashMap.get(mapLink));
                }
                mapLink.setLineThickness(1);
                mapLink.reDraw();
            }
            for (InterGraphLink interGraphLink : this.getInterGraphLinks()) {
                interGraphLink.setLineColor(ILinkDefine.SELECT_INTER_LNK_COLOR);
                interGraphLink.reDraw();
                interGraphLink.setLineThickness(1.0f);
                interGraphLink.reDraw();
            }
            Object[] objectArray = set.toArray(new Object[0]);
            for (int i = 0; i < objectArray.length; ++i) {
                if (!(objectArray[i] instanceof MapLinkBundle)) continue;
                MapLinkBundle mapLinkBundle = (MapLinkBundle)objectArray[i];
                mapLinkBundle.setLineColor((Color)hashMap.get(mapLinkBundle));
            }
        }
    }

    public void showPower(boolean bl, int n) {
        Object object;
        Object object2;
        IlvCompositeLink ilvCompositeLink;
        Object object32;
        Object object4;
        if (n == 0) {
            object4 = Collections.synchronizedMap(this.links);
            Collection collection = object4.values();
            for (Object object32 : collection) {
                if (!(object32 instanceof FunctNetMapLink)) continue;
                ilvCompositeLink = (FunctNetMapLink)object32;
                ilvCompositeLink.showBalloon(bl);
                object2 = this.getMapLinkBundle((MapLink)ilvCompositeLink);
            }
            object = (LinkedList)this.getSpanInfoInterLinks().clone();
            object32 = ((AbstractSequentialList)object).iterator();
            while (object32.hasNext()) {
                ilvCompositeLink = (InterGraphLink)object32.next();
                ilvCompositeLink.showBalloon(bl);
            }
        }
        if (n == 1) {
            object4 = this.nodes.values();
            if (FvNodePwrBalloonTask.getRunningThread() > 0) {
                return;
            }
            boolean bl2 = false;
            object = object4.iterator();
            while (object.hasNext()) {
                object32 = (FunctNetMapNode)object.next();
                ilvCompositeLink = ((FunctNetMapNode)object32).getNodeFv();
                object2 = (IFvNetNode)((Node)object32).getUserObject();
                if (ilvCompositeLink == null || !object2.isFVActive()) continue;
                String string = "FvNodePwrBalloonTask " + object2.getName();
                new Thread((Runnable)new FvNodePwrBalloonTask((ViewManagerToolKit)ilvCompositeLink, bl, this), string).start();
                bl2 = true;
            }
            if (!bl2) {
                FunctViewManagerDelegate.getInstance().circuitTableAndToolsButtonEnable(true, false);
            }
        }
    }

    public void changeNodeAttributes(FunctNetMapNode functNetMapNode) {
        FunctViewManagerDelegate.getInstance().nodeChange(functNetMapNode, 4);
        this.calculatePowerBalloon();
    }

    @Override
    public void dispose() {
        for (Object v : this.nodeGraphs.values()) {
            if (!(v instanceof MapGrapherNode)) continue;
            MapGrapherNode mapGrapherNode = (MapGrapherNode)v;
            FvMapGraph fvMapGraph = (FvMapGraph)mapGrapherNode.getChildGraph();
            fvMapGraph.dispose();
            mapGrapherNode.dispose();
        }
        this.removeMouseWheelListener(this);
        super.dispose();
        instance = null;
    }

    public void calculatePowerBalloon() {
        PowerBallon.getInstance().startCalculation(this);
    }

    public void calculateSpanLossBalloon() {
        SpanLossBalloon.getInstance().startCalculation(this);
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        IlvGraphic ilvGraphic = this.getGraph().getObject(new IlvPoint((float)mouseWheelEvent.getX(), (float)mouseWheelEvent.getY()), this);
        if ((ilvGraphic instanceof MapImage || ilvGraphic == null) && mouseWheelEvent.isControlDown()) {
            if (mouseWheelEvent.getWheelRotation() > 0) {
                this.zoom(new IlvPoint((float)mouseWheelEvent.getX(), (float)mouseWheelEvent.getY()), 1.1, 1.1, true);
            } else {
                this.zoom(new IlvPoint((float)mouseWheelEvent.getX(), (float)mouseWheelEvent.getY()), 0.9, 0.9, true);
            }
        }
    }

    public void spanLossIsReady() {
        boolean bl = FunctViewManagerDelegate.getInstance().isSpanLossPowerVisible();
        if (bl) {
            this.showPower(bl, 0);
        }
    }

    public void powerPortIsReady() {
        boolean bl = FunctViewManagerDelegate.getInstance().isPowerVisible();
        if (bl) {
            this.showPower(bl, 1);
        }
    }

    public void closeAllOpenNodes() {
        MapNode[] mapNodeArray = this.getMapNodes();
        int n = mapNodeArray.length;
        for (int i = 0; i < n; ++i) {
            AbstractGraph abstractGraph = ((FunctNetMapNode)mapNodeArray[i]).getChildGrapher();
            if (abstractGraph == null || !(abstractGraph instanceof FvMapGraph) || ((FvMapGraph)abstractGraph).isCollapsed()) continue;
            ((FvMapGraph)abstractGraph).doGoToNormalNetworkView();
        }
    }

    public void resetZoomNodes() {
        MapNode[] mapNodeArray = this.getMapNodes();
        int n = mapNodeArray.length;
        for (int i = 0; i < n; ++i) {
            AbstractGraph abstractGraph = ((FunctNetMapNode)mapNodeArray[i]).getChildGrapher();
            if (abstractGraph == null || !(abstractGraph instanceof FvMapGraph)) continue;
            ((FvMapGraph)abstractGraph).resetZoom();
        }
    }
}

