/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.fv.grapher.util;

import cerent.cms.fv.net.IFvLinkModel;
import cerent.cms.fv.net.IFvNetLink;
import cerent.cms.fv.net.IFvNetNode;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NodeModel;
import com.cisco.ctc.util.map.MapImage;
import com.cisco.ctc.util.map.MapImageIcon;
import com.cisco.fv.grapher.FunctNetMapLink;
import com.cisco.fv.grapher.FvNetworkMap;
import com.cisco.fv.grapher.util.FvMapToolkit;
import java.awt.Image;
import java.util.Observable;
import java.util.Observer;
import javax.swing.SwingUtilities;

public class FunctProtSwitchState
implements Observer {
    private static final Image MANUAL_ICON = MapImage.createImage("/images/icons/link/manual.gif");
    private static final Image FORCE_ICON = MapImage.createImage("/images/icons/link/force.gif");
    private static final Image LOCKOUT_ICON = MapImage.createImage("/images/icons/link/lockout.gif");
    private static final Image EXERCISE_ICON = MapImage.createImage("/images/icons/link/exercise.gif");
    private static final String CLEAR = "PS_C";
    private static final String PS_E = "PS_E";
    private static final String PS_M = "PS_M";
    private static final String PS_F = "PS_F";
    private static final String PS_L = "PS_L";
    private IFvNetNode srcModel = null;
    private IFvNetNode dstModel = null;
    private IFvNetLink fwdLink = null;
    private String pss = "PS_C";
    private Object[][] OnePlusOneOrderedStates = new Object[][]{{new Integer(7), "PS_E"}, {new Integer(5), "PS_M"}, {new Integer(6), "PS_M"}, {new Integer(3), "PS_F"}, {new Integer(4), "PS_F"}, {new Integer(2), "PS_L"}, {new Integer(1), "PS_L"}};
    private Object[][] BlsrOrderedStates = new Object[][]{{new Integer(6), "PS_E"}, {new Integer(7), "PS_E"}, {new Integer(4), "PS_M"}, {new Integer(5), "PS_M"}, {new Integer(2), "PS_F"}, {new Integer(3), "PS_F"}, {new Integer(1), "PS_L"}};
    private FvMapToolkit mtk;
    private FunctNetMapLink link;

    public FunctProtSwitchState(FvMapToolkit fvMapToolkit, FunctNetMapLink functNetMapLink) {
        this.mtk = fvMapToolkit;
        this.link = functNetMapLink;
        Object object = functNetMapLink.getUserObject();
        if (object instanceof IFvNetLink) {
            this.fwdLink = (IFvNetLink)object;
        }
        if (this.fwdLink == null) {
            return;
        }
        this.addConnectionNotifierObservers();
        this.addNetLinkObservers();
        this.setLinkProtectionAnnotation();
    }

    private void setLinkProtectionAnnotation() {
        String string;
        this.pss = CLEAR;
        this.removeIcons(this.link);
        int n = this.getProtectionType();
        if (n == -1) {
            return;
        }
        boolean bl = n == 1;
        IFvNetLink iFvNetLink = this.fwdLink.getReverseLink();
        int n2 = this.fwdLink.getEndProtectionSwitchState(true);
        int n3 = -1;
        if (iFvNetLink != null) {
            n3 = iFvNetLink.getEndProtectionSwitchState(true);
        }
        n2 = this.getPsState(n2, bl);
        n3 = this.getPsState(n3, bl);
        if (n2 != -1) {
            string = this.getPsString(n2, bl);
            this.showIcon(string, true);
        }
        if (n3 != -1) {
            string = this.getPsString(n3, bl);
            this.showIcon(string, false);
        }
        if (n2 != -1 || n3 != -1) {
            this.pss = this.getPsString(n2 > n3 ? n2 : n3, bl);
        }
    }

    private void removeIcons(final FunctNetMapLink functNetMapLink) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                functNetMapLink.removeAllDecorativeIcons();
            }
        });
    }

    private void showIcon(final String string, final boolean bl) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                FunctProtSwitchState.this.addIcon(string, bl);
            }
        });
    }

    private void addIcon(String string, boolean bl) {
        MapImageIcon mapImageIcon = null;
        if (string == PS_M) {
            mapImageIcon = new MapImageIcon(MANUAL_ICON);
        } else if (string == PS_F) {
            mapImageIcon = new MapImageIcon(FORCE_ICON);
        } else if (string == PS_L) {
            mapImageIcon = new MapImageIcon(LOCKOUT_ICON);
        } else if (string == PS_E) {
            mapImageIcon = new MapImageIcon(EXERCISE_ICON);
        }
        if (mapImageIcon != null) {
            if (bl) {
                this.link.addSrcDecorativeIcon(string, mapImageIcon);
            } else {
                this.link.addTargetDecorativeIcon(string, mapImageIcon);
            }
        }
    }

    private int getPsState(int n, boolean bl) {
        if (bl) {
            for (int i = 0; i < this.OnePlusOneOrderedStates.length; ++i) {
                Object[] objectArray = this.OnePlusOneOrderedStates[i];
                if (n != (Integer)objectArray[0]) continue;
                return i;
            }
        } else {
            for (int i = 0; i < this.BlsrOrderedStates.length; ++i) {
                Object[] objectArray = this.BlsrOrderedStates[i];
                if (n != (Integer)objectArray[0]) continue;
                return i;
            }
        }
        return -1;
    }

    private String getPsString(int n, boolean bl) {
        String string = CLEAR;
        try {
            if (bl) {
                Object[] objectArray = this.OnePlusOneOrderedStates[n];
                string = (String)objectArray[1];
            } else {
                Object[] objectArray = this.BlsrOrderedStates[n];
                string = (String)objectArray[1];
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    public String getProtectionSwitchStateString() {
        if (this.pss == PS_E) {
            return "Execise";
        }
        if (this.pss == PS_M) {
            return "Manual";
        }
        if (this.pss == PS_F) {
            return "Force";
        }
        if (this.pss == PS_L) {
            return "Lockout";
        }
        return null;
    }

    private void addConnectionNotifierObservers() {
        IFvLinkModel iFvLinkModel = this.fwdLink.getTheLinkModel();
        this.srcModel = iFvLinkModel.source();
        this.dstModel = iFvLinkModel.destination();
        if (this.srcModel != null && this.srcModel.getTheConnectionNotifier() != null) {
            this.srcModel.getTheConnectionNotifier().addObserver((Observer)this);
        }
        if (this.dstModel != null && this.dstModel.getTheConnectionNotifier() != null) {
            this.dstModel.getTheConnectionNotifier().addObserver((Observer)this);
        }
    }

    private void addNetLinkObservers() {
        this.fwdLink.addObserver((Observer)this);
        IFvNetLink iFvNetLink = this.fwdLink.getReverseLink();
        if (iFvNetLink != null) {
            iFvNetLink.addObserver((Observer)this);
        }
    }

    private int getProtectionType() {
        int n = -1;
        if (this.fwdLink.getProtectionType() == 1 || this.fwdLink.getProtectionType() == 0 || this.fwdLink.getProtectionType() == 4) {
            return this.fwdLink.getProtectionType();
        }
        IFvNetLink iFvNetLink = this.fwdLink.getReverseLink();
        if (n == -1 && iFvNetLink != null && (iFvNetLink.getProtectionType() == 1 || iFvNetLink.getProtectionType() == 0 || iFvNetLink.getProtectionType() == 4)) {
            return iFvNetLink.getProtectionType();
        }
        return n;
    }

    @Override
    public synchronized void update(Observable observable, Object object) {
        Observer observer;
        if (observable instanceof NodeModel.ConnectionNotifier) {
            observer = (NodeModel.ConnectionNotifier)((Object)observable);
            if (observer.getNodeModel().getConnectionState()) {
                this.setLinkProtectionAnnotation();
            } else {
                this.removeIcons(this.link);
            }
        } else if (observable instanceof IFvNetLink) {
            if (object == ModelUpdateType.DELETED) {
                observer = (IFvNetLink)observable;
                if (observer.getReverseLink() == this.fwdLink) {
                    observer.deleteObserver(this);
                }
            } else {
                this.setLinkProtectionAnnotation();
            }
        }
        if (this.mtk instanceof FvNetworkMap) {
            observer = (FvNetworkMap)this.mtk;
        }
    }

    public void destroy() {
        this.deleteNetLinkObservers();
        this.deleteConnectionNotifierObservers();
    }

    private void deleteNetLinkObservers() {
        try {
            this.fwdLink.deleteObserver((Observer)this);
            IFvNetLink iFvNetLink = this.fwdLink.getReverseLink();
            if (iFvNetLink != null) {
                iFvNetLink.addObserver((Observer)this);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void deleteConnectionNotifierObservers() {
        try {
            if (this.srcModel != null) {
                this.srcModel.getTheConnectionNotifier().deleteObserver((Observer)this);
            }
            if (this.dstModel != null) {
                this.dstModel.getTheConnectionNotifier().deleteObserver((Observer)this);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

