/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.fv.grapher.util;

import cerent.cms.fv.net.IFvMapPersist;
import cerent.cms.fv.net.IFvNetLink;
import cerent.cms.fv.net.IFvNetNode;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.UPopupMenu;
import cerent.util.view.fv.IViewGraph;
import cerent.util.view.fv.ViewCardGrapher;
import cerent.util.view.fv.ViewDomainGrapher;
import cerent.util.view.fv.ViewManagerToolKit;
import cerent.util.view.fv.ViewPin;
import cerent.util.view.fv.ViewPortGraphic;
import com.cisco.ctc.util.map.IMapFactory;
import com.cisco.ctc.util.map.InterGraphLink;
import com.cisco.ctc.util.map.Link;
import com.cisco.ctc.util.map.LinkBundle;
import com.cisco.ctc.util.map.MapDomain;
import com.cisco.ctc.util.map.MapGraph;
import com.cisco.ctc.util.map.MapLink;
import com.cisco.ctc.util.map.MapLinkBundle;
import com.cisco.ctc.util.map.MapLinkInfo;
import com.cisco.ctc.util.map.MapMouseAdapter;
import com.cisco.ctc.util.map.MapNode;
import com.cisco.ctc.util.map.MapToolkit;
import com.cisco.ctc.util.map.Node;
import com.cisco.fv.grapher.FunctNetMapLink;
import com.cisco.fv.grapher.FunctNetMapNode;
import com.cisco.fv.grapher.util.FunctLinkBundle;
import com.cisco.fv.grapher.util.FvMapGraph;
import com.cisco.fv.grapher.util.FvMapMouseAdapter;
import com.cisco.fv.grapher.util.LinkBalloon;
import com.cisco.fv.grapher.util.MapGrapherNode;
import com.cisco.fv.power.PowerBallon;
import ilog.views.IlvGrapher;
import ilog.views.IlvGraphic;
import ilog.views.IlvLinkImage;
import ilog.views.linkconnector.IlvGrapherPin;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;

public class FvMapToolkit
extends MapToolkit {
    protected IFvMapPersist mapPersist;
    private boolean zoomVisibility;
    private HashMap<IFvNetLink, InterGraphLink> interGraphLinks;
    private LinkedList<InterGraphLink> spanInfoInterLinks;
    protected Map nodeGraphs = Collections.synchronizedMap(new HashMap());
    private SDebug dbg;
    FvMapMouseAdapter mouseState = null;

    @Override
    public boolean isZoomLevelVisible() {
        return this.zoomVisibility;
    }

    public FvMapToolkit(SDebug sDebug, IMapFactory iMapFactory, IFvMapPersist iFvMapPersist) {
        this.mapPersist = iFvMapPersist;
        this.init(sDebug, iMapFactory);
        this.rootGraph = new MapGraph(this);
        this.setGraph(this.rootGraph);
        this.mouseState = new FvMapMouseAdapter(this);
        MouseListener[] mouseListenerArray = this.getMouseListeners();
        for (int i = 0; i < mouseListenerArray.length; ++i) {
            MouseListener mouseListener = mouseListenerArray[i];
            if (!(mouseListener instanceof MapMouseAdapter)) continue;
            this.removeMouseListener(mouseListener);
        }
        this.addMouseListener(this.mouseState);
        this.addMouseMotionListener(this.mouseState);
        this.addMouseWheelListener(this.mouseState);
        this.zoomVisibility = true;
        this.dbg = sDebug;
    }

    @Override
    protected void init(SDebug sDebug, IMapFactory iMapFactory) {
        this.interGraphLinks = new HashMap();
        this.spanInfoInterLinks = new LinkedList();
        super.init(sDebug, iMapFactory);
    }

    @Override
    public void destroy() {
        super.destroy();
        this.removeMouseListener(this.mouseState);
        this.removeMouseMotionListener(this.mouseState);
        this.removeMouseWheelListener(this.mouseState);
        this.mouseState = null;
        this.interGraphLinks.clear();
        this.interGraphLinks = null;
        for (InterGraphLink interGraphLink : this.spanInfoInterLinks) {
            interGraphLink.destroy();
        }
        this.spanInfoInterLinks = null;
    }

    public synchronized MapNode addNode(Object object, int n, String string, double d, double d2, Object object2) {
        boolean bl = false;
        MapGraph mapGraph = this.rootGraph;
        if (string != null && string.length() > 0) {
            MapDomain mapDomain = (MapDomain)this.domains.get(string);
            if (mapDomain == null) {
                mapDomain = this.createDomain(string, d, d2, object2);
            }
            MapGraph mapGraph2 = mapDomain.getChildGraph();
            MapGraph mapGraph3 = this.createNodeGrapher(mapGraph2, object, n, d, d2, object2);
            bl = true;
            mapGraph = mapGraph3;
        } else {
            mapGraph = this.createNodeGrapher(this.rootGraph, object, n, d, d2, object2);
        }
        return this.addNode(mapGraph, object, d, d2, object2);
    }

    @Override
    public synchronized MapDomain createDomain(String string, double d, double d2, Object object) {
        MapDomain mapDomain = this.createDomain(object);
        if (string == null) {
            string = this.makeDomainName();
        }
        this.println("createDomain: " + string + " centerX =" + d + " centerY=" + d2 + " userCookie=" + object);
        mapDomain.setName(string);
        this.rootGraph.add(mapDomain);
        mapDomain.init(null, d, d2, object);
        this.domains.put(string, mapDomain);
        this.domainCreated(mapDomain);
        return mapDomain;
    }

    private String makeDomainName() {
        String string = null;
        int n = 0;
        while (this.domains.containsKey(string = "domain-" + n)) {
            ++n;
        }
        return string;
    }

    private MapGraph createNodeGrapher(MapGraph mapGraph, Object object, int n, double d, double d2, Object object2) {
        String string = String.valueOf(n);
        MapGrapherNode mapGrapherNode = (MapGrapherNode)this.nodeGraphs.get(string);
        if (mapGrapherNode == null) {
            mapGrapherNode = this.createMapGrapherNode(mapGraph, string, d, d2, object2);
        }
        mapGrapherNode.setUserObject(object);
        ((IFvNetNode)object).fvActive(false);
        return mapGrapherNode.getChildGraph();
    }

    public synchronized MapGrapherNode createMapGrapherNode(MapGraph mapGraph, String string, double d, double d2, Object object) {
        MapGrapherNode mapGrapherNode = this.createMapGrapherNode(object);
        this.println("createDomain: " + string + " centerX =" + d + " centerY=" + d2 + " userCookie=" + object);
        mapGraph.add((Object)mapGrapherNode.getChildGraph());
        mapGrapherNode.init(null, d, d2, object);
        this.nodeGraphs.put(string, mapGrapherNode);
        this.graphNodeCreated(mapGrapherNode);
        return mapGrapherNode;
    }

    protected void graphNodeCreated(MapGrapherNode mapGrapherNode) {
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == "Go To Parent View") {
            if (this.getMapGraph() instanceof FvMapGraph) {
                this.doGoToRootGraph();
            }
        } else if (string == "Create New Domain...") {
            if (!this.getMapGraph().isDomainGraph()) {
                this.doCreateDomain();
            }
        } else if (string == "Center View") {
            this.centerView();
        } else if (string == "Fit Content to View") {
            this.doFitView();
        } else if (string == "Reset Zoom") {
            this.doResetZoom();
        } else if (string == "Zoom In") {
            this.doZoomIn();
        } else if (string == "Zoom Out") {
            this.doZoomOut();
        } else if (string == "Zoom Selected Area") {
            this.doSelectZoom();
        } else if (string == "Set Background Color...") {
            this.doSetBackColor();
        } else if (string == "Set Background Image...") {
            this.doSetBackImage();
        } else if (string == "Remove Background Image") {
            if (CerentDialog.yesNoDialog((Component)this.getGraphWindow(), (String)"Do you really want to remove the background image?", (String)"Confirm Remove")) {
                this.doRemoveBackImage();
            }
        } else if (string == "Auto Layout...") {
            this.doAutoLayout();
        } else if (string == "Collapse/Expand Links...") {
            if (!this.isDetailed()) {
                this.doCollapseExpandLinks();
            }
        } else if (string == "Show Link Icons") {
            this.setEnableLinkIcon(!this.enableLinkIcon);
        }
    }

    protected MapGrapherNode createMapGrapherNode(Object object) {
        return new MapGrapherNode(this);
    }

    @Override
    public synchronized void deleteNode(Object object) {
        MapNode mapNode = (MapNode)this.nodes.remove(object);
        if (mapNode != null) {
            this.println("disposing " + mapNode);
            mapNode.destroy();
        } else {
            this.println("couldn't find node " + object + " to delete");
        }
    }

    @Override
    protected void initPopupMenu(UPopupMenu uPopupMenu) {
        if (this.isRootGraph()) {
            this.actOrg.addMenuItem((JComponent)uPopupMenu, null, "Create New Domain...", 78);
        } else {
            this.actOrg.addMenuItem((JComponent)uPopupMenu, null, "Go To Parent View", 71);
        }
        uPopupMenu.addSeparator();
        this.actOrg.addMenuItem((JComponent)uPopupMenu, "/images/icons/zoom_in16.gif", "Zoom In", 73);
        this.actOrg.addMenuItem((JComponent)uPopupMenu, "/images/icons/zoom_out16.gif", "Zoom Out", 79);
        this.actOrg.addMenuItem((JComponent)uPopupMenu, "/images/icons/zoom_selected.gif", "Zoom Selected Area", 83);
        this.actOrg.addMenuItem((JComponent)uPopupMenu, null, "Reset Zoom", 90);
        this.actOrg.getAbstractButton("Reset Zoom").setEnabled(this.getZoomCount() != 0);
        uPopupMenu.addSeparator();
        this.actOrg.addMenuItem((JComponent)uPopupMenu, null, "Center View", 67);
        this.actOrg.addMenuItem((JComponent)uPopupMenu, null, "Fit Content to View", 70);
        uPopupMenu.addSeparator();
        this.actOrg.addMenuItem((JComponent)uPopupMenu, null, "Set Background Color...", 66);
        this.actOrg.addMenuItem((JComponent)uPopupMenu, null, "Set Background Image...", 77);
        this.actOrg.addMenuItem((JComponent)uPopupMenu, null, "Remove Background Image", 82);
        if (!this.isDetailed()) {
            uPopupMenu.addSeparator();
            this.actOrg.addMenuItem((JComponent)uPopupMenu, null, "Collapse/Expand Links...", 76);
            JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem("Show Link Icons");
            jCheckBoxMenuItem.setState(this.enableLinkIcon);
            this.actOrg.addMenuItem((JComponent)uPopupMenu, jCheckBoxMenuItem, null, "Show Link Icons");
        }
    }

    @Override
    protected MapNode addNode(MapGraph mapGraph, Object object, double d, double d2, Object object2) {
        if (this.nodes.get(object) != null) {
            return (MapNode)this.nodes.get(object);
        }
        MapNode mapNode = this.createNode(object2);
        mapNode.setID(++this.seqNum);
        if (mapGraph.isDomainGraph()) {
            this.addNodeToDomain(mapGraph, mapNode);
            mapGraph.add(mapNode);
        } else {
            ((FvMapGraph)mapGraph).applyNodeToGraph(mapNode);
        }
        mapNode.init(object, d, d2, object2);
        this.nodes.put(object, mapNode);
        this.nodeCreated(mapNode);
        return mapNode;
    }

    private void addNodeToDomain(MapGraph mapGraph, MapNode mapNode) {
    }

    @Override
    public synchronized MapLink addLink(Object object, Object object2, Object object3, String string, Object object4) {
        this.initAddLink(object);
        if (this.duplicateLinkKey(object)) {
            return this.getMapLink(object);
        }
        MapLink mapLink = null;
        MapNode mapNode = this.getMapNode(object2);
        MapNode mapNode2 = this.getMapNode(object3);
        if (mapNode == null || mapNode2 == null) {
            return null;
        }
        MapGraph mapGraph = mapNode.getMapGraph();
        MapGraph mapGraph2 = mapNode2.getMapGraph();
        if (mapGraph.getOwner() instanceof MapGrapherNode && mapGraph2.getOwner() instanceof MapGrapherNode && mapGraph.getParent().equals((Object)this.rootGraph) && mapGraph2.getParent().equals((Object)this.rootGraph)) {
            mapLink = this.createMapGraphLink(object, mapGraph, mapGraph2, string, object4);
            this.addLinkToBundle(this.rootGraph, mapLink);
            this.links.put(object, mapLink);
            mapGraph.linkAdded(mapLink);
            mapGraph2.linkAdded(mapLink);
        } else {
            MapLinkInfo mapLinkInfo = null;
            MapLinkBundle mapLinkBundle = null;
            FvMapGraph fvMapGraph = null;
            if (!((MapGraph)mapGraph.getParent()).isDomainGraph() || !((MapGraph)mapGraph2.getParent()).isDomainGraph()) {
                MapGraph mapGraph3 = null;
                MapGraph mapGraph4 = null;
                MapGraph mapGraph5 = null;
                if (((MapGraph)mapGraph.getParent()).isDomainGraph()) {
                    mapGraph3 = mapGraph2;
                    mapGraph4 = mapGraph;
                    mapGraph5 = (MapGraph)mapGraph.getParent();
                } else {
                    mapGraph3 = mapGraph;
                    mapGraph4 = mapGraph2;
                    mapGraph5 = (MapGraph)mapGraph2.getParent();
                }
                MapDomain mapDomain = (MapDomain)mapGraph5.getOwner();
                mapLinkBundle = this.createDomainLink((MapNode)mapGraph3.getCollapsedGraphic(), mapDomain);
                mapLinkInfo = new MapLinkInfo(mapLinkBundle);
                fvMapGraph = this.getVirtualNodeGraph(mapGraph5, (MapNode)mapGraph3.getCollapsedGraphic());
                mapLink = mapGraph4 == mapGraph ? this.createMapGraphLink(object, mapGraph4, fvMapGraph, string, object4) : this.createMapGraphLink(object, fvMapGraph, mapGraph4, string, object4);
                this.addLinkToBundle(mapGraph5, mapLink);
                mapLinkInfo.addLink(mapLink);
                mapLinkBundle.addLink(mapLink);
                mapGraph4.linkAdded(mapLink);
                ((MapGraph)fvMapGraph).linkAdded(mapLink);
            }
            this.links.put(object, mapLinkInfo);
        }
        return mapLink;
    }

    protected FvMapGraph getVirtualNodeGraph(MapGraph mapGraph, MapNode mapNode) {
        MapNode mapNode2 = mapGraph.getMapNode(mapNode.getUserObject());
        if (mapNode2 != null && mapNode2.isVirtual()) {
            return (FvMapGraph)mapNode2.getChildGrapher();
        }
        if (mapNode.getUserObject() != null && mapNode.getUserObject() instanceof IFvNetNode) {
            IFvNetNode iFvNetNode = (IFvNetNode)mapNode.getUserObject();
            FvMapGraph fvMapGraph = (FvMapGraph)this.createNodeGrapher(mapGraph, iFvNetNode, iFvNetNode.getNodeId(), mapNode.getCenterX(), mapNode.getCenterY(), mapNode.getUserCookie());
            mapNode2 = this.createNode(null);
            mapNode2.setID(++this.seqNum);
            mapNode2.setRealNode(mapNode);
            fvMapGraph.applyNodeToGraph(mapNode2);
            mapNode2.init(mapNode);
            mapGraph.add(fvMapGraph);
            return fvMapGraph;
        }
        return null;
    }

    @Override
    protected MapLinkBundle createDomainLink(Node node, Node node2) {
        MapLinkBundle mapLinkBundle = null;
        boolean bl = false;
        MapLinkBundle[] mapLinkBundleArray = this.rootGraph.getDomainLinks();
        for (int i = 0; i < mapLinkBundleArray.length; ++i) {
            mapLinkBundle = mapLinkBundleArray[i];
            if (!(mapLinkBundle instanceof MapLinkBundle) || !mapLinkBundle.matches(node, node2)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            mapLinkBundle = this.createLinkBundle(node, node2, MapLinkBundle.DOMAIN_LINK, 1);
            mapLinkBundle.init(null, null);
            mapLinkBundle.setFrom((IlvGraphic)node.getChildGrapher());
            this.rootGraph.add(mapLinkBundle);
        }
        return mapLinkBundle;
    }

    protected MapGraph getVirtualNode(MapGraph mapGraph, MapGraph mapGraph2) {
        Object object;
        MapNode mapNode = (MapNode)mapGraph2.getCollapsedGraphic();
        int n = -1;
        FvMapGraph fvMapGraph = null;
        if (mapGraph2.getOwner() instanceof MapGrapherNode) {
            object = (MapGrapherNode)mapGraph2.getOwner();
            n = this.getNodeId((MapGrapherNode)object);
            fvMapGraph = (FvMapGraph)this.createNodeGrapher(mapGraph, ((Node)object).getUserObject(), n, object.boundingBox().getCenterX(), object.boundingBox().getCenterY(), ((Node)object).getUserCookie());
        }
        if ((object = mapGraph.getMapGraph(mapNode.getUserObject())) != null && ((MapNode)object.getCollapsedGraphic()).isVirtual()) {
            return object;
        }
        MapNode mapNode2 = null;
        mapNode2 = this.createNode(null);
        mapNode2.setID(++this.seqNum);
        mapNode2.setRealNode(mapNode);
        if (fvMapGraph != null) {
            fvMapGraph.applyNodeToGraph(mapNode2);
        }
        mapNode2.init(mapNode);
        return fvMapGraph;
    }

    private int getNodeId(MapGrapherNode mapGrapherNode) {
        String string = null;
        Set set = this.nodeGraphs.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext() && !this.nodeGraphs.get(string = (String)iterator.next()).equals(mapGrapherNode)) {
        }
        return Integer.parseInt(string);
    }

    protected MapLinkBundle createGrapherLink(MapGraph mapGraph, MapGraph mapGraph2) {
        MapGrapherNode mapGrapherNode = (MapGrapherNode)mapGraph.getOwner();
        MapGrapherNode mapGrapherNode2 = (MapGrapherNode)mapGraph2.getOwner();
        MapLinkBundle mapLinkBundle = null;
        boolean bl = false;
        MapLinkBundle[] mapLinkBundleArray = this.rootGraph.getGrapherLinks();
        for (int i = 0; i < mapLinkBundleArray.length; ++i) {
            mapLinkBundle = mapLinkBundleArray[i];
            if (!(mapLinkBundle instanceof MapLinkBundle) || !mapLinkBundle.matches(mapGrapherNode, mapGrapherNode2)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            mapLinkBundle = this.createLinkBundle(mapGrapherNode, mapGrapherNode2, MapLinkBundle.GRAPHER_LINK, 2);
            mapLinkBundle.init(null, null);
            mapLinkBundle.setFrom((IlvGraphic)mapGraph);
            mapLinkBundle.setTo((IlvGraphic)mapGraph2);
            this.rootGraph.add(mapLinkBundle);
        }
        return mapLinkBundle;
    }

    public FunctNetMapNode getMapNodeGrapher(Object object) {
        return (FunctNetMapNode)this.nodes.get(object);
    }

    private MapLink createMapGraphLink(Object object, MapGraph mapGraph, MapGraph mapGraph2, String string, Object object2) {
        if (mapGraph.getCollapsedGraphic() != null && mapGraph2.getCollapsedGraphic() != null) {
            MapNode mapNode = (MapNode)mapGraph.getCollapsedGraphic();
            MapNode mapNode2 = (MapNode)mapGraph2.getCollapsedGraphic();
            this.println("createMapLink: key=" + object + " src=" + mapNode + " dst=" + mapNode2 + " linkClass=" + string + " userCookie=" + object2);
            MapLink mapLink = this.createLink(mapNode, mapNode2, string, object2);
            mapLink.setFrom((IlvGraphic)mapGraph);
            mapLink.setTo((IlvGraphic)mapGraph2);
            mapLink.init(object, object2);
            return mapLink;
        }
        return null;
    }

    @Override
    protected synchronized void addLinkToBundle(MapGraph mapGraph, MapLink mapLink) {
        if (this.isDetailed()) {
            mapGraph.add(mapLink);
            return;
        }
        FunctLinkBundle functLinkBundle = this.getLinkBundle(mapGraph, mapLink);
        MapLinkBundle mapLinkBundle = this.getMapLinkBundle(mapLink);
        mapLinkBundle.addLink(mapLink);
        if (mapLinkBundle.getBundleState() == 1) {
            functLinkBundle.addLink(mapLinkBundle);
        } else {
            functLinkBundle.addLink(mapLink);
        }
        this.reorderLinksBetweenNodes(functLinkBundle);
    }

    protected synchronized void reorderLinksBetweenNodes(FunctLinkBundle functLinkBundle) {
        Vector vector;
        TreeMap treeMap = new TreeMap();
        Link[] linkArray = functLinkBundle.getLinks();
        if (linkArray == null) {
            return;
        }
        for (int i = 0; i < linkArray.length; ++i) {
            Link link = linkArray[i];
            String string = link.getLinkClass();
            if (string == null) continue;
            if (!treeMap.containsKey(string)) {
                treeMap.put(string, new Vector());
            }
            vector = (Vector)treeMap.get(string);
            vector.add(link);
        }
        Set set = treeMap.keySet();
        if (set == null || set.size() == 1) {
            return;
        }
        for (int i = 0; i < linkArray.length; ++i) {
            functLinkBundle.removeLink(linkArray[i]);
        }
        for (String string : set) {
            vector = (Vector)treeMap.get(string);
            if (vector == null) continue;
            for (int i = 0; i < vector.size(); ++i) {
                Link link = (Link)vector.get(i);
                functLinkBundle.addLink(link);
            }
        }
    }

    @Override
    protected synchronized MapLinkBundle getMapLinkBundle(MapLink mapLink) {
        HashMap hashMap = null;
        String string = mapLink.getLinkClass();
        if (this.mlbMap.containsKey(string)) {
            hashMap = (HashMap)this.mlbMap.get(string);
        } else {
            hashMap = new HashMap();
            this.mlbMap.put(string, hashMap);
        }
        String string2 = mapLink.getBundleKey();
        MapLinkBundle mapLinkBundle = null;
        if (hashMap.containsKey(string2)) {
            mapLinkBundle = (MapLinkBundle)hashMap.get(string2);
            this.println("getMapLinkBundle: found state=" + mapLinkBundle.getBundleStateString() + " key=" + string2);
        } else {
            int n = this.getLinkClassState(string);
            mapLinkBundle = this.createLinkBundle(mapLink.getSrc(), mapLink.getDst(), string, n);
            this.println("getMapLinkBundle: creating state=" + mapLinkBundle.getBundleStateString() + " key=" + string2);
            mapLinkBundle.init(null, null);
            mapLinkBundle.setFrom((IlvGraphic)mapLink.getSrc().getChildGrapher());
            mapLinkBundle.setTo((IlvGraphic)mapLink.getDst().getChildGrapher());
            hashMap.put(string2, mapLinkBundle);
        }
        return mapLinkBundle;
    }

    public synchronized MapLinkBundle getCollapsedLinkBundle(MapLink mapLink) {
        return this.getMapLinkBundle(mapLink);
    }

    @Override
    protected MapLinkBundle createLinkBundle(Node node, Node node2, String string, int n) {
        return new MapLinkBundle(this, node, node2, string, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FunctLinkBundle getLinkBundle(MapGraph mapGraph, MapLink mapLink) {
        FunctLinkBundle functLinkBundle = null;
        String string = mapLink.getBundleKey();
        TreeMap treeMap = this.linkBundleMap;
        synchronized (treeMap) {
            if (this.linkBundleMap.containsKey(string)) {
                functLinkBundle = (FunctLinkBundle)this.linkBundleMap.get(string);
            } else {
                functLinkBundle = new FunctLinkBundle((MapToolkit)this, mapLink.getSource().getChildGrapher(), mapLink.getTarget().getChildGrapher(), string);
                if (!mapGraph.contains(functLinkBundle)) {
                    mapGraph.add(functLinkBundle);
                }
                this.linkBundleMap.put(string, functLinkBundle);
            }
        }
        return functLinkBundle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LinkBundle getLinkBundle(String string) {
        TreeMap treeMap = this.linkBundleMap;
        synchronized (treeMap) {
            FunctLinkBundle functLinkBundle = (FunctLinkBundle)this.linkBundleMap.get(string);
            this.println("getLinkBundle: found key=" + string);
            return functLinkBundle;
        }
    }

    @Override
    public synchronized void deleteLink(Object object) {
        MapLink mapLink = (MapLink)this.links.get(object);
        ((MapGraph)mapLink.getSrc().getChildGrapher()).linkRemoved(mapLink);
        ((MapGraph)mapLink.getDst().getChildGrapher()).linkRemoved(mapLink);
        super.deleteLink(object);
    }

    public IFvMapPersist getMapPersist() {
        return this.mapPersist;
    }

    @Override
    protected void viewChanged() {
        ViewManagerToolKit viewManagerToolKit;
        Object object4;
        Object object2;
        Object object3;
        boolean bl = false;
        if (this.getTransformer().zoomFactor() < 0.8) {
            if (this.zoomVisibility) {
                bl = true;
                this.zoomVisibility = false;
            }
        } else if (!this.zoomVisibility) {
            bl = true;
            this.zoomVisibility = true;
        }
        if (bl) {
            object3 = this.getInterGraphLinks();
            for (int i = 0; i < ((LinkedList)object3).size(); ++i) {
                object2 = (InterGraphLink)((LinkedList)object3).get(i);
                object4 = object2.getChildren();
                if (((E)object4).length == 0) continue;
                for (int j = 0; j < ((Object)object4).length; ++j) {
                    if (object4[j] == null || !(object4[j] instanceof LinkBalloon) || !((InterGraphLink)object2).isBalloonOpened()) continue;
                    ((LinkBalloon)object4[j]).showIt(this.zoomVisibility);
                }
            }
        }
        object3 = Collections.synchronizedMap(this.links);
        Collection collection = object3.values();
        for (Object object4 : collection) {
            FunctNetMapLink functNetMapLink;
            if (!(object4 instanceof FunctNetMapLink) || (functNetMapLink = (FunctNetMapLink)object4) == null || (viewManagerToolKit = functNetMapLink.getChildren()) == null || ((ViewManagerToolKit)viewManagerToolKit).length == 0) continue;
            for (int i = 0; i < ((ViewManagerToolKit)viewManagerToolKit).length; ++i) {
                if (viewManagerToolKit[i] == null || !(viewManagerToolKit[i] instanceof LinkBalloon) || !functNetMapLink.isBalloonOpened()) continue;
                boolean bl2 = this.zoomVisibility;
                if (PowerBallon.getInstance().isForCircuit()) {
                    bl2 = this.zoomVisibility && functNetMapLink.isOnCircuit();
                }
                ((LinkBalloon)viewManagerToolKit[i]).showIt(bl2);
            }
        }
        object2 = this.nodes.values();
        object4 = object2.iterator();
        while (object4.hasNext()) {
            FunctNetMapNode functNetMapNode = (FunctNetMapNode)object4.next();
            viewManagerToolKit = functNetMapNode.getNodeFv();
            IFvNetNode iFvNetNode = (IFvNetNode)functNetMapNode.getUserObject();
            if (viewManagerToolKit == null) continue;
            viewManagerToolKit.setNtwZoom(this.getTransformer().zoomFactor());
            viewManagerToolKit.transformerChanged(null);
            if (viewManagerToolKit.getGraphChildren() != null) {
                Collection collection2 = viewManagerToolKit.getGraphChildren().values();
                IViewGraph iViewGraph2 = null;
                for (IViewGraph iViewGraph2 : collection2) {
                    if (!(iViewGraph2 instanceof ViewDomainGrapher)) continue;
                    ((ViewDomainGrapher)iViewGraph2).setNtwZoom(this.getTransformer().zoomFactor());
                }
                continue;
            }
            if (!this.dbg.on()) continue;
            this.dbg.println("Funct View w/o any GraphChildren!!!" + functNetMapNode.getName() + functNetMapNode.getLabel());
        }
    }

    public InterGraphLink createInterGraphLinks(IlvGraphic ilvGraphic, IlvGraphic ilvGraphic2, FunctNetMapLink functNetMapLink, IFvNetLink iFvNetLink, int n, int n2, boolean bl, boolean bl2, ArrayList<IlvGraphic> arrayList) {
        InterGraphLink interGraphLink = null;
        if (!this.interGraphLinks.containsKey(iFvNetLink)) {
            Object object;
            IlvGraphic ilvGraphic3 = ilvGraphic;
            IlvGraphic ilvGraphic4 = ilvGraphic2;
            ViewPin viewPin = null;
            ViewPin viewPin2 = null;
            if (ilvGraphic instanceof ViewPortGraphic) {
                object = (ViewCardGrapher)((ViewPortGraphic)ilvGraphic).getGraphParent();
                viewPin = (ViewPin)object.getGraphPins().get(((ViewPortGraphic)ilvGraphic).getPortName());
                if (viewPin == null) {
                    viewPin = this.getPin(object.getGraphPins(), ((ViewPortGraphic)ilvGraphic).getGraphName());
                }
                ilvGraphic3 = object;
            }
            if (ilvGraphic2 instanceof ViewPortGraphic) {
                object = (ViewCardGrapher)((ViewPortGraphic)ilvGraphic2).getGraphParent();
                viewPin2 = (ViewPin)object.getGraphPins().get(((ViewPortGraphic)ilvGraphic2).getPortName());
                if (viewPin2 == null) {
                    viewPin2 = this.getPin(object.getGraphPins(), ((ViewPortGraphic)ilvGraphic2).getGraphName());
                }
                ilvGraphic4 = object;
            }
            interGraphLink = new InterGraphLink(this, ilvGraphic3, ilvGraphic4, ilvGraphic, ilvGraphic2, functNetMapLink.getLinkClass(), functNetMapLink, n, n2, bl, bl2);
            interGraphLink.setAssociatedSrc(ilvGraphic);
            interGraphLink.setAssociatedDst(ilvGraphic2);
            object = IlvGrapher.getLowestCommonGrapher((IlvGraphic)ilvGraphic3, (IlvGraphic)ilvGraphic4);
            if (object == null) {
                object = this.getGraph();
            }
            interGraphLink.placeBalloons();
            this.spanInfoInterLinks.add(interGraphLink);
            IlvGrapher.addInterGraphLink((IlvLinkImage)interGraphLink, (boolean)true);
            this.getGraph().setLayer((IlvGraphic)interGraphLink, 10, true);
            this.interGraphLinks.put(iFvNetLink, interGraphLink);
            if (functNetMapLink.getSrc().getChildGrapher() != null) {
                ((FvMapGraph)functNetMapLink.getSrc().getChildGrapher()).interLinkAdded(interGraphLink, iFvNetLink);
            }
            if (functNetMapLink.getDst().getChildGrapher() != null) {
                ((FvMapGraph)functNetMapLink.getDst().getChildGrapher()).interLinkAdded(interGraphLink, iFvNetLink);
            }
            if (viewPin != null) {
                ((ViewCardGrapher)ilvGraphic3).getConnector().connectLink((IlvLinkImage)interGraphLink, (IlvGrapherPin)viewPin, true);
                arrayList.add(ilvGraphic);
            }
            if (viewPin2 != null) {
                ((ViewCardGrapher)ilvGraphic4).getConnector().connectLink((IlvLinkImage)interGraphLink, (IlvGrapherPin)viewPin2, false);
                arrayList.add(ilvGraphic2);
            }
            this.debugLink("[ADDED]");
            return interGraphLink;
        }
        this.debugLink("[SKIPPED]");
        return interGraphLink;
    }

    private ViewPin getPin(HashMap<String, ViewPin> hashMap, String string) {
        for (String string2 : hashMap.keySet()) {
            if (string2.indexOf(string) < 0) continue;
            return hashMap.get(string2);
        }
        return null;
    }

    public void removeInterGraphLink(InterGraphLink interGraphLink, IFvNetLink iFvNetLink, IlvGrapher ilvGrapher) {
        if (this.interGraphLinks.containsKey(iFvNetLink)) {
            InterGraphLink interGraphLink2 = this.interGraphLinks.get(iFvNetLink);
            if (ilvGrapher != null) {
                ilvGrapher.removeLink((IlvLinkImage)interGraphLink2, true);
            }
            this.interGraphLinks.remove(iFvNetLink);
            if (interGraphLink.getAssociatedSrc() instanceof FvMapGraph) {
                ((FvMapGraph)interGraphLink.getAssociatedSrc()).interLinkRemoved(interGraphLink, iFvNetLink);
            }
            if (interGraphLink.getAssociatedDst() instanceof FvMapGraph) {
                ((FvMapGraph)interGraphLink.getAssociatedDst()).interLinkRemoved(interGraphLink, iFvNetLink);
            }
            if (this.spanInfoInterLinks.contains(interGraphLink2)) {
                this.spanInfoInterLinks.remove(interGraphLink2);
            }
            interGraphLink2.destroy();
        }
    }

    public LinkedList<InterGraphLink> getInterGraphLinks() {
        return new LinkedList<InterGraphLink>(this.interGraphLinks.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void placeInterLinkIcons() {
        if (this.interGraphLinks != null) {
            HashMap<IFvNetLink, InterGraphLink> hashMap = this.interGraphLinks;
            synchronized (hashMap) {
                for (InterGraphLink interGraphLink : this.interGraphLinks.values()) {
                    interGraphLink.placeIcons();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEnableLinkIcon(boolean bl) {
        TreeMap treeMap = this.linkBundleMap;
        synchronized (treeMap) {
            super.setEnableLinkIcon(bl);
            this.placeInterLinkIcons();
        }
    }

    protected LinkedList<InterGraphLink> getSpanInfoInterLinks() {
        return this.spanInfoInterLinks;
    }

    public void debugLink(String string) {
        if (this.dbg.on()) {
            this.dbg.print(string + " There are " + this.interGraphLinks.size() + " interGraphLinks");
            this.dbg.println(" and " + this.spanInfoInterLinks.size() + " spanInfoInterLinks");
        }
    }
}

